/*
 * Decompiled with CFR 0.152.
 */
package com.bh.spacecomments;

import com.atlassian.confluence.content.service.PageService;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.Comment;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.web.context.HttpContext;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.web.ContextProvider;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.bh.models.SpaceBannerModel;
import com.bh.services.AoModelsService;
import com.bh.services.MarkersService;
import com.bh.services.UsersExtractorService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BannerMapping
implements ContextProvider {
    private final Logger LOG = LoggerFactory.getLogger(BannerMapping.class);
    private final HttpContext httpContext;
    private final PageService pageService;
    private final PluginLicenseManager pluginLicenseManager;
    private final MarkersService markersService;
    private final UsersExtractorService usersExtractorService;
    private final UserAccessor userAccessor;
    private final AoModelsService aoModelsService;

    public BannerMapping(HttpContext httpContext, PageService pageService, PluginLicenseManager pluginLicenseManager, MarkersService markersService, UsersExtractorService usersExtractorService, UserAccessor userAccessor, AoModelsService aoModelsService) {
        this.httpContext = httpContext;
        this.pageService = pageService;
        this.pluginLicenseManager = pluginLicenseManager;
        this.markersService = markersService;
        this.usersExtractorService = usersExtractorService;
        this.userAccessor = userAccessor;
        this.aoModelsService = aoModelsService;
    }

    private boolean licenseOK() {
        if (!this.pluginLicenseManager.getLicense().isDefined()) {
            return false;
        }
        return !((PluginLicense)this.pluginLicenseManager.getLicense().get()).getError().isDefined();
    }

    public void init(Map<String, String> map) throws PluginParseException {
    }

    public Map<String, Object> getContextMap(Map<String, Object> map) {
        HashMap<String, Object> finalMap = new HashMap<String, Object>();
        boolean licenseIsOK = this.licenseOK();
        finalMap.put("licenseIsOK", licenseIsOK);
        String pageIdFromHttp = this.httpContext.getRequest().getParameter("pageId");
        String spaceKeyFromHttp = this.httpContext.getRequest().getParameter("spaceKey");
        String pageTitleFromHttp = this.httpContext.getRequest().getParameter("title");
        finalMap.put("pageIdFromHttp", pageIdFromHttp);
        finalMap.put("spaceKeyFromHttp", spaceKeyFromHttp);
        finalMap.put("pageTitleFromHttp", pageTitleFromHttp);
        Page page = StringUtils.isEmpty((CharSequence)pageIdFromHttp) && !StringUtils.isEmpty((CharSequence)spaceKeyFromHttp) & !StringUtils.isEmpty((CharSequence)pageTitleFromHttp) ? this.pageService.getTitleAndSpaceKeyPageLocator(spaceKeyFromHttp, pageTitleFromHttp).getPage() : this.pageService.getIdPageLocator(Long.parseLong(pageIdFromHttp)).getPage();
        List allComments = page.getComments();
        try {
            Optional<String> shouldDisplayOptional = Optional.of(this.aoModelsService.getIconSwitcher().getWhatToDisplay());
            finalMap.put("shouldDisplay", this.getShouldDisplay(shouldDisplayOptional.orElse("always"), page.getSpaceKey()));
        }
        catch (Exception e) {
            finalMap.put("shouldDisplay", this.getShouldDisplay("always", page.getSpaceKey()));
            this.LOG.error(String.format("[ BHT ] Error when getting 'getWhatToDisplay': %s", e.getMessage()));
        }
        ArrayList<Comment> allSimpleComments = new ArrayList<Comment>();
        ArrayList<Comment> allInlineUnresolvedComments = new ArrayList<Comment>();
        ArrayList<Comment> allInlineResolvedComments = new ArrayList<Comment>();
        for (Comment comment : allComments) {
            if (comment.isInlineComment()) continue;
            allSimpleComments.add(comment);
        }
        for (Comment comment : allComments) {
            if (!comment.isInlineComment() || comment.getStatus().isResolved() || comment.getStatus().isDangling() || comment.getParent() != null) continue;
            allInlineUnresolvedComments.add(comment);
            allInlineUnresolvedComments.addAll(comment.getChildren());
        }
        for (Comment comment : allComments) {
            if ((!comment.isInlineComment() || !comment.getStatus().isResolved() || comment.getParent() != null) && (comment.getParent() != null || !comment.getStatus().isDangling())) continue;
            allInlineResolvedComments.add(comment);
            allInlineResolvedComments.addAll(comment.getChildren());
        }
        List pageAttachments = page.getAttachments();
        ArrayList attachmentsInlineComments = new ArrayList();
        ArrayList<Comment> attachmentsInlineUnresComments = new ArrayList<Comment>();
        ArrayList<Comment> attachmentsInlineResComments = new ArrayList<Comment>();
        for (Attachment attachment : pageAttachments) {
            attachmentsInlineComments.addAll(attachment.getComments());
        }
        for (Comment comment : attachmentsInlineComments) {
            if (comment.getStatus().isResolved() || comment.isDeleted() || comment.getParent() != null) continue;
            attachmentsInlineUnresComments.add(comment);
            attachmentsInlineUnresComments.addAll(comment.getChildren());
        }
        for (Comment comment : attachmentsInlineComments) {
            if (!comment.getStatus().isResolved() || comment.isDeleted() || comment.getParent() != null) continue;
            attachmentsInlineResComments.add(comment);
            attachmentsInlineResComments.addAll(comment.getChildren());
        }
        ArrayList<Comment> pageUnresMainForCount = new ArrayList<Comment>();
        ArrayList<Comment> pageResMainForCount = new ArrayList<Comment>();
        ArrayList<Comment> attachUnresMainForCount = new ArrayList<Comment>();
        ArrayList<Comment> attachResMainForCount = new ArrayList<Comment>();
        for (Comment comment : allInlineUnresolvedComments) {
            if (comment.getParent() != null) continue;
            pageUnresMainForCount.add(comment);
        }
        for (Comment comment : allInlineResolvedComments) {
            if (comment.getParent() != null) continue;
            pageResMainForCount.add(comment);
        }
        for (Comment comment : attachmentsInlineUnresComments) {
            if (comment.getParent() != null) continue;
            attachUnresMainForCount.add(comment);
        }
        for (Comment comment : attachmentsInlineResComments) {
            if (comment.getParent() != null) continue;
            attachResMainForCount.add(comment);
        }
        finalMap.put("firstUnresComment", this.markersService.getFirstComment(pageUnresMainForCount, page.getBodyAsString()));
        finalMap.put("firstResComment", this.markersService.getFirstComment(pageResMainForCount, page.getBodyAsString()));
        finalMap.put("pageUnresMainForCount", pageUnresMainForCount);
        finalMap.put("pageResMainForCount", pageResMainForCount);
        finalMap.put("attachUnresMainForCount", attachUnresMainForCount);
        finalMap.put("attachResMainForCount", attachResMainForCount);
        finalMap.put("allSimpleComments", allSimpleComments);
        finalMap.put("allInlineUnresolvedComments", allInlineUnresolvedComments);
        finalMap.put("allInlineResolvedComments", allInlineResolvedComments);
        finalMap.put("attachmentsInlineUnresComments", attachmentsInlineUnresComments);
        finalMap.put("attachmentsInlineResComments", attachmentsInlineResComments);
        finalMap.put("contextPath", this.httpContext.getRequest().getContextPath());
        finalMap.put("usersExtractorService", this.usersExtractorService);
        finalMap.put("userAccessor", this.userAccessor);
        finalMap.put("displayMainDialog", this.aoModelsService.getPanelType().isDisplayMainDialog());
        return finalMap;
    }

    private boolean getShouldDisplay(String iconsSwitcherValue, String spaceKey) {
        if (iconsSwitcherValue.equals("always")) {
            return true;
        }
        if (iconsSwitcherValue.equals("hide")) {
            for (SpaceBannerModel spaceBannerModel : this.aoModelsService.getAllModels()) {
                if (!spaceKey.equals(spaceBannerModel.getSpaceKey())) continue;
                return false;
            }
        }
        if (iconsSwitcherValue.equals("display")) {
            for (SpaceBannerModel spaceBannerModel : this.aoModelsService.getAllModels()) {
                if (!spaceKey.equals(spaceBannerModel.getSpaceKey())) continue;
                return true;
            }
            return false;
        }
        return true;
    }
}

