import React, {useState, useEffect, useRef} from 'react';
import Avatar from "@atlaskit/avatar";
import Comment, {
    CommentAction,
    CommentAuthor,
    CommentEdited,
    CommentTime,
} from '@atlaskit/comment';

const UserComments = (props) => {
    const [author, setAuthor] = useState(null);
    const [comments, setComments] = useState([]);
    const [commentsLoaded, setCommentsLoaded] = useState(false);
    const [currUser, setCurrUser] = useState(null);
    const [currUserLoaded, setCurrUserLoaded] = useState(false);
    const [authors, setAuthors] = useState([]);
    const [authorSelected, setAuthorSelected] = useState(false);
    const [authorOptions, setAuthorOptions] = useState([]); // [{label: 'A', value: 'B'},{...}]
    const [currentUserMeta, setCurrentUserMeta] = useState(document.head.querySelector('meta[name="ajs-remote-user"]'.content));

    async function fetchCurrUser() {
        let currUserData = await fetch('/rest/api/user/current');
        let currUser = await currUserData.json();
        setCurrUser(currUser);
        setAuthorOptions([{label: currUser.displayName, value: currUser.username}]);
        setCurrUserLoaded(true);
    }

    useEffect(() => {
        fetchCurrUser();
    }, [])

    useEffect(() => {
        if (currUserLoaded) {
            getUserComments(currUser.username);
            // getUserSimpleComments();
        }
    }, [currUserLoaded])

    async function getUserSimpleComments() {
        const resp = await fetch(`/bht/comments/user?userId=${currUser.accountId}&commentType=Simple&status=&to=&from=`);
        const jsonResp = await resp.json();
        console.log(jsonResp);
    }

    async function getUserComments(username) {
        // const expandData = 'content.container,content.history,content.body.view';
        // const REQ_URL = `/rest/api/search?cql=creator="${username}" and type=comment&expand=${expandData}`;
        const REQ_URL = `/rest/bht-rest/1.0/bht-comments/user?userName=${username}`;
        const currData = await fetch(REQ_URL);
        let comments = await currData.json();
        // let comments = responseBody.results;
        setComments(data => [...data, ...comments])
        setCommentsLoaded(true);
    }

    async function fetchUsers() {
        // authorOptions.push({label: currUser.displayName, value: currUser.accountId})
    }

    return (
        <div>
            <div>
                <h3>My Comments</h3>
                <div>
                    {/*{ currUserLoaded && <Avatar*/}
                    {/*    appearance="circle"*/}
                    {/*    src={hostUrlWithoutContext + currUser.profilePicture.path}*/}
                    {/*    size="large"*/}
                    {/*    name={currUser.displayName}*/}
                    {/*/> }*/}
                </div>
                <div>
                    {commentsLoaded && comments.map(c => (
                        <Comment
                            avatar={<Avatar
                                name={c.creator.displayName}
                                src={c.creator.iconLink}
                            />}
                            author={<CommentAuthor>{c.creator.displayName}</CommentAuthor>}
                            type="author"
                            time={<CommentTime>{c.creationDate}</CommentTime>}
                            content={c.body !== undefined
                                ? c.body
                                : ""}
                            // dangerouslySetInnerHTML={{__html: c.body.view.value}}
                        />
                    ))}
                </div>
            </div>
            <div></div>
        </div>
    )
}

export default UserComments;