/*
 * Decompiled with CFR 0.152.
 */
package com.bh.rest;

import com.bh.models.dto.BhtCommentWebModel;
import com.bh.models.dto.SpaceBannerModelDto;
import com.bh.services.AoModelsService;
import com.bh.services.BhtCommentsService;
import com.bh.services.CommentsStatsService;
import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Path(value="/bht-comments")
public class BhtCommentsRestResource {
    private final BhtCommentsService bhtCommentsService;
    private final CommentsStatsService statsService;
    private final AoModelsService aoModelsService;

    public BhtCommentsRestResource(BhtCommentsService bhtCommentsService, CommentsStatsService statsService, AoModelsService aoModelsService) {
        this.bhtCommentsService = bhtCommentsService;
        this.statsService = statsService;
        this.aoModelsService = aoModelsService;
    }

    @Path(value="/spaces")
    @GET
    @Produces(value={"application/json"})
    public Response getSpacesComments(@QueryParam(value="spaceKeys") String spaceKeys, @QueryParam(value="commentType") String commentType, @QueryParam(value="dateFrom") String dateFrom, @QueryParam(value="dateTo") String dateTo) {
        return Response.ok(this.bhtCommentsService.getSpaceComments(spaceKeys, commentType, dateFrom, dateTo)).build();
    }

    @Path(value="/user")
    @GET
    @Produces(value={"application/json"})
    public Response getUserComments(@QueryParam(value="userName") String userName) {
        List<BhtCommentWebModel> userComments = this.bhtCommentsService.getUserBhtComments(userName);
        return Response.ok(userComments).status(200).header("vendor", (Object)"BHT").build();
    }

    @Path(value="/stats/footer-comments")
    @GET
    @Produces(value={"application/json"})
    public Response getFooterComments() {
        return Response.ok((Object)String.format("{\"size\": %d}", this.statsService.getFooterCommentsSize())).status(200).build();
    }

    @Path(value="/stats/inline-comments")
    @GET
    @Produces(value={"application/json"})
    public Response getInlineComments() {
        return Response.ok((Object)String.format("{\"size\": %d}", this.statsService.getInlineCommentsSize())).status(200).build();
    }

    @Path(value="/stats/unres-comments")
    @GET
    @Produces(value={"application/json"})
    public Response getUnresComments() {
        return Response.ok((Object)String.format("{\"size\": %d}", this.statsService.getInlineUNRESCommentsSize())).status(200).build();
    }

    @Path(value="/stats/res-comments")
    @GET
    @Produces(value={"application/json"})
    public Response getResComments() {
        return Response.ok((Object)String.format("{\"size\": %d}", this.statsService.getInlineRESCommentsSize())).status(200).build();
    }

    @Path(value="/panel/location")
    @GET
    @Produces(value={"application/json"})
    public Response getPanelLocations() {
        return Response.ok(this.aoModelsService.getAllModels().stream().map(s -> new SpaceBannerModelDto(s.getSpaceKey(), s.getDisplayValue())).collect(Collectors.toList())).status(200).build();
    }
}

