/*
 * Decompiled with CFR 0.152.
 */
package com.bh.conditions;

import com.atlassian.confluence.plugin.descriptor.web.WebInterfaceContext;
import com.atlassian.confluence.plugin.descriptor.web.conditions.BaseConfluenceCondition;
import com.bh.services.AoModelsService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdvancedPanelCondition
extends BaseConfluenceCondition {
    private final Logger LOG = LoggerFactory.getLogger(AdvancedPanelCondition.class);
    public static final String ADVANCED = "Advanced";
    private final AoModelsService aoModelsService;

    public AdvancedPanelCondition(AoModelsService aoModelsService) {
        this.aoModelsService = aoModelsService;
    }

    protected boolean shouldDisplay(WebInterfaceContext webInterfaceContext) {
        boolean advanced = false;
        try {
            String type = this.aoModelsService.getPanelType().getPanelTypeValue();
            advanced = type.equalsIgnoreCase(ADVANCED);
        }
        catch (NullPointerException e) {
            this.LOG.error(String.format("> [BHT] Error getting Panel Type in AdvancedPanelCondition from ModelService: %s", e.getLocalizedMessage()));
        }
        return advanced;
    }
}

