import { c as _extends, j as _toConsumableArray, a as _defineProperty } from './useAnalyticsEvents-2e16b30c.js';
import { _ as _slicedToArray } from './slicedToArray-a5de7267.js';
import { r as react } from './index-50b0b662.js';
import { g as gridSize, j as jsx } from './colors-25aad6bf.js';
import { u as useControlled, C as ChevronRightLargeIcon, a as ChevronLeftLargeIcon, n as noop } from './use-controlled-d7253071.js';
import { B as Button } from './button-b301ec95.js';
import { m as memoizeOne } from './memoize-one.esm-42a55c10.js';
import { u as usePlatformLeafEventHandler } from './get-is-only-single-icon-3e32a817.js';

var ellipsisStyle = {
  display: 'inline-flex',
  textAlign: 'center',
  alignItems: 'center',
  padding: '0 8px'
};
var navStyle = {
  display: 'flex'
};
var halfGridSize = gridSize() / 2;
var navigatorStyle = {
  paddingLeft: halfGridSize,
  paddingRight: halfGridSize
};

function Navigator(props) {
  return jsx(Button, _extends({}, props, {
    appearance: "subtle",
    spacing: "none",
    css: navigatorStyle
  }));
}

function Page(props) {
  return /*#__PURE__*/react.createElement(Button, _extends({}, props, {
    appearance: "subtle"
  }));
}

/**  @jsx jsx */
function renderEllipsis(_ref) {
  var key = _ref.key;
  return jsx("span", {
    key: key,
    css: ellipsisStyle
  }, "...");
}

var emptyObject = {};

var collapseRange = function collapseRange(pages, current, _ref, testId) {
  var max = _ref.max,
      ellipsis = _ref.ellipsis,
      transform = _ref.transform;
  var total = pages.length; // only need ellipsis if we have more pages than we can display

  var needEllipsis = total > max; // show start ellipsis if the current page is further away than max - 4 from the first page

  var hasStartEllipsis = needEllipsis && max - 4 < current; // show end ellipsis if the current page is further than total - max + 3 from the last page

  var hasEndEllipsis = needEllipsis && current < total - max + 3;
  var getPageComponents = memoizeOne(function () {
    var startIndex = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 0;
    var lastIndex = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : total;
    return pages.slice(startIndex, lastIndex).map(function (page, index) {
      return transform(page, startIndex + index, testId);
    });
  });

  if (!needEllipsis) {
    return getPageComponents(0, total);
  }

  if (hasStartEllipsis && !hasEndEllipsis) {
    var _pageCount = max - 2;

    return [].concat(_toConsumableArray(getPageComponents(0, 1)), [ellipsis({
      key: 'elipses-1'
    })], _toConsumableArray(getPageComponents(total - _pageCount)));
  }

  if (!hasStartEllipsis && hasEndEllipsis) {
    var _pageCount2 = max - 2;

    return [].concat(_toConsumableArray(getPageComponents(0, _pageCount2)), [ellipsis({
      key: 'elipses-1'
    })], _toConsumableArray(getPageComponents(total - 1)));
  } // we have both start and end ellipsis


  var pageCount = max - 4;
  return [].concat(_toConsumableArray(getPageComponents(0, 1)), [ellipsis({
    key: 'elipses-1'
  })], _toConsumableArray(getPageComponents(current - Math.floor(pageCount / 2), current + pageCount - 1)), [ellipsis({
    key: 'elipses-2'
  })], _toConsumableArray(getPageComponents(total - 1)));
};

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }
var analyticsAttributes = {
  componentName: 'pagination',
  packageName: "@atlaskit/pagination",
  packageVersion: "14.1.2"
};

function InnerPagination(_ref, ref) {
  var _ref$components = _ref.components,
      components = _ref$components === void 0 ? emptyObject : _ref$components,
      _ref$defaultSelectedI = _ref.defaultSelectedIndex,
      defaultSelectedIndex = _ref$defaultSelectedI === void 0 ? 0 : _ref$defaultSelectedI,
      selectedIndex = _ref.selectedIndex,
      _ref$label = _ref.label,
      label = _ref$label === void 0 ? 'pagination' : _ref$label,
      _ref$previousLabel = _ref.previousLabel,
      previousLabel = _ref$previousLabel === void 0 ? 'previous' : _ref$previousLabel,
      _ref$nextLabel = _ref.nextLabel,
      nextLabel = _ref$nextLabel === void 0 ? 'next' : _ref$nextLabel,
      _ref$style = _ref.style,
      style = _ref$style === void 0 ? emptyObject : _ref$style,
      _ref$max = _ref.max,
      max = _ref$max === void 0 ? 7 : _ref$max,
      _ref$onChange = _ref.onChange,
      onChange = _ref$onChange === void 0 ? noop : _ref$onChange,
      pages = _ref.pages,
      getPageLabel = _ref.getPageLabel,
      _ref$renderEllipsis = _ref.renderEllipsis,
      renderEllipsis$1 = _ref$renderEllipsis === void 0 ? renderEllipsis : _ref$renderEllipsis,
      analyticsContext = _ref.analyticsContext,
      testId = _ref.testId;

  var _useControlled = useControlled(selectedIndex, function () {
    return defaultSelectedIndex || 0;
  }),
      _useControlled2 = _slicedToArray(_useControlled, 2),
      selectedIndexValue = _useControlled2[0],
      setSelectedIndexValue = _useControlled2[1];

  var onChangeWithAnalytics = usePlatformLeafEventHandler(_objectSpread({
    fn: function fn(value, analyticsEvent) {
      var event = value.event,
          selectedPageIndex = value.selectedPageIndex;

      if (selectedIndex === undefined) {
        setSelectedIndexValue(selectedPageIndex);
      }

      if (onChange) {
        onChange(event, pages[selectedPageIndex], analyticsEvent);
      }
    },
    action: 'changed',
    actionSubject: 'pageNumber',
    analyticsData: analyticsContext
  }, analyticsAttributes));

  var transform = function transform(page, currPageIndex, testId) {
    var selectedPage = pages[selectedIndexValue];
    return jsx(Page, {
      key: "page-".concat(getPageLabel ? getPageLabel(page, currPageIndex) : currPageIndex),
      component: components.Page,
      onClick: function onClick(event) {
        return onChangeWithAnalytics({
          event: event,
          selectedPageIndex: currPageIndex
        });
      },
      isSelected: page === selectedPage,
      page: page,
      testId: testId && "".concat(testId, "--").concat(page === selectedPage ? 'current-' : '', "page-").concat(currPageIndex)
    }, getPageLabel ? getPageLabel(page, currPageIndex) : page);
  };

  return jsx("nav", {
    "data-testid": testId,
    css: _objectSpread(_objectSpread({}, navStyle), style),
    ref: ref,
    "aria-label": label
  }, jsx(Navigator, {
    key: "left-navigator",
    component: components.Previous,
    onClick: function onClick(event) {
      return onChangeWithAnalytics({
        event: event,
        selectedPageIndex: selectedIndexValue - 1
      });
    },
    isDisabled: selectedIndexValue === 0,
    iconBefore: jsx(ChevronLeftLargeIcon, {
      label: ""
    }),
    "aria-label": previousLabel,
    pages: pages,
    testId: testId && "".concat(testId, "--left-navigator")
  }), collapseRange(pages, selectedIndexValue, {
    max: max,
    ellipsis: renderEllipsis$1,
    transform: transform
  }, testId), jsx(Navigator, {
    key: "right-navigator",
    component: components.Next,
    onClick: function onClick(event) {
      return onChangeWithAnalytics({
        event: event,
        selectedPageIndex: selectedIndexValue + 1
      });
    },
    isDisabled: selectedIndexValue === pages.length - 1,
    iconBefore: jsx(ChevronRightLargeIcon, {
      label: ""
    }),
    "aria-label": nextLabel,
    pages: pages,
    testId: testId && "".concat(testId, "--right-navigator")
  }));
}

var Pagination = /*#__PURE__*/react.forwardRef(InnerPagination);
var __pika_web_default_export_for_treeshaking__ = /*#__PURE__*/react.memo(Pagination);

export { __pika_web_default_export_for_treeshaking__ as _ };
