/*
 * Decompiled with CFR 0.152.
 */
package com.bh.services;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.bh.ao.IconSwitcherAo;
import com.bh.ao.PanelTypeAo;
import com.bh.ao.SpaceBannerModelAo;
import com.bh.models.IconsSwitcher;
import com.bh.models.PanelTypeModel;
import com.bh.models.SpaceBannerModel;
import com.bh.services.AoModelsService;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.java.ao.DBParam;
import net.java.ao.RawEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AoModelsServiceImpl
implements AoModelsService {
    private final ActiveObjects activeObjects;

    @Autowired
    public AoModelsServiceImpl(ActiveObjects activeObjects) {
        this.activeObjects = activeObjects;
    }

    @Override
    public void createModels(String[] parameters, String value) {
        this.deleteEntities();
        for (String param : parameters) {
            SpaceBannerModelAo spaceBannerModel = (SpaceBannerModelAo)this.activeObjects.create(SpaceBannerModelAo.class, new DBParam[0]);
            spaceBannerModel.setSpaceKey(param);
            spaceBannerModel.setDisplayValue(value);
            spaceBannerModel.save();
        }
    }

    @Override
    public void deleteEntities() {
        SpaceBannerModelAo[] entities = (SpaceBannerModelAo[])this.activeObjects.find(SpaceBannerModelAo.class);
        if (entities != null) {
            this.activeObjects.delete((RawEntity[])entities);
        }
    }

    @Override
    public List<SpaceBannerModel> getAllModels() {
        return Arrays.stream((SpaceBannerModelAo[])this.activeObjects.find(SpaceBannerModelAo.class)).map(spaceModel -> {
            SpaceBannerModel model = new SpaceBannerModel();
            model.setDisplayValue(spaceModel.getDisplayValue());
            model.setSpaceKey(spaceModel.getSpaceKey());
            return model;
        }).collect(Collectors.toList());
    }

    @Override
    public void createIconSwitcher(String display2) {
        this.activeObjects.delete(this.activeObjects.find(IconSwitcherAo.class));
        IconSwitcherAo switcherAo = (IconSwitcherAo)this.activeObjects.create(IconSwitcherAo.class, new DBParam[0]);
        switcherAo.setWhatToDisplay(display2);
        switcherAo.save();
    }

    @Override
    public IconsSwitcher getIconSwitcher() {
        IconSwitcherAo switcherAo = ((IconSwitcherAo[])this.activeObjects.find(IconSwitcherAo.class))[0];
        IconsSwitcher switcher = new IconsSwitcher();
        switcher.setWhatToDisplay(switcherAo.getWhatToDisplay());
        return switcher;
    }

    @Override
    public void createPanelType(String type, boolean displayMainDialog) {
        this.deletePanelType();
        PanelTypeAo panelTypeAo = (PanelTypeAo)this.activeObjects.create(PanelTypeAo.class, new DBParam[0]);
        panelTypeAo.setPanelTypeValue(type);
        panelTypeAo.setDisplayMainDialog(displayMainDialog);
        panelTypeAo.save();
    }

    @Override
    public PanelTypeModel getPanelType() {
        PanelTypeAo[] panelTypeAos = (PanelTypeAo[])this.activeObjects.find(PanelTypeAo.class);
        if (panelTypeAos.length > 0) {
            PanelTypeAo pt = panelTypeAos[0];
            PanelTypeModel typeModel = new PanelTypeModel();
            typeModel.setPanelTypeValue(pt.getPanelTypeValue());
            typeModel.setDisplayMainDialog(pt.isDisplayMainDialog());
            return typeModel;
        }
        PanelTypeModel typeModel = new PanelTypeModel();
        typeModel.setPanelTypeValue("Default");
        typeModel.setDisplayMainDialog(true);
        return typeModel;
    }

    @Override
    public String getAOTableNames() {
        return ((PanelTypeAo[])this.activeObjects.find(PanelTypeAo.class))[0].getEntityManager().getTableNameConverter().getName(PanelTypeAo.class);
    }

    private void deletePanelType() {
        PanelTypeAo[] panelTypeAos;
        for (PanelTypeAo panelTypeAo : panelTypeAos = (PanelTypeAo[])this.activeObjects.find(PanelTypeAo.class)) {
            this.activeObjects.delete(new RawEntity[]{panelTypeAo});
        }
    }
}

