/*
 * Decompiled with CFR 0.152.
 */
package com.bh.servlets;

import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.bh.services.AoModelsService;
import com.bh.services.BandanaModelsService;
import com.bh.services.ConditionsCheckerService;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class IconsPanelSwitcherServlet
extends HttpServlet {
    private final TemplateRenderer templateRenderer;
    private final ConditionsCheckerService conditionsCheckerService;
    private final AoModelsService aoModelsService;
    private final BandanaModelsService bandanaModelsService;

    public IconsPanelSwitcherServlet(TemplateRenderer templateRenderer, ConditionsCheckerService conditionsCheckerService, AoModelsService aoModelsService, BandanaModelsService bandanaModelsService) {
        this.templateRenderer = templateRenderer;
        this.conditionsCheckerService = conditionsCheckerService;
        this.aoModelsService = aoModelsService;
        this.bandanaModelsService = bandanaModelsService;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        if (this.conditionsCheckerService.isLicenseOK() && this.conditionsCheckerService.isSystemConfAdmin(AuthenticatedUserThreadLocal.get())) {
            HashMap<String, Object> context = new HashMap<String, Object>();
            context.put("panel", this.aoModelsService.getPanelType());
            context.put("contextPath", req.getContextPath());
            String panelTypeValue = this.aoModelsService.getPanelType().getPanelTypeValue();
            context.put("panelTypeValue", panelTypeValue);
            this.templateRenderer.render("templates/panel-type-admin-menu.vm", context, (Writer)resp.getWriter());
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (this.conditionsCheckerService.isLicenseOK() && this.conditionsCheckerService.isSystemConfAdmin(AuthenticatedUserThreadLocal.get())) {
            if (req.getParameter("mainDialogIcon") == null || req.getParameter("mainDialogIcon").isEmpty()) {
                this.aoModelsService.createPanelType(req.getParameter("panel-type"), false);
            } else {
                this.aoModelsService.createPanelType(req.getParameter("panel-type"), true);
            }
            resp.sendRedirect(req.getContextPath() + "/plugins/servlet/panel-switcher");
        }
    }
}

