import React, {useState, useEffect} from 'react';
import {Chart} from 'react-google-charts';
import Banner from '@atlaskit/banner';
import WarningIcon from '@atlaskit/icon/glyph/warning';
import Spinner from '@atlaskit/spinner';

const Stats = (props) => {
    const [currUser, setCurrUser] = useState(null);
    const [currUserLoaded, setCurrUserLoaded] = useState(false);
    const [currUserComments, setCurrUserComments] = useState(0);
    const [currUserCommentsLoaded, setCurrUserCommentsLoaded] = useState(false);
    const [allComments, setAllComments] = useState(0);
    const [spacesComments, setSpacesComments] = useState([]);
    const [spacesCommentsLoaded, setSpacesCommentsLoaded] = useState(false);
    const [footerComments, setFooterComments] = useState(0);
    const [footerCommentsLoaded, setFooterCommentsLoaded] = useState(false);
    const [inlineComments, setInlineComments] = useState(0);
    const [inlineCommentsLoaded, setInlineCommentsLoaded] = useState(false);
    const [unresolved, setUnresolved] = useState(0);
    const [unresolvedLoaded, setUnresolvedLoaded] = useState(false);
    const [resolved, setResolved] = useState(0);
    const [resolvedLoaded, setResolvedLoaded] = useState(false);
    const [allCommentsLoaded, setAllCommentsLoaded] = useState(false);
    const [spaces, setSpaces] = useState([]);
    const [spacesLoaded, setSpacesLoaded] = useState(false);

    async function fetchSpaces() {
        let currData = await fetch(`/rest/api/space?limit=50`);
        let responseBody = await currData.json();
        let currSpaces = responseBody.results;
        setSpaces(data => [...data, ...currSpaces]);
        let nextLink = responseBody._links.next;
        if (nextLink !== undefined && nextLink !== '') {
            let nextData = await fetch(nextLink);
            let nextResponseBody = await nextData.json();
            let currSpacesNext = nextResponseBody.results;
            setSpaces(data => [...data, ...currSpacesNext]);
        }
        setSpacesLoaded(true);
    }

    async function getCommentsBySpace(spaceKey) {
        //todo
    }

    async function fetchCurrUser() {
        let currUserData = await fetch('/rest/api/user/current');
        let currUser = await currUserData.json();
        setCurrUser(currUser);
        setCurrUserLoaded(true);
    }

    useEffect(() => {
        async function initSpacesChart(colors) {
            if (spacesLoaded && currUserLoaded) {
                for (let space of spaces) {
                    if (space.type === "global") {
                        const REQ_URL = `/rest/api/search?cql=creator="${currUser.username}" and type=comment%20and%20space=${space.key}`;
                        let data = await fetch(REQ_URL);
                        let body = await data.json();
                        // console.log(body)
                        if (body !== undefined) {
                            if (body.totalSize > 0) {
                                const totalSize = Number.parseInt(body.totalSize)
                                // console.log([space.key, totalSize, '#091E42'])
                                let color = colors[Math.ceil(Math.random() * 10)]
                                setSpacesComments(old => [...old, [space.key, totalSize, color]]); //['All', allComments, '#091E42']
                            }
                        }
                    }
                }
                setSpacesCommentsLoaded(true);
            }
        }

        if (spacesLoaded) {
            let colors = ['#091E42', '#0065FF', '#00B8D9', '#36B37E', '#FFAB00', '#FF5630', '#6554C0',
                          '#EBECF0', '#0045FF', '#F15B39'];
            initSpacesChart(colors);
        }
    }, [spacesLoaded])

    useEffect(() => {
        if (currUserLoaded) {
            async function loadAllComments() {
                const data = await fetch('/rest/api/search?cql=type=comment');
                const jsonData = await data.json();
                setAllComments(jsonData.totalSize);
                setAllCommentsLoaded(true);
            }

            async function loadMyComments() {
                let resp = await fetch(`/rest/api/search?cql=creator="${currUser.username}" and type=comment`);
                let respJson = await resp.json();
                setCurrUserComments(respJson.totalSize);
                setCurrUserCommentsLoaded(true);
            }

            // async function loadSimple() {
            //     fetch(`/bht/comments/user?userId=${currUser.accountId}&commentType=Simple&status=&from=&to=`, {
            //         method: 'GET',
            //         headers: {
            //             Authorization: `JWT ${jwt}`
            //         }
            //     })
            //         .then(resp => resp.json()).then(data => {
            //         setBasic(data.length);
            //     });
            //     setBasicLoaded(true);
            // }
            async function loadFooterComments() {
                let resp = await fetch(`/rest/bht-rest/1.0/bht-comments/stats/footer-comments`);
                let respJson = await resp.json();
                setFooterComments(respJson.size);
                setFooterCommentsLoaded(true);
            }

            async function loadInlineComments() {
                let resp = await fetch(`/rest/bht-rest/1.0/bht-comments/stats/inline-comments`);
                let respJson = await resp.json();
                setInlineComments(respJson.size);
                setInlineCommentsLoaded(true);
            }

            async function loadUnresolved() {
                let resp = await fetch(`/rest/bht-rest/1.0/bht-comments/stats/unres-comments`);
                let respJson = await resp.json();
                setUnresolved(respJson.size);
                setUnresolvedLoaded(true);
            }

            async function loadResolved() {
                let resp = await fetch(`/rest/bht-rest/1.0/bht-comments/stats/res-comments`);
                let respJson = await resp.json();
                setResolved(respJson.size);
                setResolvedLoaded(true);
            }

            loadAllComments();
            loadMyComments();
            loadFooterComments();
            loadInlineComments();
            loadUnresolved();
            loadResolved();

        }
    }, [currUserLoaded])

    useEffect(() => {
        fetchCurrUser();
        fetchSpaces() // spaces
    }, []);

    return (
        <div>
            <div>
                <div>
                    <Banner
                        appearance="warning"
                        icon={<WarningIcon label="" secondaryColor="inherit"/>}
                    >
                        Menu is still in development mode to be improved.{' '}
                    </Banner>
                </div>
                <div style={{marginTop: "10px"}}>
                    <h3>Statistics</h3>
                </div>
            </div>
            <div style={{display: 'flex', padding: '15px', margin: '10px'}}>
                <div style={{width: '10rem'}}>
                    <p><b>All</b>: {allCommentsLoaded ? allComments : <Spinner interactionName={'all-load'} size={'small'} />}</p>
                    <p><b>Mine</b>: {currUserCommentsLoaded ? currUserComments : <Spinner interactionName={'mine-load'} size={'small'} />}</p>
                    <p><b>Footer</b>: {footerCommentsLoaded ? footerComments : <Spinner interactionName={'footer-load'} size={'small'} />}</p>
                    <p><b>Inline</b>: {inlineCommentsLoaded ? inlineComments : <Spinner interactionName={'inline-load'} size={'small'} />}</p>
                    <p><b>Unresolved</b>: {unresolvedLoaded ? unresolved : <Spinner interactionName={'unres-load'} size={'small'} />}</p>
                    <p><b>Resolved</b>: {resolvedLoaded ? resolved : <Spinner interactionName={'res-load'} size={'small'} />}</p>
                </div>
                <div style={{display: 'block'}}>
                    <div id='bht-comments-chart'>
                        <Chart
                            width={'900px'}
                            height={'500px'}
                            chartType='ColumnChart'
                            loader={<Spinner size={'large'} interactionName="chart-load" />}
                            data={[
                                ['Type', '', {role: 'style'}],
                                ['All', allComments, '#a3b9de'],
                                ['Mine', currUserComments, '#ab8279'],
                                ['Footer', footerComments, '#d2439f'],
                                ['Inline', inlineComments, '#2471d7'],
                                ['Unresolved', unresolved, '#d39319'],
                                ['Resolved', resolved, '#58d718'],
                            ]}
                            options={{
                                title: 'Comments count',
                                chartArea: {width: '70%'},
                                // hAxis: {
                                //   title: 'Months',
                                //   minValue: 0,
                                // },
                                // vAxis: {
                                //   title: 'Count',
                                // },
                            }}
                            // For tests
                            rootProps={{'data-testid': '1'}}
                        />
                        <div>
                            <h3>Comments per space</h3>
                            {spacesCommentsLoaded && console.log(spacesComments)}
                            {!spacesCommentsLoaded ? <Spinner size={'large'}/> : <Chart
                                width={'1200px'}
                                height={'700px'}
                                chartType='ColumnChart'
                                loader={<div>Loading Chart</div>}
                                data={[
                                    ['Type', '', {role: 'style'}],
                                    ...spacesComments
                                ]}
                                options={{
                                    title: 'Comments per space',
                                    chartArea: {width: '80%'},
                                    // hAxis: {
                                    //   title: 'Months',
                                    //   minValue: 0,
                                    // },
                                    // vAxis: {
                                    //   title: 'Count',
                                    // },
                                }}
                                // For tests
                                rootProps={{'data-testid': '2'}}
                            />}
                        </div>
                    </div>
                </div>
            </div>
        </div>
    )
}

export default Stats;
