import React, {Fragment, useCallback, useEffect, useRef, useState} from 'react';
import ReactDOM from 'react-dom';
import Button from '@atlaskit/button';
import Select from '@atlaskit/select';
import {DateTimePicker} from '@atlaskit/datetime-picker';
import Spinner from '@atlaskit/spinner';
import {LocalDate} from "@js-joda/core";
import {Checkbox} from '@atlaskit/checkbox';

import Tabs, {Tab, TabList, TabPanel} from '@atlaskit/tabs';
import CommentsListTable from './CommentsListTable';
import Stats from "./Stats";
import UserComments from "./UserComments";

const Profile = (props) => {
    let today = LocalDate.now();
    let spaceKeysRef = useRef();
    let commentTypeRef = useRef();
    let commentsAuthorRef = useRef();
    let from = today.minusDays(30).toString()  //'2021-09-01';
    let to = today.plusDays(1).toString() //'2021-09-22';      // + 1 day ?

    const hostUrlWithoutContext = "";
    const [comments, setComments] = useState([]);
    const [allComments, setAllComments] = useState([]);
    const [commentsType, setCommentsType] = useState('All');
    const [spaces, setSpaces] = useState(null);
    const [spaceOptions, setSpaceOptions] = useState([]);
    const [spaceOptionsReady, setSpaceOptionsReady] = useState(false);
    const [commentsLoading, setCommentsLoading] = useState(false);
    const [commentsLoaded, setCommentsLoaded] = useState(false);
    const [commentsEmpty, setCommentsEmpty] = useState(false);
    const [fromDate, setFromDate] = useState(from);
    const [toDate, setToDate] = useState(to);
    const [commentsNumber, setCommentsNumber] = useState(0);
    const [pagesNumber, setPagesNumber] = useState(0);
    const [unresolvedCommentsOnly, setUnresolvedCommentsOnly] = useState(false);
    const [inlinePresent, setInlinePresent] = useState(false);

    useEffect(() => {
        async function fetchSpaces() {
            let currData = await fetch(`/rest/api/space?limit=100`); // string
            let responseBody = await currData.json();  // json
            let currSpaces = responseBody.results;      // array
            currSpaces.forEach(space => spaceOptions.push({label: space.name, value: space.key}));
            let nextLink = responseBody._links.next;
            if (nextLink !== undefined && nextLink !== '') {
                while (nextLink !== undefined && nextLink !== '') {
                    let nextData = await fetch(nextLink);
                    let nextResponseBody = await nextData.json();
                    let currSpacesNext = nextResponseBody.results;
                    currSpacesNext.forEach(space => spaceOptions.push({label: space.name, value: space.key}));
                    nextLink = nextResponseBody._links.next;
                }
            }
            setSpaceOptionsReady(true);
        }

        fetchSpaces();
    }, [])

    useEffect(() => {
        // console.log('>>> state:');
        // console.log(spaces);
        // console.log(commentsLoaded);
    }, [commentsType])

    const handleClick = (event) => {
        // console.log(spaces);
        // console.log(commentsType);
        // console.log(commentsLoaded);
        setCommentsLoading(true);       // start of comments loading
        getAllComments();

        async function getPages(spaceKey) {
            let pages = [];
            let currData = await fetch(`/rest/api/content?spaceKey=${spaceKey}`);
            let responseBody = await currData.json();   // json
            let currPages = responseBody.results;      // array

            currPages.forEach(page => pages.push(page));
            let nextLink = responseBody._links.next;

            if (nextLink !== undefined && nextLink !== '') {
                while (nextLink !== undefined && nextLink !== '') {
                    let nextData = await fetch(nextLink);
                    let nextResponseBody = await nextData.json();
                    let currPagesNext = nextResponseBody.results;
                    currPagesNext.forEach(page => pages.push(page));
                    nextLink = nextResponseBody['_links'].next;
                }
            }
            return pages;
        }

        // fetch comments for a Page
        async function fetchCommRes(page) {
            // async function fetchPageCommAuthors(comments) {
            //     comments.forEach(c => {
            //         let author = c.history.createdBy;
            //         // setAuthors(data => [...data, author]);
            //     });
            // }

            try {
                let fetchedComments = await fetchPageComments(page);
                // console.log('>>> first comments:');
                // console.log(fetchedComments);

                /* get current state from CURRENT value, not from state itself
                    * setTheArray(oldArray => [...oldArray, newElement]);
                * */
                setCommentsNumber(current => current + fetchedComments.length); // set first comments number
                if (fetchedComments.length > 0) {
                    setComments(comments => [...comments, ...fetchedComments]);
                    setAllComments(comments => [...comments, ...fetchedComments]);

                    comments.filter(comment => comment.status === "Unresolved").length > 0
                        ? setInlinePresent(true) : setInlinePresent(false);
                    setCommentsLoaded(true);
                    // fetchPageCommAuthors(comments).then(resp => console.log(resp));
                }
                // check if any comments are UNRESOLVED

                // set loading to false
                setCommentsLoading(false);

            } catch (e) {
                console.error(e);
            }
        }

        async function fetchPageComments(page) {
            // console.log(">> fetchPageComments(page)")
            try {
                const reqUrl =
                    `/rest/bht-rest/1.0/bht-comments-pages/page?id=${page.id}&commentType=${commentsType}&fromDate=${fromDate}&toDate=${toDate}`;
                let res = await fetch(reqUrl);
                return await res.json();
            } catch (e) {
                console.error(e);
            }
        }

        async function getAllComments() {
            setComments([]);
            setCommentsNumber(0);

            let resBodyJson = await getPages(spaces.value); // get pages
            // console.log(">> getAllComments()");
            // console.log(resBodyJson);

            let pages = await resBodyJson;

            pages.forEach(page => {
                    getCommentsAsync(page); // getCommentsAsync
                    const delay = (ms = 300) => new Promise(r => setTimeout(r, ms)); // creating delay
                    async function getCommentsAsync(page) {
                        // console.log(">> getCommentsAsync")
                        await delay();
                        await fetchCommRes(page);   // fetchCommRes
                    }
                }
            );
            // let nextLink = resBodyJson._links.next;             // next link
            // if (nextLink !== undefined && nextLink !== '') {
            //     while (nextLink !== undefined && nextLink !== '') {
            //         let nextData = await fetch(nextLink);
            //         let nextResponseBody = await nextData.json();
            //         let nextPages = nextResponseBody.results;
            //         setPagesNumber(current => current + nextPages.length);    // add next pages iteration to number
            //         await nextPages.forEach(page => {
            //             const delay = (ms = 300) => new Promise(r => setTimeout(r, ms));    // creating delay
            //             getCommentsAsync();
            //
            //             async function getCommentsAsync() {
            //                 await delay();
            //                 await fetchCommRes(page);
            //             }
            //         });
            //         nextLink = nextResponseBody._links.next;
            //     }
            // }
        }
    }

    const handleFromDateChange = (value) => {
        // 2021-10-01T00:00+0300
        let dateFromSub = value.substring(0, value.indexOf('T'));
        setFromDate(dateFromSub);
    }
    const handleToDateChange = (value) => {
        let dateToSub = value.substring(0, value.indexOf('T'));
        setToDate(dateToSub);
    }
// const disabledArray = ['2020-12-04'];
// const defaultPreviouslySelected = ['2020-12-06'];
// const defaultSelected = ['2020-12-08'];

    const [selected, setSelected] = useState(0);

    const handleUpdate = useCallback(
        (index) => setSelected(index),
        [setSelected],
    );

    const switchUnresolvedComments = () => {
        if (unresolvedCommentsOnly === true) {
            setComments(comments => [...allComments.filter(comm => comm.status === 'Unresolved')]);
            setUnresolvedCommentsOnly(true);
        } else {
            setComments(comments => [...allComments]);
            setUnresolvedCommentsOnly(false);
        }
    }

    return (
        <Fragment>
            <div>
                <Tabs onChange={handleUpdate} selected={selected} id="bht-tabs-controlled">
                    <TabList>
                        <Tab>Comments Table</Tab>
                        <Tab>User Comments</Tab>
                        <Tab>Stats</Tab>
                    </TabList>
                    <TabPanel>
                        <div style={{display: 'block'}}>
                            <div>
                                <div className={'bht-aui-group'}>
                                    <div className={'bht-aui-elem'}>
                                        <span><b>Space:</b></span>
                                        <Select inputId="bht-spaces-select"
                                                className="single-select"
                                                classNamePrefix="react-select"
                                                options={ // {label: 'Demo', value: 'Demo'},
                                                    [...spaceOptions]
                                                }
                                                placeholder="Choose space"
                                                ref={spaceKeysRef}
                                                onChange={option => setSpaces(option)}
                                            // onChange={option => setState({...state, ['spaces']: option.value })}
                                        />
                                    </div>
                                    <div className={'bht-aui-elem'}>
                                        <span><b>Comment Type:</b></span>
                                        <Select inputId="bht-comments-type-select"
                                                className="single-select"
                                                classNamePrefix="react-select"
                                                defaultValue={{label: 'All comments', value: 'All'}}
                                            // defaultInputValue="All comments"
                                            // defaultMenuIsOpen={true}
                                                options={[
                                                    {label: 'All comments', value: 'All'},
                                                    {label: 'Inline comments', value: 'Inline'},
                                                    {label: 'Page comments', value: 'Simple'}
                                                ]}
                                                placeholder='Choose comment type'
                                                ref={commentTypeRef}
                                            // value={commentsType}
                                            // inputValue={''}
                                            // onInputChange={option => setCommentsType(option.value)}
                                                onChange={option => setCommentsType(option.value)}
                                        />

                                    </div>
                                    {/*<div className={'bht-aui-elem'}>*/}
                                    {/*    <span><b>Author:</b></span>*/}
                                    {/*    <Select inputId="bht-comment-author-select"*/}
                                    {/*            className="single-select"*/}
                                    {/*            classNamePrefix="react-select"*/}
                                    {/*            options={*/}
                                    {/*                [...authorOptions]*/}
                                    {/*            }*/}
                                    {/*            placeholder="Author"*/}
                                    {/*            ref={commentsAuthorRef}*/}
                                    {/*            onChange={option => setAuthor(option)}*/}
                                    {/*        // onChange={option => setState({...state, ['spaces']: option.value })}*/}
                                    {/*    />*/}
                                    {/*</div>*/}
                                    <div className={'bht-aui-elem'}>
                                        {/*<Calendar*/}
                                        {/*    // disabled={disabledArray}*/}
                                        {/*    // maxDate={'2020-12-25'}*/}
                                        {/*    // defaultPreviouslySelected={defaultPreviouslySelected}*/}
                                        {/*    // defaultSelected={defaultSelected}*/}
                                        {/*    defaultMonth={12}*/}
                                        {/*    // onBlur={onBlur}*/}
                                        {/*    // onChange={onChange}*/}
                                        {/*    // onSelect={(event, analyticsEvent) => setFromDate(event.ta)}*/}
                                        {/*    testId={'calendar'}*/}
                                        {/*/>*/}
                                        <span><b>Date From:</b></span>
                                        <DateTimePicker
                                            id={'from-date-picker'}
                                            defaultValue={fromDate}
                                            timePickerProps={{isDisabled: true}}
                                            onChange={value => {
                                                handleFromDateChange(value)
                                            }} // 2021-10-01T00:00+0300
                                        />

                                    </div>
                                    <div className={'bht-aui-elem'}>
                                        <span><b>Date To:</b></span>
                                        <DateTimePicker
                                            style={{'z-index': 3}}
                                            id={'to-date-picker'}
                                            defaultValue={toDate}
                                            timePickerProps={{isDisabled: true}}
                                            onChange={value => handleToDateChange(value)}
                                        />
                                    </div>
                                    <div style={{'margin-top': '31px'}} className={'bht-aui-elem'}>
                                        <Button
                                            type="submit"
                                            appearance="primary"
                                            onClick={handleClick}
                                            isDisabled={commentsLoading || !spaces}
                                        >
                                            Submit
                                        </Button>
                                    </div>
                                </div>
                            </div>
                            <div>
                                <p><b>Pages</b>: {pagesNumber}</p>
                                <p><b>Comments</b>: {commentsNumber}</p>
                                {commentsLoading && <Spinner size={'large'}/>}
                                <div style={{margin: "10px", marginLeft: "140px"}}>
                                    {comments.length > 0 && <Checkbox //&& inlinePresent
                                        value="off"
                                        label="Unresolved Only"
                                        onChange={switchUnresolvedComments}
                                        name="checkbox-default"
                                        testId="cb-default"/>}
                                </div>
                                {comments.length > 0 &&
                                    // <CommentsList hostUrlWithoutContext={hostUrlWithoutContext} comments={comments}/>}
                                    <CommentsListTable hostUrlWithoutContext={hostUrlWithoutContext}
                                                       comments={comments}/>}
                                {comments.length === 0 && commentsLoaded && <p>No comments retrieved.</p>}
                            </div>
                        </div>
                    </TabPanel>
                    <TabPanel>
                        <div>
                            <UserComments/>
                        </div>
                    </TabPanel>
                    <TabPanel>
                        <div>
                            <Stats/>
                        </div>
                    </TabPanel>
                </Tabs>
            </div>

        </Fragment>
    )
};

function startRender() {
    ReactDOM.render(<Profile/>, document.querySelector('#profile-react-root'));
}

startRender();