import React, {useState, useEffect, useRef, Fragment} from 'react';
import Comment, {
    CommentAction,
    CommentAuthor,
    CommentEdited,
    CommentLayout,
    CommentTime
} from '@atlaskit/comment';
import Avatar from "@atlaskit/avatar";
import Pagination from "@atlaskit/pagination";

const CommentsList = (props) => {
    return <Fragment>
        {props.comments.map(comm => (<Comment
                avatar={<Avatar src={props.hostUrlWithoutContext + comm.history.createdBy.profilePicture.path}
                                name={comm.history.createdBy.displayName} size="medium"/>}
                author={<CommentAuthor>{comm.history.createdBy.displayName}</CommentAuthor>}
                type="author"
                // edited={<CommentEdited>Edited</CommentEdited>}
                // restrictedTo="Restricted to Admins Only"
                time={<CommentTime>{comm.history.createdDate}</CommentTime>}
                content={
                    <p>
                        {comm.body.view.value}
                    </p>
                }
                // actions={[
                //     <CommentAction>Reply</CommentAction>,
                //     <CommentAction>Edit</CommentAction>,
                //     <CommentAction>Like</CommentAction>,
                // ]}
            />)
        )}</Fragment>
}

export default CommentsList;