import { c as createCommonjsModule, g as getDefaultExportFromCjs, r as react } from './index-50b0b662.js';

var objectWithoutPropertiesLoose = createCommonjsModule(function (module) {
function _objectWithoutPropertiesLoose(source, excluded) {
  if (source == null) return {};
  var target = {};
  var sourceKeys = Object.keys(source);
  var key, i;

  for (i = 0; i < sourceKeys.length; i++) {
    key = sourceKeys[i];
    if (excluded.indexOf(key) >= 0) continue;
    target[key] = source[key];
  }

  return target;
}

module.exports = _objectWithoutPropertiesLoose;
module.exports["default"] = module.exports, module.exports.__esModule = true;
});

var objectWithoutProperties = createCommonjsModule(function (module) {
function _objectWithoutProperties(source, excluded) {
  if (source == null) return {};
  var target = objectWithoutPropertiesLoose(source, excluded);
  var key, i;

  if (Object.getOwnPropertySymbols) {
    var sourceSymbolKeys = Object.getOwnPropertySymbols(source);

    for (i = 0; i < sourceSymbolKeys.length; i++) {
      key = sourceSymbolKeys[i];
      if (excluded.indexOf(key) >= 0) continue;
      if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue;
      target[key] = source[key];
    }
  }

  return target;
}

module.exports = _objectWithoutProperties;
module.exports["default"] = module.exports, module.exports.__esModule = true;
});

var _objectWithoutProperties = /*@__PURE__*/getDefaultExportFromCjs(objectWithoutProperties);

/**
 * createTheme is used to create a set of Providers and Consumers for theming components.
 * - Takes a default theme function; this theme function gets a set of props, and returns tokens
 *  based on those props. An example of this default theme function is one that produces the standard
 *  appearance of the component
 * - Returns three things - a Provider that allow for additional themes to be applied, a Consumer
 *  that can get the current theme and fetch it, and a custom hook - useTheme which provides an alternate (although functionally the same) API
 *  to the Consumer.
 */
function createTheme(defaultGetTokens) {
  var emptyThemeFn = function emptyThemeFn(getTokens, props) {
    return getTokens(props);
  };
  /**
   * Internally, Theme uses React Context, with internal providers and consumers.
   * The React Context passes only a function that gets props, and turns them into tokens. This
   * function gets mixed as more Providers with their own themes are added. This mixed function
   * is ultimately picked up by Consumers, which implement a context consumer internally to fetch
   * the theme.
   */


  var ThemeContext = /*#__PURE__*/react.createContext(defaultGetTokens);

  function useTheme(themeProps) {
    var theme = react.useContext(ThemeContext);
    var themeFn = theme || emptyThemeFn;
    var tokens = themeFn(themeProps);
    return tokens;
  } // The Theme Consumer takes a function as its child - this function takes tokens, and the
  // return value is generally a set of nodes with the tokens applied appropriately.


  function Consumer(props) {
    var children = props.children,
        themeProps = _objectWithoutProperties(props, ["children"]); // @ts-ignore See issue for more info: https://github.com/Microsoft/TypeScript/issues/10727
    // Argument of type 'Pick<ThemeProps & { children: (tokens: ThemeTokens) => ReactNode; }, Exclude<keyof ThemeProps, "children">>' is not assignable to parameter of type 'ThemeProps'.ts(2345)


    var tokens = useTheme(themeProps); // We add a fragment to ensure we don't break people upgrading.
    // Previously they may have been able to pass in undefined without things blowing up.

    return /*#__PURE__*/react.createElement(react.Fragment, null, children(tokens));
  }
  /**
   * The Theme Provider takes regular nodes as its children, but also takes a *theme function*
   * - The theme function takes a set of props, as well as a function (getTokens) that can turn props into tokens.
   * - The getTokens function isn't called immediately - instead the props are passed
   *    through a mix of parent theming functions
   * Children of this provider will receive this mixed theme
   */


  function Provider(props) {
    var themeFn = react.useContext(ThemeContext);
    var valueFn = props.value || emptyThemeFn;
    var mixedFn = react.useCallback(function (themeProps) {
      return valueFn(themeFn, themeProps);
    }, [themeFn, valueFn]);
    return /*#__PURE__*/react.createElement(ThemeContext.Provider, {
      value: mixedFn
    }, props.children);
  }

  return {
    Consumer: Consumer,
    Provider: Provider,
    useTheme: useTheme
  };
}

var _createTheme = createTheme(function () {
  return {
    mode: 'light'
  };
}),
    Provider = _createTheme.Provider,
    Consumer = _createTheme.Consumer,
    useTheme = _createTheme.useTheme;
var GlobalTheme = {
  Provider: Provider,
  Consumer: Consumer
};

export { GlobalTheme as G, _objectWithoutProperties as _, createTheme as c, useTheme as u };
