import { r as react } from './index-50b0b662.js';
import { c as css, j as jsx, t as token, d as N40, h as N500, O as B50, w as B500, V as Y75, L as N800, W as P50, X as P500, Z as R50, A as R500, _ as G50, $ as G500, i as N0, u as B400, F as Y500, a0 as P400, f as R400, e as G400, g as gridSize, S as borderRadius } from './colors-25aad6bf.js';

/** @jsx jsx */
var defaultAppearanceStyles = css({
  backgroundColor: token('color.background.subtleNeutral.resting', N40),
  color: token('color.text.highEmphasis', N500)
});
var inprogressAppearanceStyles = css({
  backgroundColor: token('color.background.subtleBrand.resting', B50),
  color: token('color.text.brand', B500)
});
var movedAppearanceStyles = css({
  backgroundColor: token('color.background.subtleWarning.resting', Y75),
  color: token('color.text.warning', N800)
});
var newAppearanceStyles = css({
  backgroundColor: token('color.background.subtleDiscovery.resting', P50),
  color: token('color.text.discovery', P500)
});
var removedAppearanceStyles = css({
  backgroundColor: token('color.background.subtleDanger.resting', R50),
  color: token('color.text.danger', R500)
});
var successAppearanceStyles = css({
  backgroundColor: token('color.background.subtleSuccess.resting', G50),
  color: token('color.text.success', G500)
});
var defaultBoldAppearanceStyles = css({
  backgroundColor: token('color.background.boldNeutral.resting', N500),
  color: token('color.text.onBold', N0)
});
var inprogressBoldAppearanceStyles = css({
  backgroundColor: token('color.background.boldBrand.resting', B400),
  color: token('color.text.onBold', N0)
});
var movedBoldAppearanceStyles = css({
  backgroundColor: token('color.background.boldWarning.resting', Y500),
  color: token('color.text.onBoldWarning', N800)
});
var newBoldAppearanceStyles = css({
  backgroundColor: token('color.background.boldDiscovery.resting', P400),
  color: token('color.text.onBold', N0)
});
var removedBoldAppearanceStyles = css({
  backgroundColor: token('color.background.boldDanger.resting', R400),
  color: token('color.text.onBold', N0)
});
var successBoldAppearanceStyles = css({
  backgroundColor: token('color.background.boldSuccess.resting', G400),
  color: token('color.text.onBold', N0)
});
var subtleAppearances = {
  default: defaultAppearanceStyles,
  inprogress: inprogressAppearanceStyles,
  moved: movedAppearanceStyles,
  new: newAppearanceStyles,
  removed: removedAppearanceStyles,
  success: successAppearanceStyles
};
var boldAppearances = {
  default: defaultBoldAppearanceStyles,
  inprogress: inprogressBoldAppearanceStyles,
  moved: movedBoldAppearanceStyles,
  new: newBoldAppearanceStyles,
  removed: removedBoldAppearanceStyles,
  success: successBoldAppearanceStyles
};
var contentStyles = css({
  display: 'inline-block',
  boxSizing: 'border-box',
  width: '100%',
  padding: "0 ".concat(gridSize() / 2, "px"),
  overflow: 'hidden',
  textOverflow: 'ellipsis',
  verticalAlign: 'top',
  whiteSpace: 'nowrap'
});
var containerStyles = css({
  display: 'inline-block',
  boxSizing: 'border-box',
  maxWidth: '100%',
  padding: '2px 0 3px 0',
  borderRadius: borderRadius(),
  fontSize: '11px',
  fontWeight: 700,
  lineHeight: 1,
  textTransform: 'uppercase',
  verticalAlign: 'baseline'
});
/**
 * __Lozenge__
 *
 * A lozenge is a visual indicator used to highlight an item's status for quick recognition.
 *
 * - [Examples](https://atlassian.design/components/lozenge/examples)
 * - [Code](https://atlassian.design/components/lozenge/code)
 * - [Usage](https://atlassian.design/components/lozenge/usage)
 */

var Lozenge = /*#__PURE__*/react.memo(function (_ref) {
  var children = _ref.children,
      testId = _ref.testId,
      _ref$isBold = _ref.isBold,
      isBold = _ref$isBold === void 0 ? false : _ref$isBold,
      _ref$appearance = _ref.appearance,
      appearance = _ref$appearance === void 0 ? 'default' : _ref$appearance,
      _ref$maxWidth = _ref.maxWidth,
      maxWidth = _ref$maxWidth === void 0 ? 200 : _ref$maxWidth,
      _ref$style = _ref.style,
      style = _ref$style === void 0 ? {} : _ref$style;
  return jsx("span", {
    style: {
      backgroundColor: style.backgroundColor,
      color: style.color
    },
    css: [isBold ? boldAppearances[appearance] : subtleAppearances[appearance], containerStyles],
    "data-testid": testId
  }, jsx("span", {
    style: {
      maxWidth: maxWidth
    },
    css: contentStyles
  }, children));
});
Lozenge.displayName = 'Lozenge';

export { Lozenge as L };
