import { c as _extends } from './useAnalyticsEvents-2e16b30c.js';
import { _ as _slicedToArray } from './slicedToArray-a5de7267.js';
import { G as GlobalTheme, _ as _objectWithoutProperties } from './theme-742e153b.js';
import { r as react } from './index-50b0b662.js';
import { g as getIsOnlySingleIcon, a as getCss, B as ButtonBase } from './get-is-only-single-icon-3e32a817.js';

function noop() {}

var isFirefox = typeof navigator !== 'undefined' && navigator.userAgent.toLowerCase().indexOf('firefox') > -1;
var ButtonWithMode = /*#__PURE__*/react.forwardRef(function ButtonWithMode(_ref, ref) {
  var mode = _ref.mode,
      _ref$onMouseDown = _ref.onMouseDown,
      providedOnMouseDown = _ref$onMouseDown === void 0 ? noop : _ref$onMouseDown,
      _ref$onMouseUp = _ref.onMouseUp,
      providedOnMouseUp = _ref$onMouseUp === void 0 ? noop : _ref$onMouseUp,
      rest = _objectWithoutProperties(_ref, ["mode", "onMouseDown", "onMouseUp"]);

  var appearance = rest.appearance || 'default';
  var spacing = rest.spacing || 'default';
  var shouldFitContainer = Boolean(rest.shouldFitContainer);
  var isSelected = Boolean(rest.isSelected);
  var isOnlySingleIcon = getIsOnlySingleIcon(rest);

  var _useState = react.useState(false),
      _useState2 = _slicedToArray(_useState, 2),
      isActive = _useState2[0],
      setIsActive = _useState2[1]; // Wrap onMouseDown / onMouseUp to manually trigger active state
  //  in Firefox


  var onMouseDown = react.useCallback(function (event) {
    providedOnMouseDown(event);

    if (isFirefox) {
      setIsActive(true);
    }
  }, [providedOnMouseDown, setIsActive]);
  var onMouseUp = react.useCallback(function (event) {
    providedOnMouseUp(event);

    if (isFirefox) {
      setIsActive(false);
    }
  }, [providedOnMouseUp, setIsActive]);
  var buttonCss = react.useMemo(function () {
    return getCss({
      appearance: appearance,
      spacing: spacing,
      mode: mode,
      isSelected: isSelected,
      shouldFitContainer: shouldFitContainer,
      isOnlySingleIcon: isOnlySingleIcon
    });
  }, [appearance, spacing, mode, isSelected, shouldFitContainer, isOnlySingleIcon]);
  return /*#__PURE__*/react.createElement(ButtonBase, _extends({}, rest, {
    ref: ref,
    buttonCss: buttonCss // Due to how click events are set, we need to set active styles
    //  manually in Firefox and wrap onMouseDown/onMouseUp
    ,
    "data-firefox-is-active": isActive ? true : undefined,
    onMouseDown: onMouseDown,
    onMouseUp: onMouseUp
  }));
});
var Button = /*#__PURE__*/react.memo( /*#__PURE__*/react.forwardRef(function Button(props, ref) {
  return /*#__PURE__*/react.createElement(GlobalTheme.Consumer, null, function (_ref2) {
    var mode = _ref2.mode;
    return /*#__PURE__*/react.createElement(ButtonWithMode, _extends({}, props, {
      ref: ref,
      mode: mode
    }));
  });
})); // Tools including enzyme rely on components having a display name

Button.displayName = 'Button';

export { Button as B };
