import { c as _extends, a as _defineProperty } from './useAnalyticsEvents-2e16b30c.js';
import { r as react } from './index-50b0b662.js';
import { t as token, c as css, j as jsx } from './colors-25aad6bf.js';
import { u as useTheme } from './theme-742e153b.js';

var themedBackground = {
  light: token('color.background.default', '#FFFFFF'),
  dark: token('color.background.default', '#1B2638')
};
/**
 * Returns the background color depending on the passed through mode.
 * @param mode
 */

var getBackground = function getBackground() {
  var mode = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 'light';
  return themedBackground[mode];
};

var sizes = {
  small: '16px',
  medium: '24px',
  large: '32px',
  xlarge: '48px'
};
var dimensions = {
  small: {
    width: sizes.small,
    height: sizes.small
  },
  medium: {
    width: sizes.medium,
    height: sizes.medium
  },
  large: {
    width: sizes.large,
    height: sizes.large
  },
  xlarge: {
    width: sizes.xlarge,
    height: sizes.xlarge
  }
};

var commonSVGStyles = {
  overflow: 'hidden',
  pointerEvents: 'none',

  /**
   * Stop-color doesn't properly apply in chrome when the inherited/current color changes.
   * We have to initially set stop-color to inherit (either via DOM attribute or an initial CSS
   * rule) and then override it with currentColor for the color changes to be picked up.
   */
  stop: {
    stopColor: 'currentColor'
  }
};
var smallStyles = css(dimensions.small);
var mediumStyles = css(dimensions.medium);
var largeStyles = css(dimensions.large);
var xlargeStyles = css(dimensions.xlarge); // pre-built css style-size map
/**
 * Returns the width of the icon's parent span. This function has
 * special behaviour to deal with icon-file-type specifically.
 *
 * The reality is the SVG still has its own dimensions, so this is
 * a secondary fallback which in 95% of cases is not required.
 * It's only really being kept to maintain backward compatability.
 */

var getIconSize = function getIconSize(_ref) {
  var width = _ref.width,
      height = _ref.height,
      size = _ref.size;

  if (width && height) {
    return {
      width: width,
      height: height
    };
  }

  if (size) {
    return dimensions[size];
  }

  return undefined;
};

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }
/**
 * We are hiding these props from consumers as they're used to
 * hack around icon sizing specifically for icon-file-type.
 */

var iconStyles = css({
  display: 'inline-block',
  flexShrink: 0,
  lineHeight: 1,
  // eslint-disable-next-line @repo/internal/styles/no-nested-styles
  '> svg': _objectSpread(_objectSpread({}, commonSVGStyles), {}, {
    maxWidth: '100%',
    maxHeight: '100%',
    color: 'var(--icon-primary-color)',
    fill: 'var(--icon-secondary-color)',
    verticalAlign: 'bottom'
  })
});
/**
 * For windows high contrast mode
 */

var baseHcmStyles = css({
  '@media screen and (forced-colors: active)': {
    // eslint-disable-next-line @repo/internal/styles/no-nested-styles
    '> svg': {
      filter: 'grayscale(1)',
      '--icon-primary-color': 'CanvasText',
      // foreground
      '--icon-secondary-color': 'Canvas' // background

    }
  }
});
var primaryEqualsSecondaryHcmStyles = css({
  '@media screen and (forced-colors: active)': {
    // eslint-disable-next-line @repo/internal/styles/no-nested-styles
    '> svg': {
      // if the primaryColor is the same as the secondaryColor we
      // set the --icon-primary-color to Canvas
      // this is usually to convey state i.e. Checkbox checked -> not checked
      '--icon-primary-color': 'Canvas' // foreground

    }
  }
});
var secondaryTransparentHcmStyles = css({
  '@media screen and (forced-colors: active)': {
    // eslint-disable-next-line @repo/internal/styles/no-nested-styles
    '> svg': {
      '--icon-secondary-color': 'transparent' // background

    }
  }
});
/**
 * __Icon__
 *
 * An icon is used as a visual representation of common actions and commands to provide context.
 *
 * - [Examples](https://atlaskit.atlassian.com/packages/design-system/icon)
 * - [Code](https://atlaskit.atlassian.com/packages/design-system/icon/docs/custom-icons)
 */

var Icon = /*#__PURE__*/react.memo(function Icon(props) {
  var _ref = props,
      Glyph = _ref.glyph,
      dangerouslySetGlyph = _ref.dangerouslySetGlyph,
      _ref$primaryColor = _ref.primaryColor,
      primaryColor = _ref$primaryColor === void 0 ? 'currentColor' : _ref$primaryColor,
      secondaryColor = _ref.secondaryColor,
      size = _ref.size,
      testId = _ref.testId,
      label = _ref.label,
      width = _ref.width,
      height = _ref.height;
  var glyphProps = dangerouslySetGlyph ? {
    dangerouslySetInnerHTML: {
      __html: dangerouslySetGlyph
    }
  } : {
    children: Glyph ? jsx(Glyph, {
      role: "presentation"
    }) : null
  };
  var dimensions = getIconSize({
    width: width,
    height: height,
    size: size
  });

  var _useGlobalTheme = useTheme(),
      mode = _useGlobalTheme.mode;

  return jsx("span", _extends({
    "data-testid": testId,
    role: label ? 'img' : 'presentation',
    "aria-label": label ? label : undefined,
    "aria-hidden": label ? undefined : true,
    style: {
      '--icon-primary-color': primaryColor,
      '--icon-secondary-color': secondaryColor || getBackground(mode)
    }
  }, glyphProps, {
    css: [iconStyles, baseHcmStyles, primaryColor === secondaryColor && primaryEqualsSecondaryHcmStyles, secondaryColor === 'transparent' && secondaryTransparentHcmStyles, // NB: This can be resolved if this component, composes base SVG / and/or skeleton
    // We could then simplify how common styles are dealt with simply by encapsualting them
    // at their appropriate level and/or having a singular approach to css variables in the package
    dimensions && // eslint-disable-next-line @repo/internal/react/consistent-css-prop-usage
    css({
      width: dimensions.width,
      height: dimensions.height,
      '> svg': dimensions
    })]
  }));
});

var base = /*#__PURE__*/Object.freeze({
  __proto__: null,
  'default': Icon,
  Icon: Icon
});

export { base as b, sizes as s };
