/*
 (c) 2016, Philipp Thürwächter & Pattrick Hüper
 @license BSD-3-Clause (see LICENSE in the root directory of this source tree)
 (c) 2016, Philipp Thürwächter & Pattrick Hüper
 @copyright (c) 2007-present, Stephen Colebourne & Michael Nascimento Santos
 @license BSD-3-Clause (see LICENSE in the root directory of this source tree)
*/
function createErrorType$$module$input(e,b){function d(a){Error.captureStackTrace?Error.captureStackTrace(this,this.constructor):this.stack=Error().stack;this.message=a;b&&b.apply(this,arguments);this.toString=function(){return"".concat(this.name,": ").concat(this.message)}}d.prototype=Object.create((2<arguments.length&&void 0!==arguments[2]?arguments[2]:Error).prototype);d.prototype.name=e;return d.prototype.constructor=d}
var DateTimeException$$module$input=createErrorType$$module$input("DateTimeException",messageWithCause$$module$input),DateTimeParseException$$module$input=createErrorType$$module$input("DateTimeParseException",messageForDateTimeParseException$$module$input),UnsupportedTemporalTypeException$$module$input=createErrorType$$module$input("UnsupportedTemporalTypeException",null,DateTimeException$$module$input),ArithmeticException$$module$input=createErrorType$$module$input("ArithmeticException"),IllegalArgumentException$$module$input=
createErrorType$$module$input("IllegalArgumentException"),IllegalStateException$$module$input=createErrorType$$module$input("IllegalStateException"),NullPointerException$$module$input=createErrorType$$module$input("NullPointerException");function messageWithCause$$module$input(e){var b=1<arguments.length&&void 0!==arguments[1]?arguments[1]:null,d=e||this.name;null!==b&&b instanceof Error&&(d+="\n-------\nCaused by: ".concat(b.stack,"\n-------\n"));this.message=d}
function messageForDateTimeParseException$$module$input(e){var b=1<arguments.length&&void 0!==arguments[1]?arguments[1]:"",d=2<arguments.length&&void 0!==arguments[2]?arguments[2]:0,a=3<arguments.length&&void 0!==arguments[3]?arguments[3]:null,c=e||this.name;c+=": ".concat(b,", at index: ").concat(d);null!==a&&a instanceof Error&&(c+="\n-------\nCaused by: ".concat(a.stack,"\n-------\n"));this.message=c;this.parsedString=function(){return b};this.errorIndex=function(){return d}}
function _typeof$$module$input(e){"@babel/helpers - typeof";_typeof$$module$input="function"===typeof Symbol&&"symbol"===typeof Symbol.iterator?function(b){return typeof b}:function(b){return b&&"function"===typeof Symbol&&b.constructor===Symbol&&b!==Symbol.prototype?"symbol":typeof b};return _typeof$$module$input(e)}function _classCallCheck$$module$input(e,b){if(!(e instanceof b))throw new TypeError("Cannot call a class as a function");}
function _defineProperties$$module$input(e,b){for(var d=0;d<b.length;d++){var a=b[d];a.enumerable=a.enumerable||!1;a.configurable=!0;"value"in a&&(a.writable=!0);Object.defineProperty(e,a.key,a)}}function _createClass$$module$input(e,b,d){b&&_defineProperties$$module$input(e.prototype,b);d&&_defineProperties$$module$input(e,d);return e}
function _inherits$$module$input(e,b){if("function"!==typeof b&&null!==b)throw new TypeError("Super expression must either be null or a function");e.prototype=Object.create(b&&b.prototype,{constructor:{value:e,writable:!0,configurable:!0}});b&&_setPrototypeOf$$module$input(e,b)}function _getPrototypeOf$$module$input(e){_getPrototypeOf$$module$input=Object.setPrototypeOf?Object.getPrototypeOf:function(b){return b.__proto__||Object.getPrototypeOf(b)};return _getPrototypeOf$$module$input(e)}
function _setPrototypeOf$$module$input(e,b){_setPrototypeOf$$module$input=Object.setPrototypeOf||function(b,a){b.__proto__=a;return b};return _setPrototypeOf$$module$input(e,b)}function _isNativeReflectConstruct$$module$input(){if("undefined"===typeof Reflect||!Reflect.construct||Reflect.construct.sham)return!1;if("function"===typeof Proxy)return!0;try{return Boolean.prototype.valueOf.call(Reflect.construct(Boolean,[],function(){})),!0}catch(e){return!1}}
function _assertThisInitialized$$module$input(e){if(void 0===e)throw new ReferenceError("this hasn't been initialised - super() hasn't been called");return e}function _possibleConstructorReturn$$module$input(e,b){if(b&&("object"===typeof b||"function"===typeof b))return b;if(void 0!==b)throw new TypeError("Derived constructors may only return object or undefined");return _assertThisInitialized$$module$input(e)}
function _createSuper$$module$input(e){var b=_isNativeReflectConstruct$$module$input();return function(){var d=_getPrototypeOf$$module$input(e);if(b){var a=_getPrototypeOf$$module$input(this).constructor;d=Reflect.construct(d,arguments,a)}else d=d.apply(this,arguments);return _possibleConstructorReturn$$module$input(this,d)}}function _superPropBase$$module$input(e,b){for(;!Object.prototype.hasOwnProperty.call(e,b)&&(e=_getPrototypeOf$$module$input(e),null!==e););return e}
function _get$$module$input(e,b,d){_get$$module$input="undefined"!==typeof Reflect&&Reflect.get?Reflect.get:function(a,b,f){if(a=_superPropBase$$module$input(a,b))return b=Object.getOwnPropertyDescriptor(a,b),b.get?b.get.call(f):b.value};return _get$$module$input(e,b,d||e)}function assert$$module$input(e,b,d){if(!e){if(d)throw new d(b);throw Error(b);}}function requireNonNull$$module$input(e,b){if(null==e)throw new NullPointerException$$module$input("".concat(b," must not be null"));return e}
function requireInstance$$module$input(e,b,d){if(!(e instanceof b))throw new IllegalArgumentException$$module$input("".concat(d," must be an instance of ").concat(b.name?b.name:b).concat(e&&e.constructor&&e.constructor.name?", but is ".concat(e.constructor.name):""));return e}function abstractMethodFail$$module$input(e){throw new TypeError('abstract method "'.concat(e,'" is not implemented'));}
var MAX_SAFE_INTEGER$$module$input=9007199254740991,MIN_SAFE_INTEGER$$module$input=-9007199254740991,MathUtil$$module$input=function(){function e(){_classCallCheck$$module$input(this,e)}_createClass$$module$input(e,null,[{key:"intDiv",value:function(b,d){b=e.roundDown(b/d);return e.safeZero(b)}},{key:"intMod",value:function(b,d){b-=e.intDiv(b,d)*d;b=e.roundDown(b);return e.safeZero(b)}},{key:"roundDown",value:function(b){return 0>b?Math.ceil(b):Math.floor(b)}},{key:"floorDiv",value:function(b,d){return e.safeZero(Math.floor(b/
d))}},{key:"floorMod",value:function(b,d){b-=e.floorDiv(b,d)*d;return e.safeZero(b)}},{key:"safeAdd",value:function(b,d){e.verifyInt(b);e.verifyInt(d);if(0===b)return e.safeZero(d);if(0===d)return e.safeZero(b);var a=e.safeToInt(b+d);if(a===b||a===d)throw new ArithmeticException$$module$input("Invalid addition beyond MAX_SAFE_INTEGER!");return a}},{key:"safeSubtract",value:function(b,d){e.verifyInt(b);e.verifyInt(d);return 0===b&&0===d?0:0===b?e.safeZero(-1*d):0===d?e.safeZero(b):e.safeToInt(b-d)}},
{key:"safeMultiply",value:function(b,d){e.verifyInt(b);e.verifyInt(d);if(1===b)return e.safeZero(d);if(1===d)return e.safeZero(b);if(0===b||0===d)return 0;var a=e.safeToInt(b*d);if(a/d!==b||b===MIN_SAFE_INTEGER$$module$input&&-1===d||d===MIN_SAFE_INTEGER$$module$input&&-1===b)throw new ArithmeticException$$module$input("Multiplication overflows: ".concat(b," * ").concat(d));return a}},{key:"parseInt",value:function(b){function d(a){return b.apply(this,arguments)}d.toString=function(){return b.toString()};
return d}(function(b){b=parseInt(b);return e.safeToInt(b)})},{key:"safeToInt",value:function(b){e.verifyInt(b);return e.safeZero(b)}},{key:"verifyInt",value:function(b){if(null==b)throw new ArithmeticException$$module$input("Invalid value: '".concat(b,"', using null or undefined as argument"));if(isNaN(b))throw new ArithmeticException$$module$input("Invalid int value, using NaN as argument");if(0!==b%1)throw new ArithmeticException$$module$input("Invalid value: '".concat(b,"' is a float"));if(b>MAX_SAFE_INTEGER$$module$input||
b<MIN_SAFE_INTEGER$$module$input)throw new ArithmeticException$$module$input("Calculation overflows an int: ".concat(b));}},{key:"safeZero",value:function(b){return 0===b?0:+b}},{key:"compareNumbers",value:function(b,d){return b<d?-1:b>d?1:0}},{key:"smi",value:function(b){return b>>>1&1073741824|b&3221225471}},{key:"hash",value:function(b){if(b!==b||Infinity===b)return 0;for(var d=b;4294967295<b;)b/=4294967295,d^=b;return e.smi(d)}},{key:"hashCode",value:function(){for(var b=17,d=arguments.length,
a=Array(d),c=0;c<d;c++)a[c]=arguments[c];for(d=0;d<a.length;d++)b=(b<<5)-b+e.hash(a[d]);return e.hash(b)}}]);return e}();MathUtil$$module$input.MAX_SAFE_INTEGER=MAX_SAFE_INTEGER$$module$input;MathUtil$$module$input.MIN_SAFE_INTEGER=MIN_SAFE_INTEGER$$module$input;
var Enum$$module$input=function(){function e(b){_classCallCheck$$module$input(this,e);this._name=b}_createClass$$module$input(e,[{key:"equals",value:function(b){return this===b}},{key:"toString",value:function(){return this._name}},{key:"toJSON",value:function(){return this.toString()}}]);return e}(),TemporalAmount$$module$input=function(){function e(){_classCallCheck$$module$input(this,e)}_createClass$$module$input(e,[{key:"get",value:function(b){abstractMethodFail$$module$input("get")}},{key:"units",
value:function(){abstractMethodFail$$module$input("units")}},{key:"addTo",value:function(b){abstractMethodFail$$module$input("addTo")}},{key:"subtractFrom",value:function(b){abstractMethodFail$$module$input("subtractFrom")}}]);return e}(),TemporalUnit$$module$input=function(){function e(){_classCallCheck$$module$input(this,e)}_createClass$$module$input(e,[{key:"duration",value:function(){abstractMethodFail$$module$input("duration")}},{key:"isDurationEstimated",value:function(){abstractMethodFail$$module$input("isDurationEstimated")}},
{key:"isDateBased",value:function(){abstractMethodFail$$module$input("isDateBased")}},{key:"isTimeBased",value:function(){abstractMethodFail$$module$input("isTimeBased")}},{key:"isSupportedBy",value:function(b){abstractMethodFail$$module$input("isSupportedBy")}},{key:"addTo",value:function(b,d){abstractMethodFail$$module$input("addTo")}},{key:"between",value:function(b,d){abstractMethodFail$$module$input("between")}}]);return e}(),Duration$$module$input=function(e){function b(a,c){_classCallCheck$$module$input(this,
b);var f=d.call(this);f._seconds=MathUtil$$module$input.safeToInt(a);f._nanos=MathUtil$$module$input.safeToInt(c);return f}_inherits$$module$input(b,e);var d=_createSuper$$module$input(b);_createClass$$module$input(b,[{key:"get",value:function(a){if(a===ChronoUnit$$module$input.SECONDS)return this._seconds;if(a===ChronoUnit$$module$input.NANOS)return this._nanos;throw new UnsupportedTemporalTypeException$$module$input("Unsupported unit: ".concat(a));}},{key:"units",value:function(){return[ChronoUnit$$module$input.SECONDS,
ChronoUnit$$module$input.NANOS]}},{key:"isZero",value:function(){return 0===this._seconds&&0===this._nanos}},{key:"isNegative",value:function(){return 0>this._seconds}},{key:"seconds",value:function(){return this._seconds}},{key:"nano",value:function(){return this._nanos}},{key:"withSeconds",value:function(a){return b._create(a,this._nanos)}},{key:"withNanos",value:function(a){ChronoField$$module$input.NANO_OF_SECOND.checkValidIntValue(a);return b._create(this._seconds,a)}},{key:"plusDuration",value:function(a){requireNonNull$$module$input(a,
"duration");return this.plus(a.seconds(),a.nano())}},{key:"plus",value:function(a,b){return 1===arguments.length?this.plusDuration(a):2===arguments.length&&b instanceof TemporalUnit$$module$input?this.plusAmountUnit(a,b):this.plusSecondsNanos(a,b)}},{key:"plusAmountUnit",value:function(a,b){requireNonNull$$module$input(a,"amountToAdd");requireNonNull$$module$input(b,"unit");if(b===ChronoUnit$$module$input.DAYS)return this.plusSecondsNanos(MathUtil$$module$input.safeMultiply(a,LocalTime$$module$input.SECONDS_PER_DAY),
0);if(b.isDurationEstimated())throw new UnsupportedTemporalTypeException$$module$input("Unit must not have an estimated duration");if(0===a)return this;if(b instanceof ChronoUnit$$module$input){switch(b){case ChronoUnit$$module$input.NANOS:return this.plusNanos(a);case ChronoUnit$$module$input.MICROS:return this.plusSecondsNanos(1E3*MathUtil$$module$input.intDiv(a,1E9),1E3*MathUtil$$module$input.intMod(a,1E9));case ChronoUnit$$module$input.MILLIS:return this.plusMillis(a);case ChronoUnit$$module$input.SECONDS:return this.plusSeconds(a)}return this.plusSecondsNanos(MathUtil$$module$input.safeMultiply(b.duration().seconds(),
a),0)}a=b.duration().multipliedBy(a);return this.plusSecondsNanos(a.seconds(),a.nano())}},{key:"plusDays",value:function(a){return this.plusSecondsNanos(MathUtil$$module$input.safeMultiply(a,LocalTime$$module$input.SECONDS_PER_DAY),0)}},{key:"plusHours",value:function(a){return this.plusSecondsNanos(MathUtil$$module$input.safeMultiply(a,LocalTime$$module$input.SECONDS_PER_HOUR),0)}},{key:"plusMinutes",value:function(a){return this.plusSecondsNanos(MathUtil$$module$input.safeMultiply(a,LocalTime$$module$input.SECONDS_PER_MINUTE),
0)}},{key:"plusSeconds",value:function(a){return this.plusSecondsNanos(a,0)}},{key:"plusMillis",value:function(a){return this.plusSecondsNanos(MathUtil$$module$input.intDiv(a,1E3),1E6*MathUtil$$module$input.intMod(a,1E3))}},{key:"plusNanos",value:function(a){return this.plusSecondsNanos(0,a)}},{key:"plusSecondsNanos",value:function(a,c){requireNonNull$$module$input(a,"secondsToAdd");requireNonNull$$module$input(c,"nanosToAdd");if(0===a&&0===c)return this;a=MathUtil$$module$input.safeAdd(this._seconds,
a);a=MathUtil$$module$input.safeAdd(a,MathUtil$$module$input.intDiv(c,LocalTime$$module$input.NANOS_PER_SECOND));c=MathUtil$$module$input.intMod(c,LocalTime$$module$input.NANOS_PER_SECOND);c=MathUtil$$module$input.safeAdd(this._nanos,c);return b.ofSeconds(a,c)}},{key:"minus",value:function(a,b){return 1===arguments.length?this.minusDuration(a):this.minusAmountUnit(a,b)}},{key:"minusDuration",value:function(a){requireNonNull$$module$input(a,"duration");var b=a.seconds();a=a.nano();return b===MIN_SAFE_INTEGER$$module$input?
this.plus(MAX_SAFE_INTEGER$$module$input,-a):this.plus(-b,-a)}},{key:"minusAmountUnit",value:function(a,b){requireNonNull$$module$input(a,"amountToSubtract");requireNonNull$$module$input(b,"unit");return a===MIN_SAFE_INTEGER$$module$input?this.plusAmountUnit(MAX_SAFE_INTEGER$$module$input,b):this.plusAmountUnit(-a,b)}},{key:"minusDays",value:function(a){return a===MIN_SAFE_INTEGER$$module$input?this.plusDays(MAX_SAFE_INTEGER$$module$input):this.plusDays(-a)}},{key:"minusHours",value:function(a){return a===
MIN_SAFE_INTEGER$$module$input?this.plusHours(MAX_SAFE_INTEGER$$module$input):this.plusHours(-a)}},{key:"minusMinutes",value:function(a){return a===MIN_SAFE_INTEGER$$module$input?this.plusMinutes(MAX_SAFE_INTEGER$$module$input):this.plusMinutes(-a)}},{key:"minusSeconds",value:function(a){return a===MIN_SAFE_INTEGER$$module$input?this.plusSeconds(MAX_SAFE_INTEGER$$module$input):this.plusSeconds(-a)}},{key:"minusMillis",value:function(a){return a===MIN_SAFE_INTEGER$$module$input?this.plusMillis(MAX_SAFE_INTEGER$$module$input):
this.plusMillis(-a)}},{key:"minusNanos",value:function(a){return a===MIN_SAFE_INTEGER$$module$input?this.plusNanos(MAX_SAFE_INTEGER$$module$input):this.plusNanos(-a)}},{key:"multipliedBy",value:function(a){if(0===a)return b.ZERO;if(1===a)return this;var c=MathUtil$$module$input.safeMultiply(this._seconds,a);a=MathUtil$$module$input.safeMultiply(this._nanos,a);c+=MathUtil$$module$input.intDiv(a,LocalTime$$module$input.NANOS_PER_SECOND);a=MathUtil$$module$input.intMod(a,LocalTime$$module$input.NANOS_PER_SECOND);
return b.ofSeconds(c,a)}},{key:"dividedBy",value:function(a){if(0===a)throw new ArithmeticException$$module$input("Cannot divide by zero");if(1===a)return this;var c=MathUtil$$module$input.intDiv(this._seconds,a),f=MathUtil$$module$input.roundDown((this._seconds/a-c)*LocalTime$$module$input.NANOS_PER_SECOND);a=MathUtil$$module$input.intDiv(this._nanos,a);return b.ofSeconds(c,f+a)}},{key:"negated",value:function(){return this.multipliedBy(-1)}},{key:"abs",value:function(){return this.isNegative()?
this.negated():this}},{key:"addTo",value:function(a){requireNonNull$$module$input(a,"temporal");0!==this._seconds&&(a=a.plus(this._seconds,ChronoUnit$$module$input.SECONDS));0!==this._nanos&&(a=a.plus(this._nanos,ChronoUnit$$module$input.NANOS));return a}},{key:"subtractFrom",value:function(a){requireNonNull$$module$input(a,"temporal");0!==this._seconds&&(a=a.minus(this._seconds,ChronoUnit$$module$input.SECONDS));0!==this._nanos&&(a=a.minus(this._nanos,ChronoUnit$$module$input.NANOS));return a}},
{key:"toDays",value:function(){return MathUtil$$module$input.intDiv(this._seconds,LocalTime$$module$input.SECONDS_PER_DAY)}},{key:"toHours",value:function(){return MathUtil$$module$input.intDiv(this._seconds,LocalTime$$module$input.SECONDS_PER_HOUR)}},{key:"toMinutes",value:function(){return MathUtil$$module$input.intDiv(this._seconds,LocalTime$$module$input.SECONDS_PER_MINUTE)}},{key:"toMillis",value:function(){var a=Math.round(MathUtil$$module$input.safeMultiply(this._seconds,1E3));return a=MathUtil$$module$input.safeAdd(a,
MathUtil$$module$input.intDiv(this._nanos,1E6))}},{key:"toNanos",value:function(){var a=MathUtil$$module$input.safeMultiply(this._seconds,LocalTime$$module$input.NANOS_PER_SECOND);return a=MathUtil$$module$input.safeAdd(a,this._nanos)}},{key:"compareTo",value:function(a){requireNonNull$$module$input(a,"otherDuration");requireInstance$$module$input(a,b,"otherDuration");var c=MathUtil$$module$input.compareNumbers(this._seconds,a.seconds());return 0!==c?c:this._nanos-a.nano()}},{key:"equals",value:function(a){return this===
a?!0:a instanceof b?this.seconds()===a.seconds()&&this.nano()===a.nano():!1}},{key:"toString",value:function(){if(this===b.ZERO)return"PT0S";var a=MathUtil$$module$input.intDiv(this._seconds,LocalTime$$module$input.SECONDS_PER_HOUR),c=MathUtil$$module$input.intDiv(MathUtil$$module$input.intMod(this._seconds,LocalTime$$module$input.SECONDS_PER_HOUR),LocalTime$$module$input.SECONDS_PER_MINUTE),f=MathUtil$$module$input.intMod(this._seconds,LocalTime$$module$input.SECONDS_PER_MINUTE),d="PT";0!==a&&(d+=
"".concat(a,"H"));0!==c&&(d+="".concat(c,"M"));if(0===f&&0===this._nanos&&2<d.length)return d;d=0>f&&0<this._nanos?-1===f?d+"-0":d+(f+1):d+f;if(0<this._nanos)for(d+=".",a=0>f?"".concat(2*LocalTime$$module$input.NANOS_PER_SECOND-this._nanos):"".concat(LocalTime$$module$input.NANOS_PER_SECOND+this._nanos),a=a.slice(1,a.length),d+=a;"0"===d.charAt(d.length-1);)d=d.slice(0,d.length-1);return d+"S"}},{key:"toJSON",value:function(){return this.toString()}}],[{key:"ofDays",value:function(a){return b._create(MathUtil$$module$input.safeMultiply(a,
LocalTime$$module$input.SECONDS_PER_DAY),0)}},{key:"ofHours",value:function(a){return b._create(MathUtil$$module$input.safeMultiply(a,LocalTime$$module$input.SECONDS_PER_HOUR),0)}},{key:"ofMinutes",value:function(a){return b._create(MathUtil$$module$input.safeMultiply(a,LocalTime$$module$input.SECONDS_PER_MINUTE),0)}},{key:"ofSeconds",value:function(a){var c=1<arguments.length&&void 0!==arguments[1]?arguments[1]:0,f=MathUtil$$module$input.safeAdd(a,MathUtil$$module$input.floorDiv(c,LocalTime$$module$input.NANOS_PER_SECOND));
c=MathUtil$$module$input.floorMod(c,LocalTime$$module$input.NANOS_PER_SECOND);return b._create(f,c)}},{key:"ofMillis",value:function(a){var c=MathUtil$$module$input.intDiv(a,1E3);a=MathUtil$$module$input.intMod(a,1E3);0>a&&(a+=1E3,c--);return b._create(c,1E6*a)}},{key:"ofNanos",value:function(a){var b=MathUtil$$module$input.intDiv(a,LocalTime$$module$input.NANOS_PER_SECOND);a=MathUtil$$module$input.intMod(a,LocalTime$$module$input.NANOS_PER_SECOND);0>a&&(a+=LocalTime$$module$input.NANOS_PER_SECOND,
b--);return this._create(b,a)}},{key:"of",value:function(a,c){return b.ZERO.plus(a,c)}},{key:"from",value:function(a){requireNonNull$$module$input(a,"amount");requireInstance$$module$input(a,TemporalAmount$$module$input);var c=b.ZERO;a.units().forEach(function(b){c=c.plus(a.get(b),b)});return c}},{key:"between",value:function(a,b){requireNonNull$$module$input(a,"startInclusive");requireNonNull$$module$input(b,"endExclusive");var c=a.until(b,ChronoUnit$$module$input.SECONDS),d=0;if(a.isSupported(ChronoField$$module$input.NANO_OF_SECOND)&&
b.isSupported(ChronoField$$module$input.NANO_OF_SECOND))try{var e=a.getLong(ChronoField$$module$input.NANO_OF_SECOND);d=b.getLong(ChronoField$$module$input.NANO_OF_SECOND)-e;if(0<c&&0>d)d+=LocalTime$$module$input.NANOS_PER_SECOND;else if(0>c&&0<d)d-=LocalTime$$module$input.NANOS_PER_SECOND;else if(0===c&&0!==d){var h=b.with(ChronoField$$module$input.NANO_OF_SECOND,e);c=a.until(h,ChronoUnit$$module$input.SECONDS)}}catch(k){}return this.ofSeconds(c,d)}},{key:"parse",value:function(a){requireNonNull$$module$input(a,
"text");var c=/([-+]?)P(?:([-+]?[0-9]+)D)?(T(?:([-+]?[0-9]+)H)?(?:([-+]?[0-9]+)M)?(?:([-+]?[0-9]+)(?:[.,]([0-9]{0,9}))?S)?)?/i.exec(a);if(null!==c&&"T"===c[3]===!1){var f="-"===c[1],d=c[2],e=c[4],h=c[5],k=c[6];c=c[7];if(null!=d||null!=e||null!=h||null!=k){d=b._parseNumber(a,d,LocalTime$$module$input.SECONDS_PER_DAY,"days");e=b._parseNumber(a,e,LocalTime$$module$input.SECONDS_PER_HOUR,"hours");h=b._parseNumber(a,h,LocalTime$$module$input.SECONDS_PER_MINUTE,"minutes");var m=b._parseNumber(a,k,1,"seconds");
k=null!=k&&"-"===k.charAt(0);k=b._parseFraction(a,c,k?-1:1);try{return b._create(f,d,e,h,m,k)}catch(n){throw new DateTimeParseException$$module$input("Text cannot be parsed to a Duration: overflow",a,0,n);}}}throw new DateTimeParseException$$module$input("Text cannot be parsed to a Duration",a,0);}},{key:"_parseNumber",value:function(a,b,f,d){if(null==b)return 0;try{return"+"===b[0]&&(b=b.substring(1)),MathUtil$$module$input.safeMultiply(parseFloat(b),f)}catch(g){throw new DateTimeParseException$$module$input("Text cannot be parsed to a Duration: ".concat(d),
a,0,g);}}},{key:"_parseFraction",value:function(a,b,f){if(null==b||0===b.length)return 0;b="".concat(b,"000000000").substring(0,9);return parseFloat(b)*f}},{key:"_create",value:function(){return 2>=arguments.length?b._createSecondsNanos(arguments[0],arguments[1]):b._createNegateDaysHoursMinutesSecondsNanos(arguments[0],arguments[1],arguments[2],arguments[3],arguments[4],arguments[5])}},{key:"_createNegateDaysHoursMinutesSecondsNanos",value:function(a,c,f,d,e,h){c=MathUtil$$module$input.safeAdd(c,
MathUtil$$module$input.safeAdd(f,MathUtil$$module$input.safeAdd(d,e)));return a?b.ofSeconds(c,h).negated():b.ofSeconds(c,h)}},{key:"_createSecondsNanos",value:function(){var a=0<arguments.length&&void 0!==arguments[0]?arguments[0]:0,c=1<arguments.length&&void 0!==arguments[1]?arguments[1]:0;return 0===a&&0===c?b.ZERO:new b(a,c)}}]);return b}(TemporalAmount$$module$input);function _init$$module$input(){Duration$$module$input.ZERO=new Duration$$module$input(0,0)}
var YearConstants$$module$input=function YearConstants(){_classCallCheck$$module$input(this,YearConstants)};function _init$1$$module$input(){YearConstants$$module$input.MIN_VALUE=-999999;YearConstants$$module$input.MAX_VALUE=999999}
var ChronoUnit$$module$input=function(e){function b(a,c){_classCallCheck$$module$input(this,b);var f=d.call(this);f._name=a;f._duration=c;return f}_inherits$$module$input(b,e);var d=_createSuper$$module$input(b);_createClass$$module$input(b,[{key:"duration",value:function(){return this._duration}},{key:"isDurationEstimated",value:function(){return this.isDateBased()||this===b.FOREVER}},{key:"isDateBased",value:function(){return 0<=this.compareTo(b.DAYS)&&this!==b.FOREVER}},{key:"isTimeBased",value:function(){return 0>
this.compareTo(b.DAYS)}},{key:"isSupportedBy",value:function(a){if(this===b.FOREVER)return!1;try{return a.plus(1,this),!0}catch(c){try{return a.plus(-1,this),!0}catch(f){return!1}}}},{key:"addTo",value:function(a,b){return a.plus(b,this)}},{key:"between",value:function(a,b){return a.until(b,this)}},{key:"toString",value:function(){return this._name}},{key:"compareTo",value:function(a){return this.duration().compareTo(a.duration())}}]);return b}(TemporalUnit$$module$input);
function _init$2$$module$input(){ChronoUnit$$module$input.NANOS=new ChronoUnit$$module$input("Nanos",Duration$$module$input.ofNanos(1));ChronoUnit$$module$input.MICROS=new ChronoUnit$$module$input("Micros",Duration$$module$input.ofNanos(1E3));ChronoUnit$$module$input.MILLIS=new ChronoUnit$$module$input("Millis",Duration$$module$input.ofNanos(1E6));ChronoUnit$$module$input.SECONDS=new ChronoUnit$$module$input("Seconds",Duration$$module$input.ofSeconds(1));ChronoUnit$$module$input.MINUTES=new ChronoUnit$$module$input("Minutes",
Duration$$module$input.ofSeconds(60));ChronoUnit$$module$input.HOURS=new ChronoUnit$$module$input("Hours",Duration$$module$input.ofSeconds(3600));ChronoUnit$$module$input.HALF_DAYS=new ChronoUnit$$module$input("HalfDays",Duration$$module$input.ofSeconds(43200));ChronoUnit$$module$input.DAYS=new ChronoUnit$$module$input("Days",Duration$$module$input.ofSeconds(86400));ChronoUnit$$module$input.WEEKS=new ChronoUnit$$module$input("Weeks",Duration$$module$input.ofSeconds(604800));ChronoUnit$$module$input.MONTHS=
new ChronoUnit$$module$input("Months",Duration$$module$input.ofSeconds(2629746));ChronoUnit$$module$input.YEARS=new ChronoUnit$$module$input("Years",Duration$$module$input.ofSeconds(31556952));ChronoUnit$$module$input.DECADES=new ChronoUnit$$module$input("Decades",Duration$$module$input.ofSeconds(315569520));ChronoUnit$$module$input.CENTURIES=new ChronoUnit$$module$input("Centuries",Duration$$module$input.ofSeconds(3155695200));ChronoUnit$$module$input.MILLENNIA=new ChronoUnit$$module$input("Millennia",
Duration$$module$input.ofSeconds(31556952E3));ChronoUnit$$module$input.ERAS=new ChronoUnit$$module$input("Eras",Duration$$module$input.ofSeconds(31556952*(YearConstants$$module$input.MAX_VALUE+1)));ChronoUnit$$module$input.FOREVER=new ChronoUnit$$module$input("Forever",Duration$$module$input.ofSeconds(MathUtil$$module$input.MAX_SAFE_INTEGER,999999999))}
var TemporalField$$module$input=function(){function e(){_classCallCheck$$module$input(this,e)}_createClass$$module$input(e,[{key:"isDateBased",value:function(){abstractMethodFail$$module$input("isDateBased")}},{key:"isTimeBased",value:function(){abstractMethodFail$$module$input("isTimeBased")}},{key:"baseUnit",value:function(){abstractMethodFail$$module$input("baseUnit")}},{key:"rangeUnit",value:function(){abstractMethodFail$$module$input("rangeUnit")}},{key:"range",value:function(){abstractMethodFail$$module$input("range")}},
{key:"rangeRefinedBy",value:function(b){abstractMethodFail$$module$input("rangeRefinedBy")}},{key:"getFrom",value:function(b){abstractMethodFail$$module$input("getFrom")}},{key:"adjustInto",value:function(b,d){abstractMethodFail$$module$input("adjustInto")}},{key:"isSupportedBy",value:function(b){abstractMethodFail$$module$input("isSupportedBy")}},{key:"displayName",value:function(){abstractMethodFail$$module$input("displayName")}},{key:"equals",value:function(b){abstractMethodFail$$module$input("equals")}},
{key:"name",value:function(){abstractMethodFail$$module$input("name")}}]);return e}(),ValueRange$$module$input=function(){function e(b,d,a,c){_classCallCheck$$module$input(this,e);assert$$module$input(!(b>d),"Smallest minimum value '".concat(b,"' must be less than largest minimum value '").concat(d,"'"),IllegalArgumentException$$module$input);assert$$module$input(!(a>c),"Smallest maximum value '".concat(a,"' must be less than largest maximum value '").concat(c,"'"),IllegalArgumentException$$module$input);
assert$$module$input(!(d>c),"Minimum value '".concat(d,"' must be less than maximum value '").concat(c,"'"),IllegalArgumentException$$module$input);this._minSmallest=b;this._minLargest=d;this._maxLargest=c;this._maxSmallest=a}_createClass$$module$input(e,[{key:"isFixed",value:function(){return this._minSmallest===this._minLargest&&this._maxSmallest===this._maxLargest}},{key:"minimum",value:function(){return this._minSmallest}},{key:"largestMinimum",value:function(){return this._minLargest}},{key:"maximum",
value:function(){return this._maxLargest}},{key:"smallestMaximum",value:function(){return this._maxSmallest}},{key:"isValidValue",value:function(b){return this.minimum()<=b&&b<=this.maximum()}},{key:"checkValidValue",value:function(b,d){return this.isValidValue(b)?b:(b=null!=d?"Invalid value for ".concat(d," (valid values ").concat(this.toString(),"): ").concat(b):"Invalid value (valid values ".concat(this.toString(),"): ").concat(b),assert$$module$input(!1,b,DateTimeException$$module$input))}},{key:"checkValidIntValue",
value:function(b,d){if(!1===this.isValidIntValue(b))throw new DateTimeException$$module$input("Invalid int value for ".concat(d,": ").concat(b));return b}},{key:"isValidIntValue",value:function(b){return this.isIntValue()&&this.isValidValue(b)}},{key:"isIntValue",value:function(){return this.minimum()>=MathUtil$$module$input.MIN_SAFE_INTEGER&&this.maximum()<=MathUtil$$module$input.MAX_SAFE_INTEGER}},{key:"equals",value:function(b){return b===this?!0:b instanceof e?this._minSmallest===b._minSmallest&&
this._minLargest===b._minLargest&&this._maxSmallest===b._maxSmallest&&this._maxLargest===b._maxLargest:!1}},{key:"hashCode",value:function(){return MathUtil$$module$input.hashCode(this._minSmallest,this._minLargest,this._maxSmallest,this._maxLargest)}},{key:"toString",value:function(){var b=this.minimum()+(this.minimum()!==this.largestMinimum()?"/".concat(this.largestMinimum()):"");return b=b+" - "+(this.smallestMaximum()+(this.smallestMaximum()!==this.maximum()?"/".concat(this.maximum()):""))}}],
[{key:"of",value:function(){return 2===arguments.length?new e(arguments[0],arguments[0],arguments[1],arguments[1]):3===arguments.length?new e(arguments[0],arguments[0],arguments[1],arguments[2]):4===arguments.length?new e(arguments[0],arguments[1],arguments[2],arguments[3]):assert$$module$input(!1,"Invalid number of arguments ".concat(arguments.length),IllegalArgumentException$$module$input)}}]);return e}(),ChronoField$$module$input=function(e){function b(a,c,f,e){_classCallCheck$$module$input(this,
b);var l=d.call(this);l._name=a;l._baseUnit=c;l._rangeUnit=f;l._range=e;return l}_inherits$$module$input(b,e);var d=_createSuper$$module$input(b);_createClass$$module$input(b,[{key:"name",value:function(){return this._name}},{key:"baseUnit",value:function(){return this._baseUnit}},{key:"rangeUnit",value:function(){return this._rangeUnit}},{key:"range",value:function(){return this._range}},{key:"displayName",value:function(){return this.toString()}},{key:"checkValidValue",value:function(a){return this.range().checkValidValue(a,
this)}},{key:"checkValidIntValue",value:function(a){return this.range().checkValidIntValue(a,this)}},{key:"isDateBased",value:function(){return this===b.DAY_OF_WEEK||this===b.ALIGNED_DAY_OF_WEEK_IN_MONTH||this===b.ALIGNED_DAY_OF_WEEK_IN_YEAR||this===b.DAY_OF_MONTH||this===b.DAY_OF_YEAR||this===b.EPOCH_DAY||this===b.ALIGNED_WEEK_OF_MONTH||this===b.ALIGNED_WEEK_OF_YEAR||this===b.MONTH_OF_YEAR||this===b.YEAR_OF_ERA||this===b.YEAR||this===b.ERA}},{key:"isTimeBased",value:function(){return this===b.NANO_OF_SECOND||
this===b.NANO_OF_DAY||this===b.MICRO_OF_SECOND||this===b.MICRO_OF_DAY||this===b.MILLI_OF_SECOND||this===b.MILLI_OF_DAY||this===b.SECOND_OF_MINUTE||this===b.SECOND_OF_DAY||this===b.MINUTE_OF_HOUR||this===b.MINUTE_OF_DAY||this===b.HOUR_OF_AMPM||this===b.CLOCK_HOUR_OF_AMPM||this===b.HOUR_OF_DAY||this===b.CLOCK_HOUR_OF_DAY||this===b.AMPM_OF_DAY}},{key:"rangeRefinedBy",value:function(a){return a.range(this)}},{key:"getFrom",value:function(a){return a.getLong(this)}},{key:"toString",value:function(){return this.name()}},
{key:"equals",value:function(a){return this===a}},{key:"adjustInto",value:function(a,b){return a.with(this,b)}},{key:"isSupportedBy",value:function(a){return a.isSupported(this)}}],[{key:"byName",value:function(a){for(var c in b)if(b[c]&&b[c]instanceof b&&b[c].name()===a)return b[c]}}]);return b}(TemporalField$$module$input);
function _init$3$$module$input(){ChronoField$$module$input.NANO_OF_SECOND=new ChronoField$$module$input("NanoOfSecond",ChronoUnit$$module$input.NANOS,ChronoUnit$$module$input.SECONDS,ValueRange$$module$input.of(0,999999999));ChronoField$$module$input.NANO_OF_DAY=new ChronoField$$module$input("NanoOfDay",ChronoUnit$$module$input.NANOS,ChronoUnit$$module$input.DAYS,ValueRange$$module$input.of(0,864E11-1));ChronoField$$module$input.MICRO_OF_SECOND=new ChronoField$$module$input("MicroOfSecond",ChronoUnit$$module$input.MICROS,
ChronoUnit$$module$input.SECONDS,ValueRange$$module$input.of(0,999999));ChronoField$$module$input.MICRO_OF_DAY=new ChronoField$$module$input("MicroOfDay",ChronoUnit$$module$input.MICROS,ChronoUnit$$module$input.DAYS,ValueRange$$module$input.of(0,864E8-1));ChronoField$$module$input.MILLI_OF_SECOND=new ChronoField$$module$input("MilliOfSecond",ChronoUnit$$module$input.MILLIS,ChronoUnit$$module$input.SECONDS,ValueRange$$module$input.of(0,999));ChronoField$$module$input.MILLI_OF_DAY=new ChronoField$$module$input("MilliOfDay",
ChronoUnit$$module$input.MILLIS,ChronoUnit$$module$input.DAYS,ValueRange$$module$input.of(0,864E5-1));ChronoField$$module$input.SECOND_OF_MINUTE=new ChronoField$$module$input("SecondOfMinute",ChronoUnit$$module$input.SECONDS,ChronoUnit$$module$input.MINUTES,ValueRange$$module$input.of(0,59));ChronoField$$module$input.SECOND_OF_DAY=new ChronoField$$module$input("SecondOfDay",ChronoUnit$$module$input.SECONDS,ChronoUnit$$module$input.DAYS,ValueRange$$module$input.of(0,86399));ChronoField$$module$input.MINUTE_OF_HOUR=
new ChronoField$$module$input("MinuteOfHour",ChronoUnit$$module$input.MINUTES,ChronoUnit$$module$input.HOURS,ValueRange$$module$input.of(0,59));ChronoField$$module$input.MINUTE_OF_DAY=new ChronoField$$module$input("MinuteOfDay",ChronoUnit$$module$input.MINUTES,ChronoUnit$$module$input.DAYS,ValueRange$$module$input.of(0,1439));ChronoField$$module$input.HOUR_OF_AMPM=new ChronoField$$module$input("HourOfAmPm",ChronoUnit$$module$input.HOURS,ChronoUnit$$module$input.HALF_DAYS,ValueRange$$module$input.of(0,
11));ChronoField$$module$input.CLOCK_HOUR_OF_AMPM=new ChronoField$$module$input("ClockHourOfAmPm",ChronoUnit$$module$input.HOURS,ChronoUnit$$module$input.HALF_DAYS,ValueRange$$module$input.of(1,12));ChronoField$$module$input.HOUR_OF_DAY=new ChronoField$$module$input("HourOfDay",ChronoUnit$$module$input.HOURS,ChronoUnit$$module$input.DAYS,ValueRange$$module$input.of(0,23));ChronoField$$module$input.CLOCK_HOUR_OF_DAY=new ChronoField$$module$input("ClockHourOfDay",ChronoUnit$$module$input.HOURS,ChronoUnit$$module$input.DAYS,
ValueRange$$module$input.of(1,24));ChronoField$$module$input.AMPM_OF_DAY=new ChronoField$$module$input("AmPmOfDay",ChronoUnit$$module$input.HALF_DAYS,ChronoUnit$$module$input.DAYS,ValueRange$$module$input.of(0,1));ChronoField$$module$input.DAY_OF_WEEK=new ChronoField$$module$input("DayOfWeek",ChronoUnit$$module$input.DAYS,ChronoUnit$$module$input.WEEKS,ValueRange$$module$input.of(1,7));ChronoField$$module$input.ALIGNED_DAY_OF_WEEK_IN_MONTH=new ChronoField$$module$input("AlignedDayOfWeekInMonth",ChronoUnit$$module$input.DAYS,
ChronoUnit$$module$input.WEEKS,ValueRange$$module$input.of(1,7));ChronoField$$module$input.ALIGNED_DAY_OF_WEEK_IN_YEAR=new ChronoField$$module$input("AlignedDayOfWeekInYear",ChronoUnit$$module$input.DAYS,ChronoUnit$$module$input.WEEKS,ValueRange$$module$input.of(1,7));ChronoField$$module$input.DAY_OF_MONTH=new ChronoField$$module$input("DayOfMonth",ChronoUnit$$module$input.DAYS,ChronoUnit$$module$input.MONTHS,ValueRange$$module$input.of(1,28,31),"day");ChronoField$$module$input.DAY_OF_YEAR=new ChronoField$$module$input("DayOfYear",
ChronoUnit$$module$input.DAYS,ChronoUnit$$module$input.YEARS,ValueRange$$module$input.of(1,365,366));ChronoField$$module$input.EPOCH_DAY=new ChronoField$$module$input("EpochDay",ChronoUnit$$module$input.DAYS,ChronoUnit$$module$input.FOREVER,ValueRange$$module$input.of(Math.floor(365.25*YearConstants$$module$input.MIN_VALUE),Math.floor(365.25*YearConstants$$module$input.MAX_VALUE)));ChronoField$$module$input.ALIGNED_WEEK_OF_MONTH=new ChronoField$$module$input("AlignedWeekOfMonth",ChronoUnit$$module$input.WEEKS,
ChronoUnit$$module$input.MONTHS,ValueRange$$module$input.of(1,4,5));ChronoField$$module$input.ALIGNED_WEEK_OF_YEAR=new ChronoField$$module$input("AlignedWeekOfYear",ChronoUnit$$module$input.WEEKS,ChronoUnit$$module$input.YEARS,ValueRange$$module$input.of(1,53));ChronoField$$module$input.MONTH_OF_YEAR=new ChronoField$$module$input("MonthOfYear",ChronoUnit$$module$input.MONTHS,ChronoUnit$$module$input.YEARS,ValueRange$$module$input.of(1,12),"month");ChronoField$$module$input.PROLEPTIC_MONTH=new ChronoField$$module$input("ProlepticMonth",
ChronoUnit$$module$input.MONTHS,ChronoUnit$$module$input.FOREVER,ValueRange$$module$input.of(12*YearConstants$$module$input.MIN_VALUE,12*YearConstants$$module$input.MAX_VALUE+11));ChronoField$$module$input.YEAR_OF_ERA=new ChronoField$$module$input("YearOfEra",ChronoUnit$$module$input.YEARS,ChronoUnit$$module$input.FOREVER,ValueRange$$module$input.of(1,YearConstants$$module$input.MAX_VALUE,YearConstants$$module$input.MAX_VALUE+1));ChronoField$$module$input.YEAR=new ChronoField$$module$input("Year",
ChronoUnit$$module$input.YEARS,ChronoUnit$$module$input.FOREVER,ValueRange$$module$input.of(YearConstants$$module$input.MIN_VALUE,YearConstants$$module$input.MAX_VALUE),"year");ChronoField$$module$input.ERA=new ChronoField$$module$input("Era",ChronoUnit$$module$input.ERAS,ChronoUnit$$module$input.FOREVER,ValueRange$$module$input.of(0,1));ChronoField$$module$input.INSTANT_SECONDS=new ChronoField$$module$input("InstantSeconds",ChronoUnit$$module$input.SECONDS,ChronoUnit$$module$input.FOREVER,ValueRange$$module$input.of(MIN_SAFE_INTEGER$$module$input,
MAX_SAFE_INTEGER$$module$input));ChronoField$$module$input.OFFSET_SECONDS=new ChronoField$$module$input("OffsetSeconds",ChronoUnit$$module$input.SECONDS,ChronoUnit$$module$input.FOREVER,ValueRange$$module$input.of(-64800,64800))}
var TemporalQueries$$module$input=function(){function e(){_classCallCheck$$module$input(this,e)}_createClass$$module$input(e,null,[{key:"zoneId",value:function(){return e.ZONE_ID}},{key:"chronology",value:function(){return e.CHRONO}},{key:"precision",value:function(){return e.PRECISION}},{key:"zone",value:function(){return e.ZONE}},{key:"offset",value:function(){return e.OFFSET}},{key:"localDate",value:function(){return e.LOCAL_DATE}},{key:"localTime",value:function(){return e.LOCAL_TIME}}]);return e}(),
TemporalAccessor$$module$input=function(){function e(){_classCallCheck$$module$input(this,e)}_createClass$$module$input(e,[{key:"query",value:function(b){return b===TemporalQueries$$module$input.zoneId()||b===TemporalQueries$$module$input.chronology()||b===TemporalQueries$$module$input.precision()?null:b.queryFrom(this)}},{key:"get",value:function(b){return this.range(b).checkValidIntValue(this.getLong(b),b)}},{key:"getLong",value:function(b){abstractMethodFail$$module$input("getLong")}},{key:"range",
value:function(b){if(b instanceof ChronoField$$module$input){if(this.isSupported(b))return b.range();throw new UnsupportedTemporalTypeException$$module$input("Unsupported field: ".concat(b));}return b.rangeRefinedBy(this)}},{key:"isSupported",value:function(b){abstractMethodFail$$module$input("isSupported")}}]);return e}(),TemporalQuery$$module$input=function(e){function b(){_classCallCheck$$module$input(this,b);return d.apply(this,arguments)}_inherits$$module$input(b,e);var d=_createSuper$$module$input(b);
_createClass$$module$input(b,[{key:"queryFrom",value:function(a){abstractMethodFail$$module$input("queryFrom")}}]);return b}(Enum$$module$input);function createTemporalQuery$$module$input(e,b){var d=function(a){function b(){_classCallCheck$$module$input(this,b);return f.apply(this,arguments)}_inherits$$module$input(b,a);var f=_createSuper$$module$input(b);return b}(TemporalQuery$$module$input);d.prototype.queryFrom=b;return new d(e)}
var DayOfWeek$$module$input=function(e){function b(a,c){_classCallCheck$$module$input(this,b);var f=d.call(this);f._ordinal=a;f._name=c;return f}_inherits$$module$input(b,e);var d=_createSuper$$module$input(b);_createClass$$module$input(b,[{key:"ordinal",value:function(){return this._ordinal}},{key:"name",value:function(){return this._name}},{key:"value",value:function(){return this._ordinal+1}},{key:"displayName",value:function(a,b){throw new IllegalArgumentException$$module$input("Pattern using (localized) text not implemented yet!");
}},{key:"isSupported",value:function(a){return a instanceof ChronoField$$module$input?a===ChronoField$$module$input.DAY_OF_WEEK:null!=a&&a.isSupportedBy(this)}},{key:"range",value:function(a){if(a===ChronoField$$module$input.DAY_OF_WEEK)return a.range();if(a instanceof ChronoField$$module$input)throw new UnsupportedTemporalTypeException$$module$input("Unsupported field: ".concat(a));return a.rangeRefinedBy(this)}},{key:"get",value:function(a){return a===ChronoField$$module$input.DAY_OF_WEEK?this.value():
this.range(a).checkValidIntValue(this.getLong(a),a)}},{key:"getLong",value:function(a){if(a===ChronoField$$module$input.DAY_OF_WEEK)return this.value();if(a instanceof ChronoField$$module$input)throw new UnsupportedTemporalTypeException$$module$input("Unsupported field: ".concat(a));return a.getFrom(this)}},{key:"plus",value:function(a){a=MathUtil$$module$input.floorMod(a,7);return ENUMS$$module$input[MathUtil$$module$input.floorMod(this._ordinal+(a+7),7)]}},{key:"minus",value:function(a){return this.plus(-1*
MathUtil$$module$input.floorMod(a,7))}},{key:"query",value:function(a){if(a===TemporalQueries$$module$input.precision())return ChronoUnit$$module$input.DAYS;if(a===TemporalQueries$$module$input.localDate()||a===TemporalQueries$$module$input.localTime()||a===TemporalQueries$$module$input.chronology()||a===TemporalQueries$$module$input.zone()||a===TemporalQueries$$module$input.zoneId()||a===TemporalQueries$$module$input.offset())return null;assert$$module$input(null!=a,"query",NullPointerException$$module$input);
return a.queryFrom(this)}},{key:"adjustInto",value:function(a){requireNonNull$$module$input(a,"temporal");return a.with(ChronoField$$module$input.DAY_OF_WEEK,this.value())}},{key:"equals",value:function(a){return this===a}},{key:"toString",value:function(){return this._name}},{key:"compareTo",value:function(a){requireNonNull$$module$input(a,"other");requireInstance$$module$input(a,b,"other");return this._ordinal-a._ordinal}},{key:"toJSON",value:function(){return this.toString()}}],[{key:"values",
value:function(){return ENUMS$$module$input.slice()}},{key:"valueOf",value:function(a){var c=0;for(c;c<ENUMS$$module$input.length&&ENUMS$$module$input[c].name()!==a;c++);return b.of(c+1)}},{key:"of",value:function(a){if(1>a||7<a)throw new DateTimeException$$module$input("Invalid value for DayOfWeek: ".concat(a));return ENUMS$$module$input[a-1]}},{key:"from",value:function(a){assert$$module$input(null!=a,"temporal",NullPointerException$$module$input);if(a instanceof b)return a;try{return b.of(a.get(ChronoField$$module$input.DAY_OF_WEEK))}catch(c){if(c instanceof
DateTimeException$$module$input)throw new DateTimeException$$module$input("Unable to obtain DayOfWeek from TemporalAccessor: ".concat(a,", type ").concat(null!=a.constructor?a.constructor.name:""),c);throw c;}}}]);return b}(TemporalAccessor$$module$input),ENUMS$$module$input;
function _init$4$$module$input(){DayOfWeek$$module$input.MONDAY=new DayOfWeek$$module$input(0,"MONDAY");DayOfWeek$$module$input.TUESDAY=new DayOfWeek$$module$input(1,"TUESDAY");DayOfWeek$$module$input.WEDNESDAY=new DayOfWeek$$module$input(2,"WEDNESDAY");DayOfWeek$$module$input.THURSDAY=new DayOfWeek$$module$input(3,"THURSDAY");DayOfWeek$$module$input.FRIDAY=new DayOfWeek$$module$input(4,"FRIDAY");DayOfWeek$$module$input.SATURDAY=new DayOfWeek$$module$input(5,"SATURDAY");DayOfWeek$$module$input.SUNDAY=
new DayOfWeek$$module$input(6,"SUNDAY");DayOfWeek$$module$input.FROM=createTemporalQuery$$module$input("DayOfWeek.FROM",function(e){return DayOfWeek$$module$input.from(e)});ENUMS$$module$input=[DayOfWeek$$module$input.MONDAY,DayOfWeek$$module$input.TUESDAY,DayOfWeek$$module$input.WEDNESDAY,DayOfWeek$$module$input.THURSDAY,DayOfWeek$$module$input.FRIDAY,DayOfWeek$$module$input.SATURDAY,DayOfWeek$$module$input.SUNDAY]}
var Month$$module$input=function(e){function b(a,c){_classCallCheck$$module$input(this,b);var f=d.call(this);f._value=MathUtil$$module$input.safeToInt(a);f._name=c;return f}_inherits$$module$input(b,e);var d=_createSuper$$module$input(b);_createClass$$module$input(b,[{key:"value",value:function(){return this._value}},{key:"ordinal",value:function(){return this._value-1}},{key:"name",value:function(){return this._name}},{key:"displayName",value:function(a,b){throw new IllegalArgumentException$$module$input("Pattern using (localized) text not implemented yet!");
}},{key:"isSupported",value:function(a){return null===a?!1:a instanceof ChronoField$$module$input?a===ChronoField$$module$input.MONTH_OF_YEAR:null!=a&&a.isSupportedBy(this)}},{key:"get",value:function(a){return a===ChronoField$$module$input.MONTH_OF_YEAR?this.value():this.range(a).checkValidIntValue(this.getLong(a),a)}},{key:"getLong",value:function(a){if(a===ChronoField$$module$input.MONTH_OF_YEAR)return this.value();if(a instanceof ChronoField$$module$input)throw new UnsupportedTemporalTypeException$$module$input("Unsupported field: ".concat(a));
return a.getFrom(this)}},{key:"plus",value:function(a){a=MathUtil$$module$input.intMod(a,12)+12;a=MathUtil$$module$input.intMod(this.value()+a,12);return b.of(0===a?12:a)}},{key:"minus",value:function(a){return this.plus(-1*MathUtil$$module$input.intMod(a,12))}},{key:"length",value:function(a){switch(this){case b.FEBRUARY:return a?29:28;case b.APRIL:case b.JUNE:case b.SEPTEMBER:case b.NOVEMBER:return 30;default:return 31}}},{key:"minLength",value:function(){switch(this){case b.FEBRUARY:return 28;
case b.APRIL:case b.JUNE:case b.SEPTEMBER:case b.NOVEMBER:return 30;default:return 31}}},{key:"maxLength",value:function(){switch(this){case b.FEBRUARY:return 29;case b.APRIL:case b.JUNE:case b.SEPTEMBER:case b.NOVEMBER:return 30;default:return 31}}},{key:"firstDayOfYear",value:function(a){a=a?1:0;switch(this){case b.JANUARY:return 1;case b.FEBRUARY:return 32;case b.MARCH:return 60+a;case b.APRIL:return 91+a;case b.MAY:return 121+a;case b.JUNE:return 152+a;case b.JULY:return 182+a;case b.AUGUST:return 213+
a;case b.SEPTEMBER:return 244+a;case b.OCTOBER:return 274+a;case b.NOVEMBER:return 305+a;default:return 335+a}}},{key:"firstMonthOfQuarter",value:function(){switch(this){case b.JANUARY:case b.FEBRUARY:case b.MARCH:return b.JANUARY;case b.APRIL:case b.MAY:case b.JUNE:return b.APRIL;case b.JULY:case b.AUGUST:case b.SEPTEMBER:return b.JULY;default:return b.OCTOBER}}},{key:"query",value:function(a){assert$$module$input(null!=a,"query() parameter must not be null",DateTimeException$$module$input);return a===
TemporalQueries$$module$input.chronology()?IsoChronology$$module$input.INSTANCE:a===TemporalQueries$$module$input.precision()?ChronoUnit$$module$input.MONTHS:_get$$module$input(_getPrototypeOf$$module$input(b.prototype),"query",this).call(this,a)}},{key:"toString",value:function(){switch(this){case b.JANUARY:return"JANUARY";case b.FEBRUARY:return"FEBRUARY";case b.MARCH:return"MARCH";case b.APRIL:return"APRIL";case b.MAY:return"MAY";case b.JUNE:return"JUNE";case b.JULY:return"JULY";case b.AUGUST:return"AUGUST";
case b.SEPTEMBER:return"SEPTEMBER";case b.OCTOBER:return"OCTOBER";case b.NOVEMBER:return"NOVEMBER";case b.DECEMBER:return"DECEMBER";default:return"unknown Month, value: ".concat(this.value())}}},{key:"toJSON",value:function(){return this.toString()}},{key:"adjustInto",value:function(a){return a.with(ChronoField$$module$input.MONTH_OF_YEAR,this.value())}},{key:"compareTo",value:function(a){requireNonNull$$module$input(a,"other");requireInstance$$module$input(a,b,"other");return this._value-a._value}},
{key:"equals",value:function(a){return this===a}}],[{key:"valueOf",value:function(a){var c=0;for(c;c<MONTHS$$module$input.length&&MONTHS$$module$input[c].name()!==a;c++);return b.of(c+1)}},{key:"values",value:function(){return MONTHS$$module$input.slice()}},{key:"of",value:function(a){(1>a||12<a)&&assert$$module$input(!1,"Invalid value for MonthOfYear: ".concat(a),DateTimeException$$module$input);return MONTHS$$module$input[a-1]}},{key:"from",value:function(a){if(a instanceof b)return a;try{return b.of(a.get(ChronoField$$module$input.MONTH_OF_YEAR))}catch(c){throw new DateTimeException$$module$input("Unable to obtain Month from TemporalAccessor: ".concat(a,
" of type ").concat(a&&null!=a.constructor?a.constructor.name:""),c);}}}]);return b}(TemporalAccessor$$module$input),MONTHS$$module$input;
function _init$5$$module$input(){Month$$module$input.JANUARY=new Month$$module$input(1,"JANUARY");Month$$module$input.FEBRUARY=new Month$$module$input(2,"FEBRUARY");Month$$module$input.MARCH=new Month$$module$input(3,"MARCH");Month$$module$input.APRIL=new Month$$module$input(4,"APRIL");Month$$module$input.MAY=new Month$$module$input(5,"MAY");Month$$module$input.JUNE=new Month$$module$input(6,"JUNE");Month$$module$input.JULY=new Month$$module$input(7,"JULY");Month$$module$input.AUGUST=new Month$$module$input(8,
"AUGUST");Month$$module$input.SEPTEMBER=new Month$$module$input(9,"SEPTEMBER");Month$$module$input.OCTOBER=new Month$$module$input(10,"OCTOBER");Month$$module$input.NOVEMBER=new Month$$module$input(11,"NOVEMBER");Month$$module$input.DECEMBER=new Month$$module$input(12,"DECEMBER");MONTHS$$module$input=[Month$$module$input.JANUARY,Month$$module$input.FEBRUARY,Month$$module$input.MARCH,Month$$module$input.APRIL,Month$$module$input.MAY,Month$$module$input.JUNE,Month$$module$input.JULY,Month$$module$input.AUGUST,
Month$$module$input.SEPTEMBER,Month$$module$input.OCTOBER,Month$$module$input.NOVEMBER,Month$$module$input.DECEMBER]}
var PATTERN$$module$input=/([-+]?)P(?:([-+]?[0-9]+)Y)?(?:([-+]?[0-9]+)M)?(?:([-+]?[0-9]+)W)?(?:([-+]?[0-9]+)D)?/,Period$$module$input=function(e){function b(a,c,f){_classCallCheck$$module$input(this,b);var e=d.call(this);a=MathUtil$$module$input.safeToInt(a);c=MathUtil$$module$input.safeToInt(c);f=MathUtil$$module$input.safeToInt(f);if(0===a&&0===c&&0===f)return b.ZERO||(e._years=a,e._months=c,e._days=f,b.ZERO=_assertThisInitialized$$module$input(e)),_possibleConstructorReturn$$module$input(e,b.ZERO);
e._years=a;e._months=c;e._days=f;return e}_inherits$$module$input(b,e);var d=_createSuper$$module$input(b);_createClass$$module$input(b,[{key:"units",value:function(){return[ChronoUnit$$module$input.YEARS,ChronoUnit$$module$input.MONTHS,ChronoUnit$$module$input.DAYS]}},{key:"chronology",value:function(){return IsoChronology$$module$input.INSTANCE}},{key:"get",value:function(a){if(a===ChronoUnit$$module$input.YEARS)return this._years;if(a===ChronoUnit$$module$input.MONTHS)return this._months;if(a===
ChronoUnit$$module$input.DAYS)return this._days;throw new UnsupportedTemporalTypeException$$module$input("Unsupported unit: ".concat(a));}},{key:"isZero",value:function(){return this===b.ZERO}},{key:"isNegative",value:function(){return 0>this._years||0>this._months||0>this._days}},{key:"years",value:function(){return this._years}},{key:"months",value:function(){return this._months}},{key:"days",value:function(){return this._days}},{key:"withYears",value:function(a){return a===this._years?this:b.create(a,
this._months,this._days)}},{key:"withMonths",value:function(a){return a===this._months?this:b.create(this._years,a,this._days)}},{key:"withDays",value:function(a){return a===this._days?this:b.create(this._years,this._months,a)}},{key:"plus",value:function(a){a=b.from(a);return b.create(MathUtil$$module$input.safeAdd(this._years,a._years),MathUtil$$module$input.safeAdd(this._months,a._months),MathUtil$$module$input.safeAdd(this._days,a._days))}},{key:"plusYears",value:function(a){return 0===a?this:
b.create(MathUtil$$module$input.safeToInt(MathUtil$$module$input.safeAdd(this._years,a)),this._months,this._days)}},{key:"plusMonths",value:function(a){return 0===a?this:b.create(this._years,MathUtil$$module$input.safeToInt(MathUtil$$module$input.safeAdd(this._months,a)),this._days)}},{key:"plusDays",value:function(a){return 0===a?this:b.create(this._years,this._months,MathUtil$$module$input.safeToInt(MathUtil$$module$input.safeAdd(this._days,a)))}},{key:"minus",value:function(a){a=b.from(a);return b.create(MathUtil$$module$input.safeSubtract(this._years,
a._years),MathUtil$$module$input.safeSubtract(this._months,a._months),MathUtil$$module$input.safeSubtract(this._days,a._days))}},{key:"minusYears",value:function(a){return this.plusYears(-1*a)}},{key:"minusMonths",value:function(a){return this.plusMonths(-1*a)}},{key:"minusDays",value:function(a){return this.plusDays(-1*a)}},{key:"multipliedBy",value:function(a){return this===b.ZERO||1===a?this:b.create(MathUtil$$module$input.safeMultiply(this._years,a),MathUtil$$module$input.safeMultiply(this._months,
a),MathUtil$$module$input.safeMultiply(this._days,a))}},{key:"negated",value:function(){return this.multipliedBy(-1)}},{key:"normalized",value:function(){var a=this.toTotalMonths(),c=MathUtil$$module$input.intDiv(a,12);a=MathUtil$$module$input.intMod(a,12);return c===this._years&&a===this._months?this:b.create(MathUtil$$module$input.safeToInt(c),a,this._days)}},{key:"toTotalMonths",value:function(){return 12*this._years+this._months}},{key:"addTo",value:function(a){requireNonNull$$module$input(a,
"temporal");0!==this._years?a=0!==this._months?a.plus(this.toTotalMonths(),ChronoUnit$$module$input.MONTHS):a.plus(this._years,ChronoUnit$$module$input.YEARS):0!==this._months&&(a=a.plus(this._months,ChronoUnit$$module$input.MONTHS));0!==this._days&&(a=a.plus(this._days,ChronoUnit$$module$input.DAYS));return a}},{key:"subtractFrom",value:function(a){requireNonNull$$module$input(a,"temporal");0!==this._years?a=0!==this._months?a.minus(this.toTotalMonths(),ChronoUnit$$module$input.MONTHS):a.minus(this._years,
ChronoUnit$$module$input.YEARS):0!==this._months&&(a=a.minus(this._months,ChronoUnit$$module$input.MONTHS));0!==this._days&&(a=a.minus(this._days,ChronoUnit$$module$input.DAYS));return a}},{key:"equals",value:function(a){return this===a?!0:a instanceof b?this._years===a._years&&this._months===a._months&&this._days===a._days:!1}},{key:"hashCode",value:function(){return MathUtil$$module$input.hashCode(this._years,this._months,this._days)}},{key:"toString",value:function(){if(this===b.ZERO)return"P0D";
var a="P";0!==this._years&&(a+="".concat(this._years,"Y"));0!==this._months&&(a+="".concat(this._months,"M"));0!==this._days&&(a+="".concat(this._days,"D"));return a}},{key:"toJSON",value:function(){return this.toString()}}],[{key:"ofYears",value:function(a){return b.create(a,0,0)}},{key:"ofMonths",value:function(a){return b.create(0,a,0)}},{key:"ofWeeks",value:function(a){return b.create(0,0,MathUtil$$module$input.safeMultiply(a,7))}},{key:"ofDays",value:function(a){return b.create(0,0,a)}},{key:"of",
value:function(a,c,f){return b.create(a,c,f)}},{key:"from",value:function(a){if(a instanceof b)return a;requireNonNull$$module$input(a,"amount");for(var c=0,f=0,d=0,e=a.units(),h=0;h<e.length;h++){var k=e[h],m=a.get(k);if(k===ChronoUnit$$module$input.YEARS)c=MathUtil$$module$input.safeToInt(m);else if(k===ChronoUnit$$module$input.MONTHS)f=MathUtil$$module$input.safeToInt(m);else if(k===ChronoUnit$$module$input.DAYS)d=MathUtil$$module$input.safeToInt(m);else throw new DateTimeException$$module$input("Unit must be Years, Months or Days, but was ".concat(k));
}return b.create(c,f,d)}},{key:"between",value:function(a,b){requireNonNull$$module$input(a,"startDate");requireNonNull$$module$input(b,"endDate");requireInstance$$module$input(a,LocalDate$$module$input,"startDate");requireInstance$$module$input(b,LocalDate$$module$input,"endDate");return a.until(b)}},{key:"parse",value:function(a){requireNonNull$$module$input(a,"text");try{return b._parse(a)}catch(c){if(c instanceof ArithmeticException$$module$input)throw new DateTimeParseException$$module$input("Text cannot be parsed to a Period",
a,0,c);throw c;}}},{key:"_parse",value:function(a){var c=PATTERN$$module$input.exec(a);if(null!=c){var f="-"===c[1]?-1:1,d=c[2],e=c[3],h=c[4];c=c[5];if(null!=d||null!=e||null!=h||null!=c)return d=b._parseNumber(a,d,f),e=b._parseNumber(a,e,f),h=b._parseNumber(a,h,f),a=b._parseNumber(a,c,f),a=MathUtil$$module$input.safeAdd(a,MathUtil$$module$input.safeMultiply(h,7)),b.create(d,e,a)}throw new DateTimeParseException$$module$input("Text cannot be parsed to a Period",a,0);}},{key:"_parseNumber",value:function(a,
b,f){if(null==b)return 0;a=MathUtil$$module$input.parseInt(b);return MathUtil$$module$input.safeMultiply(a,f)}},{key:"create",value:function(a,c,f){return new b(a,c,f)}}]);return b}(TemporalAmount$$module$input);function _init$6$$module$input(){Period$$module$input.ofDays(0)}
var ParsePosition$$module$input=function(){function e(b){_classCallCheck$$module$input(this,e);this._index=b;this._errorIndex=-1}_createClass$$module$input(e,[{key:"getIndex",value:function(){return this._index}},{key:"setIndex",value:function(b){this._index=b}},{key:"getErrorIndex",value:function(){return this._errorIndex}},{key:"setErrorIndex",value:function(b){this._errorIndex=b}}]);return e}(),EnumMap$$module$input=function(){function e(){_classCallCheck$$module$input(this,e);this._map={}}_createClass$$module$input(e,
[{key:"putAll",value:function(b){for(var d in b._map)this._map[d]=b._map[d];return this}},{key:"containsKey",value:function(b){return this._map.hasOwnProperty(b.name())&&void 0!==this.get(b)}},{key:"get",value:function(b){return this._map[b.name()]}},{key:"put",value:function(b,d){return this.set(b,d)}},{key:"set",value:function(b,d){this._map[b.name()]=d;return this}},{key:"retainAll",value:function(b){for(var d={},a=0;a<b.length;a++){var c=b[a].name();d[c]=this._map[c]}this._map=d;return this}},
{key:"remove",value:function(b){b=b.name();var d=this._map[b];this._map[b]=void 0;return d}},{key:"keySet",value:function(){return this._map}},{key:"clear",value:function(){this._map={}}}]);return e}(),ResolverStyle$$module$input=function(e){function b(){_classCallCheck$$module$input(this,b);return d.apply(this,arguments)}_inherits$$module$input(b,e);var d=_createSuper$$module$input(b);return b}(Enum$$module$input);ResolverStyle$$module$input.STRICT=new ResolverStyle$$module$input("STRICT");
ResolverStyle$$module$input.SMART=new ResolverStyle$$module$input("SMART");ResolverStyle$$module$input.LENIENT=new ResolverStyle$$module$input("LENIENT");
var Temporal$$module$input=function(e){function b(){_classCallCheck$$module$input(this,b);return d.apply(this,arguments)}_inherits$$module$input(b,e);var d=_createSuper$$module$input(b);_createClass$$module$input(b,[{key:"isSupported",value:function(a){abstractMethodFail$$module$input("isSupported")}},{key:"minus",value:function(a,b){return 2>arguments.length?this._minusAmount(a):this._minusUnit(a,b)}},{key:"_minusAmount",value:function(a){requireNonNull$$module$input(a,"amount");requireInstance$$module$input(a,
TemporalAmount$$module$input,"amount");return a.subtractFrom(this)}},{key:"_minusUnit",value:function(a,b){requireNonNull$$module$input(a,"amountToSubtract");requireNonNull$$module$input(b,"unit");requireInstance$$module$input(b,TemporalUnit$$module$input,"unit");return this._plusUnit(-a,b)}},{key:"plus",value:function(a,b){return 2>arguments.length?this._plusAmount(a):this._plusUnit(a,b)}},{key:"_plusAmount",value:function(a){requireNonNull$$module$input(a,"amount");requireInstance$$module$input(a,
TemporalAmount$$module$input,"amount");return a.addTo(this)}},{key:"_plusUnit",value:function(a,b){abstractMethodFail$$module$input("_plusUnit")}},{key:"until",value:function(a,b){abstractMethodFail$$module$input("until")}},{key:"with",value:function(a,b){return 2>arguments.length?this._withAdjuster(a):this._withField(a,b)}},{key:"_withAdjuster",value:function(a){requireNonNull$$module$input(a,"adjuster");assert$$module$input("function"===typeof a.adjustInto,"adjuster must be a TemporalAdjuster",
IllegalArgumentException$$module$input);return a.adjustInto(this)}},{key:"_withField",value:function(a,b){abstractMethodFail$$module$input("_withField")}}]);return b}(TemporalAccessor$$module$input),ChronoLocalDate$$module$input=function(e){function b(){_classCallCheck$$module$input(this,b);return d.apply(this,arguments)}_inherits$$module$input(b,e);var d=_createSuper$$module$input(b);_createClass$$module$input(b,[{key:"isSupported",value:function(a){return a instanceof ChronoField$$module$input||
a instanceof ChronoUnit$$module$input?a.isDateBased():null!=a&&a.isSupportedBy(this)}},{key:"query",value:function(a){return a===TemporalQueries$$module$input.chronology()?this.chronology():a===TemporalQueries$$module$input.precision()?ChronoUnit$$module$input.DAYS:a===TemporalQueries$$module$input.localDate()?LocalDate$$module$input.ofEpochDay(this.toEpochDay()):a===TemporalQueries$$module$input.localTime()||a===TemporalQueries$$module$input.zone()||a===TemporalQueries$$module$input.zoneId()||a===
TemporalQueries$$module$input.offset()?null:_get$$module$input(_getPrototypeOf$$module$input(b.prototype),"query",this).call(this,a)}},{key:"adjustInto",value:function(a){return a.with(ChronoField$$module$input.EPOCH_DAY,this.toEpochDay())}},{key:"format",value:function(a){requireNonNull$$module$input(a,"formatter");requireInstance$$module$input(a,DateTimeFormatter$$module$input,"formatter");return a.format(this)}}]);return b}(Temporal$$module$input),StringUtil$$module$input=function(){function e(){_classCallCheck$$module$input(this,
e)}_createClass$$module$input(e,null,[{key:"startsWith",value:function(b,d){return 0===b.indexOf(d)}},{key:"hashCode",value:function(b){var d=b.length;if(0===d)return 0;for(var a=0,c=0;c<d;c++){var f=b.charCodeAt(c);a=(a<<5)-a+f;a|=0}return MathUtil$$module$input.smi(a)}}]);return e}(),ZoneId$$module$input=function(){function e(){_classCallCheck$$module$input(this,e)}_createClass$$module$input(e,[{key:"id",value:function(){abstractMethodFail$$module$input("ZoneId.id")}},{key:"rules",value:function(){abstractMethodFail$$module$input("ZoneId.rules")}},
{key:"normalized",value:function(){var b=this.rules();return b.isFixedOffset()?b.offset(Instant$$module$input.EPOCH):this}},{key:"equals",value:function(b){return this===b?!0:b instanceof e?this.id()===b.id():!1}},{key:"hashCode",value:function(){return StringUtil$$module$input.hashCode(this.id())}},{key:"toString",value:function(){return this.id()}},{key:"toJSON",value:function(){return this.toString()}}],[{key:"systemDefault",value:function(){throw new DateTimeException$$module$input("not supported operation");
}},{key:"getAvailableZoneIds",value:function(){throw new DateTimeException$$module$input("not supported operation");}},{key:"of",value:function(b){throw new DateTimeException$$module$input("not supported operation".concat(b));}},{key:"ofOffset",value:function(b,d){throw new DateTimeException$$module$input("not supported operation".concat(b).concat(d));}},{key:"from",value:function(b){throw new DateTimeException$$module$input("not supported operation".concat(b));}}]);return e}(),ZoneRules$$module$input=
function(){function e(){_classCallCheck$$module$input(this,e)}_createClass$$module$input(e,[{key:"isFixedOffset",value:function(){abstractMethodFail$$module$input("ZoneRules.isFixedOffset")}},{key:"offset",value:function(b){return b instanceof Instant$$module$input?this.offsetOfInstant(b):this.offsetOfLocalDateTime(b)}},{key:"offsetOfInstant",value:function(b){abstractMethodFail$$module$input("ZoneRules.offsetInstant")}},{key:"offsetOfEpochMilli",value:function(b){abstractMethodFail$$module$input("ZoneRules.offsetOfEpochMilli")}},
{key:"offsetOfLocalDateTime",value:function(b){abstractMethodFail$$module$input("ZoneRules.offsetLocalDateTime")}},{key:"validOffsets",value:function(b){abstractMethodFail$$module$input("ZoneRules.validOffsets")}},{key:"transition",value:function(b){abstractMethodFail$$module$input("ZoneRules.transition")}},{key:"standardOffset",value:function(b){abstractMethodFail$$module$input("ZoneRules.standardOffset")}},{key:"daylightSavings",value:function(b){abstractMethodFail$$module$input("ZoneRules.daylightSavings")}},
{key:"isDaylightSavings",value:function(b){abstractMethodFail$$module$input("ZoneRules.isDaylightSavings")}},{key:"isValidOffset",value:function(b,d){abstractMethodFail$$module$input("ZoneRules.isValidOffset")}},{key:"nextTransition",value:function(b){abstractMethodFail$$module$input("ZoneRules.nextTransition")}},{key:"previousTransition",value:function(b){abstractMethodFail$$module$input("ZoneRules.previousTransition")}},{key:"transitions",value:function(){abstractMethodFail$$module$input("ZoneRules.transitions")}},
{key:"transitionRules",value:function(){abstractMethodFail$$module$input("ZoneRules.transitionRules")}},{key:"toString",value:function(){abstractMethodFail$$module$input("ZoneRules.toString")}},{key:"toJSON",value:function(){return this.toString()}}],[{key:"of",value:function(b){requireNonNull$$module$input(b,"offset");return new Fixed$$module$input(b)}}]);return e}(),Fixed$$module$input=function(e){function b(a){_classCallCheck$$module$input(this,b);var c=d.call(this);c._offset=a;return c}_inherits$$module$input(b,
e);var d=_createSuper$$module$input(b);_createClass$$module$input(b,[{key:"isFixedOffset",value:function(){return!0}},{key:"offsetOfInstant",value:function(){return this._offset}},{key:"offsetOfEpochMilli",value:function(){return this._offset}},{key:"offsetOfLocalDateTime",value:function(){return this._offset}},{key:"validOffsets",value:function(){return[this._offset]}},{key:"transition",value:function(){return null}},{key:"standardOffset",value:function(){return this._offset}},{key:"daylightSavings",
value:function(){return Duration$$module$input.ZERO}},{key:"isDaylightSavings",value:function(){return!1}},{key:"isValidOffset",value:function(a,b){return this._offset.equals(b)}},{key:"nextTransition",value:function(){return null}},{key:"previousTransition",value:function(){return null}},{key:"transitions",value:function(){return[]}},{key:"transitionRules",value:function(){return[]}},{key:"equals",value:function(a){return this===a?!0:a instanceof b?this._offset.equals(a._offset):!1}},{key:"toString",
value:function(){return"FixedRules:".concat(this._offset.toString())}}]);return b}(ZoneRules$$module$input),SECONDS_CACHE$$module$input={},ID_CACHE$$module$input={},ZoneOffset$$module$input=function(e){function b(a){_classCallCheck$$module$input(this,b);var c=d.call(this);b._validateTotalSeconds(a);c._totalSeconds=MathUtil$$module$input.safeToInt(a);c._rules=ZoneRules$$module$input.of(_assertThisInitialized$$module$input(c));c._id=b._buildId(a);return c}_inherits$$module$input(b,e);var d=_createSuper$$module$input(b);
_createClass$$module$input(b,[{key:"totalSeconds",value:function(){return this._totalSeconds}},{key:"id",value:function(){return this._id}},{key:"rules",value:function(){return this._rules}},{key:"get",value:function(a){return this.getLong(a)}},{key:"getLong",value:function(a){if(a===ChronoField$$module$input.OFFSET_SECONDS)return this._totalSeconds;if(a instanceof ChronoField$$module$input)throw new DateTimeException$$module$input("Unsupported field: ".concat(a));return a.getFrom(this)}},{key:"query",
value:function(a){requireNonNull$$module$input(a,"query");return a===TemporalQueries$$module$input.offset()||a===TemporalQueries$$module$input.zone()?this:a===TemporalQueries$$module$input.localDate()||a===TemporalQueries$$module$input.localTime()||a===TemporalQueries$$module$input.precision()||a===TemporalQueries$$module$input.chronology()||a===TemporalQueries$$module$input.zoneId()?null:a.queryFrom(this)}},{key:"adjustInto",value:function(a){return a.with(ChronoField$$module$input.OFFSET_SECONDS,
this._totalSeconds)}},{key:"compareTo",value:function(a){requireNonNull$$module$input(a,"other");return a._totalSeconds-this._totalSeconds}},{key:"equals",value:function(a){return this===a?!0:a instanceof b?this._totalSeconds===a._totalSeconds:!1}},{key:"hashCode",value:function(){return this._totalSeconds}},{key:"toString",value:function(){return this._id}}],[{key:"_buildId",value:function(a){if(0===a)return"Z";var b=Math.abs(a),f=MathUtil$$module$input.intDiv(b,LocalTime$$module$input.SECONDS_PER_HOUR),
d=MathUtil$$module$input.intMod(MathUtil$$module$input.intDiv(b,LocalTime$$module$input.SECONDS_PER_MINUTE),LocalTime$$module$input.MINUTES_PER_HOUR);a="".concat(0>a?"-":"+").concat(10>f?"0":"").concat(f).concat(10>d?":0":":").concat(d);b=MathUtil$$module$input.intMod(b,LocalTime$$module$input.SECONDS_PER_MINUTE);0!==b&&(a+=(10>b?":0":":")+b);return a}},{key:"_validateTotalSeconds",value:function(a){if(Math.abs(a)>b.MAX_SECONDS)throw new DateTimeException$$module$input("Zone offset not in valid range: -18:00 to +18:00");
}},{key:"_validate",value:function(a,b,f){if(-18>a||18<a)throw new DateTimeException$$module$input("Zone offset hours not in valid range: value ".concat(a," is not in the range -18 to 18"));if(0<a){if(0>b||0>f)throw new DateTimeException$$module$input("Zone offset minutes and seconds must be positive because hours is positive");}else if(0>a){if(0<b||0<f)throw new DateTimeException$$module$input("Zone offset minutes and seconds must be negative because hours is negative");}else if(0<b&&0>f||0>b&&0<
f)throw new DateTimeException$$module$input("Zone offset minutes and seconds must have the same sign");if(59<Math.abs(b))throw new DateTimeException$$module$input("Zone offset minutes not in valid range: abs(value) ".concat(Math.abs(b)," is not in the range 0 to 59"));if(59<Math.abs(f))throw new DateTimeException$$module$input("Zone offset seconds not in valid range: abs(value) ".concat(Math.abs(f)," is not in the range 0 to 59"));if(18===Math.abs(a)&&(0<Math.abs(b)||0<Math.abs(f)))throw new DateTimeException$$module$input("Zone offset not in valid range: -18:00 to +18:00");
}},{key:"of",value:function(a){requireNonNull$$module$input(a,"offsetId");var c=ID_CACHE$$module$input[a];if(null!=c)return c;var f;switch(a.length){case 2:a="".concat(a[0],"0").concat(a[1]);case 3:c=b._parseNumber(a,1,!1);var d=f=0;break;case 5:c=b._parseNumber(a,1,!1);f=b._parseNumber(a,3,!1);d=0;break;case 6:c=b._parseNumber(a,1,!1);f=b._parseNumber(a,4,!0);d=0;break;case 7:c=b._parseNumber(a,1,!1);f=b._parseNumber(a,3,!1);d=b._parseNumber(a,5,!1);break;case 9:c=b._parseNumber(a,1,!1);f=b._parseNumber(a,
4,!0);d=b._parseNumber(a,7,!0);break;default:throw new DateTimeException$$module$input("Invalid ID for ZoneOffset, invalid format: ".concat(a));}var e=a[0];if("+"!==e&&"-"!==e)throw new DateTimeException$$module$input("Invalid ID for ZoneOffset, plus/minus not found when expected: ".concat(a));return"-"===e?b.ofHoursMinutesSeconds(-c,-f,-d):b.ofHoursMinutesSeconds(c,f,d)}},{key:"_parseNumber",value:function(a,b,f){if(f&&":"!==a[b-1])throw new DateTimeException$$module$input("Invalid ID for ZoneOffset, colon not found when expected: ".concat(a));
f=a[b];b=a[b+1];if("0">f||"9"<f||"0">b||"9"<b)throw new DateTimeException$$module$input("Invalid ID for ZoneOffset, non numeric characters found: ".concat(a));return 10*(f.charCodeAt(0)-48)+(b.charCodeAt(0)-48)}},{key:"ofHours",value:function(a){return b.ofHoursMinutesSeconds(a,0,0)}},{key:"ofHoursMinutes",value:function(a,c){return b.ofHoursMinutesSeconds(a,c,0)}},{key:"ofHoursMinutesSeconds",value:function(a,c,f){b._validate(a,c,f);return b.ofTotalSeconds(a*LocalTime$$module$input.SECONDS_PER_HOUR+
c*LocalTime$$module$input.SECONDS_PER_MINUTE+f)}},{key:"ofTotalMinutes",value:function(a){return b.ofTotalSeconds(a*LocalTime$$module$input.SECONDS_PER_MINUTE)}},{key:"ofTotalSeconds",value:function(a){if(0===a%(15*LocalTime$$module$input.SECONDS_PER_MINUTE)){var c=SECONDS_CACHE$$module$input[a];null==c&&(c=new b(a),SECONDS_CACHE$$module$input[a]=c,ID_CACHE$$module$input[c.id()]=c);return c}return new b(a)}}]);return b}(ZoneId$$module$input);
function _init$7$$module$input(){ZoneOffset$$module$input.MAX_SECONDS=18*LocalTime$$module$input.SECONDS_PER_HOUR;ZoneOffset$$module$input.UTC=ZoneOffset$$module$input.ofTotalSeconds(0);ZoneOffset$$module$input.MIN=ZoneOffset$$module$input.ofTotalSeconds(-ZoneOffset$$module$input.MAX_SECONDS);ZoneOffset$$module$input.MAX=ZoneOffset$$module$input.ofTotalSeconds(ZoneOffset$$module$input.MAX_SECONDS)}
var DateTimeBuilder$$module$input=function(e){function b(){_classCallCheck$$module$input(this,b);var a=d.call(this);a.fieldValues=new EnumMap$$module$input;a.chrono=null;a.zone=null;a.date=null;a.time=null;a.leapSecond=!1;a.excessDays=null;return a}_inherits$$module$input(b,e);var d=_createSuper$$module$input(b);_createClass$$module$input(b,[{key:"getFieldValue0",value:function(a){return this.fieldValues.get(a)}},{key:"_addFieldValue",value:function(a,b){requireNonNull$$module$input(a,"field");var c=
this.getFieldValue0(a);if(null!=c&&c!==b)throw new DateTimeException$$module$input("Conflict found: ".concat(a," ").concat(c," differs from ").concat(a," ").concat(b,": ").concat(this));return this._putFieldValue0(a,b)}},{key:"_putFieldValue0",value:function(a,b){this.fieldValues.put(a,b);return this}},{key:"resolve",value:function(a,b){null!=b&&this.fieldValues.retainAll(b);this._mergeDate(a);this._mergeTime(a);this._resolveTimeInferZeroes(a);null!=this.excessDays&&!1===this.excessDays.isZero()&&
null!=this.date&&null!=this.time&&(this.date=this.date.plus(this.excessDays),this.excessDays=Period$$module$input.ZERO);this._resolveInstant();return this}},{key:"_mergeDate",value:function(a){this._checkDate(IsoChronology$$module$input.INSTANCE.resolveDate(this.fieldValues,a))}},{key:"_checkDate",value:function(a){if(null!=a){this._addObject(a);for(var b in this.fieldValues.keySet()){var f=ChronoField$$module$input.byName(b);if(f&&void 0!==this.fieldValues.get(f)&&f.isDateBased()){var d=void 0;try{d=
a.getLong(f)}catch(h){if(h instanceof DateTimeException$$module$input)continue;else throw h;}var e=this.fieldValues.get(f);if(d!==e)throw new DateTimeException$$module$input("Conflict found: Field ".concat(f," ").concat(d," differs from ").concat(f," ").concat(e," derived from ").concat(a));}}}}},{key:"_mergeTime",value:function(a){if(this.fieldValues.containsKey(ChronoField$$module$input.CLOCK_HOUR_OF_DAY)){var b=this.fieldValues.remove(ChronoField$$module$input.CLOCK_HOUR_OF_DAY);a===ResolverStyle$$module$input.LENIENT||
a===ResolverStyle$$module$input.SMART&&0===b||ChronoField$$module$input.CLOCK_HOUR_OF_DAY.checkValidValue(b);this._addFieldValue(ChronoField$$module$input.HOUR_OF_DAY,24===b?0:b)}this.fieldValues.containsKey(ChronoField$$module$input.CLOCK_HOUR_OF_AMPM)&&(b=this.fieldValues.remove(ChronoField$$module$input.CLOCK_HOUR_OF_AMPM),a===ResolverStyle$$module$input.LENIENT||a===ResolverStyle$$module$input.SMART&&0===b||ChronoField$$module$input.CLOCK_HOUR_OF_AMPM.checkValidValue(b),this._addFieldValue(ChronoField$$module$input.HOUR_OF_AMPM,
12===b?0:b));a!==ResolverStyle$$module$input.LENIENT&&(this.fieldValues.containsKey(ChronoField$$module$input.AMPM_OF_DAY)&&ChronoField$$module$input.AMPM_OF_DAY.checkValidValue(this.fieldValues.get(ChronoField$$module$input.AMPM_OF_DAY)),this.fieldValues.containsKey(ChronoField$$module$input.HOUR_OF_AMPM)&&ChronoField$$module$input.HOUR_OF_AMPM.checkValidValue(this.fieldValues.get(ChronoField$$module$input.HOUR_OF_AMPM)));if(this.fieldValues.containsKey(ChronoField$$module$input.AMPM_OF_DAY)&&this.fieldValues.containsKey(ChronoField$$module$input.HOUR_OF_AMPM)){b=
this.fieldValues.remove(ChronoField$$module$input.AMPM_OF_DAY);var f=this.fieldValues.remove(ChronoField$$module$input.HOUR_OF_AMPM);this._addFieldValue(ChronoField$$module$input.HOUR_OF_DAY,12*b+f)}this.fieldValues.containsKey(ChronoField$$module$input.NANO_OF_DAY)&&(b=this.fieldValues.remove(ChronoField$$module$input.NANO_OF_DAY),a!==ResolverStyle$$module$input.LENIENT&&ChronoField$$module$input.NANO_OF_DAY.checkValidValue(b),this._addFieldValue(ChronoField$$module$input.SECOND_OF_DAY,MathUtil$$module$input.intDiv(b,
1E9)),this._addFieldValue(ChronoField$$module$input.NANO_OF_SECOND,MathUtil$$module$input.intMod(b,1E9)));this.fieldValues.containsKey(ChronoField$$module$input.MICRO_OF_DAY)&&(b=this.fieldValues.remove(ChronoField$$module$input.MICRO_OF_DAY),a!==ResolverStyle$$module$input.LENIENT&&ChronoField$$module$input.MICRO_OF_DAY.checkValidValue(b),this._addFieldValue(ChronoField$$module$input.SECOND_OF_DAY,MathUtil$$module$input.intDiv(b,1E6)),this._addFieldValue(ChronoField$$module$input.MICRO_OF_SECOND,
MathUtil$$module$input.intMod(b,1E6)));this.fieldValues.containsKey(ChronoField$$module$input.MILLI_OF_DAY)&&(b=this.fieldValues.remove(ChronoField$$module$input.MILLI_OF_DAY),a!==ResolverStyle$$module$input.LENIENT&&ChronoField$$module$input.MILLI_OF_DAY.checkValidValue(b),this._addFieldValue(ChronoField$$module$input.SECOND_OF_DAY,MathUtil$$module$input.intDiv(b,1E3)),this._addFieldValue(ChronoField$$module$input.MILLI_OF_SECOND,MathUtil$$module$input.intMod(b,1E3)));this.fieldValues.containsKey(ChronoField$$module$input.SECOND_OF_DAY)&&
(b=this.fieldValues.remove(ChronoField$$module$input.SECOND_OF_DAY),a!==ResolverStyle$$module$input.LENIENT&&ChronoField$$module$input.SECOND_OF_DAY.checkValidValue(b),this._addFieldValue(ChronoField$$module$input.HOUR_OF_DAY,MathUtil$$module$input.intDiv(b,3600)),this._addFieldValue(ChronoField$$module$input.MINUTE_OF_HOUR,MathUtil$$module$input.intMod(MathUtil$$module$input.intDiv(b,60),60)),this._addFieldValue(ChronoField$$module$input.SECOND_OF_MINUTE,MathUtil$$module$input.intMod(b,60)));this.fieldValues.containsKey(ChronoField$$module$input.MINUTE_OF_DAY)&&
(b=this.fieldValues.remove(ChronoField$$module$input.MINUTE_OF_DAY),a!==ResolverStyle$$module$input.LENIENT&&ChronoField$$module$input.MINUTE_OF_DAY.checkValidValue(b),this._addFieldValue(ChronoField$$module$input.HOUR_OF_DAY,MathUtil$$module$input.intDiv(b,60)),this._addFieldValue(ChronoField$$module$input.MINUTE_OF_HOUR,MathUtil$$module$input.intMod(b,60)));a!==ResolverStyle$$module$input.LENIENT&&(this.fieldValues.containsKey(ChronoField$$module$input.MILLI_OF_SECOND)&&ChronoField$$module$input.MILLI_OF_SECOND.checkValidValue(this.fieldValues.get(ChronoField$$module$input.MILLI_OF_SECOND)),
this.fieldValues.containsKey(ChronoField$$module$input.MICRO_OF_SECOND)&&ChronoField$$module$input.MICRO_OF_SECOND.checkValidValue(this.fieldValues.get(ChronoField$$module$input.MICRO_OF_SECOND)));this.fieldValues.containsKey(ChronoField$$module$input.MILLI_OF_SECOND)&&this.fieldValues.containsKey(ChronoField$$module$input.MICRO_OF_SECOND)&&(a=this.fieldValues.remove(ChronoField$$module$input.MILLI_OF_SECOND),b=this.fieldValues.get(ChronoField$$module$input.MICRO_OF_SECOND),this._putFieldValue0(ChronoField$$module$input.MICRO_OF_SECOND,
1E3*a+MathUtil$$module$input.intMod(b,1E3)));this.fieldValues.containsKey(ChronoField$$module$input.MICRO_OF_SECOND)&&this.fieldValues.containsKey(ChronoField$$module$input.NANO_OF_SECOND)&&(a=this.fieldValues.get(ChronoField$$module$input.NANO_OF_SECOND),this._putFieldValue0(ChronoField$$module$input.MICRO_OF_SECOND,MathUtil$$module$input.intDiv(a,1E3)),this.fieldValues.remove(ChronoField$$module$input.MICRO_OF_SECOND));this.fieldValues.containsKey(ChronoField$$module$input.MILLI_OF_SECOND)&&this.fieldValues.containsKey(ChronoField$$module$input.NANO_OF_SECOND)&&
(a=this.fieldValues.get(ChronoField$$module$input.NANO_OF_SECOND),this._putFieldValue0(ChronoField$$module$input.MILLI_OF_SECOND,MathUtil$$module$input.intDiv(a,1E6)),this.fieldValues.remove(ChronoField$$module$input.MILLI_OF_SECOND));this.fieldValues.containsKey(ChronoField$$module$input.MICRO_OF_SECOND)?(a=this.fieldValues.remove(ChronoField$$module$input.MICRO_OF_SECOND),this._putFieldValue0(ChronoField$$module$input.NANO_OF_SECOND,1E3*a)):this.fieldValues.containsKey(ChronoField$$module$input.MILLI_OF_SECOND)&&
(a=this.fieldValues.remove(ChronoField$$module$input.MILLI_OF_SECOND),this._putFieldValue0(ChronoField$$module$input.NANO_OF_SECOND,1E6*a))}},{key:"_resolveTimeInferZeroes",value:function(a){var b=this.fieldValues.get(ChronoField$$module$input.HOUR_OF_DAY),f=this.fieldValues.get(ChronoField$$module$input.MINUTE_OF_HOUR),d=this.fieldValues.get(ChronoField$$module$input.SECOND_OF_MINUTE),e=this.fieldValues.get(ChronoField$$module$input.NANO_OF_SECOND);null==b||null==f&&(null!=d||null!=e)||null!=f&&
null==d&&null!=e||(a!==ResolverStyle$$module$input.LENIENT?null!=b&&(a!==ResolverStyle$$module$input.SMART||24!==b||null!=f&&0!==f||null!=d&&0!==d||null!=e&&0!==e||(b=0,this.excessDays=Period$$module$input.ofDays(1)),a=ChronoField$$module$input.HOUR_OF_DAY.checkValidIntValue(b),null!=f?(f=ChronoField$$module$input.MINUTE_OF_HOUR.checkValidIntValue(f),null!=d?(d=ChronoField$$module$input.SECOND_OF_MINUTE.checkValidIntValue(d),null!=e?(e=ChronoField$$module$input.NANO_OF_SECOND.checkValidIntValue(e),
this._addObject(LocalTime$$module$input.of(a,f,d,e))):this._addObject(LocalTime$$module$input.of(a,f,d))):null==e&&this._addObject(LocalTime$$module$input.of(a,f))):null==d&&null==e&&this._addObject(LocalTime$$module$input.of(a,0))):null!=b&&(a=b,null!=f?null!=d?(null==e&&(e=0),a=MathUtil$$module$input.safeMultiply(a,36E11),a=MathUtil$$module$input.safeAdd(a,MathUtil$$module$input.safeMultiply(f,6E10)),a=MathUtil$$module$input.safeAdd(a,MathUtil$$module$input.safeMultiply(d,1E9)),a=MathUtil$$module$input.safeAdd(a,
e),e=MathUtil$$module$input.floorDiv(a,864E11),f=MathUtil$$module$input.floorMod(a,864E11),this._addObject(LocalTime$$module$input.ofNanoOfDay(f)),this.excessDays=Period$$module$input.ofDays(e)):(e=MathUtil$$module$input.safeMultiply(a,3600),e=MathUtil$$module$input.safeAdd(e,MathUtil$$module$input.safeMultiply(f,60)),f=MathUtil$$module$input.floorDiv(e,86400),e=MathUtil$$module$input.floorMod(e,86400),this._addObject(LocalTime$$module$input.ofSecondOfDay(e)),this.excessDays=Period$$module$input.ofDays(f)):
(e=MathUtil$$module$input.safeToInt(MathUtil$$module$input.floorDiv(a,24)),a=MathUtil$$module$input.floorMod(a,24),this._addObject(LocalTime$$module$input.of(a,0)),this.excessDays=Period$$module$input.ofDays(e))),this.fieldValues.remove(ChronoField$$module$input.HOUR_OF_DAY),this.fieldValues.remove(ChronoField$$module$input.MINUTE_OF_HOUR),this.fieldValues.remove(ChronoField$$module$input.SECOND_OF_MINUTE),this.fieldValues.remove(ChronoField$$module$input.NANO_OF_SECOND))}},{key:"_addObject",value:function(a){a instanceof
ChronoLocalDate$$module$input?this.date=a:a instanceof LocalTime$$module$input&&(this.time=a)}},{key:"_resolveInstant",value:function(){if(null!=this.date&&null!=this.time){var a=this.fieldValues.get(ChronoField$$module$input.OFFSET_SECONDS);null!=a?(a=ZoneOffset$$module$input.ofTotalSeconds(a),a=this.date.atTime(this.time).atZone(a).getLong(ChronoField$$module$input.INSTANT_SECONDS),this.fieldValues.put(ChronoField$$module$input.INSTANT_SECONDS,a)):null!=this.zone&&(a=this.date.atTime(this.time).atZone(this.zone).getLong(ChronoField$$module$input.INSTANT_SECONDS),
this.fieldValues.put(ChronoField$$module$input.INSTANT_SECONDS,a))}}},{key:"build",value:function(a){return a.queryFrom(this)}},{key:"isSupported",value:function(a){return null==a?!1:this.fieldValues.containsKey(a)&&void 0!==this.fieldValues.get(a)||null!=this.date&&this.date.isSupported(a)||null!=this.time&&this.time.isSupported(a)}},{key:"getLong",value:function(a){requireNonNull$$module$input(a,"field");var b=this.getFieldValue0(a);if(null==b){if(null!=this.date&&this.date.isSupported(a))return this.date.getLong(a);
if(null!=this.time&&this.time.isSupported(a))return this.time.getLong(a);throw new DateTimeException$$module$input("Field not found: ".concat(a));}return b}},{key:"query",value:function(a){return a===TemporalQueries$$module$input.zoneId()?this.zone:a===TemporalQueries$$module$input.chronology()?this.chrono:a===TemporalQueries$$module$input.localDate()?null!=this.date?LocalDate$$module$input.from(this.date):null:a===TemporalQueries$$module$input.localTime()?this.time:a!==TemporalQueries$$module$input.zone()&&
a!==TemporalQueries$$module$input.offset()&&a===TemporalQueries$$module$input.precision()?null:a.queryFrom(this)}}],[{key:"create",value:function(a,c){var f=new b;f._addFieldValue(a,c);return f}}]);return b}(TemporalAccessor$$module$input),DateTimeParseContext$$module$input=function(){function e(){_classCallCheck$$module$input(this,e);if(1===arguments.length){if(arguments[0]instanceof e){this._constructorSelf.apply(this,arguments);return}this._constructorFormatter.apply(this,arguments)}else this._constructorParam.apply(this,
arguments);this._strict=this._caseSensitive=!0;this._parsed=[new Parsed$$module$input(this)]}_createClass$$module$input(e,[{key:"_constructorParam",value:function(b,d,a){this._locale=b;this._symbols=d;this._overrideChronology=a}},{key:"_constructorFormatter",value:function(b){this._locale=b.locale();this._symbols=b.decimalStyle();this._overrideChronology=b.chronology()}},{key:"_constructorSelf",value:function(b){this._locale=b._locale;this._symbols=b._symbols;this._overrideChronology=b._overrideChronology;
this._overrideZone=b._overrideZone;this._caseSensitive=b._caseSensitive;this._strict=b._strict;this._parsed=[new Parsed$$module$input(this)]}},{key:"copy",value:function(){return new e(this)}},{key:"symbols",value:function(){return this._symbols}},{key:"isStrict",value:function(){return this._strict}},{key:"setStrict",value:function(b){this._strict=b}},{key:"locale",value:function(){return this._locale}},{key:"setLocale",value:function(b){this._locale=b}},{key:"startOptional",value:function(){this._parsed.push(this.currentParsed().copy())}},
{key:"endOptional",value:function(b){b?this._parsed.splice(this._parsed.length-2,1):this._parsed.splice(this._parsed.length-1,1)}},{key:"isCaseSensitive",value:function(){return this._caseSensitive}},{key:"setCaseSensitive",value:function(b){this._caseSensitive=b}},{key:"subSequenceEquals",value:function(b,d,a,c,f){if(d+f>b.length||c+f>a.length)return!1;this.isCaseSensitive()||(b=b.toLowerCase(),a=a.toLowerCase());for(var e=0;e<f;e++)if(b[d+e]!==a[c+e])return!1;return!0}},{key:"charEquals",value:function(b,
d){return this.isCaseSensitive()?b===d:this.charEqualsIgnoreCase(b,d)}},{key:"charEqualsIgnoreCase",value:function(b,d){return b===d||b.toLowerCase()===d.toLowerCase()}},{key:"setParsedField",value:function(b,d,a,c){var f=this.currentParsed().fieldValues,e=f.get(b);f.set(b,d);return null!=e&&e!==d?~a:c}},{key:"setParsedZone",value:function(b){requireNonNull$$module$input(b,"zone");this.currentParsed().zone=b}},{key:"getParsed",value:function(b){return this.currentParsed().fieldValues.get(b)}},{key:"toParsed",
value:function(){return this.currentParsed()}},{key:"currentParsed",value:function(){return this._parsed[this._parsed.length-1]}},{key:"setParsedLeapSecond",value:function(){this.currentParsed().leapSecond=!0}},{key:"getEffectiveChronology",value:function(){var b=this.currentParsed().chrono;null==b&&(b=this._overrideChronology,null==b&&(b=IsoChronology$$module$input.INSTANCE));return b}}]);return e}(),Parsed$$module$input=function(e){function b(a){_classCallCheck$$module$input(this,b);var c=d.call(this);
c.chrono=null;c.zone=null;c.fieldValues=new EnumMap$$module$input;c.leapSecond=!1;c.dateTimeParseContext=a;return c}_inherits$$module$input(b,e);var d=_createSuper$$module$input(b);_createClass$$module$input(b,[{key:"copy",value:function(){var a=new b;a.chrono=this.chrono;a.zone=this.zone;a.fieldValues.putAll(this.fieldValues);a.leapSecond=this.leapSecond;a.dateTimeParseContext=this.dateTimeParseContext;return a}},{key:"toString",value:function(){return"".concat(this.fieldValues,", ").concat(this.chrono,
", ").concat(this.zone)}},{key:"isSupported",value:function(a){return this.fieldValues.containsKey(a)}},{key:"get",value:function(a){a=this.fieldValues.get(a);assert$$module$input(null!=a);return a}},{key:"query",value:function(a){return a===TemporalQueries$$module$input.chronology()?this.chrono:a===TemporalQueries$$module$input.zoneId()||a===TemporalQueries$$module$input.zone()?this.zone:_get$$module$input(_getPrototypeOf$$module$input(b.prototype),"query",this).call(this,a)}},{key:"toBuilder",value:function(){var a=
new DateTimeBuilder$$module$input;a.fieldValues.putAll(this.fieldValues);a.chrono=this.dateTimeParseContext.getEffectiveChronology();a.zone=null!=this.zone?this.zone:this.overrideZone;a.leapSecond=this.leapSecond;a.excessDays=this.excessDays;return a}}]);return b}(Temporal$$module$input),DateTimePrintContext$$module$input=function(){function e(b,d,a){_classCallCheck$$module$input(this,e);2===arguments.length&&arguments[1]instanceof DateTimeFormatter$$module$input?(this._temporal=e.adjust(b,d),this._locale=
d.locale(),this._symbols=d.decimalStyle()):(this._temporal=b,this._locale=d,this._symbols=a);this._optional=0}_createClass$$module$input(e,[{key:"symbols",value:function(){return this._symbols}},{key:"startOptional",value:function(){this._optional++}},{key:"endOptional",value:function(){this._optional--}},{key:"getValueQuery",value:function(b){b=this._temporal.query(b);if(null==b&&0===this._optional)throw new DateTimeException$$module$input("Unable to extract value: ".concat(this._temporal));return b}},
{key:"getValue",value:function(b){try{return this._temporal.getLong(b)}catch(d){if(d instanceof DateTimeException$$module$input&&0<this._optional)return null;throw d;}}},{key:"temporal",value:function(){return this._temporal}},{key:"locale",value:function(){return this._locale}},{key:"setDateTime",value:function(b){this._temporal=b}},{key:"setLocale",value:function(b){this._locale=b}}],[{key:"adjust",value:function(b,d){return b}}]);return e}(),IsoFields$$module$input={},QUARTER_DAYS$$module$input=
[0,90,181,273,0,91,182,274],Field$$module$input=function(e){function b(){_classCallCheck$$module$input(this,b);return d.apply(this,arguments)}_inherits$$module$input(b,e);var d=_createSuper$$module$input(b);_createClass$$module$input(b,[{key:"isDateBased",value:function(){return!0}},{key:"isTimeBased",value:function(){return!1}},{key:"_isIso",value:function(){return!0}},{key:"displayName",value:function(){return this.toString()}},{key:"resolve",value:function(){return null}},{key:"name",value:function(){return this.toString()}}],
[{key:"_getWeekRangeByLocalDate",value:function(a){a=b._getWeekBasedYear(a);return ValueRange$$module$input.of(1,b._getWeekRangeByYear(a))}},{key:"_getWeekRangeByYear",value:function(a){a=LocalDate$$module$input.of(a,1,1);return a.dayOfWeek()===DayOfWeek$$module$input.THURSDAY||a.dayOfWeek()===DayOfWeek$$module$input.WEDNESDAY&&a.isLeapYear()?53:52}},{key:"_getWeek",value:function(a){var c=a.dayOfWeek().ordinal(),f=a.dayOfYear()-1;c=f+(3-c);var d=MathUtil$$module$input.intDiv(c,7);c=c-7*d-3;-3>c&&
(c+=7);if(f<c)return b._getWeekRangeByLocalDate(a.withDayOfYear(180).minusYears(1)).maximum();f=MathUtil$$module$input.intDiv(f-c,7)+1;53===f&&!1===(-3===c||-2===c&&a.isLeapYear())&&(f=1);return f}},{key:"_getWeekBasedYear",value:function(a){var b=a.year(),f=a.dayOfYear();if(3>=f)a=a.dayOfWeek().ordinal(),-2>f-a&&b--;else if(363<=f){var d=a.dayOfWeek().ordinal();f=f-363-(a.isLeapYear()?1:0);0<=f-d&&b++}return b}}]);return b}(TemporalField$$module$input),DAY_OF_QUARTER_FIELD$$module$input=function(e){function b(){_classCallCheck$$module$input(this,
b);return d.apply(this,arguments)}_inherits$$module$input(b,e);var d=_createSuper$$module$input(b);_createClass$$module$input(b,[{key:"toString",value:function(){return"DayOfQuarter"}},{key:"baseUnit",value:function(){return ChronoUnit$$module$input.DAYS}},{key:"rangeUnit",value:function(){return QUARTER_YEARS$$module$input}},{key:"range",value:function(){return ValueRange$$module$input.of(1,90,92)}},{key:"isSupportedBy",value:function(a){return a.isSupported(ChronoField$$module$input.DAY_OF_YEAR)&&
a.isSupported(ChronoField$$module$input.MONTH_OF_YEAR)&&a.isSupported(ChronoField$$module$input.YEAR)&&this._isIso(a)}},{key:"rangeRefinedBy",value:function(a){if(!1===a.isSupported(this))throw new UnsupportedTemporalTypeException$$module$input("Unsupported field: DayOfQuarter");var b=a.getLong(QUARTER_OF_YEAR$$module$input);return 1===b?(a=a.getLong(ChronoField$$module$input.YEAR),IsoChronology$$module$input.isLeapYear(a)?ValueRange$$module$input.of(1,91):ValueRange$$module$input.of(1,90)):2===b?
ValueRange$$module$input.of(1,91):3===b||4===b?ValueRange$$module$input.of(1,92):this.range()}},{key:"getFrom",value:function(a){if(!1===a.isSupported(this))throw new UnsupportedTemporalTypeException$$module$input("Unsupported field: DayOfQuarter");var b=a.get(ChronoField$$module$input.DAY_OF_YEAR),f=a.get(ChronoField$$module$input.MONTH_OF_YEAR);a=a.getLong(ChronoField$$module$input.YEAR);return b-QUARTER_DAYS$$module$input[MathUtil$$module$input.intDiv(f-1,3)+(IsoChronology$$module$input.isLeapYear(a)?
4:0)]}},{key:"adjustInto",value:function(a,b){var c=this.getFrom(a);this.range().checkValidValue(b,this);return a.with(ChronoField$$module$input.DAY_OF_YEAR,a.getLong(ChronoField$$module$input.DAY_OF_YEAR)+(b-c))}},{key:"resolve",value:function(a,b,f){b=a.get(ChronoField$$module$input.YEAR);var c=a.get(QUARTER_OF_YEAR$$module$input);if(null==b||null==c)return null;var d=ChronoField$$module$input.YEAR.checkValidIntValue(b);b=a.get(DAY_OF_QUARTER$$module$input);f===ResolverStyle$$module$input.LENIENT?
(f=LocalDate$$module$input.of(d,1,1),f=f.plusMonths(MathUtil$$module$input.safeMultiply(MathUtil$$module$input.safeSubtract(c,1),3)),f=f.plusDays(MathUtil$$module$input.safeSubtract(b,1))):(c=QUARTER_OF_YEAR$$module$input.range().checkValidIntValue(c,QUARTER_OF_YEAR$$module$input),f===ResolverStyle$$module$input.STRICT?(f=92,1===c?f=IsoChronology$$module$input.isLeapYear(d)?91:90:2===c&&(f=91),ValueRange$$module$input.of(1,f).checkValidValue(b,this)):this.range().checkValidValue(b,this),f=LocalDate$$module$input.of(d,
3*(c-1)+1,1).plusDays(b-1));a.remove(this);a.remove(ChronoField$$module$input.YEAR);a.remove(QUARTER_OF_YEAR$$module$input);return f}}]);return b}(Field$$module$input),QUARTER_OF_YEAR_FIELD$$module$input=function(e){function b(){_classCallCheck$$module$input(this,b);return d.apply(this,arguments)}_inherits$$module$input(b,e);var d=_createSuper$$module$input(b);_createClass$$module$input(b,[{key:"toString",value:function(){return"QuarterOfYear"}},{key:"baseUnit",value:function(){return QUARTER_YEARS$$module$input}},
{key:"rangeUnit",value:function(){return ChronoUnit$$module$input.YEARS}},{key:"range",value:function(){return ValueRange$$module$input.of(1,4)}},{key:"isSupportedBy",value:function(a){return a.isSupported(ChronoField$$module$input.MONTH_OF_YEAR)&&this._isIso(a)}},{key:"rangeRefinedBy",value:function(a){return this.range()}},{key:"getFrom",value:function(a){if(!1===a.isSupported(this))throw new UnsupportedTemporalTypeException$$module$input("Unsupported field: QuarterOfYear");a=a.getLong(ChronoField$$module$input.MONTH_OF_YEAR);
return MathUtil$$module$input.intDiv(a+2,3)}},{key:"adjustInto",value:function(a,b){var c=this.getFrom(a);this.range().checkValidValue(b,this);return a.with(ChronoField$$module$input.MONTH_OF_YEAR,a.getLong(ChronoField$$module$input.MONTH_OF_YEAR)+3*(b-c))}}]);return b}(Field$$module$input),WEEK_OF_WEEK_BASED_YEAR_FIELD$$module$input=function(e){function b(){_classCallCheck$$module$input(this,b);return d.apply(this,arguments)}_inherits$$module$input(b,e);var d=_createSuper$$module$input(b);_createClass$$module$input(b,
[{key:"toString",value:function(){return"WeekOfWeekBasedYear"}},{key:"baseUnit",value:function(){return ChronoUnit$$module$input.WEEKS}},{key:"rangeUnit",value:function(){return WEEK_BASED_YEARS$$module$input}},{key:"range",value:function(){return ValueRange$$module$input.of(1,52,53)}},{key:"isSupportedBy",value:function(a){return a.isSupported(ChronoField$$module$input.EPOCH_DAY)&&this._isIso(a)}},{key:"rangeRefinedBy",value:function(a){if(!1===a.isSupported(this))throw new UnsupportedTemporalTypeException$$module$input("Unsupported field: WeekOfWeekBasedYear");
return Field$$module$input._getWeekRangeByLocalDate(LocalDate$$module$input.from(a))}},{key:"getFrom",value:function(a){if(!1===a.isSupported(this))throw new UnsupportedTemporalTypeException$$module$input("Unsupported field: WeekOfWeekBasedYear");return Field$$module$input._getWeek(LocalDate$$module$input.from(a))}},{key:"adjustInto",value:function(a,b){this.range().checkValidValue(b,this);return a.plus(MathUtil$$module$input.safeSubtract(b,this.getFrom(a)),ChronoUnit$$module$input.WEEKS)}},{key:"resolve",
value:function(a,b,f){b=a.get(WEEK_BASED_YEAR$$module$input);var c=a.get(ChronoField$$module$input.DAY_OF_WEEK);if(null==b||null==c)return null;b=WEEK_BASED_YEAR$$module$input.range().checkValidIntValue(b,WEEK_BASED_YEAR$$module$input);var d=a.get(WEEK_OF_WEEK_BASED_YEAR$$module$input);f===ResolverStyle$$module$input.LENIENT?(f=c,c=0,7<f?(c=MathUtil$$module$input.intDiv(f-1,7),f=MathUtil$$module$input.intMod(f-1,7)+1):1>f&&(c=MathUtil$$module$input.intDiv(f,7)-1,f=MathUtil$$module$input.intMod(f,
7)+7),b=LocalDate$$module$input.of(b,1,4).plusWeeks(d-1).plusWeeks(c).with(ChronoField$$module$input.DAY_OF_WEEK,f)):(c=ChronoField$$module$input.DAY_OF_WEEK.checkValidIntValue(c),f===ResolverStyle$$module$input.STRICT?(f=LocalDate$$module$input.of(b,1,4),Field$$module$input._getWeekRangeByLocalDate(f).checkValidValue(d,this)):this.range().checkValidValue(d,this),b=LocalDate$$module$input.of(b,1,4).plusWeeks(d-1).with(ChronoField$$module$input.DAY_OF_WEEK,c));a.remove(this);a.remove(WEEK_BASED_YEAR$$module$input);
a.remove(ChronoField$$module$input.DAY_OF_WEEK);return b}},{key:"displayName",value:function(){return"Week"}}]);return b}(Field$$module$input),WEEK_BASED_YEAR_FIELD$$module$input=function(e){function b(){_classCallCheck$$module$input(this,b);return d.apply(this,arguments)}_inherits$$module$input(b,e);var d=_createSuper$$module$input(b);_createClass$$module$input(b,[{key:"toString",value:function(){return"WeekBasedYear"}},{key:"baseUnit",value:function(){return WEEK_BASED_YEARS$$module$input}},{key:"rangeUnit",
value:function(){return ChronoUnit$$module$input.FOREVER}},{key:"range",value:function(){return ChronoField$$module$input.YEAR.range()}},{key:"isSupportedBy",value:function(a){return a.isSupported(ChronoField$$module$input.EPOCH_DAY)&&this._isIso(a)}},{key:"rangeRefinedBy",value:function(a){return ChronoField$$module$input.YEAR.range()}},{key:"getFrom",value:function(a){if(!1===a.isSupported(this))throw new UnsupportedTemporalTypeException$$module$input("Unsupported field: WeekBasedYear");return Field$$module$input._getWeekBasedYear(LocalDate$$module$input.from(a))}},
{key:"adjustInto",value:function(a,b){if(!1===this.isSupportedBy(a))throw new UnsupportedTemporalTypeException$$module$input("Unsupported field: WeekBasedYear");var c=this.range().checkValidIntValue(b,WEEK_BASED_YEAR$$module$input),d=LocalDate$$module$input.from(a);b=d.get(ChronoField$$module$input.DAY_OF_WEEK);d=Field$$module$input._getWeek(d);53===d&&52===Field$$module$input._getWeekRangeByYear(c)&&(d=52);c=LocalDate$$module$input.of(c,1,4);b=b-c.get(ChronoField$$module$input.DAY_OF_WEEK)+7*(d-
1);c=c.plusDays(b);return a.with(c)}}]);return b}(Field$$module$input),Unit$$module$input=function(e){function b(a,c){_classCallCheck$$module$input(this,b);var f=d.call(this);f._name=a;f._duration=c;return f}_inherits$$module$input(b,e);var d=_createSuper$$module$input(b);_createClass$$module$input(b,[{key:"duration",value:function(){return this._duration}},{key:"isDurationEstimated",value:function(){return!0}},{key:"isDateBased",value:function(){return!0}},{key:"isTimeBased",value:function(){return!1}},
{key:"isSupportedBy",value:function(a){return a.isSupported(ChronoField$$module$input.EPOCH_DAY)}},{key:"addTo",value:function(a,b){switch(this){case WEEK_BASED_YEARS$$module$input:return b=MathUtil$$module$input.safeAdd(a.get(WEEK_BASED_YEAR$$module$input),b),a.with(WEEK_BASED_YEAR$$module$input,b);case QUARTER_YEARS$$module$input:return a.plus(MathUtil$$module$input.intDiv(b,256),ChronoUnit$$module$input.YEARS).plus(3*MathUtil$$module$input.intMod(b,256),ChronoUnit$$module$input.MONTHS);default:throw new IllegalStateException$$module$input("Unreachable");
}}},{key:"between",value:function(a,b){switch(this){case WEEK_BASED_YEARS$$module$input:return MathUtil$$module$input.safeSubtract(b.getLong(WEEK_BASED_YEAR$$module$input),a.getLong(WEEK_BASED_YEAR$$module$input));case QUARTER_YEARS$$module$input:return MathUtil$$module$input.intDiv(a.until(b,ChronoUnit$$module$input.MONTHS),3);default:throw new IllegalStateException$$module$input("Unreachable");}}},{key:"toString",value:function(){return name}}]);return b}(TemporalUnit$$module$input),DAY_OF_QUARTER$$module$input=
null,QUARTER_OF_YEAR$$module$input=null,WEEK_OF_WEEK_BASED_YEAR$$module$input=null,WEEK_BASED_YEAR$$module$input=null,WEEK_BASED_YEARS$$module$input=null,QUARTER_YEARS$$module$input=null;
function _init$8$$module$input(){DAY_OF_QUARTER$$module$input=new DAY_OF_QUARTER_FIELD$$module$input;QUARTER_OF_YEAR$$module$input=new QUARTER_OF_YEAR_FIELD$$module$input;WEEK_OF_WEEK_BASED_YEAR$$module$input=new WEEK_OF_WEEK_BASED_YEAR_FIELD$$module$input;WEEK_BASED_YEAR$$module$input=new WEEK_BASED_YEAR_FIELD$$module$input;WEEK_BASED_YEARS$$module$input=new Unit$$module$input("WeekBasedYears",Duration$$module$input.ofSeconds(31556952));QUARTER_YEARS$$module$input=new Unit$$module$input("QuarterYears",
Duration$$module$input.ofSeconds(7889238));IsoFields$$module$input.DAY_OF_QUARTER=DAY_OF_QUARTER$$module$input;IsoFields$$module$input.QUARTER_OF_YEAR=QUARTER_OF_YEAR$$module$input;IsoFields$$module$input.WEEK_OF_WEEK_BASED_YEAR=WEEK_OF_WEEK_BASED_YEAR$$module$input;IsoFields$$module$input.WEEK_BASED_YEAR=WEEK_BASED_YEAR$$module$input;IsoFields$$module$input.WEEK_BASED_YEARS=WEEK_BASED_YEARS$$module$input;IsoFields$$module$input.QUARTER_YEARS=QUARTER_YEARS$$module$input;LocalDate$$module$input.prototype.isoWeekOfWeekyear=
function(){return this.get(IsoFields$$module$input.WEEK_OF_WEEK_BASED_YEAR)};LocalDate$$module$input.prototype.isoWeekyear=function(){return this.get(IsoFields$$module$input.WEEK_BASED_YEAR)}}
var DecimalStyle$$module$input=function(){function e(b,d,a,c){_classCallCheck$$module$input(this,e);this._zeroDigit=b;this._zeroDigitCharCode=b.charCodeAt(0);this._positiveSign=d;this._negativeSign=a;this._decimalSeparator=c}_createClass$$module$input(e,[{key:"positiveSign",value:function(){return this._positiveSign}},{key:"withPositiveSign",value:function(b){return b===this._positiveSign?this:new e(this._zeroDigit,b,this._negativeSign,this._decimalSeparator)}},{key:"negativeSign",value:function(){return this._negativeSign}},
{key:"withNegativeSign",value:function(b){return b===this._negativeSign?this:new e(this._zeroDigit,this._positiveSign,b,this._decimalSeparator)}},{key:"zeroDigit",value:function(){return this._zeroDigit}},{key:"withZeroDigit",value:function(b){return b===this._zeroDigit?this:new e(b,this._positiveSign,this._negativeSign,this._decimalSeparator)}},{key:"decimalSeparator",value:function(){return this._decimalSeparator}},{key:"withDecimalSeparator",value:function(b){return b===this._decimalSeparator?
this:new e(this._zeroDigit,this._positiveSign,this._negativeSign,b)}},{key:"convertToDigit",value:function(b){b=b.charCodeAt(0)-this._zeroDigitCharCode;return 0<=b&&9>=b?b:-1}},{key:"convertNumberToI18N",value:function(b){if("0"===this._zeroDigit)return b;for(var d=this._zeroDigitCharCode-48,a="",c=0;c<b.length;c++)a+=String.fromCharCode(b.charCodeAt(c)+d);return a}},{key:"equals",value:function(b){return this===b?!0:b instanceof e?this._zeroDigit===b._zeroDigit&&this._positiveSign===b._positiveSign&&
this._negativeSign===b._negativeSign&&this._decimalSeparator===b._decimalSeparator:!1}},{key:"hashCode",value:function(){return this._zeroDigit+this._positiveSign+this._negativeSign+this._decimalSeparator}},{key:"toString",value:function(){return"DecimalStyle[".concat(this._zeroDigit).concat(this._positiveSign).concat(this._negativeSign).concat(this._decimalSeparator,"]")}}],[{key:"of",value:function(){throw Error("not yet supported");}},{key:"availableLocales",value:function(){throw Error("not yet supported");
}}]);return e}();DecimalStyle$$module$input.STANDARD=new DecimalStyle$$module$input("0","+","-",".");var SignStyle$$module$input=function(e){function b(){_classCallCheck$$module$input(this,b);return d.apply(this,arguments)}_inherits$$module$input(b,e);var d=_createSuper$$module$input(b);_createClass$$module$input(b,[{key:"parse",value:function(a,c,d){switch(this){case b.NORMAL:return!a||!c;case b.ALWAYS:case b.EXCEEDS_PAD:return!0;default:return!c&&!d}}}]);return b}(Enum$$module$input);
SignStyle$$module$input.NORMAL=new SignStyle$$module$input("NORMAL");SignStyle$$module$input.NEVER=new SignStyle$$module$input("NEVER");SignStyle$$module$input.ALWAYS=new SignStyle$$module$input("ALWAYS");SignStyle$$module$input.EXCEEDS_PAD=new SignStyle$$module$input("EXCEEDS_PAD");SignStyle$$module$input.NOT_NEGATIVE=new SignStyle$$module$input("NOT_NEGATIVE");
var TextStyle$$module$input=function(e){function b(){_classCallCheck$$module$input(this,b);return d.apply(this,arguments)}_inherits$$module$input(b,e);var d=_createSuper$$module$input(b);_createClass$$module$input(b,[{key:"isStandalone",value:function(){switch(this){case b.FULL_STANDALONE:case b.SHORT_STANDALONE:case b.NARROW_STANDALONE:return!0;default:return!1}}},{key:"asStandalone",value:function(){switch(this){case b.FULL:return b.FULL_STANDALONE;case b.SHORT:return b.SHORT_STANDALONE;case b.NARROW:return b.NARROW_STANDALONE;
default:return this}}},{key:"asNormal",value:function(){switch(this){case b.FULL_STANDALONE:return b.FULL;case b.SHORT_STANDALONE:return b.SHORT;case b.NARROW_STANDALONE:return b.NARROW;default:return this}}}]);return b}(Enum$$module$input);TextStyle$$module$input.FULL=new TextStyle$$module$input("FULL");TextStyle$$module$input.FULL_STANDALONE=new TextStyle$$module$input("FULL_STANDALONE");TextStyle$$module$input.SHORT=new TextStyle$$module$input("SHORT");
TextStyle$$module$input.SHORT_STANDALONE=new TextStyle$$module$input("SHORT_STANDALONE");TextStyle$$module$input.NARROW=new TextStyle$$module$input("NARROW");TextStyle$$module$input.NARROW_STANDALONE=new TextStyle$$module$input("NARROW_STANDALONE");
var CharLiteralPrinterParser$$module$input=function(){function e(b){_classCallCheck$$module$input(this,e);if(1<b.length)throw new IllegalArgumentException$$module$input('invalid literal, too long: "'.concat(b,'"'));this._literal=b}_createClass$$module$input(e,[{key:"print",value:function(b,d){d.append(this._literal);return!0}},{key:"parse",value:function(b,d,a){if(a===d.length)return~a;d=d.charAt(a);return!1===b.charEquals(this._literal,d)?~a:a+this._literal.length}},{key:"toString",value:function(){return"'"===
this._literal?"''":"'".concat(this._literal,"'")}}]);return e}(),CompositePrinterParser$$module$input=function(){function e(b,d){_classCallCheck$$module$input(this,e);this._printerParsers=b;this._optional=d}_createClass$$module$input(e,[{key:"withOptional",value:function(b){return b===this._optional?this:new e(this._printerParsers,b)}},{key:"print",value:function(b,d){var a=d.length();this._optional&&b.startOptional();try{for(var c=0;c<this._printerParsers.length;c++)if(!1===this._printerParsers[c].print(b,
d)){d.setLength(a);break}}finally{this._optional&&b.endOptional()}return!0}},{key:"parse",value:function(b,d,a){if(this._optional){b.startOptional();for(var c=a,f=0;f<this._printerParsers.length;f++)if(c=this._printerParsers[f].parse(b,d,c),0>c)return b.endOptional(!1),a;b.endOptional(!0);return c}for(c=0;c<this._printerParsers.length&&!(a=this._printerParsers[c].parse(b,d,a),0>a);c++);return a}},{key:"toString",value:function(){var b="";if(null!=this._printerParsers){b+=this._optional?"[":"(";for(var d=
0;d<this._printerParsers.length;d++)b+=this._printerParsers[d].toString();b+=this._optional?"]":")"}return b}}]);return e}(),FractionPrinterParser$$module$input=function(){function e(b,d,a,c){_classCallCheck$$module$input(this,e);requireNonNull$$module$input(b,"field");if(!1===b.range().isFixed())throw new IllegalArgumentException$$module$input("Field must have a fixed set of values: ".concat(b));if(0>d||9<d)throw new IllegalArgumentException$$module$input("Minimum width must be from 0 to 9 inclusive but was ".concat(d));
if(1>a||9<a)throw new IllegalArgumentException$$module$input("Maximum width must be from 1 to 9 inclusive but was ".concat(a));if(a<d)throw new IllegalArgumentException$$module$input("Maximum width must exceed or equal the minimum width but ".concat(a," \x3c ").concat(d));this.field=b;this.minWidth=d;this.maxWidth=a;this.decimalPoint=c}_createClass$$module$input(e,[{key:"print",value:function(b,d){var a=b.getValue(this.field);if(null===a)return!1;b=b.symbols();if(0===a){if(0<this.minWidth)for(this.decimalPoint&&
d.append(b.decimalSeparator()),a=0;a<this.minWidth;a++)d.append(b.zeroDigit())}else{a=this.convertToFraction(a,b.zeroDigit());a=a.substr(0,Math.min(Math.max(a.length,this.minWidth),this.maxWidth));if(0<1*a)for(;a.length>this.minWidth&&"0"===a[a.length-1];)a=a.substr(0,a.length-1);a=b.convertNumberToI18N(a);this.decimalPoint&&d.append(b.decimalSeparator());d.append(a)}return!0}},{key:"parse",value:function(b,d,a){var c=b.isStrict()?this.minWidth:0,f=b.isStrict()?this.maxWidth:9,e=d.length;if(a===e)return 0<
c?~a:a;if(this.decimalPoint){if(d[a]!==b.symbols().decimalSeparator())return 0<c?~a:a;a++}c=a+c;if(c>e)return~a;e=Math.min(a+f,e);var g=0;for(f=a;f<e;){var h=d.charAt(f++);h=b.symbols().convertToDigit(h);if(0>h){if(f<c)return~a;f--;break}g=10*g+h}d=this.convertFromFraction(g,Math.pow(10,f-a));return b.setParsedField(this.field,d,a,f)}},{key:"convertToFraction",value:function(b,d){var a=this.field.range();a.checkValidValue(b,this.field);var c=a.minimum();a=a.maximum()-c+1;b=MathUtil$$module$input.intDiv(1E9*
(b-c),a);for(b="".concat(b);9>b.length;)b=d+b;return b}},{key:"convertFromFraction",value:function(b,d){var a=this.field.range(),c=a.minimum();a=a.maximum()-c+1;return MathUtil$$module$input.intDiv(b*a,d)}},{key:"toString",value:function(){var b=this.decimalPoint?",DecimalPoint":"";return"Fraction(".concat(this.field,",").concat(this.minWidth,",").concat(this.maxWidth).concat(b,")")}}]);return e}(),MAX_WIDTH$$module$input=15,EXCEED_POINTS$$module$input=[0,10,100,1E3,1E4,1E5,1E6,1E7,1E8,1E9],NumberPrinterParser$$module$input=
function(){function e(b,d,a,c){var f=4<arguments.length&&void 0!==arguments[4]?arguments[4]:0;_classCallCheck$$module$input(this,e);this._field=b;this._minWidth=d;this._maxWidth=a;this._signStyle=c;this._subsequentWidth=f}_createClass$$module$input(e,[{key:"field",value:function(){return this._field}},{key:"minWidth",value:function(){return this._minWidth}},{key:"maxWidth",value:function(){return this._maxWidth}},{key:"signStyle",value:function(){return this._signStyle}},{key:"withFixedWidth",value:function(){return-1===
this._subsequentWidth?this:new e(this._field,this._minWidth,this._maxWidth,this._signStyle,-1)}},{key:"withSubsequentWidth",value:function(b){return new e(this._field,this._minWidth,this._maxWidth,this._signStyle,this._subsequentWidth+b)}},{key:"_isFixedWidth",value:function(){return-1===this._subsequentWidth||0<this._subsequentWidth&&this._minWidth===this._maxWidth&&this._signStyle===SignStyle$$module$input.NOT_NEGATIVE}},{key:"print",value:function(b,d){var a=b.getValue(this._field);if(null==a)return!1;
a=this._getValue(b,a);b=b.symbols();var c="".concat(Math.abs(a));if(c.length>this._maxWidth)throw new DateTimeException$$module$input("Field ".concat(this._field," cannot be printed as the value ").concat(a," exceeds the maximum print width of ").concat(this._maxWidth));c=b.convertNumberToI18N(c);if(0<=a)switch(this._signStyle){case SignStyle$$module$input.EXCEEDS_PAD:this._minWidth<MAX_WIDTH$$module$input&&a>=EXCEED_POINTS$$module$input[this._minWidth]&&d.append(b.positiveSign());break;case SignStyle$$module$input.ALWAYS:d.append(b.positiveSign())}else switch(this._signStyle){case SignStyle$$module$input.NORMAL:case SignStyle$$module$input.EXCEEDS_PAD:case SignStyle$$module$input.ALWAYS:d.append(b.negativeSign());
break;case SignStyle$$module$input.NOT_NEGATIVE:throw new DateTimeException$$module$input("Field ".concat(this._field," cannot be printed as the value ").concat(a," cannot be negative according to the SignStyle"));}for(a=0;a<this._minWidth-c.length;a++)d.append(b.zeroDigit());d.append(c);return!0}},{key:"parse",value:function(b,d,a){var c=d.length;if(a===c)return~a;assert$$module$input(0<=a&&a<c);var f=d.charAt(a),e=!1,g=!1;if(f===b.symbols().positiveSign()){if(!1===this._signStyle.parse(!0,b.isStrict(),
this._minWidth===this._maxWidth))return~a;g=!0;a++}else if(f===b.symbols().negativeSign()){if(!1===this._signStyle.parse(!1,b.isStrict(),this._minWidth===this._maxWidth))return~a;e=!0;a++}else if(this._signStyle===SignStyle$$module$input.ALWAYS&&b.isStrict())return~a;var h=b.isStrict()||this._isFixedWidth()?this._minWidth:1,k=a+h;if(k>c)return~a;var m=(b.isStrict()||this._isFixedWidth()?this._maxWidth:9)+Math.max(this._subsequentWidth,0);f=0;for(var n=a,q=0;2>q;q++){for(m=Math.min(n+m,c);n<m;){var p=
d.charAt(n++);p=b.symbols().convertToDigit(p);if(0>p){n--;if(n<k)return~a;break}if(n-a>MAX_WIDTH$$module$input)throw new ArithmeticException$$module$input("number text exceeds length");f=10*f+p}if(0<this._subsequentWidth&&0===q)m=Math.max(h,n-a-this._subsequentWidth),n=a,f=0;else break}if(e){if(0===f&&b.isStrict())return~(a-1);0!==f&&(f=-f)}else if(this._signStyle===SignStyle$$module$input.EXCEEDS_PAD&&b.isStrict())if(d=n-a,g){if(d<=this._minWidth)return~(a-1)}else if(d>this._minWidth)return~a;return this._setValue(b,
f,a,n)}},{key:"_getValue",value:function(b,d){return d}},{key:"_setValue",value:function(b,d,a,c){return b.setParsedField(this._field,d,a,c)}},{key:"toString",value:function(){return 1===this._minWidth&&this._maxWidth===MAX_WIDTH$$module$input&&this._signStyle===SignStyle$$module$input.NORMAL?"Value(".concat(this._field,")"):this._minWidth===this._maxWidth&&this._signStyle===SignStyle$$module$input.NOT_NEGATIVE?"Value(".concat(this._field,",").concat(this._minWidth,")"):"Value(".concat(this._field,
",").concat(this._minWidth,",").concat(this._maxWidth,",").concat(this._signStyle,")")}}]);return e}(),ReducedPrinterParser$$module$input=function(e){function b(a,c,f,e,g){_classCallCheck$$module$input(this,b);var l=d.call(this,a,c,f,SignStyle$$module$input.NOT_NEGATIVE);if(1>c||10<c)throw new IllegalArgumentException$$module$input("The width must be from 1 to 10 inclusive but was ".concat(c));if(1>f||10<f)throw new IllegalArgumentException$$module$input("The maxWidth must be from 1 to 10 inclusive but was ".concat(f));
if(f<c)throw new IllegalArgumentException$$module$input("The maxWidth must be greater than the width");if(null===g){if(!1===a.range().isValidValue(e))throw new IllegalArgumentException$$module$input("The base value must be within the range of the field");if(e+EXCEED_POINTS$$module$input[c]>MathUtil$$module$input.MAX_SAFE_INTEGER)throw new DateTimeException$$module$input("Unable to add printer-parser as the range exceeds the capacity of an int");}l._baseValue=e;l._baseDate=g;return l}_inherits$$module$input(b,
e);var d=_createSuper$$module$input(b);_createClass$$module$input(b,[{key:"_getValue",value:function(a,b){var c=Math.abs(b),d=this._baseValue;null!==this._baseDate&&(a.temporal(),d=IsoChronology$$module$input.INSTANCE.date(this._baseDate).get(this._field));return b>=d&&b<d+EXCEED_POINTS$$module$input[this._minWidth]?c%EXCEED_POINTS$$module$input[this._minWidth]:c%EXCEED_POINTS$$module$input[this._maxWidth]}},{key:"_setValue",value:function(a,b,d,e){var c=this._baseValue;null!=this._baseDate&&(c=a.getEffectiveChronology().date(this._baseDate).get(this._field));
if(e-d===this._minWidth&&0<=b){var f=EXCEED_POINTS$$module$input[this._minWidth],l=c-c%f;b=0<c?l+b:l-b;b<c&&(b+=f)}return a.setParsedField(this._field,b,d,e)}},{key:"withFixedWidth",value:function(){return-1===this._subsequentWidth?this:new b(this._field,this._minWidth,this._maxWidth,this._baseValue,this._baseDate,-1)}},{key:"withSubsequentWidth",value:function(a){return new b(this._field,this._minWidth,this._maxWidth,this._baseValue,this._baseDate,this._subsequentWidth+a)}},{key:"isFixedWidth",value:function(a){return!1===
a.isStrict()?!1:_get$$module$input(_getPrototypeOf$$module$input(b.prototype),"isFixedWidth",this).call(this,a)}},{key:"toString",value:function(){return"ReducedValue(".concat(this._field,",").concat(this._minWidth,",").concat(this._maxWidth,",").concat(null!=this._baseDate?this._baseDate:this._baseValue,")")}}]);return b}(NumberPrinterParser$$module$input),PATTERNS$$module$input="+HH +HHmm +HH:mm +HHMM +HH:MM +HHMMss +HH:MM:ss +HHMMSS +HH:MM:SS".split(" "),OffsetIdPrinterParser$$module$input=function(){function e(b,
d){_classCallCheck$$module$input(this,e);requireNonNull$$module$input(b,"noOffsetText");requireNonNull$$module$input(d,"pattern");this.noOffsetText=b;this.type=this._checkPattern(d)}_createClass$$module$input(e,[{key:"_checkPattern",value:function(b){for(var d=0;d<PATTERNS$$module$input.length;d++)if(PATTERNS$$module$input[d]===b)return d;throw new IllegalArgumentException$$module$input("Invalid zone offset pattern: ".concat(b));}},{key:"print",value:function(b,d){b=b.getValue(ChronoField$$module$input.OFFSET_SECONDS);
if(null==b)return!1;b=MathUtil$$module$input.safeToInt(b);if(0===b)d.append(this.noOffsetText);else{var a=Math.abs(MathUtil$$module$input.intMod(MathUtil$$module$input.intDiv(b,3600),100)),c=Math.abs(MathUtil$$module$input.intMod(MathUtil$$module$input.intDiv(b,60),60)),f=Math.abs(MathUtil$$module$input.intMod(b,60)),e=d.length(),g=a;d.append(0>b?"-":"+").appendChar("".concat(MathUtil$$module$input.intDiv(a,10),"0")).appendChar("".concat(MathUtil$$module$input.intMod(a,10),"0"));if(3<=this.type||
1<=this.type&&0<c)if(d.append(0===this.type%2?":":"").appendChar("".concat(MathUtil$$module$input.intDiv(c,10),"0")).appendChar("".concat(c%10,"0")),g+=c,7<=this.type||5<=this.type&&0<f)d.append(0===this.type%2?":":"").appendChar("".concat(MathUtil$$module$input.intDiv(f,10),"0")).appendChar("".concat(f%10,"0")),g+=f;0===g&&(d.setLength(e),d.append(this.noOffsetText))}return!0}},{key:"parse",value:function(b,d,a){var c=d.length,f=this.noOffsetText.length;if(0===f){if(a===c)return b.setParsedField(ChronoField$$module$input.OFFSET_SECONDS,
0,a,a)}else{if(a===c)return~a;if(b.subSequenceEquals(d,a,this.noOffsetText,0,f))return b.setParsedField(ChronoField$$module$input.OFFSET_SECONDS,0,a,a+f)}c=d[a];if("+"===c||"-"===c){var e="-"===c?-1:1;c=[0,0,0,0];c[0]=a+1;if(!1===(this._parseNumber(c,1,d,!0)||this._parseNumber(c,2,d,3<=this.type)||this._parseNumber(c,3,d,!1)))return d=MathUtil$$module$input.safeZero(e*(3600*c[1]+60*c[2]+c[3])),b.setParsedField(ChronoField$$module$input.OFFSET_SECONDS,d,a,c[0])}return 0===f?b.setParsedField(ChronoField$$module$input.OFFSET_SECONDS,
0,a,a+f):~a}},{key:"_parseNumber",value:function(b,d,a,c){if((this.type+3)/2<d)return!1;var f=b[0];if(0===this.type%2&&1<d){if(f+1>a.length||":"!==a[f])return c;f++}if(f+2>a.length)return c;var e=a[f++];a=a[f++];if("0">e||"9"<e||"0">a||"9"<a)return c;e=10*(e.charCodeAt(0)-48)+(a.charCodeAt(0)-48);if(0>e||59<e)return c;b[d]=e;b[0]=f;return!1}},{key:"toString",value:function(){var b=this.noOffsetText.replace("'","''");return"Offset(".concat(PATTERNS$$module$input[this.type],",'").concat(b,"')")}}]);
return e}();OffsetIdPrinterParser$$module$input.INSTANCE_ID=new OffsetIdPrinterParser$$module$input("Z","+HH:MM:ss");OffsetIdPrinterParser$$module$input.PATTERNS=PATTERNS$$module$input;
var PadPrinterParserDecorator$$module$input=function(){function e(b,d,a){_classCallCheck$$module$input(this,e);this._printerParser=b;this._padWidth=d;this._padChar=a}_createClass$$module$input(e,[{key:"print",value:function(b,d){var a=d.length();if(!1===this._printerParser.print(b,d))return!1;b=d.length()-a;if(b>this._padWidth)throw new DateTimeException$$module$input("Cannot print as output of ".concat(b," characters exceeds pad width of ").concat(this._padWidth));for(var c=0;c<this._padWidth-b;c++)d.insert(a,
this._padChar);return!0}},{key:"parse",value:function(b,d,a){var c=b.isStrict(),f=b.isCaseSensitive();assert$$module$input(!(a>d.length));assert$$module$input(0<=a);if(a===d.length)return~a;var e=a+this._padWidth;if(e>d.length){if(c)return~a;e=d.length}for(var g=a;g<e&&(f?d[g]===this._padChar:b.charEquals(d[g],this._padChar));)g++;d=d.substring(0,e);b=this._printerParser.parse(b,d,g);return b!==e&&c?~(a+g):b}},{key:"toString",value:function(){return"Pad(".concat(this._printerParser,",").concat(this._padWidth).concat(" "===
this._padChar?")":",'".concat(this._padChar,"')"))}}]);return e}(),SettingsParser$$module$input=function(e){function b(){_classCallCheck$$module$input(this,b);return d.apply(this,arguments)}_inherits$$module$input(b,e);var d=_createSuper$$module$input(b);_createClass$$module$input(b,[{key:"print",value:function(){return!0}},{key:"parse",value:function(a,c,d){switch(this){case b.SENSITIVE:a.setCaseSensitive(!0);break;case b.INSENSITIVE:a.setCaseSensitive(!1);break;case b.STRICT:a.setStrict(!0);break;
case b.LENIENT:a.setStrict(!1)}return d}},{key:"toString",value:function(){switch(this){case b.SENSITIVE:return"ParseCaseSensitive(true)";case b.INSENSITIVE:return"ParseCaseSensitive(false)";case b.STRICT:return"ParseStrict(true)";case b.LENIENT:return"ParseStrict(false)"}}}]);return b}(Enum$$module$input);SettingsParser$$module$input.SENSITIVE=new SettingsParser$$module$input("SENSITIVE");SettingsParser$$module$input.INSENSITIVE=new SettingsParser$$module$input("INSENSITIVE");
SettingsParser$$module$input.STRICT=new SettingsParser$$module$input("STRICT");SettingsParser$$module$input.LENIENT=new SettingsParser$$module$input("LENIENT");
var StringLiteralPrinterParser$$module$input=function(){function e(b){_classCallCheck$$module$input(this,e);this._literal=b}_createClass$$module$input(e,[{key:"print",value:function(b,d){d.append(this._literal);return!0}},{key:"parse",value:function(b,d,a){assert$$module$input(!(a>d.length||0>a));return!1===b.subSequenceEquals(d,a,this._literal,0,this._literal.length)?~a:a+this._literal.length}},{key:"toString",value:function(){var b=this._literal.replace("'","''");return"'".concat(b,"'")}}]);return e}(),
ZoneRulesProvider$$module$input=function(){function e(){_classCallCheck$$module$input(this,e)}_createClass$$module$input(e,null,[{key:"getRules",value:function(b){throw new DateTimeException$$module$input("unsupported ZoneId:".concat(b));}},{key:"getAvailableZoneIds",value:function(){return[]}}]);return e}(),ZoneRegion$$module$input=function(e){function b(a,c){_classCallCheck$$module$input(this,b);var f=d.call(this);f._id=a;f._rules=c;return f}_inherits$$module$input(b,e);var d=_createSuper$$module$input(b);
_createClass$$module$input(b,[{key:"id",value:function(){return this._id}},{key:"rules",value:function(){return this._rules}}],[{key:"ofId",value:function(a){var c=ZoneRulesProvider$$module$input.getRules(a);return new b(a,c)}}]);return b}(ZoneId$$module$input),ZoneIdPrinterParser$$module$input=function(){function e(b,d){_classCallCheck$$module$input(this,e);this.query=b;this.description=d}_createClass$$module$input(e,[{key:"print",value:function(b,d){b=b.getValueQuery(this.query);if(null==b)return!1;
d.append(b.id());return!0}},{key:"parse",value:function(b,d,a){var c=d.length;if(a>c||a===c)return~a;var f=d.charAt(a);if("+"===f||"-"===f){c=b.copy();d=OffsetIdPrinterParser$$module$input.INSTANCE_ID.parse(c,d,a);if(0>d)return d;a=c.getParsed(ChronoField$$module$input.OFFSET_SECONDS);a=ZoneOffset$$module$input.ofTotalSeconds(a);b.setParsedZone(a);return d}if(c>=a+2){var e=d.charAt(a+1);if(b.charEquals(f,"U")&&b.charEquals(e,"T"))return c>=a+3&&b.charEquals(d.charAt(a+2),"C")?this._parsePrefixedOffset(b,
d,a,a+3):this._parsePrefixedOffset(b,d,a,a+2);if(b.charEquals(f,"G")&&c>=a+3&&b.charEquals(e,"M")&&b.charEquals(d.charAt(a+2),"T"))return this._parsePrefixedOffset(b,d,a,a+3)}if("SYSTEM"===d.substr(a,6))return b.setParsedZone(ZoneId$$module$input.systemDefault()),a+6;if(b.charEquals(f,"Z"))return b.setParsedZone(ZoneOffset$$module$input.UTC),a+1;f=ZoneRulesProvider$$module$input.getAvailableZoneIds();zoneIdTree$$module$input.size!==f.length&&(zoneIdTree$$module$input=ZoneIdTree$$module$input.createTreeMap(f));
c-=a;f=zoneIdTree$$module$input.treeMap;e=null;for(var g=0;null!=f;){var h=d.substr(a,Math.min(f.length,c));f=f.get(h);null!=f&&f.isLeaf&&(e=h,g=f.length)}return null!=e?(b.setParsedZone(ZoneRegion$$module$input.ofId(e)),a+g):~a}},{key:"_parsePrefixedOffset",value:function(b,d,a,c){a=d.substring(a,c).toUpperCase();var f=b.copy();if(c<d.length&&b.charEquals(d.charAt(c),"Z"))return b.setParsedZone(ZoneId$$module$input.ofOffset(a,ZoneOffset$$module$input.UTC)),c;d=OffsetIdPrinterParser$$module$input.INSTANCE_ID.parse(f,
d,c);if(0>d)return b.setParsedZone(ZoneId$$module$input.ofOffset(a,ZoneOffset$$module$input.UTC)),c;c=f.getParsed(ChronoField$$module$input.OFFSET_SECONDS);c=ZoneOffset$$module$input.ofTotalSeconds(c);b.setParsedZone(ZoneId$$module$input.ofOffset(a,c));return d}},{key:"toString",value:function(){return this.description}}]);return e}(),ZoneIdTree$$module$input=function(){function e(b,d){_classCallCheck$$module$input(this,e);this.size=b;this.treeMap=d}_createClass$$module$input(e,null,[{key:"createTreeMap",
value:function(b){b=b.sort(function(a,b){return a.length-b.length});for(var d=new ZoneIdTreeMap$$module$input(b[0].length,!1),a=0;a<b.length;a++)d.add(b[a]);return new e(b.length,d)}}]);return e}(),ZoneIdTreeMap$$module$input=function(){function e(){var b=0<arguments.length&&void 0!==arguments[0]?arguments[0]:0,d=1<arguments.length&&void 0!==arguments[1]?arguments[1]:!1;_classCallCheck$$module$input(this,e);this.length=b;this.isLeaf=d;this._treeMap={}}_createClass$$module$input(e,[{key:"add",value:function(b){var d=
b.length;if(d===this.length)this._treeMap[b]=new e(d,!0);else if(d>this.length){var a=b.substr(0,this.length),c=this._treeMap[a];null==c&&(c=new e(d,!1),this._treeMap[a]=c);c.add(b)}}},{key:"get",value:function(b){return this._treeMap[b]}}]);return e}(),zoneIdTree$$module$input=new ZoneIdTree$$module$input([]),MAX_WIDTH$1$$module$input=15,DateTimeFormatterBuilder$$module$input=function(){function e(){_classCallCheck$$module$input(this,e);this._active=this;this._parent=null;this._printerParsers=[];
this._optional=!1;this._padNextWidth=0;this._padNextChar=null;this._valueParserIndex=-1}_createClass$$module$input(e,[{key:"parseCaseSensitive",value:function(){this._appendInternalPrinterParser(SettingsParser$$module$input.SENSITIVE);return this}},{key:"parseCaseInsensitive",value:function(){this._appendInternalPrinterParser(SettingsParser$$module$input.INSENSITIVE);return this}},{key:"parseStrict",value:function(){this._appendInternalPrinterParser(SettingsParser$$module$input.STRICT);return this}},
{key:"parseLenient",value:function(){this._appendInternalPrinterParser(SettingsParser$$module$input.LENIENT);return this}},{key:"appendValue",value:function(){return 1===arguments.length?this._appendValue1.apply(this,arguments):2===arguments.length?this._appendValue2.apply(this,arguments):this._appendValue4.apply(this,arguments)}},{key:"_appendValue1",value:function(b){requireNonNull$$module$input(b);this._appendValuePrinterParser(new NumberPrinterParser$$module$input(b,1,MAX_WIDTH$1$$module$input,
SignStyle$$module$input.NORMAL));return this}},{key:"_appendValue2",value:function(b,d){requireNonNull$$module$input(b);if(1>d||d>MAX_WIDTH$1$$module$input)throw new IllegalArgumentException$$module$input("The width must be from 1 to ".concat(MAX_WIDTH$1$$module$input," inclusive but was ").concat(d));b=new NumberPrinterParser$$module$input(b,d,d,SignStyle$$module$input.NOT_NEGATIVE);this._appendValuePrinterParser(b);return this}},{key:"_appendValue4",value:function(b,d,a,c){requireNonNull$$module$input(b);
requireNonNull$$module$input(c);if(d===a&&c===SignStyle$$module$input.NOT_NEGATIVE)return this._appendValue2(b,a);if(1>d||d>MAX_WIDTH$1$$module$input)throw new IllegalArgumentException$$module$input("The minimum width must be from 1 to ".concat(MAX_WIDTH$1$$module$input," inclusive but was ").concat(d));if(1>a||a>MAX_WIDTH$1$$module$input)throw new IllegalArgumentException$$module$input("The minimum width must be from 1 to ".concat(MAX_WIDTH$1$$module$input," inclusive but was ").concat(a));if(a<
d)throw new IllegalArgumentException$$module$input("The maximum width must exceed or equal the minimum width but ".concat(a," \x3c ").concat(d));b=new NumberPrinterParser$$module$input(b,d,a,c);this._appendValuePrinterParser(b);return this}},{key:"appendValueReduced",value:function(){return 4===arguments.length&&arguments[3]instanceof ChronoLocalDate$$module$input?this._appendValueReducedFieldWidthMaxWidthBaseDate.apply(this,arguments):this._appendValueReducedFieldWidthMaxWidthBaseValue.apply(this,
arguments)}},{key:"_appendValueReducedFieldWidthMaxWidthBaseValue",value:function(b,d,a,c){requireNonNull$$module$input(b,"field");b=new ReducedPrinterParser$$module$input(b,d,a,c,null);this._appendValuePrinterParser(b);return this}},{key:"_appendValueReducedFieldWidthMaxWidthBaseDate",value:function(b,d,a,c){requireNonNull$$module$input(b,"field");requireNonNull$$module$input(c,"baseDate");requireInstance$$module$input(c,ChronoLocalDate$$module$input,"baseDate");b=new ReducedPrinterParser$$module$input(b,
d,a,0,c);this._appendValuePrinterParser(b);return this}},{key:"_appendValuePrinterParser",value:function(b){assert$$module$input(null!=b);if(0<=this._active._valueParserIndex&&this._active._printerParsers[this._active._valueParserIndex]instanceof NumberPrinterParser$$module$input){var d=this._active._valueParserIndex,a=this._active._printerParsers[d];b.minWidth()===b.maxWidth()&&b.signStyle()===SignStyle$$module$input.NOT_NEGATIVE?(a=a.withSubsequentWidth(b.maxWidth()),this._appendInternal(b.withFixedWidth()),
this._active._valueParserIndex=d):(a=a.withFixedWidth(),this._active._valueParserIndex=this._appendInternal(b));this._active._printerParsers[d]=a}else this._active._valueParserIndex=this._appendInternal(b);return this}},{key:"appendFraction",value:function(b,d,a,c){this._appendInternal(new FractionPrinterParser$$module$input(b,d,a,c));return this}},{key:"appendInstant",value:function(){var b=0<arguments.length&&void 0!==arguments[0]?arguments[0]:-2;if(-2>b||9<b)throw new IllegalArgumentException$$module$input("Invalid fractional digits: ".concat(b));
this._appendInternal(new InstantPrinterParser$$module$input(b));return this}},{key:"appendOffsetId",value:function(){this._appendInternal(OffsetIdPrinterParser$$module$input.INSTANCE_ID);return this}},{key:"appendOffset",value:function(b,d){this._appendInternalPrinterParser(new OffsetIdPrinterParser$$module$input(d,b));return this}},{key:"appendZoneId",value:function(){this._appendInternal(new ZoneIdPrinterParser$$module$input(TemporalQueries$$module$input.zoneId(),"ZoneId()"));return this}},{key:"appendPattern",
value:function(b){requireNonNull$$module$input(b,"pattern");this._parsePattern(b);return this}},{key:"appendZoneText",value:function(){throw new IllegalArgumentException$$module$input("Pattern using (localized) text not implemented, use @js-joda/locale plugin!");}},{key:"appendText",value:function(){throw new IllegalArgumentException$$module$input("Pattern using (localized) text not implemented, use @js-joda/locale plugin!");}},{key:"appendLocalizedOffset",value:function(){throw new IllegalArgumentException$$module$input("Pattern using (localized) text not implemented, use @js-joda/locale plugin!");
}},{key:"appendWeekField",value:function(){throw new IllegalArgumentException$$module$input("Pattern using (localized) text not implemented, use @js-joda/locale plugin!");}},{key:"_parsePattern",value:function(b){for(var d={G:ChronoField$$module$input.ERA,y:ChronoField$$module$input.YEAR_OF_ERA,u:ChronoField$$module$input.YEAR,Q:IsoFields$$module$input.QUARTER_OF_YEAR,q:IsoFields$$module$input.QUARTER_OF_YEAR,M:ChronoField$$module$input.MONTH_OF_YEAR,L:ChronoField$$module$input.MONTH_OF_YEAR,D:ChronoField$$module$input.DAY_OF_YEAR,
d:ChronoField$$module$input.DAY_OF_MONTH,F:ChronoField$$module$input.ALIGNED_DAY_OF_WEEK_IN_MONTH,E:ChronoField$$module$input.DAY_OF_WEEK,c:ChronoField$$module$input.DAY_OF_WEEK,e:ChronoField$$module$input.DAY_OF_WEEK,a:ChronoField$$module$input.AMPM_OF_DAY,H:ChronoField$$module$input.HOUR_OF_DAY,k:ChronoField$$module$input.CLOCK_HOUR_OF_DAY,K:ChronoField$$module$input.HOUR_OF_AMPM,h:ChronoField$$module$input.CLOCK_HOUR_OF_AMPM,m:ChronoField$$module$input.MINUTE_OF_HOUR,s:ChronoField$$module$input.SECOND_OF_MINUTE,
S:ChronoField$$module$input.NANO_OF_SECOND,A:ChronoField$$module$input.MILLI_OF_DAY,n:ChronoField$$module$input.NANO_OF_SECOND,N:ChronoField$$module$input.NANO_OF_DAY},a=0;a<b.length;a++){var c=b.charAt(a);if("A"<=c&&"Z">=c||"a"<=c&&"z">=c){for(var f=a++;a<b.length&&b.charAt(a)===c;a++);f=a-f;if("p"===c){var e=0;if(a<b.length&&(c=b.charAt(a),"A"<=c&&"Z">=c||"a"<=c&&"z">=c)){e=f;for(f=a++;a<b.length&&b.charAt(a)===c;a++);f=a-f}if(0===e)throw new IllegalArgumentException$$module$input("Pad letter 'p' must be followed by valid pad pattern: ".concat(b));
this.padNext(e)}e=d[c];if(null!=e)this._parseField(c,f,e);else if("z"===c){if(4<f)throw new IllegalArgumentException$$module$input("Too many pattern letters: ".concat(c));4===f?this.appendZoneText(TextStyle$$module$input.FULL):this.appendZoneText(TextStyle$$module$input.SHORT)}else if("V"===c){if(2!==f)throw new IllegalArgumentException$$module$input("Pattern letter count must be 2: ".concat(c));this.appendZoneId()}else if("Z"===c)if(4>f)this.appendOffset("+HHMM","+0000");else if(4===f)this.appendLocalizedOffset(TextStyle$$module$input.FULL);
else if(5===f)this.appendOffset("+HH:MM:ss","Z");else throw new IllegalArgumentException$$module$input("Too many pattern letters: ".concat(c));else if("O"===c)if(1===f)this.appendLocalizedOffset(TextStyle$$module$input.SHORT);else if(4===f)this.appendLocalizedOffset(TextStyle$$module$input.FULL);else throw new IllegalArgumentException$$module$input("Pattern letter count must be 1 or 4: ".concat(c));else if("X"===c){if(5<f)throw new IllegalArgumentException$$module$input("Too many pattern letters: ".concat(c));
this.appendOffset(OffsetIdPrinterParser$$module$input.PATTERNS[f+(1===f?0:1)],"Z")}else if("x"===c){if(5<f)throw new IllegalArgumentException$$module$input("Too many pattern letters: ".concat(c));this.appendOffset(OffsetIdPrinterParser$$module$input.PATTERNS[f+(1===f?0:1)],1===f?"+00":0===f%2?"+0000":"+00:00")}else if("W"===c){if(1<f)throw new IllegalArgumentException$$module$input("Too many pattern letters: ".concat(c));this.appendWeekField("W",f)}else if("w"===c){if(2<f)throw new IllegalArgumentException$$module$input("Too many pattern letters: ".concat(c));
this.appendWeekField("w",f)}else if("Y"===c)this.appendWeekField("Y",f);else throw new IllegalArgumentException$$module$input("Unknown pattern letter: ".concat(c));a--}else if("'"===c){for(c=a++;a<b.length;a++)if("'"===b.charAt(a))if(a+1<b.length&&"'"===b.charAt(a+1))a++;else break;if(a>=b.length)throw new IllegalArgumentException$$module$input("Pattern ends with an incomplete string literal: ".concat(b));c=b.substring(c+1,a);0===c.length?this.appendLiteral("'"):this.appendLiteral(c.replace("''",
"'"))}else if("["===c)this.optionalStart();else if("]"===c){if(null===this._active._parent)throw new IllegalArgumentException$$module$input("Pattern invalid as it contains ] without previous [");this.optionalEnd()}else{if("{"===c||"}"===c||"#"===c)throw new IllegalArgumentException$$module$input("Pattern includes reserved character: '".concat(c,"'"));this.appendLiteral(c)}}}},{key:"_parseField",value:function(b,d,a){switch(b){case "u":case "y":2===d?this.appendValueReduced(a,2,2,ReducedPrinterParser$$module$input.BASE_DATE):
4>d?this.appendValue(a,d,MAX_WIDTH$1$$module$input,SignStyle$$module$input.NORMAL):this.appendValue(a,d,MAX_WIDTH$1$$module$input,SignStyle$$module$input.EXCEEDS_PAD);break;case "M":case "Q":switch(d){case 1:this.appendValue(a);break;case 2:this.appendValue(a,2);break;case 3:this.appendText(a,TextStyle$$module$input.SHORT);break;case 4:this.appendText(a,TextStyle$$module$input.FULL);break;case 5:this.appendText(a,TextStyle$$module$input.NARROW);break;default:throw new IllegalArgumentException$$module$input("Too many pattern letters: ".concat(b));
}break;case "L":case "q":switch(d){case 1:this.appendValue(a);break;case 2:this.appendValue(a,2);break;case 3:this.appendText(a,TextStyle$$module$input.SHORT_STANDALONE);break;case 4:this.appendText(a,TextStyle$$module$input.FULL_STANDALONE);break;case 5:this.appendText(a,TextStyle$$module$input.NARROW_STANDALONE);break;default:throw new IllegalArgumentException$$module$input("Too many pattern letters: ".concat(b));}break;case "e":switch(d){case 1:case 2:this.appendWeekField("e",d);break;case 3:this.appendText(a,
TextStyle$$module$input.SHORT);break;case 4:this.appendText(a,TextStyle$$module$input.FULL);break;case 5:this.appendText(a,TextStyle$$module$input.NARROW);break;default:throw new IllegalArgumentException$$module$input("Too many pattern letters: ".concat(b));}break;case "c":switch(d){case 1:this.appendWeekField("c",d);break;case 2:throw new IllegalArgumentException$$module$input("Invalid number of pattern letters: ".concat(b));case 3:this.appendText(a,TextStyle$$module$input.SHORT_STANDALONE);break;
case 4:this.appendText(a,TextStyle$$module$input.FULL_STANDALONE);break;case 5:this.appendText(a,TextStyle$$module$input.NARROW_STANDALONE);break;default:throw new IllegalArgumentException$$module$input("Too many pattern letters: ".concat(b));}break;case "a":if(1===d)this.appendText(a,TextStyle$$module$input.SHORT);else throw new IllegalArgumentException$$module$input("Too many pattern letters: ".concat(b));break;case "E":case "G":switch(d){case 1:case 2:case 3:this.appendText(a,TextStyle$$module$input.SHORT);
break;case 4:this.appendText(a,TextStyle$$module$input.FULL);break;case 5:this.appendText(a,TextStyle$$module$input.NARROW);break;default:throw new IllegalArgumentException$$module$input("Too many pattern letters: ".concat(b));}break;case "S":this.appendFraction(ChronoField$$module$input.NANO_OF_SECOND,d,d,!1);break;case "F":if(1===d)this.appendValue(a);else throw new IllegalArgumentException$$module$input("Too many pattern letters: ".concat(b));break;case "d":case "h":case "H":case "k":case "K":case "m":case "s":if(1===
d)this.appendValue(a);else if(2===d)this.appendValue(a,d);else throw new IllegalArgumentException$$module$input("Too many pattern letters: ".concat(b));break;case "D":if(1===d)this.appendValue(a);else if(3>=d)this.appendValue(a,d);else throw new IllegalArgumentException$$module$input("Too many pattern letters: ".concat(b));break;default:1===d?this.appendValue(a):this.appendValue(a,d)}}},{key:"padNext",value:function(){return 1===arguments.length?this._padNext1.apply(this,arguments):this._padNext2.apply(this,
arguments)}},{key:"_padNext1",value:function(b){return this._padNext2(b," ")}},{key:"_padNext2",value:function(b,d){if(1>b)throw new IllegalArgumentException$$module$input("The pad width must be at least one but was ".concat(b));this._active._padNextWidth=b;this._active._padNextChar=d;this._active._valueParserIndex=-1;return this}},{key:"optionalStart",value:function(){this._active._valueParserIndex=-1;this._active=e._of(this._active,!0);return this}},{key:"optionalEnd",value:function(){if(null==
this._active._parent)throw new IllegalStateException$$module$input("Cannot call optionalEnd() as there was no previous call to optionalStart()");if(0<this._active._printerParsers.length){var b=new CompositePrinterParser$$module$input(this._active._printerParsers,this._active._optional);this._active=this._active._parent;this._appendInternal(b)}else this._active=this._active._parent;return this}},{key:"_appendInternal",value:function(b){assert$$module$input(null!=b);0<this._active._padNextWidth&&(null!=
b&&(b=new PadPrinterParserDecorator$$module$input(b,this._active._padNextWidth,this._active._padNextChar)),this._active._padNextWidth=0,this._active._padNextChar=0);this._active._printerParsers.push(b);this._active._valueParserIndex=-1;return this._active._printerParsers.length-1}},{key:"appendLiteral",value:function(b){assert$$module$input(null!=b);0<b.length&&(1===b.length?this._appendInternalPrinterParser(new CharLiteralPrinterParser$$module$input(b.charAt(0))):this._appendInternalPrinterParser(new StringLiteralPrinterParser$$module$input(b)));
return this}},{key:"_appendInternalPrinterParser",value:function(b){assert$$module$input(null!=b);0<this._active._padNextWidth&&(null!=b&&(b=new PadPrinterParserDecorator$$module$input(b,this._active._padNextWidth,this._active._padNextChar)),this._active._padNextWidth=0,this._active._padNextChar=0);this._active._printerParsers.push(b);this._active._valueParserIndex=-1;return this._active._printerParsers.length-1}},{key:"append",value:function(b){requireNonNull$$module$input(b,"formatter");this._appendInternal(b._toPrinterParser(!1));
return this}},{key:"toFormatter",value:function(){for(var b=0<arguments.length&&void 0!==arguments[0]?arguments[0]:ResolverStyle$$module$input.SMART;null!=this._active._parent;)this.optionalEnd();var d=new CompositePrinterParser$$module$input(this._printerParsers,!1);return new DateTimeFormatter$$module$input(d,null,DecimalStyle$$module$input.STANDARD,b,null,null,null)}}],[{key:"_of",value:function(b,d){requireNonNull$$module$input(b,"parent");requireNonNull$$module$input(d,"optional");var a=new e;
a._parent=b;a._optional=d;return a}}]);return e}(),SECONDS_PER_10000_YEARS$$module$input=31556952E4,SECONDS_0000_TO_1970$$module$input=62167219200,InstantPrinterParser$$module$input=function(){function e(b){_classCallCheck$$module$input(this,e);this.fractionalDigits=b}_createClass$$module$input(e,[{key:"print",value:function(b,d){var a=b.getValue(ChronoField$$module$input.INSTANT_SECONDS),c=0;b.temporal().isSupported(ChronoField$$module$input.NANO_OF_SECOND)&&(c=b.temporal().getLong(ChronoField$$module$input.NANO_OF_SECOND));
if(null==a)return!1;b=ChronoField$$module$input.NANO_OF_SECOND.checkValidIntValue(c);if(a>=-SECONDS_0000_TO_1970$$module$input)c=a-SECONDS_PER_10000_YEARS$$module$input+SECONDS_0000_TO_1970$$module$input,a=MathUtil$$module$input.floorDiv(c,SECONDS_PER_10000_YEARS$$module$input)+1,c=MathUtil$$module$input.floorMod(c,SECONDS_PER_10000_YEARS$$module$input),c=LocalDateTime$$module$input.ofEpochSecond(c-SECONDS_0000_TO_1970$$module$input,0,ZoneOffset$$module$input.UTC),0<a&&d.append("+").append(a),d.append(c),
0===c.second()&&d.append(":00");else{c=a+SECONDS_0000_TO_1970$$module$input;a=MathUtil$$module$input.intDiv(c,SECONDS_PER_10000_YEARS$$module$input);c=MathUtil$$module$input.intMod(c,SECONDS_PER_10000_YEARS$$module$input);var f=LocalDateTime$$module$input.ofEpochSecond(c-SECONDS_0000_TO_1970$$module$input,0,ZoneOffset$$module$input.UTC),e=d.length();d.append(f);0===f.second()&&d.append(":00");0>a&&(-1E4===f.year()?d.replace(e,e+2,"".concat(a-1)):0===c?d.insert(e,a):d.insert(e+1,Math.abs(a)))}if(-2===
this.fractionalDigits)0!==b&&(d.append("."),0===MathUtil$$module$input.intMod(b,1E6)?d.append("".concat(MathUtil$$module$input.intDiv(b,1E6)+1E3).substring(1)):0===MathUtil$$module$input.intMod(b,1E3)?d.append("".concat(MathUtil$$module$input.intDiv(b,1E3)+1E6).substring(1)):d.append("".concat(b+1E9).substring(1)));else if(0<this.fractionalDigits||-1===this.fractionalDigits&&0<b)for(d.append("."),a=1E8,c=0;-1===this.fractionalDigits&&0<b||c<this.fractionalDigits;c++)f=MathUtil$$module$input.intDiv(b,
a),d.append(f),b-=f*a,a=MathUtil$$module$input.intDiv(a,10);d.append("Z");return!0}},{key:"parse",value:function(b,d,a){var c=b.copy(),f=0>this.fractionalDigits?0:this.fractionalDigits,e=0>this.fractionalDigits?9:this.fractionalDigits;d=(new DateTimeFormatterBuilder$$module$input).append(DateTimeFormatter$$module$input.ISO_LOCAL_DATE).appendLiteral("T").appendValue(ChronoField$$module$input.HOUR_OF_DAY,2).appendLiteral(":").appendValue(ChronoField$$module$input.MINUTE_OF_HOUR,2).appendLiteral(":").appendValue(ChronoField$$module$input.SECOND_OF_MINUTE,
2).appendFraction(ChronoField$$module$input.NANO_OF_SECOND,f,e,!0).appendLiteral("Z").toFormatter()._toPrinterParser(!1).parse(c,d,a);if(0>d)return d;f=c.getParsed(ChronoField$$module$input.YEAR);e=c.getParsed(ChronoField$$module$input.MONTH_OF_YEAR);var g=c.getParsed(ChronoField$$module$input.DAY_OF_MONTH),h=c.getParsed(ChronoField$$module$input.HOUR_OF_DAY),k=c.getParsed(ChronoField$$module$input.MINUTE_OF_HOUR),m=c.getParsed(ChronoField$$module$input.SECOND_OF_MINUTE),n=c.getParsed(ChronoField$$module$input.NANO_OF_SECOND);
c=null!=m?m:0;m=null!=n?n:0;n=MathUtil$$module$input.intMod(f,1E4);var q=0;24===h&&0===k&&0===c&&0===m?(h=0,q=1):23===h&&59===k&&60===c&&(b.setParsedLeapSecond(),c=59);try{var p=LocalDateTime$$module$input.of(n,e,g,h,k,c,0).plusDays(q).toEpochSecond(ZoneOffset$$module$input.UTC);p+=MathUtil$$module$input.safeMultiply(MathUtil$$module$input.intDiv(f,1E4),SECONDS_PER_10000_YEARS$$module$input)}catch(r){return~a}p=b.setParsedField(ChronoField$$module$input.INSTANT_SECONDS,p,a,d);return b.setParsedField(ChronoField$$module$input.NANO_OF_SECOND,
m,a,p)}},{key:"toString",value:function(){return"Instant()"}}]);return e}();
function _init$9$$module$input(){ReducedPrinterParser$$module$input.BASE_DATE=LocalDate$$module$input.of(2E3,1,1);DateTimeFormatterBuilder$$module$input.CompositePrinterParser=CompositePrinterParser$$module$input;DateTimeFormatterBuilder$$module$input.PadPrinterParserDecorator=PadPrinterParserDecorator$$module$input;DateTimeFormatterBuilder$$module$input.SettingsParser=SettingsParser$$module$input;DateTimeFormatterBuilder$$module$input.StringLiteralPrinterParser=StringLiteralPrinterParser$$module$input;
DateTimeFormatterBuilder$$module$input.CharLiteralPrinterParser=CharLiteralPrinterParser$$module$input;DateTimeFormatterBuilder$$module$input.NumberPrinterParser=NumberPrinterParser$$module$input;DateTimeFormatterBuilder$$module$input.ReducedPrinterParser=ReducedPrinterParser$$module$input;DateTimeFormatterBuilder$$module$input.FractionPrinterParser=FractionPrinterParser$$module$input;DateTimeFormatterBuilder$$module$input.OffsetIdPrinterParser=OffsetIdPrinterParser$$module$input;DateTimeFormatterBuilder$$module$input.ZoneIdPrinterParser=
ZoneIdPrinterParser$$module$input}
var StringBuilder$$module$input=function(){function e(){_classCallCheck$$module$input(this,e);this._str=""}_createClass$$module$input(e,[{key:"append",value:function(b){this._str+=b;return this}},{key:"appendChar",value:function(b){this._str+=b[0];return this}},{key:"insert",value:function(b,d){this._str=this._str.slice(0,b)+d+this._str.slice(b);return this}},{key:"replace",value:function(b,d,a){this._str=this._str.slice(0,b)+a+this._str.slice(d);return this}},{key:"length",value:function(){return this._str.length}},
{key:"setLength",value:function(b){this._str=this._str.slice(0,b);return this}},{key:"toString",value:function(){return this._str}}]);return e}(),DateTimeFormatter$$module$input=function(){function e(b,d,a,c,f){var l=5<arguments.length&&void 0!==arguments[5]?arguments[5]:IsoChronology$$module$input.INSTANCE,g=6<arguments.length?arguments[6]:void 0;_classCallCheck$$module$input(this,e);assert$$module$input(null!=b);assert$$module$input(null!=a);assert$$module$input(null!=c);this._printerParser=b;this._locale=
d;this._decimalStyle=a;this._resolverStyle=c;this._resolverFields=f;this._chrono=l;this._zone=g}_createClass$$module$input(e,[{key:"locale",value:function(){return this._locale}},{key:"decimalStyle",value:function(){return this._decimalStyle}},{key:"chronology",value:function(){return this._chrono}},{key:"withChronology",value:function(b){return null!=this._chrono&&this._chrono.equals(b)?this:new e(this._printerParser,this._locale,this._decimalStyle,this._resolverStyle,this._resolverFields,b,this._zone)}},
{key:"withLocale",value:function(){return this}},{key:"withResolverStyle",value:function(b){requireNonNull$$module$input(b,"resolverStyle");return b.equals(this._resolverStyle)?this:new e(this._printerParser,this._locale,this._decimalStyle,b,this._resolverFields,this._chrono,this._zone)}},{key:"format",value:function(b){var d=new StringBuilder$$module$input(32);this._formatTo(b,d);return d.toString()}},{key:"_formatTo",value:function(b,d){requireNonNull$$module$input(b,"temporal");requireNonNull$$module$input(d,
"appendable");b=new DateTimePrintContext$$module$input(b,this);this._printerParser.print(b,d)}},{key:"parse",value:function(b,d){return 1===arguments.length?this.parse1(b):this.parse2(b,d)}},{key:"parse1",value:function(b){requireNonNull$$module$input(b,"text");try{return this._parseToBuilder(b,null).resolve(this._resolverStyle,this._resolverFields)}catch(d){if(d instanceof DateTimeParseException$$module$input)throw d;throw this._createError(b,d);}}},{key:"parse2",value:function(b,d){requireNonNull$$module$input(b,
"text");requireNonNull$$module$input(d,"type");try{return this._parseToBuilder(b,null).resolve(this._resolverStyle,this._resolverFields).build(d)}catch(a){if(a instanceof DateTimeParseException$$module$input)throw a;throw this._createError(b,a);}}},{key:"_createError",value:function(b,d){var a=64<b.length?"".concat(b.substring(0,64),"..."):b;return new DateTimeParseException$$module$input("Text '".concat(a,"' could not be parsed: ").concat(d.message),b,0,d)}},{key:"_parseToBuilder",value:function(b,
d){var a=null!=d?d:new ParsePosition$$module$input(0),c=this._parseUnresolved0(b,a);if(null==c||0<=a.getErrorIndex()||null==d&&a.getIndex()<b.length){d=64<b.length?"".concat(b.substr(0,64).toString(),"..."):b;if(0<=a.getErrorIndex())throw new DateTimeParseException$$module$input("Text '".concat(d,"' could not be parsed at index ").concat(a.getErrorIndex()),b,a.getErrorIndex());throw new DateTimeParseException$$module$input("Text '".concat(d,"' could not be parsed, unparsed text found at index ").concat(a.getIndex()),
b,a.getIndex());}return c.toBuilder()}},{key:"parseUnresolved",value:function(b,d){return this._parseUnresolved0(b,d)}},{key:"_parseUnresolved0",value:function(b,d){assert$$module$input(null!=b,"text",NullPointerException$$module$input);assert$$module$input(null!=d,"position",NullPointerException$$module$input);var a=new DateTimeParseContext$$module$input(this),c=d.getIndex();c=this._printerParser.parse(a,b,c);if(0>c)return d.setErrorIndex(~c),null;d.setIndex(c);return a.toParsed()}},{key:"_toPrinterParser",
value:function(b){return this._printerParser.withOptional(b)}},{key:"toString",value:function(){var b=this._printerParser.toString();return 0===b.indexOf("[")?b:b.substring(1,b.length-1)}}],[{key:"parsedExcessDays",value:function(){return e.PARSED_EXCESS_DAYS}},{key:"parsedLeapSecond",value:function(){return e.PARSED_LEAP_SECOND}},{key:"ofPattern",value:function(b){return(new DateTimeFormatterBuilder$$module$input).appendPattern(b).toFormatter()}}]);return e}();
function _init$a$$module$input(){DateTimeFormatter$$module$input.ISO_LOCAL_DATE=(new DateTimeFormatterBuilder$$module$input).appendValue(ChronoField$$module$input.YEAR,4,10,SignStyle$$module$input.EXCEEDS_PAD).appendLiteral("-").appendValue(ChronoField$$module$input.MONTH_OF_YEAR,2).appendLiteral("-").appendValue(ChronoField$$module$input.DAY_OF_MONTH,2).toFormatter(ResolverStyle$$module$input.STRICT).withChronology(IsoChronology$$module$input.INSTANCE);DateTimeFormatter$$module$input.ISO_LOCAL_TIME=
(new DateTimeFormatterBuilder$$module$input).appendValue(ChronoField$$module$input.HOUR_OF_DAY,2).appendLiteral(":").appendValue(ChronoField$$module$input.MINUTE_OF_HOUR,2).optionalStart().appendLiteral(":").appendValue(ChronoField$$module$input.SECOND_OF_MINUTE,2).optionalStart().appendFraction(ChronoField$$module$input.NANO_OF_SECOND,0,9,!0).toFormatter(ResolverStyle$$module$input.STRICT);DateTimeFormatter$$module$input.ISO_LOCAL_DATE_TIME=(new DateTimeFormatterBuilder$$module$input).parseCaseInsensitive().append(DateTimeFormatter$$module$input.ISO_LOCAL_DATE).appendLiteral("T").append(DateTimeFormatter$$module$input.ISO_LOCAL_TIME).toFormatter(ResolverStyle$$module$input.STRICT).withChronology(IsoChronology$$module$input.INSTANCE);
DateTimeFormatter$$module$input.ISO_INSTANT=(new DateTimeFormatterBuilder$$module$input).parseCaseInsensitive().appendInstant().toFormatter(ResolverStyle$$module$input.STRICT);DateTimeFormatter$$module$input.ISO_OFFSET_DATE_TIME=(new DateTimeFormatterBuilder$$module$input).parseCaseInsensitive().append(DateTimeFormatter$$module$input.ISO_LOCAL_DATE_TIME).appendOffsetId().toFormatter(ResolverStyle$$module$input.STRICT).withChronology(IsoChronology$$module$input.INSTANCE);DateTimeFormatter$$module$input.ISO_ZONED_DATE_TIME=
(new DateTimeFormatterBuilder$$module$input).append(DateTimeFormatter$$module$input.ISO_OFFSET_DATE_TIME).optionalStart().appendLiteral("[").parseCaseSensitive().appendZoneId().appendLiteral("]").toFormatter(ResolverStyle$$module$input.STRICT).withChronology(IsoChronology$$module$input.INSTANCE);DateTimeFormatter$$module$input.BASIC_ISO_DATE=(new DateTimeFormatterBuilder$$module$input).appendValue(ChronoField$$module$input.YEAR,4,10,SignStyle$$module$input.EXCEEDS_PAD).appendValue(ChronoField$$module$input.MONTH_OF_YEAR,
2).appendValue(ChronoField$$module$input.DAY_OF_MONTH,2).toFormatter(ResolverStyle$$module$input.STRICT).withChronology(IsoChronology$$module$input.INSTANCE);DateTimeFormatter$$module$input.ISO_OFFSET_DATE=(new DateTimeFormatterBuilder$$module$input).parseCaseInsensitive().append(DateTimeFormatter$$module$input.ISO_LOCAL_DATE).appendOffsetId().toFormatter(ResolverStyle$$module$input.STRICT).withChronology(IsoChronology$$module$input.INSTANCE);DateTimeFormatter$$module$input.ISO_OFFSET_TIME=(new DateTimeFormatterBuilder$$module$input).parseCaseInsensitive().append(DateTimeFormatter$$module$input.ISO_LOCAL_TIME).appendOffsetId().toFormatter(ResolverStyle$$module$input.STRICT).withChronology(IsoChronology$$module$input.INSTANCE);
DateTimeFormatter$$module$input.ISO_ORDINAL_DATE=(new DateTimeFormatterBuilder$$module$input).appendValue(ChronoField$$module$input.YEAR,4,10,SignStyle$$module$input.EXCEEDS_PAD).appendLiteral("-").appendValue(ChronoField$$module$input.DAY_OF_YEAR).toFormatter(ResolverStyle$$module$input.STRICT);DateTimeFormatter$$module$input.ISO_WEEK_DATE=(new DateTimeFormatterBuilder$$module$input).appendValue(ChronoField$$module$input.YEAR,4,10,SignStyle$$module$input.EXCEEDS_PAD).appendLiteral("-W").appendValue(ChronoField$$module$input.ALIGNED_WEEK_OF_YEAR).appendLiteral("-").appendValue(ChronoField$$module$input.DAY_OF_WEEK).toFormatter(ResolverStyle$$module$input.STRICT);
DateTimeFormatter$$module$input.ISO_DATE=(new DateTimeFormatterBuilder$$module$input).parseCaseInsensitive().append(DateTimeFormatter$$module$input.ISO_LOCAL_DATE).optionalStart().appendOffsetId().optionalEnd().toFormatter(ResolverStyle$$module$input.STRICT).withChronology(IsoChronology$$module$input.INSTANCE);DateTimeFormatter$$module$input.ISO_TIME=(new DateTimeFormatterBuilder$$module$input).parseCaseInsensitive().append(DateTimeFormatter$$module$input.ISO_LOCAL_TIME).optionalStart().appendOffsetId().optionalEnd().toFormatter(ResolverStyle$$module$input.STRICT);
DateTimeFormatter$$module$input.ISO_DATE_TIME=(new DateTimeFormatterBuilder$$module$input).append(DateTimeFormatter$$module$input.ISO_LOCAL_DATE_TIME).optionalStart().appendOffsetId().optionalEnd().toFormatter(ResolverStyle$$module$input.STRICT).withChronology(IsoChronology$$module$input.INSTANCE);DateTimeFormatter$$module$input.PARSED_EXCESS_DAYS=createTemporalQuery$$module$input("PARSED_EXCESS_DAYS",function(e){return e instanceof DateTimeBuilder$$module$input?e.excessDays:Period$$module$input.ZERO});
DateTimeFormatter$$module$input.PARSED_LEAP_SECOND=createTemporalQuery$$module$input("PARSED_LEAP_SECOND",function(e){return e instanceof DateTimeBuilder$$module$input?e.leapSecond:!1})}
var MonthDay$$module$input=function(e){function b(a,c){_classCallCheck$$module$input(this,b);var f=d.call(this);f._month=MathUtil$$module$input.safeToInt(a);f._day=MathUtil$$module$input.safeToInt(c);return f}_inherits$$module$input(b,e);var d=_createSuper$$module$input(b);_createClass$$module$input(b,[{key:"monthValue",value:function(){return this._month}},{key:"month",value:function(){return Month$$module$input.of(this._month)}},{key:"dayOfMonth",value:function(){return this._day}},{key:"isSupported",
value:function(a){return a instanceof ChronoField$$module$input?a===ChronoField$$module$input.MONTH_OF_YEAR||a===ChronoField$$module$input.DAY_OF_MONTH:null!=a&&a.isSupportedBy(this)}},{key:"range",value:function(a){return a===ChronoField$$module$input.MONTH_OF_YEAR?a.range():a===ChronoField$$module$input.DAY_OF_MONTH?ValueRange$$module$input.of(1,this.month().minLength(),this.month().maxLength()):_get$$module$input(_getPrototypeOf$$module$input(b.prototype),"range",this).call(this,a)}},{key:"get",
value:function(a){return this.range(a).checkValidIntValue(this.getLong(a),a)}},{key:"getLong",value:function(a){requireNonNull$$module$input(a,"field");if(a instanceof ChronoField$$module$input){switch(a){case ChronoField$$module$input.DAY_OF_MONTH:return this._day;case ChronoField$$module$input.MONTH_OF_YEAR:return this._month}throw new UnsupportedTemporalTypeException$$module$input("Unsupported field: ".concat(a));}return a.getFrom(this)}},{key:"isValidYear",value:function(a){return!1===(29===this._day&&
2===this._month&&!1===Year$$module$input.isLeap(a))}},{key:"withMonth",value:function(a){return this.with(Month$$module$input.of(a))}},{key:"with",value:function(a){requireNonNull$$module$input(a,"month");if(a.value()===this._month)return this;var c=Math.min(this._day,a.maxLength());return new b(a.value(),c)}},{key:"withDayOfMonth",value:function(a){return a===this._day?this:b.of(this._month,a)}},{key:"query",value:function(a){requireNonNull$$module$input(a,"query");requireInstance$$module$input(a,
TemporalQuery$$module$input,"query");return a===TemporalQueries$$module$input.chronology()?IsoChronology$$module$input.INSTANCE:_get$$module$input(_getPrototypeOf$$module$input(b.prototype),"query",this).call(this,a)}},{key:"adjustInto",value:function(a){requireNonNull$$module$input(a,"temporal");a=a.with(ChronoField$$module$input.MONTH_OF_YEAR,this._month);return a.with(ChronoField$$module$input.DAY_OF_MONTH,Math.min(a.range(ChronoField$$module$input.DAY_OF_MONTH).maximum(),this._day))}},{key:"atYear",
value:function(a){return LocalDate$$module$input.of(a,this._month,this.isValidYear(a)?this._day:28)}},{key:"compareTo",value:function(a){requireNonNull$$module$input(a,"other");requireInstance$$module$input(a,b,"other");var c=this._month-a.monthValue();0===c&&(c=this._day-a.dayOfMonth());return c}},{key:"isAfter",value:function(a){requireNonNull$$module$input(a,"other");requireInstance$$module$input(a,b,"other");return 0<this.compareTo(a)}},{key:"isBefore",value:function(a){requireNonNull$$module$input(a,
"other");requireInstance$$module$input(a,b,"other");return 0>this.compareTo(a)}},{key:"equals",value:function(a){return this===a?!0:a instanceof b?this.monthValue()===a.monthValue()&&this.dayOfMonth()===a.dayOfMonth():!1}},{key:"toString",value:function(){return"--".concat(10>this._month?"0":"").concat(this._month).concat(10>this._day?"-0":"-").concat(this._day)}},{key:"toJSON",value:function(){return this.toString()}},{key:"format",value:function(a){requireNonNull$$module$input(a,"formatter");requireInstance$$module$input(a,
DateTimeFormatter$$module$input,"formatter");return a.format(this)}}],[{key:"now",value:function(a){return 0===arguments.length?b.now0():1===arguments.length&&a instanceof ZoneId$$module$input?b.nowZoneId(a):b.nowClock(a)}},{key:"now0",value:function(){return this.nowClock(Clock$$module$input.systemDefaultZone())}},{key:"nowZoneId",value:function(a){requireNonNull$$module$input(a,"zone");return this.nowClock(Clock$$module$input.system(a))}},{key:"nowClock",value:function(a){requireNonNull$$module$input(a,
"clock");a=LocalDate$$module$input.now(a);return b.of(a.month(),a.dayOfMonth())}},{key:"of",value:function(a,c){return 2===arguments.length&&a instanceof Month$$module$input?b.ofMonthNumber(a,c):b.ofNumberNumber(a,c)}},{key:"ofMonthNumber",value:function(a,c){requireNonNull$$module$input(a,"month");ChronoField$$module$input.DAY_OF_MONTH.checkValidValue(c);if(c>a.maxLength())throw new DateTimeException$$module$input("Illegal value for DayOfMonth field, value ".concat(c," is not valid for month ").concat(a.toString()));
return new b(a.value(),c)}},{key:"ofNumberNumber",value:function(a,c){requireNonNull$$module$input(a,"month");requireNonNull$$module$input(c,"dayOfMonth");return b.of(Month$$module$input.of(a),c)}},{key:"from",value:function(a){requireNonNull$$module$input(a,"temporal");requireInstance$$module$input(a,TemporalAccessor$$module$input,"temporal");if(a instanceof b)return a;try{return b.of(a.get(ChronoField$$module$input.MONTH_OF_YEAR),a.get(ChronoField$$module$input.DAY_OF_MONTH))}catch(c){throw new DateTimeException$$module$input("Unable to obtain MonthDay from TemporalAccessor: ".concat(a,
", type ").concat(a&&null!=a.constructor?a.constructor.name:""));}}},{key:"parse",value:function(a,c){return 1===arguments.length?b.parseString(a):b.parseStringFormatter(a,c)}},{key:"parseString",value:function(a){return b.parseStringFormatter(a,PARSER$$module$input)}},{key:"parseStringFormatter",value:function(a,c){requireNonNull$$module$input(a,"text");requireNonNull$$module$input(c,"formatter");requireInstance$$module$input(c,DateTimeFormatter$$module$input,"formatter");return c.parse(a,b.FROM)}}]);
return b}(TemporalAccessor$$module$input),PARSER$$module$input;function _init$b$$module$input(){PARSER$$module$input=(new DateTimeFormatterBuilder$$module$input).appendLiteral("--").appendValue(ChronoField$$module$input.MONTH_OF_YEAR,2).appendLiteral("-").appendValue(ChronoField$$module$input.DAY_OF_MONTH,2).toFormatter();MonthDay$$module$input.FROM=createTemporalQuery$$module$input("MonthDay.FROM",function(e){return MonthDay$$module$input.from(e)})}
var YearMonth$$module$input=function(e){function b(a,c){_classCallCheck$$module$input(this,b);var f=d.call(this);f._year=MathUtil$$module$input.safeToInt(a);f._month=MathUtil$$module$input.safeToInt(c);return f}_inherits$$module$input(b,e);var d=_createSuper$$module$input(b);_createClass$$module$input(b,[{key:"isSupported",value:function(a){return 1===arguments.length&&a instanceof TemporalField$$module$input?this.isSupportedField(a):this.isSupportedUnit(a)}},{key:"isSupportedField",value:function(a){return a instanceof
ChronoField$$module$input?a===ChronoField$$module$input.YEAR||a===ChronoField$$module$input.MONTH_OF_YEAR||a===ChronoField$$module$input.PROLEPTIC_MONTH||a===ChronoField$$module$input.YEAR_OF_ERA||a===ChronoField$$module$input.ERA:null!=a&&a.isSupportedBy(this)}},{key:"isSupportedUnit",value:function(a){return a instanceof ChronoUnit$$module$input?a===ChronoUnit$$module$input.MONTHS||a===ChronoUnit$$module$input.YEARS||a===ChronoUnit$$module$input.DECADES||a===ChronoUnit$$module$input.CENTURIES||
a===ChronoUnit$$module$input.MILLENNIA||a===ChronoUnit$$module$input.ERAS:null!=a&&a.isSupportedBy(this)}},{key:"range",value:function(a){return a===ChronoField$$module$input.YEAR_OF_ERA?0>=this.year()?ValueRange$$module$input.of(1,Year$$module$input.MAX_VALUE+1):ValueRange$$module$input.of(1,Year$$module$input.MAX_VALUE):_get$$module$input(_getPrototypeOf$$module$input(b.prototype),"range",this).call(this,a)}},{key:"get",value:function(a){requireNonNull$$module$input(a,"field");requireInstance$$module$input(a,
TemporalField$$module$input,"field");return this.range(a).checkValidIntValue(this.getLong(a),a)}},{key:"getLong",value:function(a){requireNonNull$$module$input(a,"field");requireInstance$$module$input(a,TemporalField$$module$input,"field");if(a instanceof ChronoField$$module$input){switch(a){case ChronoField$$module$input.MONTH_OF_YEAR:return this._month;case ChronoField$$module$input.PROLEPTIC_MONTH:return this._getProlepticMonth();case ChronoField$$module$input.YEAR_OF_ERA:return 1>this._year?1-
this._year:this._year;case ChronoField$$module$input.YEAR:return this._year;case ChronoField$$module$input.ERA:return 1>this._year?0:1}throw new UnsupportedTemporalTypeException$$module$input("Unsupported field: ".concat(a));}return a.getFrom(this)}},{key:"_getProlepticMonth",value:function(){return MathUtil$$module$input.safeAdd(MathUtil$$module$input.safeMultiply(this._year,12),this._month-1)}},{key:"year",value:function(){return this._year}},{key:"monthValue",value:function(){return this._month}},
{key:"month",value:function(){return Month$$module$input.of(this._month)}},{key:"isLeapYear",value:function(){return IsoChronology$$module$input.isLeapYear(this._year)}},{key:"isValidDay",value:function(a){return 1<=a&&a<=this.lengthOfMonth()}},{key:"lengthOfMonth",value:function(){return this.month().length(this.isLeapYear())}},{key:"lengthOfYear",value:function(){return this.isLeapYear()?366:365}},{key:"with",value:function(a,b){return 1===arguments.length?this._withAdjuster(a):this._withField(a,
b)}},{key:"_withField",value:function(a,b){requireNonNull$$module$input(a,"field");requireInstance$$module$input(a,TemporalField$$module$input,"field");if(a instanceof ChronoField$$module$input){a.checkValidValue(b);switch(a){case ChronoField$$module$input.MONTH_OF_YEAR:return this.withMonth(b);case ChronoField$$module$input.PROLEPTIC_MONTH:return this.plusMonths(b-this.getLong(ChronoField$$module$input.PROLEPTIC_MONTH));case ChronoField$$module$input.YEAR_OF_ERA:return this.withYear(1>this._year?
1-b:b);case ChronoField$$module$input.YEAR:return this.withYear(b);case ChronoField$$module$input.ERA:return this.getLong(ChronoField$$module$input.ERA)===b?this:this.withYear(1-this._year)}throw new UnsupportedTemporalTypeException$$module$input("Unsupported field: ".concat(a));}return a.adjustInto(this,b)}},{key:"withYear",value:function(a){ChronoField$$module$input.YEAR.checkValidValue(a);return new b(a,this._month)}},{key:"withMonth",value:function(a){ChronoField$$module$input.MONTH_OF_YEAR.checkValidValue(a);
return new b(this._year,a)}},{key:"_plusUnit",value:function(a,b){requireNonNull$$module$input(b,"unit");requireInstance$$module$input(b,TemporalUnit$$module$input,"unit");if(b instanceof ChronoUnit$$module$input){switch(b){case ChronoUnit$$module$input.MONTHS:return this.plusMonths(a);case ChronoUnit$$module$input.YEARS:return this.plusYears(a);case ChronoUnit$$module$input.DECADES:return this.plusYears(MathUtil$$module$input.safeMultiply(a,10));case ChronoUnit$$module$input.CENTURIES:return this.plusYears(MathUtil$$module$input.safeMultiply(a,
100));case ChronoUnit$$module$input.MILLENNIA:return this.plusYears(MathUtil$$module$input.safeMultiply(a,1E3));case ChronoUnit$$module$input.ERAS:return this.with(ChronoField$$module$input.ERA,MathUtil$$module$input.safeAdd(this.getLong(ChronoField$$module$input.ERA),a))}throw new UnsupportedTemporalTypeException$$module$input("Unsupported unit: ".concat(b));}return b.addTo(this,a)}},{key:"plusYears",value:function(a){if(0===a)return this;a=ChronoField$$module$input.YEAR.checkValidIntValue(this._year+
a);return this.withYear(a)}},{key:"plusMonths",value:function(a){if(0===a)return this;var c=12*this._year+(this._month-1)+a;a=ChronoField$$module$input.YEAR.checkValidIntValue(MathUtil$$module$input.floorDiv(c,12));c=MathUtil$$module$input.floorMod(c,12)+1;return new b(a,c)}},{key:"minusYears",value:function(a){return a===MathUtil$$module$input.MIN_SAFE_INTEGER?this.plusYears(MathUtil$$module$input.MIN_SAFE_INTEGER).plusYears(1):this.plusYears(-a)}},{key:"minusMonths",value:function(a){return a===
MathUtil$$module$input.MIN_SAFE_INTEGER?this.plusMonths(Math.MAX_SAFE_INTEGER).plusMonths(1):this.plusMonths(-a)}},{key:"query",value:function(a){requireNonNull$$module$input(a,"query");requireInstance$$module$input(a,TemporalQuery$$module$input,"query");return a===TemporalQueries$$module$input.chronology()?IsoChronology$$module$input.INSTANCE:a===TemporalQueries$$module$input.precision()?ChronoUnit$$module$input.MONTHS:a===TemporalQueries$$module$input.localDate()||a===TemporalQueries$$module$input.localTime()||
a===TemporalQueries$$module$input.zone()||a===TemporalQueries$$module$input.zoneId()||a===TemporalQueries$$module$input.offset()?null:_get$$module$input(_getPrototypeOf$$module$input(b.prototype),"query",this).call(this,a)}},{key:"adjustInto",value:function(a){requireNonNull$$module$input(a,"temporal");requireInstance$$module$input(a,Temporal$$module$input,"temporal");return a.with(ChronoField$$module$input.PROLEPTIC_MONTH,this._getProlepticMonth())}},{key:"until",value:function(a,c){requireNonNull$$module$input(a,
"endExclusive");requireNonNull$$module$input(c,"unit");requireInstance$$module$input(a,Temporal$$module$input,"endExclusive");requireInstance$$module$input(c,TemporalUnit$$module$input,"unit");a=b.from(a);if(c instanceof ChronoUnit$$module$input){var d=a._getProlepticMonth()-this._getProlepticMonth();switch(c){case ChronoUnit$$module$input.MONTHS:return d;case ChronoUnit$$module$input.YEARS:return d/12;case ChronoUnit$$module$input.DECADES:return d/120;case ChronoUnit$$module$input.CENTURIES:return d/
1200;case ChronoUnit$$module$input.MILLENNIA:return d/12E3;case ChronoUnit$$module$input.ERAS:return a.getLong(ChronoField$$module$input.ERA)-this.getLong(ChronoField$$module$input.ERA)}throw new UnsupportedTemporalTypeException$$module$input("Unsupported unit: ".concat(c));}return c.between(this,a)}},{key:"atDay",value:function(a){return LocalDate$$module$input.of(this._year,this._month,a)}},{key:"atEndOfMonth",value:function(){return LocalDate$$module$input.of(this._year,this._month,this.lengthOfMonth())}},
{key:"compareTo",value:function(a){requireNonNull$$module$input(a,"other");requireInstance$$module$input(a,b,"other");var c=this._year-a.year();0===c&&(c=this._month-a.monthValue());return c}},{key:"isAfter",value:function(a){return 0<this.compareTo(a)}},{key:"isBefore",value:function(a){return 0>this.compareTo(a)}},{key:"equals",value:function(a){return this===a?!0:a instanceof b?this.year()===a.year()&&this.monthValue()===a.monthValue():!1}},{key:"toString",value:function(){return PARSER$1$$module$input.format(this)}},
{key:"toJSON",value:function(){return this.toString()}},{key:"format",value:function(a){requireNonNull$$module$input(a,"formatter");return a.format(this)}}],[{key:"now",value:function(a){return 0===arguments.length?b.now0():1===arguments.length&&a instanceof ZoneId$$module$input?b.nowZoneId(a):b.nowClock(a)}},{key:"now0",value:function(){return b.nowClock(Clock$$module$input.systemDefaultZone())}},{key:"nowZoneId",value:function(a){return b.nowClock(Clock$$module$input.system(a))}},{key:"nowClock",
value:function(a){a=LocalDate$$module$input.now(a);return b.of(a.year(),a.month())}},{key:"of",value:function(a,c){return 2===arguments.length&&c instanceof Month$$module$input?b.ofNumberMonth(a,c):b.ofNumberNumber(a,c)}},{key:"ofNumberMonth",value:function(a,c){requireNonNull$$module$input(c,"month");requireInstance$$module$input(c,Month$$module$input,"month");return b.ofNumberNumber(a,c.value())}},{key:"ofNumberNumber",value:function(a,c){requireNonNull$$module$input(a,"year");requireNonNull$$module$input(c,
"month");ChronoField$$module$input.YEAR.checkValidValue(a);ChronoField$$module$input.MONTH_OF_YEAR.checkValidValue(c);return new b(a,c)}},{key:"from",value:function(a){requireNonNull$$module$input(a,"temporal");if(a instanceof b)return a;try{return b.of(a.get(ChronoField$$module$input.YEAR),a.get(ChronoField$$module$input.MONTH_OF_YEAR))}catch(c){throw new DateTimeException$$module$input("Unable to obtain YearMonth from TemporalAccessor: ".concat(a,", type ").concat(a&&null!=a.constructor?a.constructor.name:
""));}}},{key:"parse",value:function(a,c){return 1===arguments.length?b.parseString(a):b.parseStringFormatter(a,c)}},{key:"parseString",value:function(a){return b.parseStringFormatter(a,PARSER$1$$module$input)}},{key:"parseStringFormatter",value:function(a,c){requireNonNull$$module$input(c,"formatter");return c.parse(a,b.FROM)}}]);return b}(Temporal$$module$input),PARSER$1$$module$input;
function _init$c$$module$input(){PARSER$1$$module$input=(new DateTimeFormatterBuilder$$module$input).appendValue(ChronoField$$module$input.YEAR,4,10,SignStyle$$module$input.EXCEEDS_PAD).appendLiteral("-").appendValue(ChronoField$$module$input.MONTH_OF_YEAR,2).toFormatter();YearMonth$$module$input.FROM=createTemporalQuery$$module$input("YearMonth.FROM",function(e){return YearMonth$$module$input.from(e)})}
var Year$$module$input=function(e){function b(a){_classCallCheck$$module$input(this,b);var c=d.call(this);c._year=MathUtil$$module$input.safeToInt(a);return c}_inherits$$module$input(b,e);var d=_createSuper$$module$input(b);_createClass$$module$input(b,[{key:"value",value:function(){return this._year}},{key:"isSupported",value:function(a){return 1===arguments.length&&a instanceof TemporalField$$module$input?this.isSupportedField(a):this.isSupportedUnit(a)}},{key:"isSupportedField",value:function(a){return a instanceof
ChronoField$$module$input?a===ChronoField$$module$input.YEAR||a===ChronoField$$module$input.YEAR_OF_ERA||a===ChronoField$$module$input.ERA:null!=a&&a.isSupportedBy(this)}},{key:"isSupportedUnit",value:function(a){return a instanceof ChronoUnit$$module$input?a===ChronoUnit$$module$input.YEARS||a===ChronoUnit$$module$input.DECADES||a===ChronoUnit$$module$input.CENTURIES||a===ChronoUnit$$module$input.MILLENNIA||a===ChronoUnit$$module$input.ERAS:null!=a&&a.isSupportedBy(this)}},{key:"range",value:function(a){if(this.isSupported(a))return a.range();
if(a instanceof ChronoField$$module$input)throw new UnsupportedTemporalTypeException$$module$input("Unsupported field: ".concat(a));return _get$$module$input(_getPrototypeOf$$module$input(b.prototype),"range",this).call(this,a)}},{key:"get",value:function(a){return this.range(a).checkValidIntValue(this.getLong(a),a)}},{key:"getLong",value:function(a){requireNonNull$$module$input(a,"field");if(a instanceof ChronoField$$module$input){switch(a){case ChronoField$$module$input.YEAR_OF_ERA:return 1>this._year?
1-this._year:this._year;case ChronoField$$module$input.YEAR:return this._year;case ChronoField$$module$input.ERA:return 1>this._year?0:1}throw new UnsupportedTemporalTypeException$$module$input("Unsupported field: ".concat(a));}return a.getFrom(this)}},{key:"isLeap",value:function(){return b.isLeap(this._year)}},{key:"_withField",value:function(a,c){requireNonNull$$module$input(a,"field");requireInstance$$module$input(a,TemporalField$$module$input,"field");if(a instanceof ChronoField$$module$input){a.checkValidValue(c);
switch(a){case ChronoField$$module$input.YEAR_OF_ERA:return b.of(1>this._year?1-c:c);case ChronoField$$module$input.YEAR:return b.of(c);case ChronoField$$module$input.ERA:return this.getLong(ChronoField$$module$input.ERA)===c?this:b.of(1-this._year)}throw new UnsupportedTemporalTypeException$$module$input("Unsupported field: ".concat(a));}return a.adjustInto(this,c)}},{key:"_plusUnit",value:function(a,b){requireNonNull$$module$input(a,"amountToAdd");requireNonNull$$module$input(b,"unit");requireInstance$$module$input(b,
TemporalUnit$$module$input,"unit");if(b instanceof ChronoUnit$$module$input){switch(b){case ChronoUnit$$module$input.YEARS:return this.plusYears(a);case ChronoUnit$$module$input.DECADES:return this.plusYears(MathUtil$$module$input.safeMultiply(a,10));case ChronoUnit$$module$input.CENTURIES:return this.plusYears(MathUtil$$module$input.safeMultiply(a,100));case ChronoUnit$$module$input.MILLENNIA:return this.plusYears(MathUtil$$module$input.safeMultiply(a,1E3));case ChronoUnit$$module$input.ERAS:return this.with(ChronoField$$module$input.ERA,
MathUtil$$module$input.safeAdd(this.getLong(ChronoField$$module$input.ERA),a))}throw new UnsupportedTemporalTypeException$$module$input("Unsupported unit: ".concat(b));}return b.addTo(this,a)}},{key:"plusYears",value:function(a){return 0===a?this:b.of(ChronoField$$module$input.YEAR.checkValidIntValue(MathUtil$$module$input.safeAdd(this._year,a)))}},{key:"minusYears",value:function(a){return a===MathUtil$$module$input.MIN_SAFE_INTEGER?this.plusYears(MathUtil$$module$input.MAX_SAFE_INTEGER).plusYears(1):
this.plusYears(-a)}},{key:"adjustInto",value:function(a){requireNonNull$$module$input(a,"temporal");return a.with(ChronoField$$module$input.YEAR,this._year)}},{key:"isValidMonthDay",value:function(a){return null!=a&&a.isValidYear(this._year)}},{key:"length",value:function(){return this.isLeap()?366:365}},{key:"atDay",value:function(a){return LocalDate$$module$input.ofYearDay(this._year,a)}},{key:"atMonth",value:function(a){return 1===arguments.length&&a instanceof Month$$module$input?this.atMonthMonth(a):
this.atMonthNumber(a)}},{key:"atMonthMonth",value:function(a){requireNonNull$$module$input(a,"month");requireInstance$$module$input(a,Month$$module$input,"month");return YearMonth$$module$input.of(this._year,a)}},{key:"atMonthNumber",value:function(a){requireNonNull$$module$input(a,"month");return YearMonth$$module$input.of(this._year,a)}},{key:"atMonthDay",value:function(a){requireNonNull$$module$input(a,"monthDay");requireInstance$$module$input(a,MonthDay$$module$input,"monthDay");return a.atYear(this._year)}},
{key:"query",value:function(a){requireNonNull$$module$input(a,"query()");requireInstance$$module$input(a,TemporalQuery$$module$input,"query()");return a===TemporalQueries$$module$input.chronology()?IsoChronology$$module$input.INSTANCE:a===TemporalQueries$$module$input.precision()?ChronoUnit$$module$input.YEARS:a===TemporalQueries$$module$input.localDate()||a===TemporalQueries$$module$input.localTime()||a===TemporalQueries$$module$input.zone()||a===TemporalQueries$$module$input.zoneId()||a===TemporalQueries$$module$input.offset()?
null:_get$$module$input(_getPrototypeOf$$module$input(b.prototype),"query",this).call(this,a)}},{key:"compareTo",value:function(a){requireNonNull$$module$input(a,"other");requireInstance$$module$input(a,b,"other");return this._year-a._year}},{key:"isAfter",value:function(a){requireNonNull$$module$input(a,"other");requireInstance$$module$input(a,b,"other");return this._year>a._year}},{key:"isBefore",value:function(a){requireNonNull$$module$input(a,"other");requireInstance$$module$input(a,b,"other");
return this._year<a._year}},{key:"format",value:function(a){requireNonNull$$module$input(a,"formatter");requireInstance$$module$input(a,DateTimeFormatter$$module$input,"formatter");return a.format(this)}},{key:"equals",value:function(a){return this===a?!0:a instanceof b?this.value()===a.value():!1}},{key:"toString",value:function(){return"".concat(this._year)}},{key:"toJSON",value:function(){return this.toString()}},{key:"until",value:function(a,c){a=b.from(a);if(c instanceof ChronoUnit$$module$input){var d=
a.value()-this.value();switch(c){case ChronoUnit$$module$input.YEARS:return d;case ChronoUnit$$module$input.DECADES:return MathUtil$$module$input.intDiv(d,10);case ChronoUnit$$module$input.CENTURIES:return MathUtil$$module$input.intDiv(d,100);case ChronoUnit$$module$input.MILLENNIA:return MathUtil$$module$input.intDiv(d,1E3);case ChronoUnit$$module$input.ERAS:return a.getLong(ChronoField$$module$input.ERA)-this.getLong(ChronoField$$module$input.ERA)}throw new UnsupportedTemporalTypeException$$module$input("Unsupported unit: ".concat(c));
}return c.between(this,a)}}],[{key:"now",value:function(){var a=0<arguments.length&&void 0!==arguments[0]?arguments[0]:void 0;return void 0===a?b.now0():a instanceof ZoneId$$module$input?b.nowZoneId(a):b.nowClock(a)}},{key:"now0",value:function(){return b.nowClock(Clock$$module$input.systemDefaultZone())}},{key:"nowZoneId",value:function(a){requireNonNull$$module$input(a,"zone");requireInstance$$module$input(a,ZoneId$$module$input,"zone");return b.nowClock(Clock$$module$input.system(a))}},{key:"nowClock",
value:function(a){requireNonNull$$module$input(a,"clock");requireInstance$$module$input(a,Clock$$module$input,"clock");a=LocalDate$$module$input.now(a);return b.of(a.year())}},{key:"of",value:function(a){requireNonNull$$module$input(a,"isoYear");ChronoField$$module$input.YEAR.checkValidValue(a);return new b(a)}},{key:"from",value:function(a){requireNonNull$$module$input(a,"temporal");requireInstance$$module$input(a,TemporalAccessor$$module$input,"temporal");if(a instanceof b)return a;try{return b.of(a.get(ChronoField$$module$input.YEAR))}catch(c){throw new DateTimeException$$module$input("Unable to obtain Year from TemporalAccessor: ".concat(a,
", type ").concat(a&&null!=a.constructor?a.constructor.name:""));}}},{key:"parse",value:function(a,c){return 1>=arguments.length?b.parseText(a):b.parseTextFormatter(a,c)}},{key:"parseText",value:function(a){requireNonNull$$module$input(a,"text");return b.parse(a,PARSER$2$$module$input)}},{key:"parseTextFormatter",value:function(a){var c=1<arguments.length&&void 0!==arguments[1]?arguments[1]:PARSER$2$$module$input;requireNonNull$$module$input(a,"text");requireNonNull$$module$input(c,"formatter");requireInstance$$module$input(c,
DateTimeFormatter$$module$input,"formatter");return c.parse(a,b.FROM)}},{key:"isLeap",value:function(a){return 0===MathUtil$$module$input.intMod(a,4)&&(0!==MathUtil$$module$input.intMod(a,100)||0===MathUtil$$module$input.intMod(a,400))}}]);return b}(Temporal$$module$input),PARSER$2$$module$input;
function _init$d$$module$input(){Year$$module$input.MIN_VALUE=YearConstants$$module$input.MIN_VALUE;Year$$module$input.MAX_VALUE=YearConstants$$module$input.MAX_VALUE;PARSER$2$$module$input=(new DateTimeFormatterBuilder$$module$input).appendValue(ChronoField$$module$input.YEAR,4,10,SignStyle$$module$input.EXCEEDS_PAD).toFormatter();Year$$module$input.FROM=createTemporalQuery$$module$input("Year.FROM",function(e){return Year$$module$input.from(e)})}
var TemporalAdjuster$$module$input=function(){function e(){_classCallCheck$$module$input(this,e)}_createClass$$module$input(e,[{key:"adjustInto",value:function(b){abstractMethodFail$$module$input("adjustInto")}}]);return e}(),TemporalAdjusters$$module$input=function(){function e(){_classCallCheck$$module$input(this,e)}_createClass$$module$input(e,null,[{key:"firstDayOfMonth",value:function(){return Impl$$module$input.FIRST_DAY_OF_MONTH}},{key:"lastDayOfMonth",value:function(){return Impl$$module$input.LAST_DAY_OF_MONTH}},
{key:"firstDayOfNextMonth",value:function(){return Impl$$module$input.FIRST_DAY_OF_NEXT_MONTH}},{key:"firstDayOfYear",value:function(){return Impl$$module$input.FIRST_DAY_OF_YEAR}},{key:"lastDayOfYear",value:function(){return Impl$$module$input.LAST_DAY_OF_YEAR}},{key:"firstDayOfNextYear",value:function(){return Impl$$module$input.FIRST_DAY_OF_NEXT_YEAR}},{key:"firstInMonth",value:function(b){requireNonNull$$module$input(b,"dayOfWeek");return new DayOfWeekInMonth$$module$input(1,b)}},{key:"lastInMonth",
value:function(b){requireNonNull$$module$input(b,"dayOfWeek");return new DayOfWeekInMonth$$module$input(-1,b)}},{key:"dayOfWeekInMonth",value:function(b,d){requireNonNull$$module$input(d,"dayOfWeek");return new DayOfWeekInMonth$$module$input(b,d)}},{key:"next",value:function(b){return new RelativeDayOfWeek$$module$input(2,b)}},{key:"nextOrSame",value:function(b){return new RelativeDayOfWeek$$module$input(0,b)}},{key:"previous",value:function(b){return new RelativeDayOfWeek$$module$input(3,b)}},{key:"previousOrSame",
value:function(b){return new RelativeDayOfWeek$$module$input(1,b)}}]);return e}(),Impl$$module$input=function(e){function b(a){_classCallCheck$$module$input(this,b);var c=d.call(this);c._ordinal=a;return c}_inherits$$module$input(b,e);var d=_createSuper$$module$input(b);_createClass$$module$input(b,[{key:"adjustInto",value:function(a){switch(this._ordinal){case 0:return a.with(ChronoField$$module$input.DAY_OF_MONTH,1);case 1:return a.with(ChronoField$$module$input.DAY_OF_MONTH,a.range(ChronoField$$module$input.DAY_OF_MONTH).maximum());
case 2:return a.with(ChronoField$$module$input.DAY_OF_MONTH,1).plus(1,ChronoUnit$$module$input.MONTHS);case 3:return a.with(ChronoField$$module$input.DAY_OF_YEAR,1);case 4:return a.with(ChronoField$$module$input.DAY_OF_YEAR,a.range(ChronoField$$module$input.DAY_OF_YEAR).maximum());case 5:return a.with(ChronoField$$module$input.DAY_OF_YEAR,1).plus(1,ChronoUnit$$module$input.YEARS)}throw new IllegalStateException$$module$input("Unreachable");}}]);return b}(TemporalAdjuster$$module$input);
Impl$$module$input.FIRST_DAY_OF_MONTH=new Impl$$module$input(0);Impl$$module$input.LAST_DAY_OF_MONTH=new Impl$$module$input(1);Impl$$module$input.FIRST_DAY_OF_NEXT_MONTH=new Impl$$module$input(2);Impl$$module$input.FIRST_DAY_OF_YEAR=new Impl$$module$input(3);Impl$$module$input.LAST_DAY_OF_YEAR=new Impl$$module$input(4);Impl$$module$input.FIRST_DAY_OF_NEXT_YEAR=new Impl$$module$input(5);
var DayOfWeekInMonth$$module$input=function(e){function b(a,c){_classCallCheck$$module$input(this,b);var f=d.call(this);f._ordinal=a;f._dowValue=c.value();return f}_inherits$$module$input(b,e);var d=_createSuper$$module$input(b);_createClass$$module$input(b,[{key:"adjustInto",value:function(a){if(0<=this._ordinal){a=a.with(ChronoField$$module$input.DAY_OF_MONTH,1);var b=a.get(ChronoField$$module$input.DAY_OF_WEEK);b=MathUtil$$module$input.intMod(this._dowValue-b+7,7);b+=7*(this._ordinal-1);return a.plus(b,
ChronoUnit$$module$input.DAYS)}a=a.with(ChronoField$$module$input.DAY_OF_MONTH,a.range(ChronoField$$module$input.DAY_OF_MONTH).maximum());b=a.get(ChronoField$$module$input.DAY_OF_WEEK);b=this._dowValue-b;b=(0===b?0:0<b?b-7:b)-7*(-this._ordinal-1);return a.plus(b,ChronoUnit$$module$input.DAYS)}}]);return b}(TemporalAdjuster$$module$input),RelativeDayOfWeek$$module$input=function(e){function b(a,c){_classCallCheck$$module$input(this,b);var f=d.call(this);requireNonNull$$module$input(c,"dayOfWeek");
f._relative=a;f._dowValue=c.value();return f}_inherits$$module$input(b,e);var d=_createSuper$$module$input(b);_createClass$$module$input(b,[{key:"adjustInto",value:function(a){var b=a.get(ChronoField$$module$input.DAY_OF_WEEK);if(2>this._relative&&b===this._dowValue)return a;if(0===(this._relative&1))return b-=this._dowValue,a.plus(0<=b?7-b:-b,ChronoUnit$$module$input.DAYS);b=this._dowValue-b;return a.minus(0<=b?7-b:-b,ChronoUnit$$module$input.DAYS)}}]);return b}(TemporalAdjuster$$module$input),IsoChronology$$module$input=
function(e){function b(){_classCallCheck$$module$input(this,b);return d.apply(this,arguments)}_inherits$$module$input(b,e);var d=_createSuper$$module$input(b);_createClass$$module$input(b,[{key:"_updateResolveMap",value:function(a,b,d){requireNonNull$$module$input(a,"fieldValues");requireNonNull$$module$input(b,"field");var c=a.get(b);if(null!=c&&c!==d)throw new DateTimeException$$module$input("Invalid state, field: ".concat(b," ").concat(c," conflicts with ").concat(b," ").concat(d));a.put(b,d)}},
{key:"resolveDate",value:function(a,b){if(a.containsKey(ChronoField$$module$input.EPOCH_DAY))return LocalDate$$module$input.ofEpochDay(a.remove(ChronoField$$module$input.EPOCH_DAY));var c=a.remove(ChronoField$$module$input.PROLEPTIC_MONTH);null!=c&&(b!==ResolverStyle$$module$input.LENIENT&&ChronoField$$module$input.PROLEPTIC_MONTH.checkValidValue(c),this._updateResolveMap(a,ChronoField$$module$input.MONTH_OF_YEAR,MathUtil$$module$input.floorMod(c,12)+1),this._updateResolveMap(a,ChronoField$$module$input.YEAR,
MathUtil$$module$input.floorDiv(c,12)));c=a.remove(ChronoField$$module$input.YEAR_OF_ERA);if(null!=c){b!==ResolverStyle$$module$input.LENIENT&&ChronoField$$module$input.YEAR_OF_ERA.checkValidValue(c);var d=a.remove(ChronoField$$module$input.ERA);if(null==d)d=a.get(ChronoField$$module$input.YEAR),b===ResolverStyle$$module$input.STRICT?null!=d?this._updateResolveMap(a,ChronoField$$module$input.YEAR,0<d?c:MathUtil$$module$input.safeSubtract(1,c)):a.put(ChronoField$$module$input.YEAR_OF_ERA,c):this._updateResolveMap(a,
ChronoField$$module$input.YEAR,null==d||0<d?c:MathUtil$$module$input.safeSubtract(1,c));else if(1===d)this._updateResolveMap(a,ChronoField$$module$input.YEAR,c);else if(0===d)this._updateResolveMap(a,ChronoField$$module$input.YEAR,MathUtil$$module$input.safeSubtract(1,c));else throw new DateTimeException$$module$input("Invalid value for era: ".concat(d));}else a.containsKey(ChronoField$$module$input.ERA)&&ChronoField$$module$input.ERA.checkValidValue(a.get(ChronoField$$module$input.ERA));if(a.containsKey(ChronoField$$module$input.YEAR)){if(a.containsKey(ChronoField$$module$input.MONTH_OF_YEAR)&&
a.containsKey(ChronoField$$module$input.DAY_OF_MONTH)){c=ChronoField$$module$input.YEAR.checkValidIntValue(a.remove(ChronoField$$module$input.YEAR));d=a.remove(ChronoField$$module$input.MONTH_OF_YEAR);a=a.remove(ChronoField$$module$input.DAY_OF_MONTH);if(b===ResolverStyle$$module$input.LENIENT)return b=d-1,--a,LocalDate$$module$input.of(c,1,1).plusMonths(b).plusDays(a);b===ResolverStyle$$module$input.SMART&&(ChronoField$$module$input.DAY_OF_MONTH.checkValidValue(a),4===d||6===d||9===d||11===d?a=Math.min(a,
30):2===d&&(a=Math.min(a,Month$$module$input.FEBRUARY.length(Year$$module$input.isLeap(c)))));return LocalDate$$module$input.of(c,d,a)}if(a.containsKey(ChronoField$$module$input.DAY_OF_YEAR)){c=ChronoField$$module$input.YEAR.checkValidIntValue(a.remove(ChronoField$$module$input.YEAR));if(b===ResolverStyle$$module$input.LENIENT)return b=MathUtil$$module$input.safeSubtract(a.remove(ChronoField$$module$input.DAY_OF_YEAR),1),LocalDate$$module$input.ofYearDay(c,1).plusDays(b);b=ChronoField$$module$input.DAY_OF_YEAR.checkValidIntValue(a.remove(ChronoField$$module$input.DAY_OF_YEAR));
return LocalDate$$module$input.ofYearDay(c,b)}if(a.containsKey(ChronoField$$module$input.ALIGNED_WEEK_OF_YEAR)){if(a.containsKey(ChronoField$$module$input.ALIGNED_DAY_OF_WEEK_IN_YEAR)){c=ChronoField$$module$input.YEAR.checkValidIntValue(a.remove(ChronoField$$module$input.YEAR));if(b===ResolverStyle$$module$input.LENIENT)return b=MathUtil$$module$input.safeSubtract(a.remove(ChronoField$$module$input.ALIGNED_WEEK_OF_YEAR),1),a=MathUtil$$module$input.safeSubtract(a.remove(ChronoField$$module$input.ALIGNED_DAY_OF_WEEK_IN_YEAR),
1),LocalDate$$module$input.of(c,1,1).plusWeeks(b).plusDays(a);d=ChronoField$$module$input.ALIGNED_WEEK_OF_YEAR.checkValidIntValue(a.remove(ChronoField$$module$input.ALIGNED_WEEK_OF_YEAR));a=ChronoField$$module$input.ALIGNED_DAY_OF_WEEK_IN_YEAR.checkValidIntValue(a.remove(ChronoField$$module$input.ALIGNED_DAY_OF_WEEK_IN_YEAR));a=LocalDate$$module$input.of(c,1,1).plusDays(7*(d-1)+(a-1));if(b===ResolverStyle$$module$input.STRICT&&a.get(ChronoField$$module$input.YEAR)!==c)throw new DateTimeException$$module$input("Strict mode rejected date parsed to a different year");
return a}if(a.containsKey(ChronoField$$module$input.DAY_OF_WEEK)){c=ChronoField$$module$input.YEAR.checkValidIntValue(a.remove(ChronoField$$module$input.YEAR));if(b===ResolverStyle$$module$input.LENIENT)return b=MathUtil$$module$input.safeSubtract(a.remove(ChronoField$$module$input.ALIGNED_WEEK_OF_YEAR),1),a=MathUtil$$module$input.safeSubtract(a.remove(ChronoField$$module$input.DAY_OF_WEEK),1),LocalDate$$module$input.of(c,1,1).plusWeeks(b).plusDays(a);d=ChronoField$$module$input.ALIGNED_WEEK_OF_YEAR.checkValidIntValue(a.remove(ChronoField$$module$input.ALIGNED_WEEK_OF_YEAR));
a=ChronoField$$module$input.DAY_OF_WEEK.checkValidIntValue(a.remove(ChronoField$$module$input.DAY_OF_WEEK));a=LocalDate$$module$input.of(c,1,1).plusWeeks(d-1).with(TemporalAdjusters$$module$input.nextOrSame(DayOfWeek$$module$input.of(a)));if(b===ResolverStyle$$module$input.STRICT&&a.get(ChronoField$$module$input.YEAR)!==c)throw new DateTimeException$$module$input("Strict mode rejected date parsed to a different month");return a}}}return null}},{key:"date",value:function(a){return LocalDate$$module$input.from(a)}}],
[{key:"isLeapYear",value:function(a){return 0===(a&3)&&(0!==a%100||0===a%400)}}]);return b}(Enum$$module$input);function _init$e$$module$input(){IsoChronology$$module$input.INSTANCE=new IsoChronology$$module$input("IsoChronology")}
var OffsetTime$$module$input=function(e){function b(a,c){_classCallCheck$$module$input(this,b);var f=d.call(this);requireNonNull$$module$input(a,"time");requireInstance$$module$input(a,LocalTime$$module$input,"time");requireNonNull$$module$input(c,"offset");requireInstance$$module$input(c,ZoneOffset$$module$input,"offset");f._time=a;f._offset=c;return f}_inherits$$module$input(b,e);var d=_createSuper$$module$input(b);_createClass$$module$input(b,[{key:"adjustInto",value:function(a){return a.with(ChronoField$$module$input.NANO_OF_DAY,
this._time.toNanoOfDay()).with(ChronoField$$module$input.OFFSET_SECONDS,this.offset().totalSeconds())}},{key:"atDate",value:function(a){return OffsetDateTime$$module$input.of(a,this._time,this._offset)}},{key:"format",value:function(a){requireNonNull$$module$input(a,"formatter");return a.format(this,b.FROM)}},{key:"get",value:function(a){return _get$$module$input(_getPrototypeOf$$module$input(b.prototype),"get",this).call(this,a)}},{key:"getLong",value:function(a){return a instanceof ChronoField$$module$input?
a===ChronoField$$module$input.OFFSET_SECONDS?this._offset.totalSeconds():this._time.getLong(a):a.getFrom(this)}},{key:"hour",value:function(){return this._time.hour()}},{key:"minute",value:function(){return this._time.minute()}},{key:"second",value:function(){return this._time.second()}},{key:"nano",value:function(){return this._time.nano()}},{key:"offset",value:function(){return this._offset}},{key:"isAfter",value:function(a){requireNonNull$$module$input(a,"other");return this._toEpochNano()>a._toEpochNano()}},
{key:"isBefore",value:function(a){requireNonNull$$module$input(a,"other");return this._toEpochNano()<a._toEpochNano()}},{key:"isEqual",value:function(a){requireNonNull$$module$input(a,"other");return this._toEpochNano()===a._toEpochNano()}},{key:"isSupported",value:function(a){return a instanceof ChronoField$$module$input?a.isTimeBased()||a===ChronoField$$module$input.OFFSET_SECONDS:a instanceof ChronoUnit$$module$input?a.isTimeBased():null!=a&&a.isSupportedBy(this)}},{key:"minusHours",value:function(a){return this._withLocalTimeOffset(this._time.minusHours(a),
this._offset)}},{key:"minusMinutes",value:function(a){return this._withLocalTimeOffset(this._time.minusMinutes(a),this._offset)}},{key:"minusSeconds",value:function(a){return this._withLocalTimeOffset(this._time.minusSeconds(a),this._offset)}},{key:"minusNanos",value:function(a){return this._withLocalTimeOffset(this._time.minusNanos(a),this._offset)}},{key:"_minusAmount",value:function(a){requireNonNull$$module$input(a);return a.subtractFrom(this)}},{key:"_minusUnit",value:function(a,b){return this.plus(-1*
a,b)}},{key:"_plusAmount",value:function(a){requireNonNull$$module$input(a);return a.addTo(this)}},{key:"_plusUnit",value:function(a,b){return b instanceof ChronoUnit$$module$input?this._withLocalTimeOffset(this._time.plus(a,b),this._offset):b.addTo(this,a)}},{key:"plusHours",value:function(a){return this._withLocalTimeOffset(this._time.plusHours(a),this._offset)}},{key:"plusMinutes",value:function(a){return this._withLocalTimeOffset(this._time.plusMinutes(a),this._offset)}},{key:"plusSeconds",value:function(a){return this._withLocalTimeOffset(this._time.plusSeconds(a),
this._offset)}},{key:"plusNanos",value:function(a){return this._withLocalTimeOffset(this._time.plusNanos(a),this._offset)}},{key:"query",value:function(a){requireNonNull$$module$input(a,"query");return a===TemporalQueries$$module$input.precision()?ChronoUnit$$module$input.NANOS:a===TemporalQueries$$module$input.offset()||a===TemporalQueries$$module$input.zone()?this.offset():a===TemporalQueries$$module$input.localTime()?this._time:a===TemporalQueries$$module$input.chronology()||a===TemporalQueries$$module$input.localDate()||
a===TemporalQueries$$module$input.zoneId()?null:_get$$module$input(_getPrototypeOf$$module$input(b.prototype),"query",this).call(this,a)}},{key:"range",value:function(a){return a instanceof ChronoField$$module$input?a===ChronoField$$module$input.OFFSET_SECONDS?a.range():this._time.range(a):a.rangeRefinedBy(this)}},{key:"toLocalTime",value:function(){return this._time}},{key:"truncatedTo",value:function(a){return this._withLocalTimeOffset(this._time.truncatedTo(a),this._offset)}},{key:"until",value:function(a,
c){requireNonNull$$module$input(a,"endExclusive");requireNonNull$$module$input(c,"unit");a=b.from(a);if(c instanceof ChronoUnit$$module$input){a=a._toEpochNano()-this._toEpochNano();switch(c){case ChronoUnit$$module$input.NANOS:return a;case ChronoUnit$$module$input.MICROS:return Math.floor(a/1E3);case ChronoUnit$$module$input.MILLIS:return Math.floor(a/1E6);case ChronoUnit$$module$input.SECONDS:return Math.floor(a/LocalTime$$module$input.NANOS_PER_SECOND);case ChronoUnit$$module$input.MINUTES:return Math.floor(a/
LocalTime$$module$input.NANOS_PER_MINUTE);case ChronoUnit$$module$input.HOURS:return Math.floor(a/LocalTime$$module$input.NANOS_PER_HOUR);case ChronoUnit$$module$input.HALF_DAYS:return Math.floor(a/(12*LocalTime$$module$input.NANOS_PER_HOUR))}throw new UnsupportedTemporalTypeException$$module$input("Unsupported unit: ".concat(c));}return c.between(this,a)}},{key:"withHour",value:function(a){return this._withLocalTimeOffset(this._time.withHour(a),this._offset)}},{key:"withMinute",value:function(a){return this._withLocalTimeOffset(this._time.withMinute(a),
this._offset)}},{key:"withSecond",value:function(a){return this._withLocalTimeOffset(this._time.withSecond(a),this._offset)}},{key:"withNano",value:function(a){return this._withLocalTimeOffset(this._time.withNano(a),this._offset)}},{key:"withOffsetSameInstant",value:function(a){requireNonNull$$module$input(a,"offset");if(a.equals(this._offset))return this;var c=a.totalSeconds()-this._offset.totalSeconds();c=this._time.plusSeconds(c);return new b(c,a)}},{key:"withOffsetSameLocal",value:function(a){return null!=
a&&a.equals(this._offset)?this:new b(this._time,a)}},{key:"_toEpochNano",value:function(){var a=this._time.toNanoOfDay(),b=this._offset.totalSeconds()*LocalTime$$module$input.NANOS_PER_SECOND;return a-b}},{key:"_withAdjuster",value:function(a){requireNonNull$$module$input(a,"adjuster");return a instanceof LocalTime$$module$input?this._withLocalTimeOffset(a,this._offset):a instanceof ZoneOffset$$module$input?this._withLocalTimeOffset(this._time,a):a instanceof b?a:a.adjustInto(this)}},{key:"_withField",
value:function(a,b){requireNonNull$$module$input(a,"field");return a instanceof ChronoField$$module$input?a===ChronoField$$module$input.OFFSET_SECONDS?this._withLocalTimeOffset(this._time,ZoneOffset$$module$input.ofTotalSeconds(a.checkValidIntValue(b))):this._withLocalTimeOffset(this._time.with(a,b),this._offset):a.adjustInto(this,b)}},{key:"_withLocalTimeOffset",value:function(a,c){return this._time===a&&this._offset.equals(c)?this:new b(a,c)}},{key:"compareTo",value:function(a){requireNonNull$$module$input(a,
"other");requireInstance$$module$input(a,b,"other");if(this._offset.equals(a._offset))return this._time.compareTo(a._time);var c=MathUtil$$module$input.compareNumbers(this._toEpochNano(),a._toEpochNano());return 0===c?this._time.compareTo(a._time):c}},{key:"equals",value:function(a){return this===a?!0:a instanceof b?this._time.equals(a._time)&&this._offset.equals(a._offset):!1}},{key:"hashCode",value:function(){return this._time.hashCode()^this._offset.hashCode()}},{key:"toString",value:function(){return this._time.toString()+
this._offset.toString()}},{key:"toJSON",value:function(){return this.toString()}}],[{key:"from",value:function(a){requireNonNull$$module$input(a,"temporal");if(a instanceof b)return a;if(a instanceof OffsetDateTime$$module$input)return a.toOffsetTime();try{var c=LocalTime$$module$input.from(a),d=ZoneOffset$$module$input.from(a);return new b(c,d)}catch(l){throw new DateTimeException$$module$input("Unable to obtain OffsetTime TemporalAccessor: ".concat(a,", type ").concat(null!=a.constructor?a.constructor.name:
""));}}},{key:"now",value:function(a){return 0===arguments.length?b._now(Clock$$module$input.systemDefaultZone()):a instanceof Clock$$module$input?b._now(a):b._now(Clock$$module$input.system(a))}},{key:"_now",value:function(a){requireNonNull$$module$input(a,"clock");var c=a.instant();return b.ofInstant(c,a.zone().rules().offset(c))}},{key:"of",value:function(){return 2>=arguments.length?b.ofTimeAndOffset.apply(this,arguments):b.ofNumbers.apply(this,arguments)}},{key:"ofNumbers",value:function(a,c,
d,e,g){a=LocalTime$$module$input.of(a,c,d,e);return new b(a,g)}},{key:"ofTimeAndOffset",value:function(a,c){return new b(a,c)}},{key:"ofInstant",value:function(a,c){requireNonNull$$module$input(a,"instant");requireInstance$$module$input(a,Instant$$module$input,"instant");requireNonNull$$module$input(c,"zone");requireInstance$$module$input(c,ZoneId$$module$input,"zone");c=c.rules().offset(a);var d=a.epochSecond()%LocalTime$$module$input.SECONDS_PER_DAY;d=(d+c.totalSeconds())%LocalTime$$module$input.SECONDS_PER_DAY;
0>d&&(d+=LocalTime$$module$input.SECONDS_PER_DAY);a=LocalTime$$module$input.ofSecondOfDay(d,a.nano());return new b(a,c)}},{key:"parse",value:function(a){var c=1<arguments.length&&void 0!==arguments[1]?arguments[1]:DateTimeFormatter$$module$input.ISO_OFFSET_TIME;requireNonNull$$module$input(c,"formatter");return c.parse(a,b.FROM)}}]);return b}(Temporal$$module$input);
function _init$f$$module$input(){OffsetTime$$module$input.MIN=OffsetTime$$module$input.ofNumbers(0,0,0,0,ZoneOffset$$module$input.MAX);OffsetTime$$module$input.MAX=OffsetTime$$module$input.ofNumbers(23,59,59,999999999,ZoneOffset$$module$input.MIN);OffsetTime$$module$input.FROM=createTemporalQuery$$module$input("OffsetTime.FROM",function(e){return OffsetTime$$module$input.from(e)})}
var ChronoZonedDateTime$$module$input=function(e){function b(){_classCallCheck$$module$input(this,b);return d.apply(this,arguments)}_inherits$$module$input(b,e);var d=_createSuper$$module$input(b);_createClass$$module$input(b,[{key:"query",value:function(a){return a===TemporalQueries$$module$input.zoneId()||a===TemporalQueries$$module$input.zone()?this.zone():a===TemporalQueries$$module$input.chronology()?this.toLocalDate().chronology():a===TemporalQueries$$module$input.precision()?ChronoUnit$$module$input.NANOS:
a===TemporalQueries$$module$input.offset()?this.offset():a===TemporalQueries$$module$input.localDate()?LocalDate$$module$input.ofEpochDay(this.toLocalDate().toEpochDay()):a===TemporalQueries$$module$input.localTime()?this.toLocalTime():_get$$module$input(_getPrototypeOf$$module$input(b.prototype),"query",this).call(this,a)}},{key:"format",value:function(a){requireNonNull$$module$input(a,"formatter");return a.format(this)}},{key:"toInstant",value:function(){return Instant$$module$input.ofEpochSecond(this.toEpochSecond(),
this.toLocalTime().nano())}},{key:"toEpochSecond",value:function(){var a=86400*this.toLocalDate().toEpochDay()+this.toLocalTime().toSecondOfDay();return a-=this.offset().totalSeconds()}},{key:"compareTo",value:function(a){requireNonNull$$module$input(a,"other");var b=MathUtil$$module$input.compareNumbers(this.toEpochSecond(),a.toEpochSecond());0===b&&(b=this.toLocalTime().nano()-a.toLocalTime().nano(),0===b&&(b=this.toLocalDateTime().compareTo(a.toLocalDateTime()),0===b&&(b=strcmp$$module$input(this.zone().id(),
a.zone().id()))));return b}},{key:"isAfter",value:function(a){requireNonNull$$module$input(a,"other");var b=this.toEpochSecond(),d=a.toEpochSecond();return b>d||b===d&&this.toLocalTime().nano()>a.toLocalTime().nano()}},{key:"isBefore",value:function(a){requireNonNull$$module$input(a,"other");var b=this.toEpochSecond(),d=a.toEpochSecond();return b<d||b===d&&this.toLocalTime().nano()<a.toLocalTime().nano()}},{key:"isEqual",value:function(a){requireNonNull$$module$input(a,"other");return this.toEpochSecond()===
a.toEpochSecond()&&this.toLocalTime().nano()===a.toLocalTime().nano()}},{key:"equals",value:function(a){return this===a?!0:a instanceof b?0===this.compareTo(a):!1}}]);return b}(Temporal$$module$input);function strcmp$$module$input(e,b){return e<b?-1:e>b?1:0}
var ZonedDateTime$$module$input=function(e){function b(a,c,f){_classCallCheck$$module$input(this,b);requireNonNull$$module$input(a,"dateTime");requireNonNull$$module$input(c,"offset");requireNonNull$$module$input(f,"zone");var e=d.call(this);e._dateTime=a;e._offset=c;e._zone=f;return e}_inherits$$module$input(b,e);var d=_createSuper$$module$input(b);_createClass$$module$input(b,[{key:"_resolveLocal",value:function(a){requireNonNull$$module$input(a,"newDateTime");return b.ofLocal(a,this._zone,this._offset)}},
{key:"_resolveInstant",value:function(a){return b.ofInstant3(a,this._offset,this._zone)}},{key:"_resolveOffset",value:function(a){return!1===a.equals(this._offset)&&this._zone.rules().isValidOffset(this._dateTime,a)?new b(this._dateTime,a,this._zone):this}},{key:"isSupported",value:function(a){return a instanceof ChronoField$$module$input?!0:a instanceof ChronoUnit$$module$input?a.isDateBased()||a.isTimeBased():null!=a&&a.isSupportedBy(this)}},{key:"range",value:function(a){return a instanceof ChronoField$$module$input?
a===ChronoField$$module$input.INSTANT_SECONDS||a===ChronoField$$module$input.OFFSET_SECONDS?a.range():this._dateTime.range(a):a.rangeRefinedBy(this)}},{key:"get",value:function(a){return this.getLong(a)}},{key:"getLong",value:function(a){if(a instanceof ChronoField$$module$input){switch(a){case ChronoField$$module$input.INSTANT_SECONDS:return this.toEpochSecond();case ChronoField$$module$input.OFFSET_SECONDS:return this._offset.totalSeconds()}return this._dateTime.getLong(a)}requireNonNull$$module$input(a,
"field");return a.getFrom(this)}},{key:"offset",value:function(){return this._offset}},{key:"withEarlierOffsetAtOverlap",value:function(){var a=this._zone.rules().transition(this._dateTime);return null!=a&&a.isOverlap()&&(a=a.offsetBefore(),!1===a.equals(this._offset))?new b(this._dateTime,a,this._zone):this}},{key:"withLaterOffsetAtOverlap",value:function(){var a=this._zone.rules().transition(this.toLocalDateTime());return null!=a&&(a=a.offsetAfter(),!1===a.equals(this._offset))?new b(this._dateTime,
a,this._zone):this}},{key:"zone",value:function(){return this._zone}},{key:"withZoneSameLocal",value:function(a){requireNonNull$$module$input(a,"zone");return this._zone.equals(a)?this:b.ofLocal(this._dateTime,a,this._offset)}},{key:"withZoneSameInstant",value:function(a){requireNonNull$$module$input(a,"zone");return this._zone.equals(a)?this:b._create(this._dateTime.toEpochSecond(this._offset),this._dateTime.nano(),a)}},{key:"withFixedOffsetZone",value:function(){return this._zone.equals(this._offset)?
this:new b(this._dateTime,this._offset,this._offset)}},{key:"year",value:function(){return this._dateTime.year()}},{key:"monthValue",value:function(){return this._dateTime.monthValue()}},{key:"month",value:function(){return this._dateTime.month()}},{key:"dayOfMonth",value:function(){return this._dateTime.dayOfMonth()}},{key:"dayOfYear",value:function(){return this._dateTime.dayOfYear()}},{key:"dayOfWeek",value:function(){return this._dateTime.dayOfWeek()}},{key:"hour",value:function(){return this._dateTime.hour()}},
{key:"minute",value:function(){return this._dateTime.minute()}},{key:"second",value:function(){return this._dateTime.second()}},{key:"nano",value:function(){return this._dateTime.nano()}},{key:"_withAdjuster",value:function(a){return a instanceof LocalDate$$module$input?this._resolveLocal(LocalDateTime$$module$input.of(a,this._dateTime.toLocalTime())):a instanceof LocalTime$$module$input?this._resolveLocal(LocalDateTime$$module$input.of(this._dateTime.toLocalDate(),a)):a instanceof LocalDateTime$$module$input?
this._resolveLocal(a):a instanceof Instant$$module$input?b._create(a.epochSecond(),a.nano(),this._zone):a instanceof ZoneOffset$$module$input?this._resolveOffset(a):_get$$module$input(_getPrototypeOf$$module$input(b.prototype),"_withAdjuster",this).call(this,a)}},{key:"_withField",value:function(a,c){if(a instanceof ChronoField$$module$input){switch(a){case ChronoField$$module$input.INSTANT_SECONDS:return b._create(c,this.nano(),this._zone);case ChronoField$$module$input.OFFSET_SECONDS:return a=ZoneOffset$$module$input.ofTotalSeconds(a.checkValidIntValue(c)),
this._resolveOffset(a)}return this._resolveLocal(this._dateTime.with(a,c))}return a.adjustInto(this,c)}},{key:"withYear",value:function(a){return this._resolveLocal(this._dateTime.withYear(a))}},{key:"withMonth",value:function(a){return this._resolveLocal(this._dateTime.withMonth(a))}},{key:"withDayOfMonth",value:function(a){return this._resolveLocal(this._dateTime.withDayOfMonth(a))}},{key:"withDayOfYear",value:function(a){return this._resolveLocal(this._dateTime.withDayOfYear(a))}},{key:"withHour",
value:function(a){return this._resolveLocal(this._dateTime.withHour(a))}},{key:"withMinute",value:function(a){return this._resolveLocal(this._dateTime.withMinute(a))}},{key:"withSecond",value:function(a){return this._resolveLocal(this._dateTime.withSecond(a))}},{key:"withNano",value:function(a){return this._resolveLocal(this._dateTime.withNano(a))}},{key:"truncatedTo",value:function(a){return this._resolveLocal(this._dateTime.truncatedTo(a))}},{key:"_plusUnit",value:function(a,b){if(b instanceof ChronoUnit$$module$input)return b.isDateBased()?
this._resolveLocal(this._dateTime.plus(a,b)):this._resolveInstant(this._dateTime.plus(a,b));requireNonNull$$module$input(b,"unit");return b.addTo(this,a)}},{key:"plusYears",value:function(a){return this._resolveLocal(this._dateTime.plusYears(a))}},{key:"plusMonths",value:function(a){return this._resolveLocal(this._dateTime.plusMonths(a))}},{key:"plusWeeks",value:function(a){return this._resolveLocal(this._dateTime.plusWeeks(a))}},{key:"plusDays",value:function(a){return this._resolveLocal(this._dateTime.plusDays(a))}},
{key:"plusHours",value:function(a){return this._resolveInstant(this._dateTime.plusHours(a))}},{key:"plusMinutes",value:function(a){return this._resolveInstant(this._dateTime.plusMinutes(a))}},{key:"plusSeconds",value:function(a){return this._resolveInstant(this._dateTime.plusSeconds(a))}},{key:"plusNanos",value:function(a){return this._resolveInstant(this._dateTime.plusNanos(a))}},{key:"_minusUnit",value:function(a,b){return this._plusUnit(-1*a,b)}},{key:"minusYears",value:function(a){return this.plusYears(-1*
a)}},{key:"minusMonths",value:function(a){return this.plusMonths(-1*a)}},{key:"minusWeeks",value:function(a){return this.plusWeeks(-1*a)}},{key:"minusDays",value:function(a){return this.plusDays(-1*a)}},{key:"minusHours",value:function(a){return this.plusHours(-1*a)}},{key:"minusMinutes",value:function(a){return this.plusMinutes(-1*a)}},{key:"minusSeconds",value:function(a){return this.plusSeconds(-1*a)}},{key:"minusNanos",value:function(a){return this.plusNanos(-1*a)}},{key:"query",value:function(a){if(a===
TemporalQueries$$module$input.localDate())return this.toLocalDate();requireNonNull$$module$input(a,"query");return _get$$module$input(_getPrototypeOf$$module$input(b.prototype),"query",this).call(this,a)}},{key:"until",value:function(a,c){a=b.from(a);if(c instanceof ChronoUnit$$module$input){a=a.withZoneSameInstant(this._zone);if(c.isDateBased())return this._dateTime.until(a._dateTime,c);var d=this._offset.totalSeconds()-a._offset.totalSeconds();a=a._dateTime.plusSeconds(d);return this._dateTime.until(a,
c)}return c.between(this,a)}},{key:"toLocalDateTime",value:function(){return this._dateTime}},{key:"toLocalDate",value:function(){return this._dateTime.toLocalDate()}},{key:"toLocalTime",value:function(){return this._dateTime.toLocalTime()}},{key:"toOffsetDateTime",value:function(){return OffsetDateTime$$module$input.of(this._dateTime,this._offset)}},{key:"equals",value:function(a){return this===a?!0:a instanceof b?this._dateTime.equals(a._dateTime)&&this._offset.equals(a._offset)&&this._zone.equals(a._zone):
!1}},{key:"hashCode",value:function(){return MathUtil$$module$input.hashCode(this._dateTime.hashCode(),this._offset.hashCode(),this._zone.hashCode())}},{key:"toString",value:function(){var a=this._dateTime.toString()+this._offset.toString();this._offset!==this._zone&&(a+="[".concat(this._zone.toString(),"]"));return a}},{key:"toJSON",value:function(){return this.toString()}},{key:"format",value:function(a){return _get$$module$input(_getPrototypeOf$$module$input(b.prototype),"format",this).call(this,
a)}}],[{key:"now",value:function(a){a=a instanceof ZoneId$$module$input?Clock$$module$input.system(a):null==a?Clock$$module$input.systemDefaultZone():a;return b.ofInstant(a.instant(),a.zone())}},{key:"of",value:function(){return 2>=arguments.length?b.of2.apply(this,arguments):3===arguments.length&&arguments[0]instanceof LocalDate$$module$input?b.of3.apply(this,arguments):b.of8.apply(this,arguments)}},{key:"of3",value:function(a,c,d){return b.of2(LocalDateTime$$module$input.of(a,c),d)}},{key:"of2",
value:function(a,c){return b.ofLocal(a,c,null)}},{key:"of8",value:function(a,c,d,e,g,h,k,m){a=LocalDateTime$$module$input.of(a,c,d,e,g,h,k);return b.ofLocal(a,m,null)}},{key:"ofLocal",value:function(a,c,d){requireNonNull$$module$input(a,"localDateTime");requireNonNull$$module$input(c,"zone");if(c instanceof ZoneOffset$$module$input)return new b(a,c,c);var f=null;f=c.rules();var e=f.validOffsets(a);1===e.length?f=e[0]:0===e.length?(f=f.transition(a),a=a.plusSeconds(f.duration().seconds()),f=f.offsetAfter()):
f=null!=d&&e.some(function(a){return a.equals(d)})?d:requireNonNull$$module$input(e[0],"offset");return new b(a,f,c)}},{key:"ofInstant",value:function(){return 2===arguments.length?b.ofInstant2.apply(this,arguments):b.ofInstant3.apply(this,arguments)}},{key:"ofInstant2",value:function(a,c){requireNonNull$$module$input(a,"instant");requireNonNull$$module$input(c,"zone");return b._create(a.epochSecond(),a.nano(),c)}},{key:"ofInstant3",value:function(a,c,d){requireNonNull$$module$input(a,"localDateTime");
requireNonNull$$module$input(c,"offset");requireNonNull$$module$input(d,"zone");return b._create(a.toEpochSecond(c),a.nano(),d)}},{key:"_create",value:function(a,c,d){var f=d.rules(),e=Instant$$module$input.ofEpochSecond(a,c);f=f.offset(e);a=LocalDateTime$$module$input.ofEpochSecond(a,c,f);return new b(a,f,d)}},{key:"ofStrict",value:function(a,c,d){requireNonNull$$module$input(a,"localDateTime");requireNonNull$$module$input(c,"offset");requireNonNull$$module$input(d,"zone");var e=d.rules();if(!1===
e.isValidOffset(a,c)){e=e.transition(a);if(null!=e&&e.isGap())throw new DateTimeException$$module$input("LocalDateTime ".concat(a," does not exist in zone ").concat(d," due to a gap in the local time-line, typically caused by daylight savings"));throw new DateTimeException$$module$input('ZoneOffset "'.concat(c,'" is not valid for LocalDateTime "').concat(a,'" in zone "').concat(d,'"'));}return new b(a,c,d)}},{key:"ofLenient",value:function(a,c,d){requireNonNull$$module$input(a,"localDateTime");requireNonNull$$module$input(c,
"offset");requireNonNull$$module$input(d,"zone");if(d instanceof ZoneOffset$$module$input&&!1===c.equals(d))throw new IllegalArgumentException$$module$input("ZoneId must match ZoneOffset");return new b(a,c,d)}},{key:"from",value:function(a){requireNonNull$$module$input(a,"temporal");if(a instanceof b)return a;var c=ZoneId$$module$input.from(a);if(a.isSupported(ChronoField$$module$input.INSTANT_SECONDS)){var d=b._from(a,c);if(null!=d)return d}a=LocalDateTime$$module$input.from(a);return b.of2(a,c)}},
{key:"_from",value:function(a,c){try{return b.__from(a,c)}catch(f){if(!(f instanceof DateTimeException$$module$input))throw f;}}},{key:"__from",value:function(a,c){var d=a.getLong(ChronoField$$module$input.INSTANT_SECONDS);a=a.get(ChronoField$$module$input.NANO_OF_SECOND);return b._create(d,a,c)}},{key:"parse",value:function(a){var c=1<arguments.length&&void 0!==arguments[1]?arguments[1]:DateTimeFormatter$$module$input.ISO_ZONED_DATE_TIME;requireNonNull$$module$input(c,"formatter");return c.parse(a,
b.FROM)}}]);return b}(ChronoZonedDateTime$$module$input);function _init$g$$module$input(){ZonedDateTime$$module$input.FROM=createTemporalQuery$$module$input("ZonedDateTime.FROM",function(e){return ZonedDateTime$$module$input.from(e)})}
var OffsetDateTime$$module$input=function(e){function b(a,c){_classCallCheck$$module$input(this,b);var e=d.call(this);requireNonNull$$module$input(a,"dateTime");requireInstance$$module$input(a,LocalDateTime$$module$input,"dateTime");requireNonNull$$module$input(c,"offset");requireInstance$$module$input(c,ZoneOffset$$module$input,"offset");e._dateTime=a;e._offset=c;return e}_inherits$$module$input(b,e);var d=_createSuper$$module$input(b);_createClass$$module$input(b,[{key:"adjustInto",value:function(a){return a.with(ChronoField$$module$input.EPOCH_DAY,
this.toLocalDate().toEpochDay()).with(ChronoField$$module$input.NANO_OF_DAY,this.toLocalTime().toNanoOfDay()).with(ChronoField$$module$input.OFFSET_SECONDS,this.offset().totalSeconds())}},{key:"until",value:function(a,c){a=b.from(a);return c instanceof ChronoUnit$$module$input?(a=a.withOffsetSameInstant(this._offset),this._dateTime.until(a._dateTime,c)):c.between(this,a)}},{key:"atZoneSameInstant",value:function(a){return ZonedDateTime$$module$input.ofInstant(this._dateTime,this._offset,a)}},{key:"atZoneSimilarLocal",
value:function(a){return ZonedDateTime$$module$input.ofLocal(this._dateTime,a,this._offset)}},{key:"query",value:function(a){requireNonNull$$module$input(a,"query");return a===TemporalQueries$$module$input.chronology()?IsoChronology$$module$input.INSTANCE:a===TemporalQueries$$module$input.precision()?ChronoUnit$$module$input.NANOS:a===TemporalQueries$$module$input.offset()||a===TemporalQueries$$module$input.zone()?this.offset():a===TemporalQueries$$module$input.localDate()?this.toLocalDate():a===
TemporalQueries$$module$input.localTime()?this.toLocalTime():a===TemporalQueries$$module$input.zoneId()?null:_get$$module$input(_getPrototypeOf$$module$input(b.prototype),"query",this).call(this,a)}},{key:"get",value:function(a){if(a instanceof ChronoField$$module$input){switch(a){case ChronoField$$module$input.INSTANT_SECONDS:throw new DateTimeException$$module$input("Field too large for an int: ".concat(a));case ChronoField$$module$input.OFFSET_SECONDS:return this.offset().totalSeconds()}return this._dateTime.get(a)}return _get$$module$input(_getPrototypeOf$$module$input(b.prototype),
"get",this).call(this,a)}},{key:"getLong",value:function(a){if(a instanceof ChronoField$$module$input){switch(a){case ChronoField$$module$input.INSTANT_SECONDS:return this.toEpochSecond();case ChronoField$$module$input.OFFSET_SECONDS:return this.offset().totalSeconds()}return this._dateTime.getLong(a)}return a.getFrom(this)}},{key:"offset",value:function(){return this._offset}},{key:"year",value:function(){return this._dateTime.year()}},{key:"monthValue",value:function(){return this._dateTime.monthValue()}},
{key:"month",value:function(){return this._dateTime.month()}},{key:"dayOfMonth",value:function(){return this._dateTime.dayOfMonth()}},{key:"dayOfYear",value:function(){return this._dateTime.dayOfYear()}},{key:"dayOfWeek",value:function(){return this._dateTime.dayOfWeek()}},{key:"hour",value:function(){return this._dateTime.hour()}},{key:"minute",value:function(){return this._dateTime.minute()}},{key:"second",value:function(){return this._dateTime.second()}},{key:"nano",value:function(){return this._dateTime.nano()}},
{key:"toLocalDateTime",value:function(){return this._dateTime}},{key:"toLocalDate",value:function(){return this._dateTime.toLocalDate()}},{key:"toLocalTime",value:function(){return this._dateTime.toLocalTime()}},{key:"toOffsetTime",value:function(){return OffsetTime$$module$input.of(this._dateTime.toLocalTime(),this._offset)}},{key:"toZonedDateTime",value:function(){return ZonedDateTime$$module$input.of(this._dateTime,this._offset)}},{key:"toInstant",value:function(){return this._dateTime.toInstant(this._offset)}},
{key:"toEpochSecond",value:function(){return this._dateTime.toEpochSecond(this._offset)}},{key:"isSupported",value:function(a){return a instanceof ChronoField$$module$input||a instanceof ChronoUnit$$module$input?a.isDateBased()||a.isTimeBased():null!=a&&a.isSupportedBy(this)}},{key:"range",value:function(a){return a instanceof ChronoField$$module$input?a===ChronoField$$module$input.INSTANT_SECONDS||a===ChronoField$$module$input.OFFSET_SECONDS?a.range():this._dateTime.range(a):a.rangeRefinedBy(this)}},
{key:"_withAdjuster",value:function(a){requireNonNull$$module$input(a);return a instanceof LocalDate$$module$input||a instanceof LocalTime$$module$input||a instanceof LocalDateTime$$module$input?this._withDateTimeOffset(this._dateTime.with(a),this._offset):a instanceof Instant$$module$input?b.ofInstant(a,this._offset):a instanceof ZoneOffset$$module$input?this._withDateTimeOffset(this._dateTime,a):a instanceof b?a:a.adjustInto(this)}},{key:"_withField",value:function(a,c){requireNonNull$$module$input(a);
if(a instanceof ChronoField$$module$input){switch(a){case ChronoField$$module$input.INSTANT_SECONDS:return b.ofInstant(Instant$$module$input.ofEpochSecond(c,this.nano()),this._offset);case ChronoField$$module$input.OFFSET_SECONDS:return this._withDateTimeOffset(this._dateTime,ZoneOffset$$module$input.ofTotalSeconds(a.checkValidIntValue(c)))}return this._withDateTimeOffset(this._dateTime.with(a,c),this._offset)}return a.adjustInto(this,c)}},{key:"_withDateTimeOffset",value:function(a,c){return this._dateTime===
a&&this._offset.equals(c)?this:new b(a,c)}},{key:"withYear",value:function(a){return this._withDateTimeOffset(this._dateTime.withYear(a),this._offset)}},{key:"withMonth",value:function(a){return this._withDateTimeOffset(this._dateTime.withMonth(a),this._offset)}},{key:"withDayOfMonth",value:function(a){return this._withDateTimeOffset(this._dateTime.withDayOfMonth(a),this._offset)}},{key:"withDayOfYear",value:function(a){return this._withDateTimeOffset(this._dateTime.withDayOfYear(a),this._offset)}},
{key:"withHour",value:function(a){return this._withDateTimeOffset(this._dateTime.withHour(a),this._offset)}},{key:"withMinute",value:function(a){return this._withDateTimeOffset(this._dateTime.withMinute(a),this._offset)}},{key:"withSecond",value:function(a){return this._withDateTimeOffset(this._dateTime.withSecond(a),this._offset)}},{key:"withNano",value:function(a){return this._withDateTimeOffset(this._dateTime.withNano(a),this._offset)}},{key:"withOffsetSameLocal",value:function(a){requireNonNull$$module$input(a,
"offset");return this._withDateTimeOffset(this._dateTime,a)}},{key:"withOffsetSameInstant",value:function(a){requireNonNull$$module$input(a,"offset");if(a.equals(this._offset))return this;var c=a.totalSeconds()-this._offset.totalSeconds();c=this._dateTime.plusSeconds(c);return new b(c,a)}},{key:"truncatedTo",value:function(a){return this._withDateTimeOffset(this._dateTime.truncatedTo(a),this._offset)}},{key:"_plusAmount",value:function(a){requireNonNull$$module$input(a,"amount");return a.addTo(this)}},
{key:"_plusUnit",value:function(a,b){return b instanceof ChronoUnit$$module$input?this._withDateTimeOffset(this._dateTime.plus(a,b),this._offset):b.addTo(this,a)}},{key:"plusYears",value:function(a){return this._withDateTimeOffset(this._dateTime.plusYears(a),this._offset)}},{key:"plusMonths",value:function(a){return this._withDateTimeOffset(this._dateTime.plusMonths(a),this._offset)}},{key:"plusWeeks",value:function(a){return this._withDateTimeOffset(this._dateTime.plusWeeks(a),this._offset)}},{key:"plusDays",
value:function(a){return this._withDateTimeOffset(this._dateTime.plusDays(a),this._offset)}},{key:"plusHours",value:function(a){return this._withDateTimeOffset(this._dateTime.plusHours(a),this._offset)}},{key:"plusMinutes",value:function(a){return this._withDateTimeOffset(this._dateTime.plusMinutes(a),this._offset)}},{key:"plusSeconds",value:function(a){return this._withDateTimeOffset(this._dateTime.plusSeconds(a),this._offset)}},{key:"plusNanos",value:function(a){return this._withDateTimeOffset(this._dateTime.plusNanos(a),
this._offset)}},{key:"_minusAmount",value:function(a){requireNonNull$$module$input(a);return a.subtractFrom(this)}},{key:"_minusUnit",value:function(a,b){return this.plus(-1*a,b)}},{key:"minusYears",value:function(a){return this._withDateTimeOffset(this._dateTime.minusYears(a),this._offset)}},{key:"minusMonths",value:function(a){return this._withDateTimeOffset(this._dateTime.minusMonths(a),this._offset)}},{key:"minusWeeks",value:function(a){return this._withDateTimeOffset(this._dateTime.minusWeeks(a),
this._offset)}},{key:"minusDays",value:function(a){return this._withDateTimeOffset(this._dateTime.minusDays(a),this._offset)}},{key:"minusHours",value:function(a){return this._withDateTimeOffset(this._dateTime.minusHours(a),this._offset)}},{key:"minusMinutes",value:function(a){return this._withDateTimeOffset(this._dateTime.minusMinutes(a),this._offset)}},{key:"minusSeconds",value:function(a){return this._withDateTimeOffset(this._dateTime.minusSeconds(a),this._offset)}},{key:"minusNanos",value:function(a){return this._withDateTimeOffset(this._dateTime.minusNanos(a),
this._offset)}},{key:"compareTo",value:function(a){requireNonNull$$module$input(a,"other");requireInstance$$module$input(a,b,"other");if(this.offset().equals(a.offset()))return this.toLocalDateTime().compareTo(a.toLocalDateTime());var c=MathUtil$$module$input.compareNumbers(this.toEpochSecond(),a.toEpochSecond());0===c&&(c=this.toLocalTime().nano()-a.toLocalTime().nano(),0===c&&(c=this.toLocalDateTime().compareTo(a.toLocalDateTime())));return c}},{key:"isAfter",value:function(a){requireNonNull$$module$input(a,
"other");var b=this.toEpochSecond(),d=a.toEpochSecond();return b>d||b===d&&this.toLocalTime().nano()>a.toLocalTime().nano()}},{key:"isBefore",value:function(a){requireNonNull$$module$input(a,"other");var b=this.toEpochSecond(),d=a.toEpochSecond();return b<d||b===d&&this.toLocalTime().nano()<a.toLocalTime().nano()}},{key:"isEqual",value:function(a){requireNonNull$$module$input(a,"other");return this.toEpochSecond()===a.toEpochSecond()&&this.toLocalTime().nano()===a.toLocalTime().nano()}},{key:"equals",
value:function(a){return this===a?!0:a instanceof b?this._dateTime.equals(a._dateTime)&&this._offset.equals(a._offset):!1}},{key:"hashCode",value:function(){return this._dateTime.hashCode()^this._offset.hashCode()}},{key:"toString",value:function(){return this._dateTime.toString()+this._offset.toString()}},{key:"toJSON",value:function(){return this.toString()}},{key:"format",value:function(a){requireNonNull$$module$input(a,"formatter");return a.format(this)}}],[{key:"from",value:function(a){requireNonNull$$module$input(a,
"temporal");if(a instanceof b)return a;try{var c=ZoneOffset$$module$input.from(a);try{var d=LocalDateTime$$module$input.from(a);return b.of(d,c)}catch(g){var e=Instant$$module$input.from(a);return b.ofInstant(e,c)}}catch(g){throw new DateTimeException$$module$input("Unable to obtain OffsetDateTime TemporalAccessor: ".concat(a,", type ").concat(null!=a.constructor?a.constructor.name:""));}}},{key:"now",value:function(a){if(0===arguments.length)return b.now(Clock$$module$input.systemDefaultZone());
requireNonNull$$module$input(a,"clockOrZone");if(a instanceof ZoneId$$module$input)return b.now(Clock$$module$input.system(a));if(a instanceof Clock$$module$input){var c=a.instant();return b.ofInstant(c,a.zone().rules().offset(c))}throw new IllegalArgumentException$$module$input("clockOrZone must be an instance of ZoneId or Clock");}},{key:"of",value:function(){return 2>=arguments.length?b.ofDateTime.apply(this,arguments):3===arguments.length?b.ofDateAndTime.apply(this,arguments):b.ofNumbers.apply(this,
arguments)}},{key:"ofDateTime",value:function(a,c){return new b(a,c)}},{key:"ofDateAndTime",value:function(a,c,d){a=LocalDateTime$$module$input.of(a,c);return new b(a,d)}},{key:"ofNumbers",value:function(a,c,d){var e=7<arguments.length?arguments[7]:void 0,f=LocalDateTime$$module$input.of(a,c,d,3<arguments.length&&void 0!==arguments[3]?arguments[3]:0,4<arguments.length&&void 0!==arguments[4]?arguments[4]:0,5<arguments.length&&void 0!==arguments[5]?arguments[5]:0,6<arguments.length&&void 0!==arguments[6]?
arguments[6]:0);return new b(f,e)}},{key:"ofInstant",value:function(a,c){requireNonNull$$module$input(a,"instant");requireNonNull$$module$input(c,"zone");c=c.rules().offset(a);a=LocalDateTime$$module$input.ofEpochSecond(a.epochSecond(),a.nano(),c);return new b(a,c)}},{key:"parse",value:function(a){var c=1<arguments.length&&void 0!==arguments[1]?arguments[1]:DateTimeFormatter$$module$input.ISO_OFFSET_DATE_TIME;requireNonNull$$module$input(c,"formatter");return c.parse(a,b.FROM)}}]);return b}(Temporal$$module$input);
function _init$h$$module$input(){OffsetDateTime$$module$input.MIN=LocalDateTime$$module$input.MIN.atOffset(ZoneOffset$$module$input.MAX);OffsetDateTime$$module$input.MAX=LocalDateTime$$module$input.MAX.atOffset(ZoneOffset$$module$input.MIN);OffsetDateTime$$module$input.FROM=createTemporalQuery$$module$input("OffsetDateTime.FROM",function(e){return OffsetDateTime$$module$input.from(e)})}
var DAYS_PER_CYCLE$$module$input=146097,DAYS_0000_TO_1970$$module$input=5*DAYS_PER_CYCLE$$module$input-10957,LocalDate$$module$input=function(e){function b(a,c,e){_classCallCheck$$module$input(this,b);var f=d.call(this);requireNonNull$$module$input(a,"year");requireNonNull$$module$input(c,"month");requireNonNull$$module$input(e,"dayOfMonth");c instanceof Month$$module$input&&(c=c.value());f._year=MathUtil$$module$input.safeToInt(a);f._month=MathUtil$$module$input.safeToInt(c);f._day=MathUtil$$module$input.safeToInt(e);
b._validate(f._year,f._month,f._day);return f}_inherits$$module$input(b,e);var d=_createSuper$$module$input(b);_createClass$$module$input(b,[{key:"isSupported",value:function(a){return _get$$module$input(_getPrototypeOf$$module$input(b.prototype),"isSupported",this).call(this,a)}},{key:"range",value:function(a){if(a instanceof ChronoField$$module$input){if(a.isDateBased()){switch(a){case ChronoField$$module$input.DAY_OF_MONTH:return ValueRange$$module$input.of(1,this.lengthOfMonth());case ChronoField$$module$input.DAY_OF_YEAR:return ValueRange$$module$input.of(1,
this.lengthOfYear());case ChronoField$$module$input.ALIGNED_WEEK_OF_MONTH:return ValueRange$$module$input.of(1,this.month()===Month$$module$input.FEBRUARY&&!1===this.isLeapYear()?4:5);case ChronoField$$module$input.YEAR_OF_ERA:return 0>=this._year?ValueRange$$module$input.of(1,Year$$module$input.MAX_VALUE+1):ValueRange$$module$input.of(1,Year$$module$input.MAX_VALUE)}return a.range()}throw new UnsupportedTemporalTypeException$$module$input("Unsupported field: ".concat(a));}return a.rangeRefinedBy(this)}},
{key:"get",value:function(a){return this.getLong(a)}},{key:"getLong",value:function(a){assert$$module$input(null!=a,"",NullPointerException$$module$input);return a instanceof ChronoField$$module$input?this._get0(a):a.getFrom(this)}},{key:"_get0",value:function(a){switch(a){case ChronoField$$module$input.DAY_OF_WEEK:return this.dayOfWeek().value();case ChronoField$$module$input.ALIGNED_DAY_OF_WEEK_IN_MONTH:return MathUtil$$module$input.intMod(this._day-1,7)+1;case ChronoField$$module$input.ALIGNED_DAY_OF_WEEK_IN_YEAR:return MathUtil$$module$input.intMod(this.dayOfYear()-
1,7)+1;case ChronoField$$module$input.DAY_OF_MONTH:return this._day;case ChronoField$$module$input.DAY_OF_YEAR:return this.dayOfYear();case ChronoField$$module$input.EPOCH_DAY:return this.toEpochDay();case ChronoField$$module$input.ALIGNED_WEEK_OF_MONTH:return MathUtil$$module$input.intDiv(this._day-1,7)+1;case ChronoField$$module$input.ALIGNED_WEEK_OF_YEAR:return MathUtil$$module$input.intDiv(this.dayOfYear()-1,7)+1;case ChronoField$$module$input.MONTH_OF_YEAR:return this._month;case ChronoField$$module$input.PROLEPTIC_MONTH:return this._prolepticMonth();
case ChronoField$$module$input.YEAR_OF_ERA:return 1<=this._year?this._year:1-this._year;case ChronoField$$module$input.YEAR:return this._year;case ChronoField$$module$input.ERA:return 1<=this._year?1:0}throw new UnsupportedTemporalTypeException$$module$input("Unsupported field: ".concat(a));}},{key:"_prolepticMonth",value:function(){return 12*this._year+(this._month-1)}},{key:"chronology",value:function(){return IsoChronology$$module$input.INSTANCE}},{key:"year",value:function(){return this._year}},
{key:"monthValue",value:function(){return this._month}},{key:"month",value:function(){return Month$$module$input.of(this._month)}},{key:"dayOfMonth",value:function(){return this._day}},{key:"dayOfYear",value:function(){return this.month().firstDayOfYear(this.isLeapYear())+this._day-1}},{key:"dayOfWeek",value:function(){var a=MathUtil$$module$input.floorMod(this.toEpochDay()+3,7);return DayOfWeek$$module$input.of(a+1)}},{key:"isLeapYear",value:function(){return IsoChronology$$module$input.isLeapYear(this._year)}},
{key:"lengthOfMonth",value:function(){switch(this._month){case 2:return this.isLeapYear()?29:28;case 4:case 6:case 9:case 11:return 30;default:return 31}}},{key:"lengthOfYear",value:function(){return this.isLeapYear()?366:365}},{key:"_withAdjuster",value:function(a){requireNonNull$$module$input(a,"adjuster");return a instanceof b?a:_get$$module$input(_getPrototypeOf$$module$input(b.prototype),"_withAdjuster",this).call(this,a)}},{key:"_withField",value:function(a,c){assert$$module$input(null!=a,"field",
NullPointerException$$module$input);if(a instanceof ChronoField$$module$input){a.checkValidValue(c);switch(a){case ChronoField$$module$input.DAY_OF_WEEK:return this.plusDays(c-this.dayOfWeek().value());case ChronoField$$module$input.ALIGNED_DAY_OF_WEEK_IN_MONTH:return this.plusDays(c-this.getLong(ChronoField$$module$input.ALIGNED_DAY_OF_WEEK_IN_MONTH));case ChronoField$$module$input.ALIGNED_DAY_OF_WEEK_IN_YEAR:return this.plusDays(c-this.getLong(ChronoField$$module$input.ALIGNED_DAY_OF_WEEK_IN_YEAR));
case ChronoField$$module$input.DAY_OF_MONTH:return this.withDayOfMonth(c);case ChronoField$$module$input.DAY_OF_YEAR:return this.withDayOfYear(c);case ChronoField$$module$input.EPOCH_DAY:return b.ofEpochDay(c);case ChronoField$$module$input.ALIGNED_WEEK_OF_MONTH:return this.plusWeeks(c-this.getLong(ChronoField$$module$input.ALIGNED_WEEK_OF_MONTH));case ChronoField$$module$input.ALIGNED_WEEK_OF_YEAR:return this.plusWeeks(c-this.getLong(ChronoField$$module$input.ALIGNED_WEEK_OF_YEAR));case ChronoField$$module$input.MONTH_OF_YEAR:return this.withMonth(c);
case ChronoField$$module$input.PROLEPTIC_MONTH:return this.plusMonths(c-this.getLong(ChronoField$$module$input.PROLEPTIC_MONTH));case ChronoField$$module$input.YEAR_OF_ERA:return this.withYear(1<=this._year?c:1-c);case ChronoField$$module$input.YEAR:return this.withYear(c);case ChronoField$$module$input.ERA:return this.getLong(ChronoField$$module$input.ERA)===c?this:this.withYear(1-this._year)}throw new UnsupportedTemporalTypeException$$module$input("Unsupported field: ".concat(a));}return a.adjustInto(this,
c)}},{key:"withYear",value:function(a){if(this._year===a)return this;ChronoField$$module$input.YEAR.checkValidValue(a);return b._resolvePreviousValid(a,this._month,this._day)}},{key:"withMonth",value:function(a){a=a instanceof Month$$module$input?a.value():a;if(this._month===a)return this;ChronoField$$module$input.MONTH_OF_YEAR.checkValidValue(a);return b._resolvePreviousValid(this._year,a,this._day)}},{key:"withDayOfMonth",value:function(a){return this._day===a?this:b.of(this._year,this._month,a)}},
{key:"withDayOfYear",value:function(a){return this.dayOfYear()===a?this:b.ofYearDay(this._year,a)}},{key:"_plusUnit",value:function(a,b){requireNonNull$$module$input(a,"amountToAdd");requireNonNull$$module$input(b,"unit");if(b instanceof ChronoUnit$$module$input){switch(b){case ChronoUnit$$module$input.DAYS:return this.plusDays(a);case ChronoUnit$$module$input.WEEKS:return this.plusWeeks(a);case ChronoUnit$$module$input.MONTHS:return this.plusMonths(a);case ChronoUnit$$module$input.YEARS:return this.plusYears(a);
case ChronoUnit$$module$input.DECADES:return this.plusYears(MathUtil$$module$input.safeMultiply(a,10));case ChronoUnit$$module$input.CENTURIES:return this.plusYears(MathUtil$$module$input.safeMultiply(a,100));case ChronoUnit$$module$input.MILLENNIA:return this.plusYears(MathUtil$$module$input.safeMultiply(a,1E3));case ChronoUnit$$module$input.ERAS:return this.with(ChronoField$$module$input.ERA,MathUtil$$module$input.safeAdd(this.getLong(ChronoField$$module$input.ERA),a))}throw new UnsupportedTemporalTypeException$$module$input("Unsupported unit: ".concat(b));
}return b.addTo(this,a)}},{key:"plusYears",value:function(a){if(0===a)return this;a=ChronoField$$module$input.YEAR.checkValidIntValue(this._year+a);return b._resolvePreviousValid(a,this._month,this._day)}},{key:"plusMonths",value:function(a){if(0===a)return this;var c=12*this._year+(this._month-1)+a;a=ChronoField$$module$input.YEAR.checkValidIntValue(MathUtil$$module$input.floorDiv(c,12));c=MathUtil$$module$input.floorMod(c,12)+1;return b._resolvePreviousValid(a,c,this._day)}},{key:"plusWeeks",value:function(a){return this.plusDays(MathUtil$$module$input.safeMultiply(a,
7))}},{key:"plusDays",value:function(a){if(0===a)return this;a=MathUtil$$module$input.safeAdd(this.toEpochDay(),a);return b.ofEpochDay(a)}},{key:"_minusUnit",value:function(a,b){requireNonNull$$module$input(a,"amountToSubtract");requireNonNull$$module$input(b,"unit");return this._plusUnit(-1*a,b)}},{key:"minusYears",value:function(a){return this.plusYears(-1*a)}},{key:"minusMonths",value:function(a){return this.plusMonths(-1*a)}},{key:"minusWeeks",value:function(a){return this.plusWeeks(-1*a)}},{key:"minusDays",
value:function(a){return this.plusDays(-1*a)}},{key:"query",value:function(a){requireNonNull$$module$input(a,"query");return a===TemporalQueries$$module$input.localDate()?this:_get$$module$input(_getPrototypeOf$$module$input(b.prototype),"query",this).call(this,a)}},{key:"adjustInto",value:function(a){return _get$$module$input(_getPrototypeOf$$module$input(b.prototype),"adjustInto",this).call(this,a)}},{key:"until",value:function(a,b){return 2>arguments.length?this.until1(a):this.until2(a,b)}},{key:"until2",
value:function(a,c){a=b.from(a);if(c instanceof ChronoUnit$$module$input){switch(c){case ChronoUnit$$module$input.DAYS:return this.daysUntil(a);case ChronoUnit$$module$input.WEEKS:return MathUtil$$module$input.intDiv(this.daysUntil(a),7);case ChronoUnit$$module$input.MONTHS:return this._monthsUntil(a);case ChronoUnit$$module$input.YEARS:return MathUtil$$module$input.intDiv(this._monthsUntil(a),12);case ChronoUnit$$module$input.DECADES:return MathUtil$$module$input.intDiv(this._monthsUntil(a),120);
case ChronoUnit$$module$input.CENTURIES:return MathUtil$$module$input.intDiv(this._monthsUntil(a),1200);case ChronoUnit$$module$input.MILLENNIA:return MathUtil$$module$input.intDiv(this._monthsUntil(a),12E3);case ChronoUnit$$module$input.ERAS:return a.getLong(ChronoField$$module$input.ERA)-this.getLong(ChronoField$$module$input.ERA)}throw new UnsupportedTemporalTypeException$$module$input("Unsupported unit: ".concat(c));}return c.between(this,a)}},{key:"daysUntil",value:function(a){return a.toEpochDay()-
this.toEpochDay()}},{key:"_monthsUntil",value:function(a){var b=32*this._prolepticMonth()+this.dayOfMonth();a=32*a._prolepticMonth()+a.dayOfMonth();return MathUtil$$module$input.intDiv(a-b,32)}},{key:"until1",value:function(a){var c=b.from(a);a=c._prolepticMonth()-this._prolepticMonth();var d=c._day-this._day;0<a&&0>d?(a--,d=this.plusMonths(a),d=c.toEpochDay()-d.toEpochDay()):0>a&&0<d&&(a++,d-=c.lengthOfMonth());c=MathUtil$$module$input.intDiv(a,12);a=MathUtil$$module$input.intMod(a,12);return Period$$module$input.of(c,
a,d)}},{key:"atTime",value:function(){return 1===arguments.length?this.atTime1.apply(this,arguments):this.atTime4.apply(this,arguments)}},{key:"atTime1",value:function(a){requireNonNull$$module$input(a,"time");if(a instanceof LocalTime$$module$input)return LocalDateTime$$module$input.of(this,a);if(a instanceof OffsetTime$$module$input)return this._atTimeOffsetTime(a);throw new IllegalArgumentException$$module$input("time must be an instance of LocalTime or OffsetTime".concat(a&&a.constructor&&a.constructor.name?
", but is ".concat(a.constructor.name):""));}},{key:"atTime4",value:function(a,b){return this.atTime1(LocalTime$$module$input.of(a,b,2<arguments.length&&void 0!==arguments[2]?arguments[2]:0,3<arguments.length&&void 0!==arguments[3]?arguments[3]:0))}},{key:"_atTimeOffsetTime",value:function(a){return OffsetDateTime$$module$input.of(LocalDateTime$$module$input.of(this,a.toLocalTime()),a.offset())}},{key:"atStartOfDay",value:function(a){return null!=a?this._atStartOfDayWithZone(a):LocalDateTime$$module$input.of(this,
LocalTime$$module$input.MIDNIGHT)}},{key:"_atStartOfDayWithZone",value:function(a){requireNonNull$$module$input(a,"zone");var b=this.atTime(LocalTime$$module$input.MIDNIGHT);if(!1===a instanceof ZoneOffset$$module$input){var d=a.rules().transition(b);null!=d&&d.isGap()&&(b=d.dateTimeAfter())}return ZonedDateTime$$module$input.of(b,a)}},{key:"toEpochDay",value:function(){var a=this._year,b=this._month;var d=365*a;d=0<=a?d+(MathUtil$$module$input.intDiv(a+3,4)-MathUtil$$module$input.intDiv(a+99,100)+
MathUtil$$module$input.intDiv(a+399,400)):d-(MathUtil$$module$input.intDiv(a,-4)-MathUtil$$module$input.intDiv(a,-100)+MathUtil$$module$input.intDiv(a,-400));d+=MathUtil$$module$input.intDiv(367*b-362,12);d+=this.dayOfMonth()-1;2<b&&(d--,IsoChronology$$module$input.isLeapYear(a)||d--);return d-DAYS_0000_TO_1970$$module$input}},{key:"compareTo",value:function(a){requireNonNull$$module$input(a,"other");requireInstance$$module$input(a,b,"other");return this._compareTo0(a)}},{key:"_compareTo0",value:function(a){var b=
this._year-a._year;0===b&&(b=this._month-a._month,0===b&&(b=this._day-a._day));return b}},{key:"isAfter",value:function(a){return 0<this.compareTo(a)}},{key:"isBefore",value:function(a){return 0>this.compareTo(a)}},{key:"isEqual",value:function(a){return 0===this.compareTo(a)}},{key:"equals",value:function(a){return this===a?!0:a instanceof b?0===this._compareTo0(a):!1}},{key:"hashCode",value:function(){var a=this._year;return MathUtil$$module$input.hash(a&4294965248^(a<<11)+(this._month<<6)+this._day)}},
{key:"toString",value:function(){var a=this._year;var b=this._month;var d=this._day;a=1E3>Math.abs(a)?0>a?"-".concat("".concat(a-1E4).slice(-4)):"".concat(a+1E4).slice(-4):9999<a?"+".concat(a):"".concat(a);b=10>b?"-0".concat(b):"-".concat(b);d=10>d?"-0".concat(d):"-".concat(d);return a+b+d}},{key:"toJSON",value:function(){return this.toString()}},{key:"format",value:function(a){requireNonNull$$module$input(a,"formatter");requireInstance$$module$input(a,DateTimeFormatter$$module$input,"formatter");
return _get$$module$input(_getPrototypeOf$$module$input(b.prototype),"format",this).call(this,a)}}],[{key:"now",value:function(a){a=null==a?Clock$$module$input.systemDefaultZone():a instanceof ZoneId$$module$input?Clock$$module$input.system(a):a;return b.ofInstant(a.instant(),a.zone())}},{key:"ofInstant",value:function(a){var c=1<arguments.length&&void 0!==arguments[1]?arguments[1]:ZoneId$$module$input.systemDefault();requireNonNull$$module$input(a,"instant");c=c.rules().offset(a);c=a.epochSecond()+
c.totalSeconds();c=MathUtil$$module$input.floorDiv(c,LocalTime$$module$input.SECONDS_PER_DAY);return b.ofEpochDay(c)}},{key:"of",value:function(a,c,d){return new b(a,c,d)}},{key:"ofYearDay",value:function(a,c){ChronoField$$module$input.YEAR.checkValidValue(a);var d=IsoChronology$$module$input.isLeapYear(a);366===c&&!1===d&&assert$$module$input(!1,"Invalid date 'DayOfYear 366' as '".concat(a,"' is not a leap year"),DateTimeException$$module$input);var e=Month$$module$input.of(Math.floor((c-1)/31+1)),
g=e.firstDayOfYear(d)+e.length(d)-1;c>g&&(e=e.plus(1));c=c-e.firstDayOfYear(d)+1;return new b(a,e.value(),c)}},{key:"ofEpochDay",value:function(){var a=(0<arguments.length&&void 0!==arguments[0]?arguments[0]:0)+DAYS_0000_TO_1970$$module$input;a-=60;var c=0;if(0>a){var d=MathUtil$$module$input.intDiv(a+1,DAYS_PER_CYCLE$$module$input)-1;c=400*d;a+=-d*DAYS_PER_CYCLE$$module$input}d=MathUtil$$module$input.intDiv(400*a+591,DAYS_PER_CYCLE$$module$input);var e=a-(365*d+MathUtil$$module$input.intDiv(d,4)-
MathUtil$$module$input.intDiv(d,100)+MathUtil$$module$input.intDiv(d,400));0>e&&(d--,e=a-(365*d+MathUtil$$module$input.intDiv(d,4)-MathUtil$$module$input.intDiv(d,100)+MathUtil$$module$input.intDiv(d,400)));d+=c;c=MathUtil$$module$input.intDiv(5*e+2,153);a=(c+2)%12+1;e=e-MathUtil$$module$input.intDiv(306*c+5,10)+1;d+=MathUtil$$module$input.intDiv(c,10);return new b(d,a,e)}},{key:"from",value:function(a){requireNonNull$$module$input(a,"temporal");var b=a.query(TemporalQueries$$module$input.localDate());
if(null==b)throw new DateTimeException$$module$input("Unable to obtain LocalDate from TemporalAccessor: ".concat(a,", type ").concat(null!=a.constructor?a.constructor.name:""));return b}},{key:"parse",value:function(a){var c=1<arguments.length&&void 0!==arguments[1]?arguments[1]:DateTimeFormatter$$module$input.ISO_LOCAL_DATE;assert$$module$input(null!=c,"formatter",NullPointerException$$module$input);return c.parse(a,b.FROM)}},{key:"_resolvePreviousValid",value:function(a,c,d){switch(c){case 2:d=
Math.min(d,IsoChronology$$module$input.isLeapYear(a)?29:28);break;case 4:case 6:case 9:case 11:d=Math.min(d,30)}return b.of(a,c,d)}},{key:"_validate",value:function(a,b,d){ChronoField$$module$input.YEAR.checkValidValue(a);ChronoField$$module$input.MONTH_OF_YEAR.checkValidValue(b);ChronoField$$module$input.DAY_OF_MONTH.checkValidValue(d);if(28<d){var c=31;switch(b){case 2:c=IsoChronology$$module$input.isLeapYear(a)?29:28;break;case 4:case 6:case 9:case 11:c=30}d>c&&(29===d?assert$$module$input(!1,
"Invalid date 'February 29' as '".concat(a,"' is not a leap year"),DateTimeException$$module$input):assert$$module$input(!1,"Invalid date '".concat(a,"' '").concat(b,"' '").concat(d,"'"),DateTimeException$$module$input))}}}]);return b}(ChronoLocalDate$$module$input);
function _init$i$$module$input(){LocalDate$$module$input.MIN=LocalDate$$module$input.of(YearConstants$$module$input.MIN_VALUE,1,1);LocalDate$$module$input.MAX=LocalDate$$module$input.of(YearConstants$$module$input.MAX_VALUE,12,31);LocalDate$$module$input.EPOCH_0=LocalDate$$module$input.ofEpochDay(0);LocalDate$$module$input.FROM=createTemporalQuery$$module$input("LocalDate.FROM",function(e){return LocalDate$$module$input.from(e)})}
var ChronoLocalDateTime$$module$input=function(e){function b(){_classCallCheck$$module$input(this,b);return d.apply(this,arguments)}_inherits$$module$input(b,e);var d=_createSuper$$module$input(b);_createClass$$module$input(b,[{key:"chronology",value:function(){return this.toLocalDate().chronology()}},{key:"query",value:function(a){return a===TemporalQueries$$module$input.chronology()?this.chronology():a===TemporalQueries$$module$input.precision()?ChronoUnit$$module$input.NANOS:a===TemporalQueries$$module$input.localDate()?
LocalDate$$module$input.ofEpochDay(this.toLocalDate().toEpochDay()):a===TemporalQueries$$module$input.localTime()?this.toLocalTime():a===TemporalQueries$$module$input.zone()||a===TemporalQueries$$module$input.zoneId()||a===TemporalQueries$$module$input.offset()?null:_get$$module$input(_getPrototypeOf$$module$input(b.prototype),"query",this).call(this,a)}},{key:"adjustInto",value:function(a){return a.with(ChronoField$$module$input.EPOCH_DAY,this.toLocalDate().toEpochDay()).with(ChronoField$$module$input.NANO_OF_DAY,
this.toLocalTime().toNanoOfDay())}},{key:"toInstant",value:function(a){requireInstance$$module$input(a,ZoneOffset$$module$input,"zoneId");return Instant$$module$input.ofEpochSecond(this.toEpochSecond(a),this.toLocalTime().nano())}},{key:"toEpochSecond",value:function(a){requireNonNull$$module$input(a,"offset");var b=86400*this.toLocalDate().toEpochDay()+this.toLocalTime().toSecondOfDay();b-=a.totalSeconds();return MathUtil$$module$input.safeToInt(b)}}]);return b}(Temporal$$module$input),LocalDateTime$$module$input=
function(e){function b(a,c){_classCallCheck$$module$input(this,b);var e=d.call(this);requireInstance$$module$input(a,LocalDate$$module$input,"date");requireInstance$$module$input(c,LocalTime$$module$input,"time");e._date=a;e._time=c;return e}_inherits$$module$input(b,e);var d=_createSuper$$module$input(b);_createClass$$module$input(b,[{key:"_withDateTime",value:function(a,c){return this._date.equals(a)&&this._time.equals(c)?this:new b(a,c)}},{key:"isSupported",value:function(a){return a instanceof
ChronoField$$module$input||a instanceof ChronoUnit$$module$input?a.isDateBased()||a.isTimeBased():null!=a&&a.isSupportedBy(this)}},{key:"range",value:function(a){return a instanceof ChronoField$$module$input?a.isTimeBased()?this._time.range(a):this._date.range(a):a.rangeRefinedBy(this)}},{key:"get",value:function(a){return a instanceof ChronoField$$module$input?a.isTimeBased()?this._time.get(a):this._date.get(a):_get$$module$input(_getPrototypeOf$$module$input(b.prototype),"get",this).call(this,a)}},
{key:"getLong",value:function(a){requireNonNull$$module$input(a,"field");return a instanceof ChronoField$$module$input?a.isTimeBased()?this._time.getLong(a):this._date.getLong(a):a.getFrom(this)}},{key:"year",value:function(){return this._date.year()}},{key:"monthValue",value:function(){return this._date.monthValue()}},{key:"month",value:function(){return this._date.month()}},{key:"dayOfMonth",value:function(){return this._date.dayOfMonth()}},{key:"dayOfYear",value:function(){return this._date.dayOfYear()}},
{key:"dayOfWeek",value:function(){return this._date.dayOfWeek()}},{key:"hour",value:function(){return this._time.hour()}},{key:"minute",value:function(){return this._time.minute()}},{key:"second",value:function(){return this._time.second()}},{key:"nano",value:function(){return this._time.nano()}},{key:"_withAdjuster",value:function(a){requireNonNull$$module$input(a,"adjuster");return a instanceof LocalDate$$module$input?this._withDateTime(a,this._time):a instanceof LocalTime$$module$input?this._withDateTime(this._date,
a):a instanceof b?a:_get$$module$input(_getPrototypeOf$$module$input(b.prototype),"_withAdjuster",this).call(this,a)}},{key:"_withField",value:function(a,b){requireNonNull$$module$input(a,"field");return a instanceof ChronoField$$module$input?a.isTimeBased()?this._withDateTime(this._date,this._time.with(a,b)):this._withDateTime(this._date.with(a,b),this._time):a.adjustInto(this,b)}},{key:"withYear",value:function(a){return this._withDateTime(this._date.withYear(a),this._time)}},{key:"withMonth",value:function(a){return this._withDateTime(this._date.withMonth(a),
this._time)}},{key:"withDayOfMonth",value:function(a){return this._withDateTime(this._date.withDayOfMonth(a),this._time)}},{key:"withDayOfYear",value:function(a){return this._withDateTime(this._date.withDayOfYear(a),this._time)}},{key:"withHour",value:function(a){a=this._time.withHour(a);return this._withDateTime(this._date,a)}},{key:"withMinute",value:function(a){a=this._time.withMinute(a);return this._withDateTime(this._date,a)}},{key:"withSecond",value:function(a){a=this._time.withSecond(a);return this._withDateTime(this._date,
a)}},{key:"withNano",value:function(a){a=this._time.withNano(a);return this._withDateTime(this._date,a)}},{key:"truncatedTo",value:function(a){return this._withDateTime(this._date,this._time.truncatedTo(a))}},{key:"_plusUnit",value:function(a,b){requireNonNull$$module$input(b,"unit");if(b instanceof ChronoUnit$$module$input){switch(b){case ChronoUnit$$module$input.NANOS:return this.plusNanos(a);case ChronoUnit$$module$input.MICROS:return this.plusDays(MathUtil$$module$input.intDiv(a,LocalTime$$module$input.MICROS_PER_DAY)).plusNanos(1E3*
MathUtil$$module$input.intMod(a,LocalTime$$module$input.MICROS_PER_DAY));case ChronoUnit$$module$input.MILLIS:return this.plusDays(MathUtil$$module$input.intDiv(a,LocalTime$$module$input.MILLIS_PER_DAY)).plusNanos(1E6*MathUtil$$module$input.intMod(a,LocalTime$$module$input.MILLIS_PER_DAY));case ChronoUnit$$module$input.SECONDS:return this.plusSeconds(a);case ChronoUnit$$module$input.MINUTES:return this.plusMinutes(a);case ChronoUnit$$module$input.HOURS:return this.plusHours(a);case ChronoUnit$$module$input.HALF_DAYS:return this.plusDays(MathUtil$$module$input.intDiv(a,
256)).plusHours(12*MathUtil$$module$input.intMod(a,256))}return this._withDateTime(this._date.plus(a,b),this._time)}return b.addTo(this,a)}},{key:"plusYears",value:function(a){a=this._date.plusYears(a);return this._withDateTime(a,this._time)}},{key:"plusMonths",value:function(a){a=this._date.plusMonths(a);return this._withDateTime(a,this._time)}},{key:"plusWeeks",value:function(a){a=this._date.plusWeeks(a);return this._withDateTime(a,this._time)}},{key:"plusDays",value:function(a){a=this._date.plusDays(a);
return this._withDateTime(a,this._time)}},{key:"plusHours",value:function(a){return this._plusWithOverflow(this._date,a,0,0,0,1)}},{key:"plusMinutes",value:function(a){return this._plusWithOverflow(this._date,0,a,0,0,1)}},{key:"plusSeconds",value:function(a){return this._plusWithOverflow(this._date,0,0,a,0,1)}},{key:"plusNanos",value:function(a){return this._plusWithOverflow(this._date,0,0,0,a,1)}},{key:"_minusUnit",value:function(a,b){requireNonNull$$module$input(b,"unit");return this._plusUnit(-1*
a,b)}},{key:"minusYears",value:function(a){return this.plusYears(-1*a)}},{key:"minusMonths",value:function(a){return this.plusMonths(-1*a)}},{key:"minusWeeks",value:function(a){return this.plusWeeks(-1*a)}},{key:"minusDays",value:function(a){return this.plusDays(-1*a)}},{key:"minusHours",value:function(a){return this._plusWithOverflow(this._date,a,0,0,0,-1)}},{key:"minusMinutes",value:function(a){return this._plusWithOverflow(this._date,0,a,0,0,-1)}},{key:"minusSeconds",value:function(a){return this._plusWithOverflow(this._date,
0,0,a,0,-1)}},{key:"minusNanos",value:function(a){return this._plusWithOverflow(this._date,0,0,0,a,-1)}},{key:"_plusWithOverflow",value:function(a,b,d,e,g,h){if(0===b&&0===d&&0===e&&0===g)return this._withDateTime(a,this._time);var c=MathUtil$$module$input.intDiv(g,LocalTime$$module$input.NANOS_PER_DAY)+MathUtil$$module$input.intDiv(e,LocalTime$$module$input.SECONDS_PER_DAY)+MathUtil$$module$input.intDiv(d,LocalTime$$module$input.MINUTES_PER_DAY)+MathUtil$$module$input.intDiv(b,LocalTime$$module$input.HOURS_PER_DAY);
c*=h;d=MathUtil$$module$input.intMod(g,LocalTime$$module$input.NANOS_PER_DAY)+MathUtil$$module$input.intMod(e,LocalTime$$module$input.SECONDS_PER_DAY)*LocalTime$$module$input.NANOS_PER_SECOND+MathUtil$$module$input.intMod(d,LocalTime$$module$input.MINUTES_PER_DAY)*LocalTime$$module$input.NANOS_PER_MINUTE+MathUtil$$module$input.intMod(b,LocalTime$$module$input.HOURS_PER_DAY)*LocalTime$$module$input.NANOS_PER_HOUR;b=this._time.toNanoOfDay();d=d*h+b;c+=MathUtil$$module$input.floorDiv(d,LocalTime$$module$input.NANOS_PER_DAY);
h=MathUtil$$module$input.floorMod(d,LocalTime$$module$input.NANOS_PER_DAY);h=h===b?this._time:LocalTime$$module$input.ofNanoOfDay(h);return this._withDateTime(a.plusDays(c),h)}},{key:"query",value:function(a){requireNonNull$$module$input(a,"query");return a===TemporalQueries$$module$input.localDate()?this.toLocalDate():_get$$module$input(_getPrototypeOf$$module$input(b.prototype),"query",this).call(this,a)}},{key:"adjustInto",value:function(a){return _get$$module$input(_getPrototypeOf$$module$input(b.prototype),
"adjustInto",this).call(this,a)}},{key:"until",value:function(a,c){requireNonNull$$module$input(a,"endExclusive");requireNonNull$$module$input(c,"unit");a=b.from(a);if(c instanceof ChronoUnit$$module$input){if(c.isTimeBased()){var d=this._date.daysUntil(a._date);a=a._time.toNanoOfDay()-this._time.toNanoOfDay();0<d&&0>a?(d--,a+=LocalTime$$module$input.NANOS_PER_DAY):0>d&&0<a&&(d++,a-=LocalTime$$module$input.NANOS_PER_DAY);switch(c){case ChronoUnit$$module$input.NANOS:return d=MathUtil$$module$input.safeMultiply(d,
LocalTime$$module$input.NANOS_PER_DAY),MathUtil$$module$input.safeAdd(d,a);case ChronoUnit$$module$input.MICROS:return d=MathUtil$$module$input.safeMultiply(d,LocalTime$$module$input.MICROS_PER_DAY),MathUtil$$module$input.safeAdd(d,MathUtil$$module$input.intDiv(a,1E3));case ChronoUnit$$module$input.MILLIS:return d=MathUtil$$module$input.safeMultiply(d,LocalTime$$module$input.MILLIS_PER_DAY),MathUtil$$module$input.safeAdd(d,MathUtil$$module$input.intDiv(a,1E6));case ChronoUnit$$module$input.SECONDS:return d=
MathUtil$$module$input.safeMultiply(d,LocalTime$$module$input.SECONDS_PER_DAY),MathUtil$$module$input.safeAdd(d,MathUtil$$module$input.intDiv(a,LocalTime$$module$input.NANOS_PER_SECOND));case ChronoUnit$$module$input.MINUTES:return d=MathUtil$$module$input.safeMultiply(d,LocalTime$$module$input.MINUTES_PER_DAY),MathUtil$$module$input.safeAdd(d,MathUtil$$module$input.intDiv(a,LocalTime$$module$input.NANOS_PER_MINUTE));case ChronoUnit$$module$input.HOURS:return d=MathUtil$$module$input.safeMultiply(d,
LocalTime$$module$input.HOURS_PER_DAY),MathUtil$$module$input.safeAdd(d,MathUtil$$module$input.intDiv(a,LocalTime$$module$input.NANOS_PER_HOUR));case ChronoUnit$$module$input.HALF_DAYS:return d=MathUtil$$module$input.safeMultiply(d,2),MathUtil$$module$input.safeAdd(d,MathUtil$$module$input.intDiv(a,12*LocalTime$$module$input.NANOS_PER_HOUR))}throw new UnsupportedTemporalTypeException$$module$input("Unsupported unit: ".concat(c));}d=a._date;a=a._time;d.isAfter(this._date)&&a.isBefore(this._time)?d=
d.minusDays(1):d.isBefore(this._date)&&a.isAfter(this._time)&&(d=d.plusDays(1));return this._date.until(d,c)}return c.between(this,a)}},{key:"atOffset",value:function(a){return OffsetDateTime$$module$input.of(this,a)}},{key:"atZone",value:function(a){return ZonedDateTime$$module$input.of(this,a)}},{key:"toLocalDate",value:function(){return this._date}},{key:"toLocalTime",value:function(){return this._time}},{key:"compareTo",value:function(a){requireNonNull$$module$input(a,"other");requireInstance$$module$input(a,
b,"other");return this._compareTo0(a)}},{key:"_compareTo0",value:function(a){var b=this._date.compareTo(a.toLocalDate());0===b&&(b=this._time.compareTo(a.toLocalTime()));return b}},{key:"isAfter",value:function(a){return 0<this.compareTo(a)}},{key:"isBefore",value:function(a){return 0>this.compareTo(a)}},{key:"isEqual",value:function(a){return 0===this.compareTo(a)}},{key:"equals",value:function(a){return this===a?!0:a instanceof b?this._date.equals(a._date)&&this._time.equals(a._time):!1}},{key:"hashCode",
value:function(){return this._date.hashCode()^this._time.hashCode()}},{key:"toString",value:function(){return"".concat(this._date.toString(),"T").concat(this._time.toString())}},{key:"toJSON",value:function(){return this.toString()}},{key:"format",value:function(a){requireNonNull$$module$input(a,"formatter");return a.format(this)}}],[{key:"now",value:function(a){return null==a?b._now(Clock$$module$input.systemDefaultZone()):a instanceof Clock$$module$input?b._now(a):b._now(Clock$$module$input.system(a))}},
{key:"_now",value:function(a){requireNonNull$$module$input(a,"clock");return b.ofInstant(a.instant(),a.zone())}},{key:"_ofEpochMillis",value:function(a,c){var d=MathUtil$$module$input.floorDiv(a,1E3)+c.totalSeconds();c=MathUtil$$module$input.floorDiv(d,LocalTime$$module$input.SECONDS_PER_DAY);d=MathUtil$$module$input.floorMod(d,LocalTime$$module$input.SECONDS_PER_DAY);a=1E6*MathUtil$$module$input.floorMod(a,1E3);c=LocalDate$$module$input.ofEpochDay(c);a=LocalTime$$module$input.ofSecondOfDay(d,a);
return new b(c,a)}},{key:"of",value:function(){return 2>=arguments.length?b.ofDateAndTime.apply(this,arguments):b.ofNumbers.apply(this,arguments)}},{key:"ofNumbers",value:function(a,c,d){var e=3<arguments.length&&void 0!==arguments[3]?arguments[3]:0,f=4<arguments.length&&void 0!==arguments[4]?arguments[4]:0,h=5<arguments.length&&void 0!==arguments[5]?arguments[5]:0,k=6<arguments.length&&void 0!==arguments[6]?arguments[6]:0,m=LocalDate$$module$input.of(a,c,d);e=LocalTime$$module$input.of(e,f,h,k);
return new b(m,e)}},{key:"ofDateAndTime",value:function(a,c){requireNonNull$$module$input(a,"date");requireNonNull$$module$input(c,"time");return new b(a,c)}},{key:"ofInstant",value:function(a){var c=1<arguments.length&&void 0!==arguments[1]?arguments[1]:ZoneId$$module$input.systemDefault();requireNonNull$$module$input(a,"instant");requireInstance$$module$input(a,Instant$$module$input,"instant");requireNonNull$$module$input(c,"zone");c=c.rules().offset(a);return b.ofEpochSecond(a.epochSecond(),a.nano(),
c)}},{key:"ofEpochSecond",value:function(){var a=0<arguments.length&&void 0!==arguments[0]?arguments[0]:0,c=1<arguments.length&&void 0!==arguments[1]?arguments[1]:0,d=2<arguments.length?arguments[2]:void 0;2===arguments.length&&c instanceof ZoneOffset$$module$input&&(d=c,c=0);requireNonNull$$module$input(d,"offset");d=a+d.totalSeconds();a=MathUtil$$module$input.floorDiv(d,LocalTime$$module$input.SECONDS_PER_DAY);d=MathUtil$$module$input.floorMod(d,LocalTime$$module$input.SECONDS_PER_DAY);a=LocalDate$$module$input.ofEpochDay(a);
c=LocalTime$$module$input.ofSecondOfDay(d,c);return new b(a,c)}},{key:"from",value:function(a){requireNonNull$$module$input(a,"temporal");if(a instanceof b)return a;if(a instanceof ZonedDateTime$$module$input)return a.toLocalDateTime();try{var c=LocalDate$$module$input.from(a),d=LocalTime$$module$input.from(a);return new b(c,d)}catch(l){throw new DateTimeException$$module$input("Unable to obtain LocalDateTime TemporalAccessor: ".concat(a,", type ").concat(null!=a.constructor?a.constructor.name:""));
}}},{key:"parse",value:function(a){var c=1<arguments.length&&void 0!==arguments[1]?arguments[1]:DateTimeFormatter$$module$input.ISO_LOCAL_DATE_TIME;requireNonNull$$module$input(c,"formatter");return c.parse(a,b.FROM)}}]);return b}(ChronoLocalDateTime$$module$input);
function _init$j$$module$input(){LocalDateTime$$module$input.MIN=LocalDateTime$$module$input.of(LocalDate$$module$input.MIN,LocalTime$$module$input.MIN);LocalDateTime$$module$input.MAX=LocalDateTime$$module$input.of(LocalDate$$module$input.MAX,LocalTime$$module$input.MAX);LocalDateTime$$module$input.FROM=createTemporalQuery$$module$input("LocalDateTime.FROM",function(e){return LocalDateTime$$module$input.from(e)})}
var LocalTime$$module$input=function(e){function b(){var a=0<arguments.length&&void 0!==arguments[0]?arguments[0]:0,c=1<arguments.length&&void 0!==arguments[1]?arguments[1]:0,e=2<arguments.length&&void 0!==arguments[2]?arguments[2]:0,l=3<arguments.length&&void 0!==arguments[3]?arguments[3]:0;_classCallCheck$$module$input(this,b);var g=d.call(this);a=MathUtil$$module$input.safeToInt(a);c=MathUtil$$module$input.safeToInt(c);e=MathUtil$$module$input.safeToInt(e);l=MathUtil$$module$input.safeToInt(l);
b._validate(a,c,e,l);if(0===c&&0===e&&0===l)return b.HOURS[a]||(g._hour=a,g._minute=c,g._second=e,g._nano=l,b.HOURS[a]=_assertThisInitialized$$module$input(g)),_possibleConstructorReturn$$module$input(g,b.HOURS[a]);g._hour=a;g._minute=c;g._second=e;g._nano=l;return g}_inherits$$module$input(b,e);var d=_createSuper$$module$input(b);_createClass$$module$input(b,[{key:"isSupported",value:function(a){return a instanceof ChronoField$$module$input||a instanceof ChronoUnit$$module$input?a.isTimeBased():
null!=a&&a.isSupportedBy(this)}},{key:"range",value:function(a){requireNonNull$$module$input(a);return _get$$module$input(_getPrototypeOf$$module$input(b.prototype),"range",this).call(this,a)}},{key:"get",value:function(a){return this.getLong(a)}},{key:"getLong",value:function(a){requireNonNull$$module$input(a,"field");return a instanceof ChronoField$$module$input?this._get0(a):a.getFrom(this)}},{key:"_get0",value:function(a){switch(a){case ChronoField$$module$input.NANO_OF_SECOND:return this._nano;
case ChronoField$$module$input.NANO_OF_DAY:return this.toNanoOfDay();case ChronoField$$module$input.MICRO_OF_SECOND:return MathUtil$$module$input.intDiv(this._nano,1E3);case ChronoField$$module$input.MICRO_OF_DAY:return MathUtil$$module$input.intDiv(this.toNanoOfDay(),1E3);case ChronoField$$module$input.MILLI_OF_SECOND:return MathUtil$$module$input.intDiv(this._nano,1E6);case ChronoField$$module$input.MILLI_OF_DAY:return MathUtil$$module$input.intDiv(this.toNanoOfDay(),1E6);case ChronoField$$module$input.SECOND_OF_MINUTE:return this._second;
case ChronoField$$module$input.SECOND_OF_DAY:return this.toSecondOfDay();case ChronoField$$module$input.MINUTE_OF_HOUR:return this._minute;case ChronoField$$module$input.MINUTE_OF_DAY:return 60*this._hour+this._minute;case ChronoField$$module$input.HOUR_OF_AMPM:return MathUtil$$module$input.intMod(this._hour,12);case ChronoField$$module$input.CLOCK_HOUR_OF_AMPM:return a=MathUtil$$module$input.intMod(this._hour,12),0===a%12?12:a;case ChronoField$$module$input.HOUR_OF_DAY:return this._hour;case ChronoField$$module$input.CLOCK_HOUR_OF_DAY:return 0===
this._hour?24:this._hour;case ChronoField$$module$input.AMPM_OF_DAY:return MathUtil$$module$input.intDiv(this._hour,12)}throw new UnsupportedTemporalTypeException$$module$input("Unsupported field: ".concat(a));}},{key:"hour",value:function(){return this._hour}},{key:"minute",value:function(){return this._minute}},{key:"second",value:function(){return this._second}},{key:"nano",value:function(){return this._nano}},{key:"_withAdjuster",value:function(a){requireNonNull$$module$input(a,"adjuster");return a instanceof
b?a:_get$$module$input(_getPrototypeOf$$module$input(b.prototype),"_withAdjuster",this).call(this,a)}},{key:"_withField",value:function(a,c){requireNonNull$$module$input(a,"field");requireInstance$$module$input(a,TemporalField$$module$input,"field");if(a instanceof ChronoField$$module$input){a.checkValidValue(c);switch(a){case ChronoField$$module$input.NANO_OF_SECOND:return this.withNano(c);case ChronoField$$module$input.NANO_OF_DAY:return b.ofNanoOfDay(c);case ChronoField$$module$input.MICRO_OF_SECOND:return this.withNano(1E3*
c);case ChronoField$$module$input.MICRO_OF_DAY:return b.ofNanoOfDay(1E3*c);case ChronoField$$module$input.MILLI_OF_SECOND:return this.withNano(1E6*c);case ChronoField$$module$input.MILLI_OF_DAY:return b.ofNanoOfDay(1E6*c);case ChronoField$$module$input.SECOND_OF_MINUTE:return this.withSecond(c);case ChronoField$$module$input.SECOND_OF_DAY:return this.plusSeconds(c-this.toSecondOfDay());case ChronoField$$module$input.MINUTE_OF_HOUR:return this.withMinute(c);case ChronoField$$module$input.MINUTE_OF_DAY:return this.plusMinutes(c-
(60*this._hour+this._minute));case ChronoField$$module$input.HOUR_OF_AMPM:return this.plusHours(c-MathUtil$$module$input.intMod(this._hour,12));case ChronoField$$module$input.CLOCK_HOUR_OF_AMPM:return this.plusHours((12===c?0:c)-MathUtil$$module$input.intMod(this._hour,12));case ChronoField$$module$input.HOUR_OF_DAY:return this.withHour(c);case ChronoField$$module$input.CLOCK_HOUR_OF_DAY:return this.withHour(24===c?0:c);case ChronoField$$module$input.AMPM_OF_DAY:return this.plusHours(12*(c-MathUtil$$module$input.intDiv(this._hour,
12)))}throw new UnsupportedTemporalTypeException$$module$input("Unsupported field: ".concat(a));}return a.adjustInto(this,c)}},{key:"withHour",value:function(){var a=0<arguments.length&&void 0!==arguments[0]?arguments[0]:0;return this._hour===a?this:new b(a,this._minute,this._second,this._nano)}},{key:"withMinute",value:function(){var a=0<arguments.length&&void 0!==arguments[0]?arguments[0]:0;return this._minute===a?this:new b(this._hour,a,this._second,this._nano)}},{key:"withSecond",value:function(){var a=
0<arguments.length&&void 0!==arguments[0]?arguments[0]:0;return this._second===a?this:new b(this._hour,this._minute,a,this._nano)}},{key:"withNano",value:function(){var a=0<arguments.length&&void 0!==arguments[0]?arguments[0]:0;return this._nano===a?this:new b(this._hour,this._minute,this._second,a)}},{key:"truncatedTo",value:function(a){requireNonNull$$module$input(a,"unit");if(a===ChronoUnit$$module$input.NANOS)return this;a=a.duration();if(a.seconds()>b.SECONDS_PER_DAY)throw new DateTimeException$$module$input("Unit is too large to be used for truncation");
a=a.toNanos();if(0!==MathUtil$$module$input.intMod(b.NANOS_PER_DAY,a))throw new DateTimeException$$module$input("Unit must divide into a standard day without remainder");var c=this.toNanoOfDay();return b.ofNanoOfDay(MathUtil$$module$input.intDiv(c,a)*a)}},{key:"_plusUnit",value:function(a,c){requireNonNull$$module$input(c,"unit");if(c instanceof ChronoUnit$$module$input){switch(c){case ChronoUnit$$module$input.NANOS:return this.plusNanos(a);case ChronoUnit$$module$input.MICROS:return this.plusNanos(1E3*
MathUtil$$module$input.intMod(a,b.MICROS_PER_DAY));case ChronoUnit$$module$input.MILLIS:return this.plusNanos(1E6*MathUtil$$module$input.intMod(a,b.MILLIS_PER_DAY));case ChronoUnit$$module$input.SECONDS:return this.plusSeconds(a);case ChronoUnit$$module$input.MINUTES:return this.plusMinutes(a);case ChronoUnit$$module$input.HOURS:return this.plusHours(a);case ChronoUnit$$module$input.HALF_DAYS:return this.plusHours(12*MathUtil$$module$input.intMod(a,2))}throw new UnsupportedTemporalTypeException$$module$input("Unsupported unit: ".concat(c));
}return c.addTo(this,a)}},{key:"plusHours",value:function(a){if(0===a)return this;a=MathUtil$$module$input.intMod(MathUtil$$module$input.intMod(a,b.HOURS_PER_DAY)+this._hour+b.HOURS_PER_DAY,b.HOURS_PER_DAY);return new b(a,this._minute,this._second,this._nano)}},{key:"plusMinutes",value:function(a){if(0===a)return this;var c=this._hour*b.MINUTES_PER_HOUR+this._minute;a=MathUtil$$module$input.intMod(MathUtil$$module$input.intMod(a,b.MINUTES_PER_DAY)+c+b.MINUTES_PER_DAY,b.MINUTES_PER_DAY);if(c===a)return this;
c=MathUtil$$module$input.intDiv(a,b.MINUTES_PER_HOUR);a=MathUtil$$module$input.intMod(a,b.MINUTES_PER_HOUR);return new b(c,a,this._second,this._nano)}},{key:"plusSeconds",value:function(a){if(0===a)return this;var c=this._hour*b.SECONDS_PER_HOUR+this._minute*b.SECONDS_PER_MINUTE+this._second;a=MathUtil$$module$input.intMod(MathUtil$$module$input.intMod(a,b.SECONDS_PER_DAY)+c+b.SECONDS_PER_DAY,b.SECONDS_PER_DAY);if(c===a)return this;c=MathUtil$$module$input.intDiv(a,b.SECONDS_PER_HOUR);var d=MathUtil$$module$input.intMod(MathUtil$$module$input.intDiv(a,
b.SECONDS_PER_MINUTE),b.MINUTES_PER_HOUR);a=MathUtil$$module$input.intMod(a,b.SECONDS_PER_MINUTE);return new b(c,d,a,this._nano)}},{key:"plusNanos",value:function(a){if(0===a)return this;var c=this.toNanoOfDay();a=MathUtil$$module$input.intMod(MathUtil$$module$input.intMod(a,b.NANOS_PER_DAY)+c+b.NANOS_PER_DAY,b.NANOS_PER_DAY);if(c===a)return this;c=MathUtil$$module$input.intDiv(a,b.NANOS_PER_HOUR);var d=MathUtil$$module$input.intMod(MathUtil$$module$input.intDiv(a,b.NANOS_PER_MINUTE),b.MINUTES_PER_HOUR),
e=MathUtil$$module$input.intMod(MathUtil$$module$input.intDiv(a,b.NANOS_PER_SECOND),b.SECONDS_PER_MINUTE);a=MathUtil$$module$input.intMod(a,b.NANOS_PER_SECOND);return new b(c,d,e,a)}},{key:"_minusUnit",value:function(a,b){requireNonNull$$module$input(b,"unit");return this._plusUnit(-1*a,b)}},{key:"minusHours",value:function(a){return this.plusHours(-1*MathUtil$$module$input.intMod(a,b.HOURS_PER_DAY))}},{key:"minusMinutes",value:function(a){return this.plusMinutes(-1*MathUtil$$module$input.intMod(a,
b.MINUTES_PER_DAY))}},{key:"minusSeconds",value:function(a){return this.plusSeconds(-1*MathUtil$$module$input.intMod(a,b.SECONDS_PER_DAY))}},{key:"minusNanos",value:function(a){return this.plusNanos(-1*MathUtil$$module$input.intMod(a,b.NANOS_PER_DAY))}},{key:"query",value:function(a){requireNonNull$$module$input(a,"query");return a===TemporalQueries$$module$input.precision()?ChronoUnit$$module$input.NANOS:a===TemporalQueries$$module$input.localTime()?this:a===TemporalQueries$$module$input.chronology()||
a===TemporalQueries$$module$input.zoneId()||a===TemporalQueries$$module$input.zone()||a===TemporalQueries$$module$input.offset()||a===TemporalQueries$$module$input.localDate()?null:a.queryFrom(this)}},{key:"adjustInto",value:function(a){return a.with(b.NANO_OF_DAY,this.toNanoOfDay())}},{key:"until",value:function(a,c){requireNonNull$$module$input(a,"endExclusive");requireNonNull$$module$input(c,"unit");a=b.from(a);if(c instanceof ChronoUnit$$module$input){a=a.toNanoOfDay()-this.toNanoOfDay();switch(c){case ChronoUnit$$module$input.NANOS:return a;
case ChronoUnit$$module$input.MICROS:return MathUtil$$module$input.intDiv(a,1E3);case ChronoUnit$$module$input.MILLIS:return MathUtil$$module$input.intDiv(a,1E6);case ChronoUnit$$module$input.SECONDS:return MathUtil$$module$input.intDiv(a,b.NANOS_PER_SECOND);case ChronoUnit$$module$input.MINUTES:return MathUtil$$module$input.intDiv(a,b.NANOS_PER_MINUTE);case ChronoUnit$$module$input.HOURS:return MathUtil$$module$input.intDiv(a,b.NANOS_PER_HOUR);case ChronoUnit$$module$input.HALF_DAYS:return MathUtil$$module$input.intDiv(a,
12*b.NANOS_PER_HOUR)}throw new UnsupportedTemporalTypeException$$module$input("Unsupported unit: ".concat(c));}return c.between(this,a)}},{key:"atDate",value:function(a){return LocalDateTime$$module$input.of(a,this)}},{key:"atOffset",value:function(a){return OffsetTime$$module$input.of(this,a)}},{key:"toSecondOfDay",value:function(){var a=this._hour*b.SECONDS_PER_HOUR;a+=this._minute*b.SECONDS_PER_MINUTE;return a+=this._second}},{key:"toNanoOfDay",value:function(){var a=this._hour*b.NANOS_PER_HOUR;
a+=this._minute*b.NANOS_PER_MINUTE;a+=this._second*b.NANOS_PER_SECOND;return a+=this._nano}},{key:"compareTo",value:function(a){requireNonNull$$module$input(a,"other");requireInstance$$module$input(a,b,"other");var c=MathUtil$$module$input.compareNumbers(this._hour,a._hour);0===c&&(c=MathUtil$$module$input.compareNumbers(this._minute,a._minute),0===c&&(c=MathUtil$$module$input.compareNumbers(this._second,a._second),0===c&&(c=MathUtil$$module$input.compareNumbers(this._nano,a._nano))));return c}},
{key:"isAfter",value:function(a){return 0<this.compareTo(a)}},{key:"isBefore",value:function(a){return 0>this.compareTo(a)}},{key:"equals",value:function(a){return this===a?!0:a instanceof b?this._hour===a._hour&&this._minute===a._minute&&this._second===a._second&&this._nano===a._nano:!1}},{key:"hashCode",value:function(){var a=this.toNanoOfDay();return MathUtil$$module$input.hash(a)}},{key:"toString",value:function(){var a=this._hour;var b=this._minute,d=this._second,e=this._nano;a=(10>a?"0":"")+
a+(10>b?":0":":")+b;if(0<d||0<e)a+=10>d?":0":":",a+=d,0<e&&(a+=".",a=0===MathUtil$$module$input.intMod(e,1E6)?a+"".concat(MathUtil$$module$input.intDiv(e,1E6)+1E3).substring(1):0===MathUtil$$module$input.intMod(e,1E3)?a+"".concat(MathUtil$$module$input.intDiv(e,1E3)+1E6).substring(1):a+"".concat(e+1E9).substring(1));return a}},{key:"toJSON",value:function(){return this.toString()}},{key:"format",value:function(a){requireNonNull$$module$input(a,"formatter");return a.format(this)}}],[{key:"now",value:function(a){return null==
a?b._now(Clock$$module$input.systemDefaultZone()):a instanceof Clock$$module$input?b._now(a):b._now(Clock$$module$input.system(a))}},{key:"_now",value:function(){var a=0<arguments.length&&void 0!==arguments[0]?arguments[0]:Clock$$module$input.systemDefaultZone();requireNonNull$$module$input(a,"clock");return b.ofInstant(a.instant(),a.zone())}},{key:"ofInstant",value:function(a){var c=(1<arguments.length&&void 0!==arguments[1]?arguments[1]:ZoneId$$module$input.systemDefault()).rules().offset(a),d=
MathUtil$$module$input.intMod(a.epochSecond(),b.SECONDS_PER_DAY);d=MathUtil$$module$input.intMod(d+c.totalSeconds(),b.SECONDS_PER_DAY);0>d&&(d+=b.SECONDS_PER_DAY);return b.ofSecondOfDay(d,a.nano())}},{key:"of",value:function(a,c,d,e){return new b(a,c,d,e)}},{key:"ofSecondOfDay",value:function(){var a=0<arguments.length&&void 0!==arguments[0]?arguments[0]:0,c=1<arguments.length&&void 0!==arguments[1]?arguments[1]:0;ChronoField$$module$input.SECOND_OF_DAY.checkValidValue(a);ChronoField$$module$input.NANO_OF_SECOND.checkValidValue(c);
var d=MathUtil$$module$input.intDiv(a,b.SECONDS_PER_HOUR);a-=d*b.SECONDS_PER_HOUR;var e=MathUtil$$module$input.intDiv(a,b.SECONDS_PER_MINUTE);a-=e*b.SECONDS_PER_MINUTE;return new b(d,e,a,c)}},{key:"ofNanoOfDay",value:function(){var a=0<arguments.length&&void 0!==arguments[0]?arguments[0]:0;ChronoField$$module$input.NANO_OF_DAY.checkValidValue(a);var c=MathUtil$$module$input.intDiv(a,b.NANOS_PER_HOUR);a-=c*b.NANOS_PER_HOUR;var d=MathUtil$$module$input.intDiv(a,b.NANOS_PER_MINUTE);a-=d*b.NANOS_PER_MINUTE;
var e=MathUtil$$module$input.intDiv(a,b.NANOS_PER_SECOND);a-=e*b.NANOS_PER_SECOND;return new b(c,d,e,a)}},{key:"from",value:function(a){requireNonNull$$module$input(a,"temporal");var b=a.query(TemporalQueries$$module$input.localTime());if(null==b)throw new DateTimeException$$module$input("Unable to obtain LocalTime TemporalAccessor: ".concat(a,", type ").concat(null!=a.constructor?a.constructor.name:""));return b}},{key:"parse",value:function(a){var c=1<arguments.length&&void 0!==arguments[1]?arguments[1]:
DateTimeFormatter$$module$input.ISO_LOCAL_TIME;requireNonNull$$module$input(c,"formatter");return c.parse(a,b.FROM)}},{key:"_validate",value:function(a,b,d,e){ChronoField$$module$input.HOUR_OF_DAY.checkValidValue(a);ChronoField$$module$input.MINUTE_OF_HOUR.checkValidValue(b);ChronoField$$module$input.SECOND_OF_MINUTE.checkValidValue(d);ChronoField$$module$input.NANO_OF_SECOND.checkValidValue(e)}}]);return b}(Temporal$$module$input);
function _init$k$$module$input(){LocalTime$$module$input.HOURS=[];for(var e=0;24>e;e++)LocalTime$$module$input.of(e,0,0,0);LocalTime$$module$input.MIN=LocalTime$$module$input.HOURS[0];LocalTime$$module$input.MAX=new LocalTime$$module$input(23,59,59,999999999);LocalTime$$module$input.MIDNIGHT=LocalTime$$module$input.HOURS[0];LocalTime$$module$input.NOON=LocalTime$$module$input.HOURS[12];LocalTime$$module$input.FROM=createTemporalQuery$$module$input("LocalTime.FROM",function(b){return LocalTime$$module$input.from(b)})}
LocalTime$$module$input.HOURS_PER_DAY=24;LocalTime$$module$input.MINUTES_PER_HOUR=60;LocalTime$$module$input.MINUTES_PER_DAY=LocalTime$$module$input.MINUTES_PER_HOUR*LocalTime$$module$input.HOURS_PER_DAY;LocalTime$$module$input.SECONDS_PER_MINUTE=60;LocalTime$$module$input.SECONDS_PER_HOUR=LocalTime$$module$input.SECONDS_PER_MINUTE*LocalTime$$module$input.MINUTES_PER_HOUR;LocalTime$$module$input.SECONDS_PER_DAY=LocalTime$$module$input.SECONDS_PER_HOUR*LocalTime$$module$input.HOURS_PER_DAY;
LocalTime$$module$input.MILLIS_PER_DAY=1E3*LocalTime$$module$input.SECONDS_PER_DAY;LocalTime$$module$input.MICROS_PER_DAY=1E6*LocalTime$$module$input.SECONDS_PER_DAY;LocalTime$$module$input.NANOS_PER_SECOND=1E9;LocalTime$$module$input.NANOS_PER_MINUTE=LocalTime$$module$input.NANOS_PER_SECOND*LocalTime$$module$input.SECONDS_PER_MINUTE;LocalTime$$module$input.NANOS_PER_HOUR=LocalTime$$module$input.NANOS_PER_MINUTE*LocalTime$$module$input.MINUTES_PER_HOUR;
LocalTime$$module$input.NANOS_PER_DAY=LocalTime$$module$input.NANOS_PER_HOUR*LocalTime$$module$input.HOURS_PER_DAY;
var NANOS_PER_MILLI$$module$input=1E6,Instant$$module$input=function(e){function b(a,c){_classCallCheck$$module$input(this,b);var e=d.call(this);b._validate(a,c);e._seconds=MathUtil$$module$input.safeToInt(a);e._nanos=MathUtil$$module$input.safeToInt(c);return e}_inherits$$module$input(b,e);var d=_createSuper$$module$input(b);_createClass$$module$input(b,[{key:"isSupported",value:function(a){return a instanceof ChronoField$$module$input?a===ChronoField$$module$input.INSTANT_SECONDS||a===ChronoField$$module$input.NANO_OF_SECOND||
a===ChronoField$$module$input.MICRO_OF_SECOND||a===ChronoField$$module$input.MILLI_OF_SECOND:a instanceof ChronoUnit$$module$input?a.isTimeBased()||a===ChronoUnit$$module$input.DAYS:null!=a&&a.isSupportedBy(this)}},{key:"range",value:function(a){return _get$$module$input(_getPrototypeOf$$module$input(b.prototype),"range",this).call(this,a)}},{key:"get",value:function(a){return this.getLong(a)}},{key:"getLong",value:function(a){if(a instanceof ChronoField$$module$input){switch(a){case ChronoField$$module$input.NANO_OF_SECOND:return this._nanos;
case ChronoField$$module$input.MICRO_OF_SECOND:return MathUtil$$module$input.intDiv(this._nanos,1E3);case ChronoField$$module$input.MILLI_OF_SECOND:return MathUtil$$module$input.intDiv(this._nanos,NANOS_PER_MILLI$$module$input);case ChronoField$$module$input.INSTANT_SECONDS:return this._seconds}throw new UnsupportedTemporalTypeException$$module$input("Unsupported field: ".concat(a));}return a.getFrom(this)}},{key:"epochSecond",value:function(){return this._seconds}},{key:"nano",value:function(){return this._nanos}},
{key:"_withField",value:function(a,c){requireNonNull$$module$input(a,"field");if(a instanceof ChronoField$$module$input){a.checkValidValue(c);switch(a){case ChronoField$$module$input.MILLI_OF_SECOND:return a=c*NANOS_PER_MILLI$$module$input,a!==this._nanos?b._create(this._seconds,a):this;case ChronoField$$module$input.MICRO_OF_SECOND:return a=1E3*c,a!==this._nanos?b._create(this._seconds,a):this;case ChronoField$$module$input.NANO_OF_SECOND:return c!==this._nanos?b._create(this._seconds,c):this;case ChronoField$$module$input.INSTANT_SECONDS:return c!==
this._seconds?b._create(c,this._nanos):this}throw new UnsupportedTemporalTypeException$$module$input("Unsupported field: ".concat(a));}return a.adjustInto(this,c)}},{key:"truncatedTo",value:function(a){requireNonNull$$module$input(a,"unit");if(a===ChronoUnit$$module$input.NANOS)return this;a=a.duration();if(a.seconds()>LocalTime$$module$input.SECONDS_PER_DAY)throw new DateTimeException$$module$input("Unit is too large to be used for truncation");var b=a.toNanos();if(0!==MathUtil$$module$input.intMod(LocalTime$$module$input.NANOS_PER_DAY,
b))throw new DateTimeException$$module$input("Unit must divide into a standard day without remainder");a=MathUtil$$module$input.intMod(this._seconds,LocalTime$$module$input.SECONDS_PER_DAY)*LocalTime$$module$input.NANOS_PER_SECOND+this._nanos;b*=MathUtil$$module$input.intDiv(a,b);return this.plusNanos(b-a)}},{key:"_plusUnit",value:function(a,b){requireNonNull$$module$input(a,"amountToAdd");requireNonNull$$module$input(b,"unit");requireInstance$$module$input(b,TemporalUnit$$module$input);if(b instanceof
ChronoUnit$$module$input){switch(b){case ChronoUnit$$module$input.NANOS:return this.plusNanos(a);case ChronoUnit$$module$input.MICROS:return this._plus(MathUtil$$module$input.intDiv(a,1E6),1E3*MathUtil$$module$input.intMod(a,1E6));case ChronoUnit$$module$input.MILLIS:return this.plusMillis(a);case ChronoUnit$$module$input.SECONDS:return this.plusSeconds(a);case ChronoUnit$$module$input.MINUTES:return this.plusSeconds(MathUtil$$module$input.safeMultiply(a,LocalTime$$module$input.SECONDS_PER_MINUTE));
case ChronoUnit$$module$input.HOURS:return this.plusSeconds(MathUtil$$module$input.safeMultiply(a,LocalTime$$module$input.SECONDS_PER_HOUR));case ChronoUnit$$module$input.HALF_DAYS:return this.plusSeconds(MathUtil$$module$input.safeMultiply(a,LocalTime$$module$input.SECONDS_PER_DAY/2));case ChronoUnit$$module$input.DAYS:return this.plusSeconds(MathUtil$$module$input.safeMultiply(a,LocalTime$$module$input.SECONDS_PER_DAY))}throw new UnsupportedTemporalTypeException$$module$input("Unsupported unit: ".concat(b));
}return b.addTo(this,a)}},{key:"plusSeconds",value:function(a){return this._plus(a,0)}},{key:"plusMillis",value:function(a){return this._plus(MathUtil$$module$input.intDiv(a,1E3),MathUtil$$module$input.intMod(a,1E3)*NANOS_PER_MILLI$$module$input)}},{key:"plusNanos",value:function(a){return this._plus(0,a)}},{key:"_plus",value:function(a,c){if(0===a&&0===c)return this;a=this._seconds+a;a+=MathUtil$$module$input.intDiv(c,LocalTime$$module$input.NANOS_PER_SECOND);return b.ofEpochSecond(a,this._nanos+
c%LocalTime$$module$input.NANOS_PER_SECOND)}},{key:"_minusUnit",value:function(a,b){return this._plusUnit(-1*a,b)}},{key:"minusSeconds",value:function(a){return this.plusSeconds(-1*a)}},{key:"minusMillis",value:function(a){return this.plusMillis(-1*a)}},{key:"minusNanos",value:function(a){return this.plusNanos(-1*a)}},{key:"query",value:function(a){requireNonNull$$module$input(a,"query");return a===TemporalQueries$$module$input.precision()?ChronoUnit$$module$input.NANOS:a===TemporalQueries$$module$input.localDate()||
a===TemporalQueries$$module$input.localTime()||a===TemporalQueries$$module$input.chronology()||a===TemporalQueries$$module$input.zoneId()||a===TemporalQueries$$module$input.zone()||a===TemporalQueries$$module$input.offset()?null:a.queryFrom(this)}},{key:"adjustInto",value:function(a){requireNonNull$$module$input(a,"temporal");return a.with(ChronoField$$module$input.INSTANT_SECONDS,this._seconds).with(ChronoField$$module$input.NANO_OF_SECOND,this._nanos)}},{key:"until",value:function(a,c){requireNonNull$$module$input(a,
"endExclusive");requireNonNull$$module$input(c,"unit");a=b.from(a);if(c instanceof ChronoUnit$$module$input){switch(c){case ChronoUnit$$module$input.NANOS:return this._nanosUntil(a);case ChronoUnit$$module$input.MICROS:return this._microsUntil(a);case ChronoUnit$$module$input.MILLIS:return MathUtil$$module$input.safeSubtract(a.toEpochMilli(),this.toEpochMilli());case ChronoUnit$$module$input.SECONDS:return this._secondsUntil(a);case ChronoUnit$$module$input.MINUTES:return MathUtil$$module$input.intDiv(this._secondsUntil(a),
LocalTime$$module$input.SECONDS_PER_MINUTE);case ChronoUnit$$module$input.HOURS:return MathUtil$$module$input.intDiv(this._secondsUntil(a),LocalTime$$module$input.SECONDS_PER_HOUR);case ChronoUnit$$module$input.HALF_DAYS:return MathUtil$$module$input.intDiv(this._secondsUntil(a),12*LocalTime$$module$input.SECONDS_PER_HOUR);case ChronoUnit$$module$input.DAYS:return MathUtil$$module$input.intDiv(this._secondsUntil(a),LocalTime$$module$input.SECONDS_PER_DAY)}throw new UnsupportedTemporalTypeException$$module$input("Unsupported unit: ".concat(c));
}return c.between(this,a)}},{key:"_microsUntil",value:function(a){var b=MathUtil$$module$input.safeSubtract(a.epochSecond(),this.epochSecond());b=MathUtil$$module$input.safeMultiply(b,1E6);return MathUtil$$module$input.safeAdd(b,MathUtil$$module$input.intDiv(a.nano()-this.nano(),1E3))}},{key:"_nanosUntil",value:function(a){var b=MathUtil$$module$input.safeSubtract(a.epochSecond(),this.epochSecond());b=MathUtil$$module$input.safeMultiply(b,LocalTime$$module$input.NANOS_PER_SECOND);return MathUtil$$module$input.safeAdd(b,
a.nano()-this.nano())}},{key:"_secondsUntil",value:function(a){var b=MathUtil$$module$input.safeSubtract(a.epochSecond(),this.epochSecond());a=a.nano()-this.nano();0<b&&0>a?b--:0>b&&0<a&&b++;return b}},{key:"atOffset",value:function(a){return OffsetDateTime$$module$input.ofInstant(this,a)}},{key:"atZone",value:function(a){return ZonedDateTime$$module$input.ofInstant(this,a)}},{key:"toEpochMilli",value:function(){return MathUtil$$module$input.safeMultiply(this._seconds,1E3)+MathUtil$$module$input.intDiv(this._nanos,
NANOS_PER_MILLI$$module$input)}},{key:"compareTo",value:function(a){requireNonNull$$module$input(a,"otherInstant");requireInstance$$module$input(a,b,"otherInstant");var c=MathUtil$$module$input.compareNumbers(this._seconds,a._seconds);return 0!==c?c:this._nanos-a._nanos}},{key:"isAfter",value:function(a){return 0<this.compareTo(a)}},{key:"isBefore",value:function(a){return 0>this.compareTo(a)}},{key:"equals",value:function(a){return this===a?!0:a instanceof b?this.epochSecond()===a.epochSecond()&&
this.nano()===a.nano():!1}},{key:"hashCode",value:function(){return MathUtil$$module$input.hashCode(this._seconds,this._nanos)}},{key:"toString",value:function(){return DateTimeFormatter$$module$input.ISO_INSTANT.format(this)}},{key:"toJSON",value:function(){return this.toString()}}],[{key:"now",value:function(){return(0<arguments.length&&void 0!==arguments[0]?arguments[0]:Clock$$module$input.systemUTC()).instant()}},{key:"ofEpochSecond",value:function(a){var c=1<arguments.length&&void 0!==arguments[1]?
arguments[1]:0,d=a+MathUtil$$module$input.floorDiv(c,LocalTime$$module$input.NANOS_PER_SECOND);c=MathUtil$$module$input.floorMod(c,LocalTime$$module$input.NANOS_PER_SECOND);return b._create(d,c)}},{key:"ofEpochMilli",value:function(a){var c=MathUtil$$module$input.floorDiv(a,1E3);a=MathUtil$$module$input.floorMod(a,1E3);return b._create(c,1E6*a)}},{key:"from",value:function(a){try{var c=a.getLong(ChronoField$$module$input.INSTANT_SECONDS),d=a.get(ChronoField$$module$input.NANO_OF_SECOND);return b.ofEpochSecond(c,
d)}catch(l){throw new DateTimeException$$module$input("Unable to obtain Instant from TemporalAccessor: ".concat(a,", type ").concat(_typeof$$module$input(a)),l);}}},{key:"parse",value:function(a){return DateTimeFormatter$$module$input.ISO_INSTANT.parse(a,b.FROM)}},{key:"_create",value:function(a,c){return 0===a&&0===c?b.EPOCH:new b(a,c)}},{key:"_validate",value:function(a,c){if(a<b.MIN_SECONDS||a>b.MAX_SECONDS)throw new DateTimeException$$module$input("Instant exceeds minimum or maximum instant");
if(0>c||c>LocalTime$$module$input.NANOS_PER_SECOND)throw new DateTimeException$$module$input("Instant exceeds minimum or maximum instant");}}]);return b}(Temporal$$module$input);
function _init$l$$module$input(){Instant$$module$input.MIN_SECONDS=-31619119219200;Instant$$module$input.MAX_SECONDS=31494816403199;Instant$$module$input.EPOCH=new Instant$$module$input(0,0);Instant$$module$input.MIN=Instant$$module$input.ofEpochSecond(Instant$$module$input.MIN_SECONDS,0);Instant$$module$input.MAX=Instant$$module$input.ofEpochSecond(Instant$$module$input.MAX_SECONDS,999999999);Instant$$module$input.FROM=createTemporalQuery$$module$input("Instant.FROM",function(e){return Instant$$module$input.from(e)})}
var Clock$$module$input=function(){function e(){_classCallCheck$$module$input(this,e)}_createClass$$module$input(e,[{key:"millis",value:function(){abstractMethodFail$$module$input("Clock.millis")}},{key:"instant",value:function(){abstractMethodFail$$module$input("Clock.instant")}},{key:"zone",value:function(){abstractMethodFail$$module$input("Clock.zone")}},{key:"withZone",value:function(){abstractMethodFail$$module$input("Clock.withZone")}}],[{key:"systemUTC",value:function(){return new SystemClock$$module$input(ZoneOffset$$module$input.UTC)}},
{key:"systemDefaultZone",value:function(){return new SystemClock$$module$input(ZoneId$$module$input.systemDefault())}},{key:"system",value:function(b){return new SystemClock$$module$input(b)}},{key:"fixed",value:function(b,d){return new FixedClock$$module$input(b,d)}},{key:"offset",value:function(b,d){return new OffsetClock$$module$input(b,d)}}]);return e}(),SystemClock$$module$input=function(e){function b(a){_classCallCheck$$module$input(this,b);requireNonNull$$module$input(a,"zone");var c=d.call(this);
c._zone=a;return c}_inherits$$module$input(b,e);var d=_createSuper$$module$input(b);_createClass$$module$input(b,[{key:"zone",value:function(){return this._zone}},{key:"millis",value:function(){return(new Date).getTime()}},{key:"instant",value:function(){return Instant$$module$input.ofEpochMilli(this.millis())}},{key:"equals",value:function(a){return a instanceof b?this._zone.equals(a._zone):!1}},{key:"withZone",value:function(a){return a.equals(this._zone)?this:new b(a)}},{key:"toString",value:function(){return"SystemClock[".concat(this._zone.toString(),
"]")}}]);return b}(Clock$$module$input),FixedClock$$module$input=function(e){function b(a,c){_classCallCheck$$module$input(this,b);var e=d.call(this);e._instant=a;e._zoneId=c;return e}_inherits$$module$input(b,e);var d=_createSuper$$module$input(b);_createClass$$module$input(b,[{key:"instant",value:function(){return this._instant}},{key:"millis",value:function(){return this._instant.toEpochMilli()}},{key:"zone",value:function(){return this._zoneId}},{key:"toString",value:function(){return"FixedClock[]"}},
{key:"equals",value:function(a){return a instanceof b?this._instant.equals(a._instant)&&this._zoneId.equals(a._zoneId):!1}},{key:"withZone",value:function(a){return a.equals(this._zoneId)?this:new b(this._instant,a)}}]);return b}(Clock$$module$input),OffsetClock$$module$input=function(e){function b(a,c){_classCallCheck$$module$input(this,b);var e=d.call(this);e._baseClock=a;e._offset=c;return e}_inherits$$module$input(b,e);var d=_createSuper$$module$input(b);_createClass$$module$input(b,[{key:"zone",
value:function(){return this._baseClock.zone()}},{key:"withZone",value:function(a){return a.equals(this._baseClock.zone())?this:new b(this._baseClock.withZone(a),this._offset)}},{key:"millis",value:function(){return this._baseClock.millis()+this._offset.toMillis()}},{key:"instant",value:function(){return this._baseClock.instant().plus(this._offset)}},{key:"equals",value:function(a){return a instanceof b?this._baseClock.equals(a._baseClock)&&this._offset.equals(a._offset):!1}},{key:"toString",value:function(){return"OffsetClock[".concat(this._baseClock,
",").concat(this._offset,"]")}}]);return b}(Clock$$module$input),ZoneOffsetTransition$$module$input=function(){function e(b,d,a){_classCallCheck$$module$input(this,e);requireNonNull$$module$input(b,"transition");requireNonNull$$module$input(d,"offsetBefore");requireNonNull$$module$input(a,"offsetAfter");if(d.equals(a))throw new IllegalArgumentException$$module$input("Offsets must not be equal");if(0!==b.nano())throw new IllegalArgumentException$$module$input("Nano-of-second must be zero");this._transition=
b instanceof LocalDateTime$$module$input?b:LocalDateTime$$module$input.ofEpochSecond(b,0,d);this._offsetBefore=d;this._offsetAfter=a}_createClass$$module$input(e,[{key:"instant",value:function(){return this._transition.toInstant(this._offsetBefore)}},{key:"toEpochSecond",value:function(){return this._transition.toEpochSecond(this._offsetBefore)}},{key:"dateTimeBefore",value:function(){return this._transition}},{key:"dateTimeAfter",value:function(){return this._transition.plusSeconds(this.durationSeconds())}},
{key:"offsetBefore",value:function(){return this._offsetBefore}},{key:"offsetAfter",value:function(){return this._offsetAfter}},{key:"duration",value:function(){return Duration$$module$input.ofSeconds(this.durationSeconds())}},{key:"durationSeconds",value:function(){return this._offsetAfter.totalSeconds()-this._offsetBefore.totalSeconds()}},{key:"isGap",value:function(){return this._offsetAfter.totalSeconds()>this._offsetBefore.totalSeconds()}},{key:"isOverlap",value:function(){return this._offsetAfter.totalSeconds()<
this._offsetBefore.totalSeconds()}},{key:"isValidOffset",value:function(b){return this.isGap()?!1:this._offsetBefore.equals(b)||this._offsetAfter.equals(b)}},{key:"validOffsets",value:function(){return this.isGap()?[]:[this._offsetBefore,this._offsetAfter]}},{key:"compareTo",value:function(b){return this.instant().compareTo(b.instant())}},{key:"equals",value:function(b){return b===this?!0:b instanceof e?this._transition.equals(b._transition)&&this._offsetBefore.equals(b.offsetBefore())&&this._offsetAfter.equals(b.offsetAfter()):
!1}},{key:"hashCode",value:function(){return this._transition.hashCode()^this._offsetBefore.hashCode()^this._offsetAfter.hashCode()>>>16}},{key:"toString",value:function(){return"Transition[".concat(this.isGap()?"Gap":"Overlap"," at ").concat(this._transition.toString()).concat(this._offsetBefore.toString()," to ").concat(this._offsetAfter,"]")}}],[{key:"of",value:function(b,d,a){return new e(b,d,a)}}]);return e}();
function _init$m$$module$input(){TemporalQueries$$module$input.ZONE_ID=createTemporalQuery$$module$input("ZONE_ID",function(e){return e.query(TemporalQueries$$module$input.ZONE_ID)});TemporalQueries$$module$input.CHRONO=createTemporalQuery$$module$input("CHRONO",function(e){return e.query(TemporalQueries$$module$input.CHRONO)});TemporalQueries$$module$input.PRECISION=createTemporalQuery$$module$input("PRECISION",function(e){return e.query(TemporalQueries$$module$input.PRECISION)});TemporalQueries$$module$input.OFFSET=
createTemporalQuery$$module$input("OFFSET",function(e){return e.isSupported(ChronoField$$module$input.OFFSET_SECONDS)?ZoneOffset$$module$input.ofTotalSeconds(e.get(ChronoField$$module$input.OFFSET_SECONDS)):null});TemporalQueries$$module$input.ZONE=createTemporalQuery$$module$input("ZONE",function(e){var b=e.query(TemporalQueries$$module$input.ZONE_ID);return null!=b?b:e.query(TemporalQueries$$module$input.OFFSET)});TemporalQueries$$module$input.LOCAL_DATE=createTemporalQuery$$module$input("LOCAL_DATE",
function(e){return e.isSupported(ChronoField$$module$input.EPOCH_DAY)?LocalDate$$module$input.ofEpochDay(e.getLong(ChronoField$$module$input.EPOCH_DAY)):null});TemporalQueries$$module$input.LOCAL_TIME=createTemporalQuery$$module$input("LOCAL_TIME",function(e){return e.isSupported(ChronoField$$module$input.NANO_OF_DAY)?LocalTime$$module$input.ofNanoOfDay(e.getLong(ChronoField$$module$input.NANO_OF_DAY)):null})}
var SystemDefaultZoneRules$$module$input=function(e){function b(){_classCallCheck$$module$input(this,b);return d.apply(this,arguments)}_inherits$$module$input(b,e);var d=_createSuper$$module$input(b);_createClass$$module$input(b,[{key:"isFixedOffset",value:function(){return!1}},{key:"offsetOfInstant",value:function(a){a=(new Date(a.toEpochMilli())).getTimezoneOffset();return ZoneOffset$$module$input.ofTotalMinutes(-1*a)}},{key:"offsetOfEpochMilli",value:function(a){a=(new Date(a)).getTimezoneOffset();
return ZoneOffset$$module$input.ofTotalMinutes(-1*a)}},{key:"offsetOfLocalDateTime",value:function(a){a=1E3*a.toEpochSecond(ZoneOffset$$module$input.UTC);var b=(new Date(a)).getTimezoneOffset();a=(new Date(a+6E4*b)).getTimezoneOffset();return ZoneOffset$$module$input.ofTotalMinutes(-1*a)}},{key:"validOffsets",value:function(a){return[this.offsetOfLocalDateTime(a)]}},{key:"transition",value:function(){return null}},{key:"standardOffset",value:function(a){return this.offsetOfInstant(a)}},{key:"daylightSavings",
value:function(){this._throwNotSupported()}},{key:"isDaylightSavings",value:function(){this._throwNotSupported()}},{key:"isValidOffset",value:function(a,b){return this.offsetOfLocalDateTime(a).equals(b)}},{key:"nextTransition",value:function(){this._throwNotSupported()}},{key:"previousTransition",value:function(){this._throwNotSupported()}},{key:"transitions",value:function(){this._throwNotSupported()}},{key:"transitionRules",value:function(){this._throwNotSupported()}},{key:"_throwNotSupported",
value:function(){throw new DateTimeException$$module$input("not supported operation");}},{key:"equals",value:function(a){return this===a||a instanceof b?!0:!1}},{key:"toString",value:function(){return"SYSTEM"}}]);return b}(ZoneRules$$module$input),SystemDefaultZoneId$$module$input=function(e){function b(){_classCallCheck$$module$input(this,b);var a=d.call(this);a._rules=new SystemDefaultZoneRules$$module$input;return a}_inherits$$module$input(b,e);var d=_createSuper$$module$input(b);_createClass$$module$input(b,
[{key:"rules",value:function(){return this._rules}},{key:"equals",value:function(a){return this===a?!0:!1}},{key:"id",value:function(){return"SYSTEM"}}]);return b}(ZoneId$$module$input),ZoneIdFactory$$module$input=function(){function e(){_classCallCheck$$module$input(this,e)}_createClass$$module$input(e,null,[{key:"systemDefault",value:function(){return SYSTEM_DEFAULT_ZONE_ID_INSTANCE$$module$input}},{key:"getAvailableZoneIds",value:function(){return ZoneRulesProvider$$module$input.getAvailableZoneIds()}},
{key:"of",value:function(b){requireNonNull$$module$input(b,"zoneId");if("Z"===b)return ZoneOffset$$module$input.UTC;if(1===b.length)throw new DateTimeException$$module$input("Invalid zone: ".concat(b));if(StringUtil$$module$input.startsWith(b,"+")||StringUtil$$module$input.startsWith(b,"-"))return ZoneOffset$$module$input.of(b);if("UTC"===b||"GMT"===b||"GMT0"===b||"UT"===b)return new ZoneRegion$$module$input(b,ZoneOffset$$module$input.UTC.rules());if(StringUtil$$module$input.startsWith(b,"UTC+")||
StringUtil$$module$input.startsWith(b,"GMT+")||StringUtil$$module$input.startsWith(b,"UTC-")||StringUtil$$module$input.startsWith(b,"GMT-")){var d=ZoneOffset$$module$input.of(b.substring(3));return 0===d.totalSeconds()?new ZoneRegion$$module$input(b.substring(0,3),d.rules()):new ZoneRegion$$module$input(b.substring(0,3)+d.id(),d.rules())}return StringUtil$$module$input.startsWith(b,"UT+")||StringUtil$$module$input.startsWith(b,"UT-")?(b=ZoneOffset$$module$input.of(b.substring(2)),0===b.totalSeconds()?
new ZoneRegion$$module$input("UT",b.rules()):new ZoneRegion$$module$input("UT".concat(b.id()),b.rules())):"SYSTEM"===b?ZoneId$$module$input.systemDefault():ZoneRegion$$module$input.ofId(b)}},{key:"ofOffset",value:function(b,d){requireNonNull$$module$input(b,"prefix");requireNonNull$$module$input(d,"offset");if(0===b.length)return d;if("GMT"===b||"UTC"===b||"UT"===b)return 0===d.totalSeconds()?new ZoneRegion$$module$input(b,d.rules()):new ZoneRegion$$module$input(b+d.id(),d.rules());throw new IllegalArgumentException$$module$input("Invalid prefix, must be GMT, UTC or UT: ".concat(b));
}},{key:"from",value:function(b){requireNonNull$$module$input(b,"temporal");var d=b.query(TemporalQueries$$module$input.zone());if(null==d)throw new DateTimeException$$module$input("Unable to obtain ZoneId from TemporalAccessor: ".concat(b,", type ").concat(null!=b.constructor?b.constructor.name:""));return d}}]);return e}(),SYSTEM_DEFAULT_ZONE_ID_INSTANCE$$module$input=null;
function _init$n$$module$input(){SYSTEM_DEFAULT_ZONE_ID_INSTANCE$$module$input=new SystemDefaultZoneId$$module$input;ZoneId$$module$input.systemDefault=ZoneIdFactory$$module$input.systemDefault;ZoneId$$module$input.getAvailableZoneIds=ZoneIdFactory$$module$input.getAvailableZoneIds;ZoneId$$module$input.of=ZoneIdFactory$$module$input.of;ZoneId$$module$input.ofOffset=ZoneIdFactory$$module$input.ofOffset;ZoneId$$module$input.from=ZoneIdFactory$$module$input.from;ZoneOffset$$module$input.from=ZoneIdFactory$$module$input.from;
ZoneId$$module$input.SYSTEM=SYSTEM_DEFAULT_ZONE_ID_INSTANCE$$module$input;ZoneId$$module$input.UTC=ZoneOffset$$module$input.ofTotalSeconds(0)}var isInit$$module$input=!1;
function init$$module$input(){isInit$$module$input||(isInit$$module$input=!0,_init$1$$module$input(),_init$$module$input(),_init$2$$module$input(),_init$3$$module$input(),_init$k$$module$input(),_init$8$$module$input(),_init$m$$module$input(),_init$4$$module$input(),_init$l$$module$input(),_init$i$$module$input(),_init$j$$module$input(),_init$d$$module$input(),_init$5$$module$input(),_init$c$$module$input(),_init$b$$module$input(),_init$6$$module$input(),_init$7$$module$input(),_init$g$$module$input(),
_init$n$$module$input(),_init$e$$module$input(),_init$a$$module$input(),_init$9$$module$input(),_init$h$$module$input(),_init$f$$module$input())}init$$module$input();
var ToNativeJsConverter$$module$input=function(){function e(b,d){_classCallCheck$$module$input(this,e);if(b instanceof Instant$$module$input)this.instant=b;else{if(b instanceof LocalDate$$module$input)d=null==d?ZoneId$$module$input.systemDefault():d,b=b.atStartOfDay(d);else if(b instanceof LocalDateTime$$module$input)d=null==d?ZoneId$$module$input.systemDefault():d,b=b.atZone(d);else if(b instanceof ZonedDateTime$$module$input)b=null==d?b:b.withZoneSameInstant(d);else throw new IllegalArgumentException$$module$input("unsupported instance for convert operation:".concat(b));
this.instant=b.toInstant()}}_createClass$$module$input(e,[{key:"toDate",value:function(){return new Date(this.instant.toEpochMilli())}},{key:"toEpochMilli",value:function(){return this.instant.toEpochMilli()}}]);return e}(),NativeJsTemporal$$module$input=function(e){function b(a){var c=1<arguments.length&&void 0!==arguments[1]?arguments[1]:ZoneId$$module$input.systemDefault();_classCallCheck$$module$input(this,b);var e=d.call(this);e._zone=c;if(a instanceof Date)return e._epochMilli=a.getTime(),_possibleConstructorReturn$$module$input(e);
if("function"===typeof a.toDate&&a.toDate()instanceof Date)return e._epochMilli=a.toDate().getTime(),_possibleConstructorReturn$$module$input(e);assert$$module$input(!1,"date must be either a javascript date or a moment");return e}_inherits$$module$input(b,e);var d=_createSuper$$module$input(b);_createClass$$module$input(b,[{key:"query",value:function(a){requireNonNull$$module$input(a,"query");return a===TemporalQueries$$module$input.localDate()?LocalDate$$module$input.ofInstant(Instant$$module$input.ofEpochMilli(this._epochMilli),
this._zone):a===TemporalQueries$$module$input.localTime()?LocalTime$$module$input.ofInstant(Instant$$module$input.ofEpochMilli(this._epochMilli),this._zone):a===TemporalQueries$$module$input.zone()?this._zone:_get$$module$input(_getPrototypeOf$$module$input(b.prototype),"query",this).call(this,a)}},{key:"get",value:function(a){return this.getLong(a)}},{key:"getLong",value:function(a){requireNonNull$$module$input(a,"field");if(a instanceof ChronoField$$module$input){switch(a){case ChronoField$$module$input.NANO_OF_SECOND:return 1E6*
MathUtil$$module$input.floorMod(this._epochMilli,1E3);case ChronoField$$module$input.INSTANT_SECONDS:return MathUtil$$module$input.floorDiv(this._epochMilli,1E3)}throw new UnsupportedTemporalTypeException$$module$input("Unsupported field: ".concat(a));}return a.getFrom(this)}},{key:"isSupported",value:function(a){return a===ChronoField$$module$input.INSTANT_SECONDS||a===ChronoField$$module$input.NANO_OF_SECOND}}]);return b}(TemporalAccessor$$module$input),module$input={};module$input.LocalDate=LocalDate$$module$input;