/*
 * Decompiled with CFR 0.152.
 */
package com.bh.services;

import com.atlassian.confluence.pages.Comment;
import com.bh.models.BhtComment;
import com.bh.services.MarkersService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class MarkersServiceImpl
implements MarkersService {
    @Override
    public Comment getFirstComment(List<Comment> comments, String body) {
        if (comments.size() > 0) {
            ArrayList<BhtComment> bhtComments = new ArrayList<BhtComment>();
            for (Comment comment : comments) {
                if (comment.getParent() != null || comment.isDeleted()) continue;
                BhtComment bhtComment = new BhtComment();
                bhtComment.setComment(comment);
                bhtComment.setMarker(comment.getProperties().getStringProperty("inline-original-selection"));
                bhtComment.setMarkerPosition(body.indexOf(bhtComment.getMarker()));
                bhtComments.add(bhtComment);
            }
            ArrayList<Integer> ints = new ArrayList<Integer>();
            for (BhtComment bhtComment : bhtComments) {
                ints.add(bhtComment.getMarkerPosition());
            }
            int n = (Integer)Collections.min(ints);
            for (BhtComment bhtComment : bhtComments) {
                if (bhtComment.getMarkerPosition() != n) continue;
                return bhtComment.getComment();
            }
        }
        return new Comment();
    }
}

