/*
 * Decompiled with CFR 0.152.
 */
package com.bh.services;

import com.atlassian.confluence.pages.Comment;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.user.User;
import com.bh.rest.BhtCommentCreator;
import com.bh.rest.BhtCommentWebModel;
import com.bh.rest.BhtPage;
import com.bh.services.CommentToModelConv;
import java.text.SimpleDateFormat;
import org.springframework.stereotype.Service;

@Service
public class CommentToModelConvImpl
implements CommentToModelConv {
    private final UserAccessor userAccessor;
    SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat("MMMM dd, yyyy");

    public CommentToModelConvImpl(UserAccessor userAccessor) {
        this.userAccessor = userAccessor;
    }

    @Override
    public BhtCommentWebModel convertToModel(Comment comment) {
        BhtCommentWebModel model = new BhtCommentWebModel();
        model.setBody(comment.getBodyAsStringWithoutMarkup());
        BhtCommentCreator bhtCommentCreator = new BhtCommentCreator();
        bhtCommentCreator.setName(comment.getCreator().getFullName());
        bhtCommentCreator.setLink("/display/~" + comment.getCreator().getName());
        bhtCommentCreator.setIconLink(this.userAccessor.getUserProfilePicture((User)comment.getCreator()).getUriReference());
        model.setCreator(bhtCommentCreator);
        model.setSpace(comment.getSpace().getDisplayTitle());
        BhtPage bhtPage = new BhtPage();
        bhtPage.setTitle(comment.getContainer().getDisplayTitle());
        bhtPage.setLink(comment.getContainer().getUrlPath());
        model.setPage(bhtPage);
        model.setType(comment.getType());
        if (comment.getProperties().getStringProperty("inline-original-selection") != null) {
            model.setMarkedContent(comment.getProperties().getStringProperty("inline-original-selection"));
        } else {
            model.setMarkedContent("");
        }
        if (comment.getStatus().isResolved() || comment.getStatus().isDangling()) {
            model.setStatus("Resolved");
        } else {
            model.setStatus("Unresolved");
        }
        model.setLink(comment.getUrlPath());
        model.setCreationDate(this.simpleDateFormat2.format(comment.getCreationDate()));
        return model;
    }
}

