/*
 * Decompiled with CFR 0.152.
 */
package com.bh.services;

import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.setup.bandana.ConfluenceBandanaContext;
import com.bh.models.IconsSwitcher;
import com.bh.models.PanelTypeModel;
import com.bh.models.SpaceBannerModel;
import com.bh.services.BandanaModelsService;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BandanaModelsServiceImpl
implements BandanaModelsService {
    private static final String ICONS_SWITCHER = "bht.iconsSwitcher";
    private final BandanaManager bandanaManager;

    @Autowired
    public BandanaModelsServiceImpl(BandanaManager bandanaManager) {
        this.bandanaManager = bandanaManager;
    }

    @Override
    public List<SpaceBannerModel> getAllModels() {
        ArrayList<SpaceBannerModel> models = new ArrayList<SpaceBannerModel>();
        Iterable keys = this.bandanaManager.getKeys((BandanaContext)new ConfluenceBandanaContext());
        for (String key : keys) {
            if (key == null || !(this.bandanaManager.getValue((BandanaContext)new ConfluenceBandanaContext(), key) instanceof SpaceBannerModel)) continue;
            SpaceBannerModel spaceBannerModel = (SpaceBannerModel)this.bandanaManager.getValue((BandanaContext)new ConfluenceBandanaContext(), key);
            models.add(spaceBannerModel);
        }
        return models;
    }

    @Override
    public void createIconSwitcher(String display2) {
        IconsSwitcher iconsSwitcher = new IconsSwitcher();
        iconsSwitcher.setWhatToDisplay(display2);
        this.bandanaManager.setValue((BandanaContext)new ConfluenceBandanaContext(), ICONS_SWITCHER, (Object)iconsSwitcher);
    }

    @Override
    public IconsSwitcher getIconSwitcher() {
        if (this.bandanaManager.getValue((BandanaContext)new ConfluenceBandanaContext(), ICONS_SWITCHER) == null) {
            this.createIconSwitcher("always");
        }
        IconsSwitcher iconsSwitcher = (IconsSwitcher)this.bandanaManager.getValue((BandanaContext)new ConfluenceBandanaContext(), ICONS_SWITCHER);
        return iconsSwitcher;
    }

    @Override
    public void createModels(String[] parameters, String value) {
        this.deleteEntities();
        for (String s : parameters) {
            SpaceBannerModel spaceBannerModel = new SpaceBannerModel();
            spaceBannerModel.setSpaceKey(s);
            spaceBannerModel.setDisplayValue(value);
            this.bandanaManager.setValue((BandanaContext)new ConfluenceBandanaContext(), s, (Object)spaceBannerModel);
        }
    }

    @Override
    public void deleteEntities() {
        for (SpaceBannerModel spaceBannerModel : this.getAllModels()) {
            this.bandanaManager.removeValue((BandanaContext)new ConfluenceBandanaContext(), spaceBannerModel.getSpaceKey());
        }
    }

    @Override
    public void createPanelType(String type, boolean displayMainDialog) {
        PanelTypeModel panelTypeModel = new PanelTypeModel(type, displayMainDialog);
        this.bandanaManager.setValue((BandanaContext)new ConfluenceBandanaContext(), "panelTypeModel", (Object)panelTypeModel);
    }

    @Override
    public PanelTypeModel getPanelType() {
        if (this.bandanaManager.getValue((BandanaContext)new ConfluenceBandanaContext(), "panelTypeModel") == null) {
            this.createPanelType("Default", true);
        }
        PanelTypeModel panelTypeModel = (PanelTypeModel)this.bandanaManager.getValue((BandanaContext)new ConfluenceBandanaContext(), "panelTypeModel");
        return panelTypeModel;
    }
}

