import { _ as _taggedTemplateLiteral } from './taggedTemplateLiteral-12969f7e.js';
import { r as react } from './index-50b0b662.js';
import { j as jsx, a1 as keyframes, c as css, t as token, h as N500, i as N0, a2 as DN900, a3 as DN500 } from './colors-25aad6bf.js';
import { G as GlobalTheme } from './theme-742e153b.js';

var presetSizes = {
  xsmall: 8,
  small: 16,
  medium: 24,
  large: 48,
  xlarge: 96
};

var _templateObject, _templateObject2, _templateObject3, _templateObject4;
var rotate = keyframes(_templateObject || (_templateObject = _taggedTemplateLiteral(["\n  to { transform: rotate(360deg); }\n"]))); // There are three parts to the load in animation:
// 1. Fade in
// 2. Accelerated spin
// 3. Stretch the spinner line

var loadIn = keyframes(_templateObject2 || (_templateObject2 = _taggedTemplateLiteral(["\n  from {\n    transform: rotate(50deg);\n    opacity: 0;\n    stroke-dashoffset: 60;\n  }\n  to {\n    transform: rotate(230deg);\n    opacity: 1;\n    stroke-dashoffset: 50;\n  }\n"])));

function getStrokeColor(_ref) {
  var mode = _ref.mode,
      appearance = _ref.appearance;

  if (mode === 'light') {
    return appearance === 'inherit' ? token('color.text.mediumEmphasis', N500) : token('color.text.onBold', N0);
  }

  return appearance === 'inherit' ? token('color.text.mediumEmphasis', DN900) : token('color.text.onBold', DN500);
}

var __pika_web_default_export_for_treeshaking__ = /*#__PURE__*/react.memo( /*#__PURE__*/react.forwardRef(function Spinner(_ref2, ref) {
  var testId = _ref2.testId,
      _ref2$appearance = _ref2.appearance,
      appearance = _ref2$appearance === void 0 ? 'inherit' : _ref2$appearance,
      _ref2$delay = _ref2.delay,
      delay = _ref2$delay === void 0 ? 0 : _ref2$delay,
      _ref2$size = _ref2.size,
      providedSize = _ref2$size === void 0 ? 'medium' : _ref2$size;
  var size = typeof providedSize === 'number' ? providedSize : presetSizes[providedSize];
  return jsx(GlobalTheme.Consumer, null, function (tokens) {
    var strokeColor = getStrokeColor({
      mode: tokens.mode,
      appearance: appearance
    }); // The Spinner animation uses a combination of two
    // css animations on two separate elements.

    return jsx("span", {
      /* This span exists to off-load animations from the circle element,
       which were causing performance issues (style recalculations) on Safari and older versions of Chrome.
       This can be removed and styles placed back on the circle element once Safari fixes this bug and off-loads rendering to the GPU from the CPU.
       */
      css: css(_templateObject3 || (_templateObject3 = _taggedTemplateLiteral(["\n                transform-origin: center;\n                animation: ", " 0.86s infinite;\n                animation-delay: ", "ms;\n                animation-timing-function: cubic-bezier(0.4, 0.15, 0.6, 0.85);\n                height: ", "px;\n                width: ", "px;\n                display: inline-flex;\n                /* align better inline with text */\n                vertical-align: middle;\n              "])), rotate, delay, size, size),
      "data-testid": testId && "".concat(testId, "-wrapper")
    }, jsx("svg", {
      height: size,
      width: size,
      viewBox: "0 0 16 16",
      xmlns: "http://www.w3.org/2000/svg",
      "data-testid": testId,
      ref: ref,
      css: css(_templateObject4 || (_templateObject4 = _taggedTemplateLiteral(["\n                  /* We are going to animate this in */\n                  opacity: 0;\n                  animation: ", " 1s ease-in-out;\n                  /* When the animation completes, stay at the last frame of the animation */\n                  animation-fill-mode: forwards;\n                  animation-delay: ", "ms;\n                  fill: none;\n                  stroke: ", ";\n                  stroke-width: 1.5;\n                  stroke-linecap: round;\n                  stroke-dasharray: 60;\n                  stroke-dashoffset: inherit;\n                  @media screen and (forced-colors: active) {\n                    filter: grayscale(100%);\n                    stroke: CanvasText;\n                  }\n                "])), loadIn, delay, strokeColor)
    }, jsx("circle", {
      cx: "8",
      cy: "8",
      r: "7"
    })));
  });
}));

export { __pika_web_default_export_for_treeshaking__ as _ };
