import React, {useState, useEffect} from 'react';
import {Chart} from 'react-google-charts';
import Banner from '@atlaskit/banner';
import WarningIcon from '@atlaskit/icon/glyph/warning';
import Spinner from '@atlaskit/spinner';

const Stats = (props) => {
    const [currUser, setCurrUser] = useState(null);
    const [currUserLoaded, setCurrUserLoaded] = useState(false);
    const [currUserComments, setCurrUserComments] = useState(0);
    const [currUserCommentsLoaded, setCurrUserCommentsLoaded] = useState(false);
    const [allComments, setAllComments] = useState(0);
    const [spacesComments, setSpacesComments] = useState([]);
    const [spacesCommentsLoaded, setSpacesCommentsLoaded] = useState(false);
    const [basic, setBasic] = useState(0);
    const [resolved, setResolved] = useState(0);
    const [unresolved, setUnresolved] = useState(0);
    const [allCommentsLoaded, setAllCommentsLoaded] = useState(false);
    const [basicLoaded, setBasicLoaded] = useState(false);
    const [unresolvedLoaded, setUnresolvedLoaded] = useState(false);
    const [resolvedLoaded, setResolvedLoaded] = useState(false);
    const [spaces, setSpaces] = useState([]);
    const [spacesLoaded, setSpacesLoaded] = useState(false);

    async function fetchSpaces() {
        let currData = await fetch(`/rest/api/space?limit=50`);
        let responseBody = await currData.json();
        let currSpaces = responseBody.results;
        setSpaces(data => [...data, ...currSpaces]);
        let nextLink = responseBody._links.next;
        if (nextLink !== undefined && nextLink !== '') {
            let nextData = await fetch(nextLink);
            let nextResponseBody = await nextData.json();
            let currSpacesNext = nextResponseBody.results;
            setSpaces(data => [...data, ...currSpacesNext]);
        }
        setSpacesLoaded(true);
    }

    async function getCommentsBySpace(spaceKey) {
        //todo
    }

    async function fetchCurrUser() {
        let currUserData = await fetch('/rest/api/user/current');
        let currUser = await currUserData.json();
        setCurrUser(currUser);
        setCurrUserLoaded(true);
    }

    useEffect(() => {
        async function initSpacesChart(colors) {
            if (spacesLoaded && currUserLoaded) {
                for (let space of spaces) {
                    if (space.type === "global") {
                        const REQ_URL = `/rest/api/search?cql=creator="${currUser.username}" and type=comment%20and%20space=${space.key}`;
                        let data = await fetch(REQ_URL);
                        let body = await data.json();
                        // console.log(body)
                        if (body !== undefined) {
                            if (body.totalSize > 0) {
                                const totalSize = Number.parseInt(body.totalSize)
                                // console.log([space.key, totalSize, '#091E42'])
                                let color = colors[Math.ceil(Math.random() * 10)]
                                setSpacesComments(old => [...old, [space.key, totalSize, color]]); //['All', allComments, '#091E42']
                            }
                        }
                    }
                }
                setSpacesCommentsLoaded(true);
            }
        }

        if (spacesLoaded) {
            let colors = ['#091E42', '#0065FF', '#00B8D9', '#36B37E', '#FFAB00', '#FF5630', '#6554C0', '#EBECF0', '#0045FF', '#F15B39'];
            initSpacesChart(colors);
        }
    }, [spacesLoaded])

    useEffect(() => {
        if (currUserLoaded) {
            async function loadAllComments() {
                const data = await fetch('/rest/api/search?cql=type=comment');
                const jsonData = await data.json();
                setAllComments(jsonData.totalSize);
                setAllCommentsLoaded(true);
            }

            async function loadMyComments() {
                let resp = await fetch(`/rest/api/search?cql=creator="${currUser.username}" and type=comment`);
                let respJson = await resp.json();
                setCurrUserComments(respJson.totalSize);
                setCurrUserCommentsLoaded(true);
            }

            // async function loadSimple() {
            //     fetch(`/bht/comments/user?userId=${currUser.accountId}&commentType=Simple&status=&from=&to=`, {
            //         method: 'GET',
            //         headers: {
            //             Authorization: `JWT ${jwt}`
            //         }
            //     })
            //         .then(resp => resp.json()).then(data => {
            //         setBasic(data.length);
            //     });
            //     setBasicLoaded(true);
            // }
            async function loadUnresolved() {
                // todo
                setUnresolved(true);
            }

            async function loadResolved() {
                // todo
                setResolvedLoaded(true);
            }

            loadAllComments();
            loadMyComments();
            // loadUnresolved();
            // loadResolved();
        }
    }, [currUserLoaded])

    useEffect(() => {
        fetchCurrUser();
        fetchSpaces() // spaces
    }, []);

    return (
        <div>
            <div>
                <h3>Statistics</h3>
                <div>
                    <Banner
                        appearance="warning"
                        icon={<WarningIcon label="" secondaryColor="inherit"/>}
                    >
                        Menu is still in development mode to be improved.{' '}
                    </Banner>
                </div>
            </div>
            <div style={{display: 'flex', padding: '15px', margin: '10px'}}>
                <div>
                    <p><b>All</b>: {allCommentsLoaded && allComments}</p>
                    <p><b>My</b>: {currUserCommentsLoaded && currUserComments}</p>
                    {/*<p><b>Unresolved</b>: {unresolvedLoaded && unresolved}</p>*/}
                    {/*<p><b>Resolved</b>: {resolved}</p>*/}
                </div>
                <div style={{display: 'block'}}>
                    <div id='bht-comments-chart'>
                        <Chart
                            width={'800px'}
                            height={'500px'}
                            chartType='ColumnChart'
                            loader={<Spinner size={'large'} interactionName="load" />}
                            data={[
                                ['Type', '', {role: 'style'}],
                                ['All', allComments, '#091E42'],
                                ['My', currUserComments, '#0065FF'],
                                ['Unresolved', unresolved, '#FFAB00'],
                                ['Resolved', resolved, '#36B37E'],
                            ]}
                            options={{
                                title: 'Comments count',
                                chartArea: {width: '70%'},
                                // hAxis: {
                                //   title: 'Months',
                                //   minValue: 0,
                                // },
                                // vAxis: {
                                //   title: 'Count',
                                // },
                            }}
                            // For tests
                            rootProps={{'data-testid': '1'}}
                        />
                        <div>
                            <h3>Comments per space</h3>
                            {spacesCommentsLoaded && console.log(spacesComments)}
                            {!spacesCommentsLoaded ? <Spinner size={'large'}/> : <Chart
                                width={'1200px'}
                                height={'700px'}
                                chartType='ColumnChart'
                                loader={<div>Loading Chart</div>}
                                data={[
                                    ['Type', '', {role: 'style'}],
                                    ...spacesComments
                                ]}
                                options={{
                                    title: 'Comments per space',
                                    chartArea: {width: '80%'},
                                    // hAxis: {
                                    //   title: 'Months',
                                    //   minValue: 0,
                                    // },
                                    // vAxis: {
                                    //   title: 'Count',
                                    // },
                                }}
                                // For tests
                                rootProps={{'data-testid': '2'}}
                            />}
                        </div>
                    </div>
                </div>
            </div>
        </div>
    )
}

export default Stats;