/*
 * Decompiled with CFR 0.152.
 */
package com.bh.services;

import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.Expansions;
import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.service.content.ContentService;
import com.atlassian.confluence.api.service.search.CQLSearchService;
import com.atlassian.confluence.content.service.PageService;
import com.atlassian.confluence.pages.Comment;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.user.User;
import com.bh.rest.BhtCommentWebModel;
import com.bh.services.BhtCommentsService;
import com.bh.services.CommentToModelConv;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BhtCommentsServiceImpl
implements BhtCommentsService {
    private final PageManager pageManager;
    private final PageService pageService;
    private final SpaceManager spaceManager;
    private final UserAccessor userAccessor;
    private final PermissionManager permissionManager;
    private final CommentToModelConv commentToModelConv;
    private final ContentService contentService;
    private final CQLSearchService cqlSearchService;
    private final Logger LOG = LoggerFactory.getLogger(BhtCommentsServiceImpl.class);
    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
    SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat("MMMM dd, yyyy");

    @Autowired
    public BhtCommentsServiceImpl(PageManager pageManager, PageService pageService, SpaceManager spaceManager, UserAccessor userAccessor, PermissionManager permissionManager, CommentToModelConv commentToModelConv, ContentService contentService, CQLSearchService cqlSearchService) {
        this.pageManager = pageManager;
        this.pageService = pageService;
        this.spaceManager = spaceManager;
        this.userAccessor = userAccessor;
        this.permissionManager = permissionManager;
        this.commentToModelConv = commentToModelConv;
        this.contentService = contentService;
        this.cqlSearchService = cqlSearchService;
    }

    @Override
    public List<BhtCommentWebModel> getSpaceComments(String spaceKeys, String commentType, String dateFrom, String dateTo) {
        if (spaceKeys != null && !spaceKeys.isEmpty()) {
            String[] spaceKeysArr;
            Date dateFromNew = null;
            Date dateToNew = null;
            if (dateFrom == null || dateFrom.isEmpty()) {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(new Date());
                calendar.add(5, -7);
                dateFromNew = calendar.getTime();
            } else {
                try {
                    dateFromNew = this.simpleDateFormat.parse(dateFrom);
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
            }
            if (dateTo == null || dateTo.isEmpty()) {
                dateToNew = new Date();
            } else {
                try {
                    dateToNew = this.simpleDateFormat.parse(dateTo);
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
            }
            ArrayList<Page> allPages = new ArrayList<Page>();
            for (String string : spaceKeysArr = spaceKeys.split(",")) {
                List list = this.pageManager.getPages(this.spaceManager.getSpace(string), true);
                for (Page page2 : list) {
                    if (!this.permissionManager.hasPermission((User)AuthenticatedUserThreadLocal.get(), Permission.VIEW, (Object)page2)) continue;
                    allPages.add(page2);
                }
            }
            if (commentType.equals("All")) {
                ArrayList allComments = new ArrayList();
                ArrayList<Comment> simpleComments = new ArrayList<Comment>();
                ArrayList<Comment> inlineComments = new ArrayList<Comment>();
                for (Page page2 : allPages) {
                    for (Comment comment : page2.getComments()) {
                        if (comment.isInlineComment()) continue;
                        simpleComments.add(comment);
                    }
                }
                for (Page page3 : allPages) {
                    for (Comment comment : page3.getComments()) {
                        if (!comment.isInlineComment() || comment.getParent() != null) continue;
                        inlineComments.add(comment);
                        for (Comment child : comment.getChildren()) {
                            child.setStatus(comment.getStatus());
                            inlineComments.add(child);
                        }
                    }
                }
                allComments.addAll(simpleComments);
                allComments.addAll(inlineComments);
                ArrayList<BhtCommentWebModel> arrayList = new ArrayList<BhtCommentWebModel>();
                for (Comment comment : allComments) {
                    if (!comment.getCreationDate().after(dateFromNew) || !comment.getCreationDate().before(dateToNew)) continue;
                    arrayList.add(this.commentToModelConv.convertToModel(comment));
                }
                return arrayList;
            }
            if (commentType.equals("Simple")) {
                ArrayList<Comment> simpleComments = new ArrayList<Comment>();
                for (Page page4 : allPages) {
                    for (Comment comment : page4.getComments()) {
                        if (comment.isInlineComment()) continue;
                        simpleComments.add(comment);
                    }
                }
                ArrayList<BhtCommentWebModel> returnComments = new ArrayList<BhtCommentWebModel>();
                for (Comment comment : simpleComments) {
                    if (!comment.getCreationDate().after(dateFromNew) || !comment.getCreationDate().before(dateToNew)) continue;
                    returnComments.add(this.commentToModelConv.convertToModel(comment));
                }
                return returnComments;
            }
            if (commentType.equals("Inline")) {
                ArrayList inlineComments = new ArrayList();
                allPages.forEach(page -> page.getComments().stream().filter(c -> c.isInlineComment() && c.getParent() == null).forEach(comment -> {
                    inlineComments.add(comment);
                    comment.getChildren().forEach(child -> {
                        child.setStatus(comment.getStatus());
                        inlineComments.add(child);
                    });
                }));
                ArrayList<BhtCommentWebModel> returnComments = new ArrayList<BhtCommentWebModel>();
                for (Comment comment : inlineComments) {
                    if (!comment.getCreationDate().after(dateFromNew) || !comment.getCreationDate().before(dateToNew)) continue;
                    returnComments.add(this.commentToModelConv.convertToModel(comment));
                }
                return returnComments;
            }
        }
        return new ArrayList<BhtCommentWebModel>();
    }

    @Override
    public List<Comment> getPageInlineComments(long pageId) {
        return this.pageService.getIdPageLocator(pageId).getPage().getComments().stream().filter(c -> c.isInlineComment()).collect(Collectors.toList());
    }

    @Override
    public List<Comment> getCommentsByDates(List<Comment> comments, String dateFrom, String dateTo) {
        ArrayList<Comment> commentList = new ArrayList<Comment>();
        try {
            Date fromDate = this.simpleDateFormat.parse(dateFrom);
            Date toDate = this.simpleDateFormat.parse(dateTo);
            comments.stream().filter(c -> c.getCreationDate().after(fromDate) && c.getCreationDate().before(toDate)).forEach(commentList::add);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return commentList;
    }

    @Override
    public List<BhtCommentWebModel> getPageComments(long pageId, String commentsType, String dateFrom, String dateTo) {
        Page page = this.pageService.getIdPageLocator(pageId).getPage();
        ArrayList<BhtCommentWebModel> models = new ArrayList<BhtCommentWebModel>();
        List comments = page.getComments();
        try {
            Date dateFromDate = dateFrom == null || dateFrom.equals("") ? Date.from(LocalDate.now().minusDays(8L).atStartOfDay().atZone(ZoneId.systemDefault()).toInstant()) : this.simpleDateFormat.parse(dateFrom);
            Date dateToDate = dateTo == null || dateTo.equals("") ? Date.from(LocalDate.now().plusDays(1L).atStartOfDay().atZone(ZoneId.systemDefault()).toInstant()) : this.simpleDateFormat.parse(dateTo);
            comments.stream().filter(Objects::nonNull).filter(c -> Objects.nonNull(c.getCreationDate())).filter(c -> c.getCreationDate().after(dateFromDate) && c.getCreationDate().before(dateToDate)).forEach(c -> models.add(this.commentToModelConv.convertToModel((Comment)c)));
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
        return models;
    }

    @Override
    public List<Content> getUserComments(String userName) {
        List comments = this.cqlSearchService.searchContent(String.format("type=comment and creator = %s", userName), new Expansion[]{new Expansion("body", Expansions.of((String[])new String[]{"view"})), new Expansion("space"), new Expansion("container"), new Expansion("history")}).getResults();
        return comments;
    }
}

