import React, {useState, useEffect, useRef, Fragment} from "../_snowpack/pkg/react.js";
import DynamicTable from "../_snowpack/pkg/@atlaskit/dynamic-table.js";
import Avatar from "../_snowpack/pkg/@atlaskit/avatar.js";
import Lozenge from "../_snowpack/pkg/@atlaskit/lozenge.js";
const CommentsListTable = (props) => {
  const InlineStatus = ({status}) => {
    let appearance = status === "Resolved" ? "success" : "moved";
    return /* @__PURE__ */ React.createElement(Lozenge, {
      appearance,
      isBold: true
    }, status);
  };
  const CommentType = ({type}) => {
    if (type === "Simple")
      return /* @__PURE__ */ React.createElement(Lozenge, null, type);
    return /* @__PURE__ */ React.createElement(Lozenge, {
      appearance: "new"
    }, type);
  };
  const head = {
    cells: [
      {
        key: "page",
        content: "Page",
        isSortable: true
      },
      {
        key: "author",
        content: "Author",
        isSortable: true
      },
      {
        key: "commented",
        content: "Commented",
        isSortable: true
      },
      {
        key: "body",
        content: "Body",
        isSortable: true
      },
      {
        key: "type",
        content: "Type",
        isSortable: true
      },
      {
        key: "status",
        content: "Status",
        isSortable: true
      },
      {
        key: "creation-date",
        content: "Creation Date",
        isSortable: true
      }
    ]
  };
  const rows = props.comments.map((comm, index) => ({
    key: index,
    cells: [
      {
        key: comm.id,
        content: /* @__PURE__ */ React.createElement("p", null, comm.container.title)
      },
      {
        key: index,
        content: /* @__PURE__ */ React.createElement("div", null, /* @__PURE__ */ React.createElement(Avatar, {
          src: props.hostUrlWithoutContext + comm.history.createdBy.profilePicture.path,
          name: comm.history.createdBy.displayName,
          size: "medium"
        }), comm.history.createdBy.displayName)
      },
      {
        key: index,
        content: /* @__PURE__ */ React.createElement("p", null, comm.extensions.inlineProperties !== null ? comm.extensions.inlineProperties.originalSelection : "")
      },
      {
        key: index,
        content: /* @__PURE__ */ React.createElement("p", null, comm.body.view.value)
      },
      {
        key: index,
        content: /* @__PURE__ */ React.createElement("p", null, comm.extensions.inlineProperties !== null ? /* @__PURE__ */ React.createElement(CommentType, {
          type: "Inline"
        }) : /* @__PURE__ */ React.createElement(CommentType, {
          type: "Simple"
        }))
      },
      {
        key: index,
        content: /* @__PURE__ */ React.createElement("p", null, comm.extensions.inlineProperties !== null ? /* @__PURE__ */ React.createElement(InlineStatus, {
          status: comm.extensions.resolution.status
        }) : "")
      },
      {
        key: index,
        content: /* @__PURE__ */ React.createElement("p", null, comm.history.createdDate)
      }
    ]
  }));
  return /* @__PURE__ */ React.createElement(DynamicTable, {
    head,
    rows,
    rowsPerPage: 20,
    defaultPage: 1,
    loadingSpinnerSize: "large",
    isLoading: false,
    isFixedSize: true,
    defaultSortKey: "page",
    defaultSortOrder: "ASC"
  });
};
export default CommentsListTable;
