import React, {useState, useEffect, useRef, Fragment} from "../_snowpack/pkg/react.js";
import Comment, {
  CommentAction,
  CommentAuthor,
  CommentEdited,
  CommentLayout,
  CommentTime
} from "../_snowpack/pkg/@atlaskit/comment.js";
import Avatar from "../_snowpack/pkg/@atlaskit/avatar.js";
import Pagination from "../_snowpack/pkg/@atlaskit/pagination.js";
const CommentsList = (props) => {
  return /* @__PURE__ */ React.createElement(Fragment, null, props.comments.map((comm) => /* @__PURE__ */ React.createElement(Comment, {
    avatar: /* @__PURE__ */ React.createElement(Avatar, {
      src: props.hostUrlWithoutContext + comm.history.createdBy.profilePicture.path,
      name: comm.history.createdBy.displayName,
      size: "medium"
    }),
    author: /* @__PURE__ */ React.createElement(CommentAuthor, null, comm.history.createdBy.displayName),
    type: "author",
    time: /* @__PURE__ */ React.createElement(CommentTime, null, comm.history.createdDate),
    content: /* @__PURE__ */ React.createElement("p", null, comm.body.view.value)
  })));
};
export default CommentsList;
