/*
 * Decompiled with CFR 0.152.
 */
package com.bh.ac.dp.listeners;

import com.atlassian.confluence.event.events.content.page.PageRemoveEvent;
import com.atlassian.confluence.event.events.content.pagehierarchy.DeletePageHierarchyStartEvent;
import com.atlassian.confluence.pages.Page;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.bh.ac.dp.models.PageActions;
import com.bh.ac.dp.services.PDEService;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PageDeleteListener
implements InitializingBean,
DisposableBean {
    private final EventPublisher eventPublisher;
    private final UserManager userManager;
    private final PDEService pdeService;
    private final PluginLicenseManager pluginLicenseManager;

    @Autowired
    public PageDeleteListener(EventPublisher eventPublisher, UserManager userManager, PDEService pdeService, PluginLicenseManager pluginLicenseManager) {
        this.eventPublisher = eventPublisher;
        this.userManager = userManager;
        this.pdeService = pdeService;
        this.pluginLicenseManager = pluginLicenseManager;
    }

    @EventListener
    public void handleEvent(PageRemoveEvent pageRemoveEvent) {
        if (this.licenseOK()) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MMMM dd, yyyy h:mm:ss a");
            this.pdeService.createPageEventModel(pageRemoveEvent.getPage().getId(), pageRemoveEvent.getPage().getTitle(), this.userManager.getRemoteUser().getUsername(), this.userManager.getRemoteUser().getUserKey().getStringValue(), pageRemoveEvent.getTimestamp(), simpleDateFormat.format(new Date()), pageRemoveEvent.getPage().getSpaceKey(), PageActions.DELETE.toString());
        }
    }

    @EventListener
    public void handleEvent(DeletePageHierarchyStartEvent deletePageHierarchyStartEvent) {
        if (this.licenseOK()) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MMMM dd, yyyy h:mm:ss a");
            this.pdeService.createPageEventModel(deletePageHierarchyStartEvent.getPage().getId(), deletePageHierarchyStartEvent.getPage().getTitle(), this.userManager.getRemoteUser().getUsername(), this.userManager.getRemoteUser().getUserKey().getStringValue(), deletePageHierarchyStartEvent.getTimestamp(), simpleDateFormat.format(new Date()), deletePageHierarchyStartEvent.getPage().getSpaceKey(), PageActions.DELETE_HIERARCHY.toString());
            for (Page page : deletePageHierarchyStartEvent.getPage().getDescendants()) {
                this.pdeService.createPageEventModel(page.getId(), page.getTitle(), this.userManager.getRemoteUser().getUsername(), this.userManager.getRemoteUser().getUserKey().getStringValue(), deletePageHierarchyStartEvent.getTimestamp(), simpleDateFormat.format(new Date()), page.getSpaceKey(), PageActions.DELETE_HIERARCHY.toString());
            }
        }
    }

    private boolean licenseOK() {
        if (!this.pluginLicenseManager.getLicense().isDefined()) {
            return false;
        }
        return !((PluginLicense)this.pluginLicenseManager.getLicense().get()).getError().isDefined();
    }

    public void destroy() throws Exception {
        this.eventPublisher.unregister((Object)this);
    }

    public void afterPropertiesSet() throws Exception {
        this.eventPublisher.register((Object)this);
    }
}

