/*
 * Decompiled with CFR 0.152.
 */
package com.bh.ac.dp.services;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.bh.ac.dp.models.PageEventModel;
import com.bh.ac.dp.services.PDEService;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.java.ao.DBParam;
import net.java.ao.RawEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PDEServiceImpl
implements PDEService {
    private final ActiveObjects activeObjects;

    @Autowired
    public PDEServiceImpl(ActiveObjects activeObjects) {
        this.activeObjects = activeObjects;
    }

    @Override
    public void createPageEventModel(long pageId, String pageTitle, String userName, String userKey, long timeStamp, String eventTime, String spaceKey, String actionType) {
        PageEventModel pageEventModel = (PageEventModel)this.activeObjects.create(PageEventModel.class, new DBParam[0]);
        pageEventModel.setPageName(pageTitle);
        pageEventModel.setUserName(userName);
        pageEventModel.setUserKey(userKey);
        pageEventModel.setTimeStamp(timeStamp);
        pageEventModel.setEventTime(eventTime);
        pageEventModel.setPageId(pageId);
        pageEventModel.setSpaceKey(spaceKey);
        pageEventModel.setActionType(actionType);
        pageEventModel.save();
    }

    @Override
    public List<PageEventModel> getAll() {
        return Lists.newArrayList((Object[])((PageEventModel[])this.activeObjects.find(PageEventModel.class)));
    }

    @Override
    public List<PageEventModel> getAllByActionType(String actionType) {
        ArrayList<PageEventModel> newList = new ArrayList<PageEventModel>();
        for (PageEventModel pageEventModel : this.getAll()) {
            if (!pageEventModel.getActionType().equals(actionType)) continue;
            newList.add(pageEventModel);
        }
        return newList;
    }

    @Override
    public List<PageEventModel> getAllBySpaceKey(String spaceKey) {
        ArrayList<PageEventModel> newList = new ArrayList<PageEventModel>();
        for (PageEventModel pageEventModel : this.getAll()) {
            if (!pageEventModel.getSpaceKey().equals(spaceKey)) continue;
            newList.add(pageEventModel);
        }
        return newList;
    }

    @Override
    public long getPageModelViews(long id) {
        ArrayList<Long> ids = new ArrayList<Long>();
        for (PageEventModel pageEventModel : this.getAll()) {
            ids.add(pageEventModel.getPageId());
        }
        return Collections.frequency(ids, id);
    }

    @Override
    public void deleteAll() {
        PageEventModel[] entities = (PageEventModel[])this.activeObjects.find(PageEventModel.class);
        if (entities != null) {
            this.activeObjects.delete((RawEntity[])entities);
        }
    }

    @Override
    public void deleteEventsBySpace(String spaceKey) {
        this.activeObjects.deleteWithSQL(PageEventModel.class, "SPACE_KEY = ?", new Object[]{spaceKey});
    }

    @Override
    public void deleteModel(long pageId) {
        this.activeObjects.deleteWithSQL(PageEventModel.class, "PAGE_ID = ?", new Object[]{pageId});
    }
}

