/*
 * Decompiled with CFR 0.152.
 */
package com.bh.ac.dp.services;

import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.security.SpacePermissionManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.atlassian.user.User;
import com.bh.ac.dp.services.ConditionsCheckerService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ConditionsCheckerServiceImpl
implements ConditionsCheckerService {
    private final PluginLicenseManager pluginLicenseManager;
    private final SpacePermissionManager spacePermissionManager;
    private final PermissionManager permissionManager;

    @Autowired
    public ConditionsCheckerServiceImpl(PluginLicenseManager pluginLicenseManager, SpacePermissionManager spacePermissionManager, PermissionManager permissionManager) {
        this.pluginLicenseManager = pluginLicenseManager;
        this.spacePermissionManager = spacePermissionManager;
        this.permissionManager = permissionManager;
    }

    @Override
    public boolean isLicenseOK() {
        if (!this.pluginLicenseManager.getLicense().isDefined()) {
            return false;
        }
        return !((PluginLicense)this.pluginLicenseManager.getLicense().get()).getError().isDefined();
    }

    @Override
    public boolean isSpaceAdmin(Space space) {
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        return this.spacePermissionManager.hasPermission("SETSPACEPERMISSIONS", space, (User)user);
    }

    @Override
    public boolean isSystemConfAdmin(ConfluenceUser user) {
        boolean isSystemAdmin = this.permissionManager.isSystemAdministrator((User)user);
        boolean isConfAdmin = this.permissionManager.isConfluenceAdministrator((User)user);
        return isConfAdmin || isSystemAdmin;
    }
}

