/*
 * Decompiled with CFR 0.152.
 */
package co.uk.automationconsultants.approvals.utils;

import co.uk.automationconsultants.approvals.service.exception.NoPageException;
import co.uk.automationconsultants.approvals.service.exception.NoPagePermissionException;
import co.uk.automationconsultants.approvals.service.exception.NoPageVersionException;
import co.uk.automationconsultants.approvals.service.exception.NoSpacePermissionException;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.ContentPermissionManager;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.security.SpacePermissionManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import jakarta.inject.Inject;
import jakarta.inject.Named;

@Named(value="confluenceServiceUtils")
public class ConfluencePageUtils {
    @ComponentImport
    private final PageManager pageManager;
    @ComponentImport
    private final SpacePermissionManager spacePermissionManager;
    @ComponentImport
    private final ContentPermissionManager contentPermissionManager;

    @Inject
    public ConfluencePageUtils(PageManager pageManager, SpacePermissionManager spacePermissionManager, ContentPermissionManager contentPermissionManager) {
        this.pageManager = pageManager;
        this.spacePermissionManager = spacePermissionManager;
        this.contentPermissionManager = contentPermissionManager;
    }

    public AbstractPage getConfluencePage(ConfluenceUser user, long pageId, Integer version) throws NoPageException, NoPagePermissionException, NoSpacePermissionException, NoPageVersionException {
        Page page = this.pageManager.getPage(pageId);
        if (page == null) {
            throw new NoPageException();
        }
        if (!this.spacePermissionManager.hasPermission("VIEWSPACE", page.getSpace(), user)) {
            throw new NoSpacePermissionException();
        }
        if (!this.contentPermissionManager.hasContentLevelPermission(user, "View", (ContentEntityObject)page)) {
            throw new NoPagePermissionException();
        }
        if (version == null || version == 0) {
            return page.getLatestVersion();
        }
        AbstractPage pageByVersion = this.pageManager.getPageByVersion((AbstractPage)page, version.intValue());
        if (pageByVersion == null) {
            throw new NoPageVersionException();
        }
        return pageByVersion;
    }
}

