/*
 * Decompiled with CFR 0.152.
 */
package co.uk.automationconsultants.approvals.service.migration;

import co.uk.automationconsultants.approvals.helper.GroupHelper;
import co.uk.automationconsultants.approvals.service.migration.BandanaDataType;
import co.uk.automationconsultants.approvals.utils.ApprovalMigrationUtils;
import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.setup.bandana.ConfluenceBandanaContext;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import jakarta.annotation.Nullable;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@Named
public class SpaceMacroMigrationService {
    @ComponentImport
    private final BandanaManager bandanaManager;
    @ComponentImport
    private final UserAccessor userAccessor;
    private final GroupHelper groupHelper;

    @Inject
    public SpaceMacroMigrationService(BandanaManager bandanaManager, UserAccessor userAccessor, GroupHelper groupHelper) {
        this.bandanaManager = bandanaManager;
        this.userAccessor = userAccessor;
        this.groupHelper = groupHelper;
    }

    public boolean isSpaceSettingsEnabled(String spaceKey) {
        String value = this.getSpaceMacroValue(spaceKey, BandanaDataType.SHOW_MACRO);
        return Boolean.parseBoolean(value);
    }

    private Set<ConfluenceUser> getUsersFromGroup(String spaceKey, int limit) {
        HashSet<ConfluenceUser> users = new HashSet<ConfluenceUser>();
        String groupString = this.getSpaceMacroValue(spaceKey, BandanaDataType.APPROVAL_GROUP);
        if (groupString == null || groupString.isEmpty()) {
            return new HashSet<ConfluenceUser>();
        }
        for (String groupName : groupString.split(",")) {
            if (users.size() == limit) {
                return users;
            }
            List<ConfluenceUser> groupMembers = this.groupHelper.getGroupMembers(groupName, limit);
            for (ConfluenceUser user : groupMembers) {
                if (users.size() == limit) {
                    return users;
                }
                users.add(user);
            }
        }
        return users;
    }

    public Set<ConfluenceUser> getUsers(String spaceKey, int limit) {
        if (spaceKey == null || spaceKey.isEmpty()) {
            return new HashSet<ConfluenceUser>();
        }
        String usersString = this.getSpaceMacroValue(spaceKey, BandanaDataType.LIST_USERS);
        if (usersString == null || usersString.isEmpty()) {
            return this.getUsersFromGroup(spaceKey, limit);
        }
        HashSet<ConfluenceUser> users = new HashSet<ConfluenceUser>();
        usersString = usersString.replace(" ", "");
        for (String username : usersString.split(",")) {
            if (users.size() == limit) {
                return users;
            }
            ConfluenceUser user = this.userAccessor.getUserByName(username);
            if (user == null) continue;
            users.add(user);
        }
        Set<ConfluenceUser> usersFromGroups = this.getUsersFromGroup(spaceKey, limit);
        int extraMembersAllowed = limit - users.size();
        List<ConfluenceUser> additionalMembers = new ArrayList<ConfluenceUser>(usersFromGroups).subList(0, Math.min(extraMembersAllowed, usersFromGroups.size()));
        users.addAll(additionalMembers);
        return users;
    }

    public Set<ConfluenceUser> getUsers(String spaceKey) {
        return this.getUsers(spaceKey, 20);
    }

    private Integer safeParseInt(String value) {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Nullable
    public Date getExpiryDate(String spaceKey) {
        return this.getExpiryDate(new Date(), spaceKey);
    }

    @Nullable
    public Date getExpiryDate(Date dateMacroCreated, String spaceKey) {
        if (spaceKey == null || spaceKey.isEmpty()) {
            return null;
        }
        String monthProperty = this.getSpaceMacroValue(spaceKey, BandanaDataType.EXPIRY_MONTH);
        String dayProperty = this.getSpaceMacroValue(spaceKey, BandanaDataType.EXPIRY_DAY);
        String expireAfterProperty = this.getSpaceMacroValue(spaceKey, BandanaDataType.EXPIRY_AFTER);
        if (!(monthProperty != null && !monthProperty.isEmpty() || dayProperty != null && !dayProperty.isEmpty() || expireAfterProperty == null || expireAfterProperty.isEmpty())) {
            return ApprovalMigrationUtils.parseExpireAfterTerm(dateMacroCreated, expireAfterProperty);
        }
        return ApprovalMigrationUtils.parseExpiryDate(this.safeParseInt(monthProperty), this.safeParseInt(dayProperty));
    }

    private String getSpaceMacroValue(String spaceKey, BandanaDataType bandanaDataType) {
        return (String)this.bandanaManager.getValue((BandanaContext)new ConfluenceBandanaContext(spaceKey), bandanaDataType.key);
    }
}

