/*
 * Decompiled with CFR 0.152.
 */
package co.uk.automationconsultants.approvals.service;

import co.uk.automationconsultants.approvals.ao.ApprovalMember;
import co.uk.automationconsultants.approvals.ao.settings.Group;
import co.uk.automationconsultants.approvals.ao.settings.SystemSettings;
import co.uk.automationconsultants.approvals.cache.SystemSettingsCache;
import co.uk.automationconsultants.approvals.json.settings.SystemSettingsJson;
import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.mywork.service.LocalNotificationService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.user.UserKey;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.Function;
import net.java.ao.DBParam;
import net.java.ao.Query;
import net.java.ao.RawEntity;

@Named(value="approvalSettingsService")
public class ApprovalSystemService {
    @ComponentImport
    private final ActiveObjects activeObjects;
    @ComponentImport
    private final UserAccessor userAccessor;
    @ComponentImport
    private final LocalNotificationService notificationService;
    private final SystemSettingsCache systemSettingsCache;
    public static final String ORDER_STRING = "ID ASC";

    @Inject
    public ApprovalSystemService(ActiveObjects activeObjects, UserAccessor userAccessor, LocalNotificationService notificationService, SystemSettingsCache systemSettingsCache) {
        this.activeObjects = activeObjects;
        this.userAccessor = userAccessor;
        this.notificationService = notificationService;
        this.systemSettingsCache = systemSettingsCache;
    }

    public SystemSettingsJson getSettings() {
        return this.systemSettingsCache.getSystemSettings();
    }

    public void removeMyNotifications(ConfluenceUser user) {
        for (ApprovalMember approvalMember : (ApprovalMember[])this.activeObjects.find(ApprovalMember.class, Query.select().where("USER_KEY = ? AND NOTIFICATION_ID IS NOT NULL", new Object[]{user.getKey().getStringValue()}))) {
            try {
                this.notificationService.delete(user.getName(), approvalMember.getNotificationId().longValue());
                approvalMember.setNotificationId(null);
                approvalMember.save();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void removeAllNotifications() {
        for (ApprovalMember approvalMember : (ApprovalMember[])this.activeObjects.find(ApprovalMember.class, Query.select().where("NOTIFICATION_ID IS NOT NULL", new Object[0]))) {
            try {
                ConfluenceUser user = this.userAccessor.getUserByKey(new UserKey(approvalMember.getUserKey()));
                if (user == null) continue;
                this.notificationService.delete(user.getName(), approvalMember.getNotificationId().longValue());
                approvalMember.setNotificationId(null);
                approvalMember.save();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public SystemSettingsJson updateSettings(SystemSettingsJson systemSettingsJson) {
        SystemSettingsJson change = this.getSettings();
        if (systemSettingsJson == null) {
            return null;
        }
        if (systemSettingsJson.getGloballyControlled() != null) {
            change.setGloballyControlled(systemSettingsJson.getGloballyControlled());
        }
        if (systemSettingsJson.getDefaultEnabled() != null) {
            change.setDefaultEnabled(systemSettingsJson.getDefaultEnabled());
        }
        if (systemSettingsJson.getEnabled() != null) {
            change.setEnabled(systemSettingsJson.getEnabled());
        }
        if (systemSettingsJson.getNotificationsEmail() != null) {
            change.setNotificationsEmail(systemSettingsJson.getNotificationsEmail());
        }
        if (systemSettingsJson.getNotificationsInApp() != null) {
            change.setNotificationsInApp(systemSettingsJson.getNotificationsInApp());
        }
        if (systemSettingsJson.getApprovedText() != null && systemSettingsJson.getApprovedText().length() > 1) {
            change.setApprovedText(systemSettingsJson.getApprovedText());
        }
        if (systemSettingsJson.getRejectedText() != null && systemSettingsJson.getRejectedText().length() > 1) {
            change.setRejectedText(systemSettingsJson.getRejectedText());
        }
        if (systemSettingsJson.getPendingText() != null && systemSettingsJson.getPendingText().length() > 1) {
            change.setPendingText(systemSettingsJson.getPendingText());
        }
        if (systemSettingsJson.getExpiredText() != null && systemSettingsJson.getExpiredText().length() > 1) {
            change.setExpiredText(systemSettingsJson.getExpiredText());
        }
        if (systemSettingsJson.getCreateApprovalGroups() != null) {
            change.setCreateApprovalGroups(systemSettingsJson.getCreateApprovalGroups());
        }
        return ApprovalSystemService.mapSettingsToJson((SystemSettings)this.activeObjects.executeInTransaction(() -> {
            SystemSettings systemSettings;
            SystemSettings[] settings = (SystemSettings[])this.activeObjects.find(SystemSettings.class, Query.select().order(ORDER_STRING).limit(1));
            if (settings.length < 1) {
                systemSettings = (SystemSettings)this.activeObjects.create(SystemSettings.class, new DBParam[]{new DBParam("GLOBALLY_CONTROLLED", (Object)change.getGloballyControlled()), new DBParam("DEFAULT_ENABLED", (Object)change.getDefaultEnabled()), new DBParam("ENABLED", (Object)change.getEnabled()), new DBParam("PENDING_TEXT", (Object)change.getPendingText()), new DBParam("APPROVED_TEXT", (Object)change.getApprovedText()), new DBParam("REJECTED_TEXT", (Object)change.getRejectedText()), new DBParam("EXPIRED_TEXT", (Object)change.getExpiredText()), new DBParam("CREATE_APPROVAL_RESTRICTED", (Object)(!change.getCreateApprovalGroups().isEmpty() ? 1 : 0)), new DBParam("NOTIFICATIONS_IN_APP", (Object)change.getNotificationsInApp()), new DBParam("NOTIFICATIONS_EMAIL", (Object)change.getNotificationsEmail())});
            } else {
                for (Group group2 : (Group[])this.activeObjects.find(Group.class, Query.select().where("SYSTEM_SETTINGS_ID = ?", new Object[]{settings[0].getID()}))) {
                    if (change.getCreateApprovalGroups().contains(group2.getName())) continue;
                    this.activeObjects.delete(new RawEntity[]{group2});
                }
                SystemSettings[] refreshedSettings = (SystemSettings[])this.activeObjects.find(SystemSettings.class, Query.select().order(ORDER_STRING).limit(1));
                systemSettings = refreshedSettings[0];
                systemSettings.setGloballyControlled(change.getGloballyControlled());
                systemSettings.setDefaultEnabled(change.getDefaultEnabled());
                systemSettings.setEnabled(change.getEnabled());
                systemSettings.setApprovedText(change.getApprovedText());
                systemSettings.setRejectedText(change.getRejectedText());
                systemSettings.setPendingText(change.getPendingText());
                systemSettings.setExpiredText(change.getExpiredText());
                systemSettings.setCreateApprovalRestricted(change.getCreateApprovalGroups().isEmpty());
                systemSettings.setNotificationsEmail(change.getNotificationsEmail());
                systemSettings.setNotificationsInApp(change.getNotificationsInApp());
                systemSettings.save();
            }
            for (String createApprovalGroup : change.getCreateApprovalGroups()) {
                if (this.userAccessor.getGroup(createApprovalGroup) == null || !Arrays.stream(systemSettings.getCreateApprovalGroups()).noneMatch(group -> group.getName().equals(createApprovalGroup))) continue;
                this.activeObjects.create(Group.class, new DBParam[]{new DBParam("SYSTEM_SETTINGS_ID", (Object)systemSettings.getID()), new DBParam("NAME", (Object)createApprovalGroup)});
            }
            systemSettings.save();
            this.systemSettingsCache.invalidateCaches();
            return systemSettings;
        }));
    }

    public static SystemSettingsJson mapSettingsToJson(SystemSettings systemSettings) {
        ArrayList<String> groupNames = new ArrayList<String>();
        Function<Group, Object> mapper = Group::getName;
        for (Group group : systemSettings.getCreateApprovalGroups()) {
            String o = (String)mapper.apply(group);
            groupNames.add(o);
        }
        return new SystemSettingsJson(systemSettings.isGloballyControlled(), systemSettings.isDefaultEnabled(), systemSettings.isEnabled(), systemSettings.getPendingText(), systemSettings.getApprovedText(), systemSettings.getRejectedText(), systemSettings.getExpiredText(), groupNames, systemSettings.isNotificationsInApp(), systemSettings.isNotificationsEmail());
    }

    public static SystemSettingsJson getDefaultJson() {
        return new SystemSettingsJson(false, true, true, "Pending", "Approved", "Rejected", "Expired", new ArrayList<String>(), true, true);
    }
}

