/*
 * Decompiled with CFR 0.152.
 */
package co.uk.automationconsultants.approvals.service;

import co.uk.automationconsultants.approvals.ao.Approval;
import co.uk.automationconsultants.approvals.ao.ApprovalMember;
import co.uk.automationconsultants.approvals.ao.settings.SystemStats;
import co.uk.automationconsultants.approvals.json.ApprovalJson;
import co.uk.automationconsultants.approvals.json.ApprovalMemberJson;
import co.uk.automationconsultants.approvals.json.request.ActionRequest;
import co.uk.automationconsultants.approvals.json.request.ApprovalCreationJson;
import co.uk.automationconsultants.approvals.json.request.ApprovalCreationPageJson;
import co.uk.automationconsultants.approvals.json.settings.SystemStatsJson;
import co.uk.automationconsultants.approvals.service.ApprovalMaintenanceService;
import co.uk.automationconsultants.approvals.service.enumerator.ApproverType;
import co.uk.automationconsultants.approvals.service.events.ApprovalRequestEvent;
import co.uk.automationconsultants.approvals.service.events.ApprovalStatusEvent;
import co.uk.automationconsultants.approvals.service.exception.InvalidJsonException;
import co.uk.automationconsultants.approvals.service.exception.NoApprovalException;
import co.uk.automationconsultants.approvals.service.exception.NoPageException;
import co.uk.automationconsultants.approvals.service.exception.NoPagePermissionException;
import co.uk.automationconsultants.approvals.service.exception.NoPageVersionException;
import co.uk.automationconsultants.approvals.service.exception.NoSpacePermissionException;
import co.uk.automationconsultants.approvals.service.exception.OutdatedApprovalException;
import co.uk.automationconsultants.approvals.utils.ConfluencePageUtils;
import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.confluence.core.ContentPermissionManager;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.security.SpacePermissionManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.mywork.service.LocalNotificationService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.user.UserKey;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.java.ao.DBParam;
import net.java.ao.Query;
import net.java.ao.RawEntity;

@Named(value="approvalService")
public class ApprovalService {
    @ComponentImport
    private final PageManager pageManager;
    @ComponentImport
    private final ActiveObjects activeObjects;
    @ComponentImport
    private final ContentPermissionManager contentPermissionManager;
    @ComponentImport
    private final SpacePermissionManager spacePermissionManager;
    @ComponentImport
    private final UserAccessor userAccessor;
    @ComponentImport
    private final EventPublisher eventPublisher;
    @ComponentImport
    private final LocalNotificationService notificationService;
    private final ConfluencePageUtils confluencePageUtils;
    private final ApprovalMaintenanceService approvalMaintenanceService;
    public static final String PAGE_TYPE = "page";
    private static final String MACRO_TYPE = "macro";

    @Inject
    public ApprovalService(PageManager pageManager, ActiveObjects activeObjects, ContentPermissionManager contentPermissionManager, SpacePermissionManager spacePermissionManager, UserAccessor userAccessor, EventPublisher eventPublisher, LocalNotificationService notificationService, ApprovalMaintenanceService approvalMaintenanceService, ConfluencePageUtils confluencePageUtils) {
        this.pageManager = pageManager;
        this.activeObjects = activeObjects;
        this.contentPermissionManager = contentPermissionManager;
        this.spacePermissionManager = spacePermissionManager;
        this.userAccessor = userAccessor;
        this.eventPublisher = eventPublisher;
        this.notificationService = notificationService;
        this.approvalMaintenanceService = approvalMaintenanceService;
        this.confluencePageUtils = confluencePageUtils;
    }

    public ApprovalJson getPageApproval(ConfluenceUser user, long pageId, int version) {
        try {
            Integer lastApprovedVersion = this.getLastApprovedVersion(pageId);
            Approval pageApprovalEntity = this.getPageApprovalEntity(pageId, version);
            return ApprovalJson.map(this.userAccessor, pageApprovalEntity, lastApprovedVersion);
        }
        catch (NoApprovalException e) {
            return null;
        }
    }

    public Approval getRawPageApproval(ConfluenceUser user, long pageId, int version) {
        try {
            return this.getPageApprovalEntity(pageId, version);
        }
        catch (NoApprovalException e) {
            return null;
        }
    }

    public ApprovalJson postPageApproval(ConfluenceUser user, long pageId, ApprovalCreationJson approvalJson, ApprovalJson existingApproval) throws NoPageException, NoSpacePermissionException, NoPagePermissionException, NoPageVersionException, NoApprovalException, InvalidJsonException {
        AbstractPage latestPageVersion = this.confluencePageUtils.getConfluencePage(user, pageId, approvalJson.getVersion());
        if (existingApproval == null) {
            return ApprovalJson.map(this.userAccessor, this.createPageApprovalEntity(this.setPageApprovalDefaults(user, approvalJson, latestPageVersion), latestPageVersion));
        }
        return ApprovalJson.map(this.userAccessor, this.updatePageApprovalEntity(user, existingApproval, approvalJson, latestPageVersion));
    }

    private Approval createPageApprovalEntity(ApprovalCreationJson newApproval, AbstractPage page) throws NoApprovalException {
        Date now = new Date();
        String user = newApproval.getCreatorUsername();
        HashMap<String, ApproverType> approvers = new HashMap<String, ApproverType>();
        Approval approval = (Approval)this.activeObjects.executeInTransaction(() -> {
            Approval approvalRet = (Approval)this.activeObjects.create(Approval.class, new DBParam[]{new DBParam("TYPE", (Object)PAGE_TYPE), new DBParam("STATUS", (Object)"pending"), new DBParam("TITLE", (Object)newApproval.getTitle()), new DBParam("MACRO_ID", null), new DBParam("PAGE_ID", (Object)newApproval.getPageId()), new DBParam("EXPIRE_ON_EDIT", (Object)newApproval.getExpireOnEdit()), new DBParam("EXPIRY_DATE", (Object)newApproval.getExpiryDate()), new DBParam("QUORUM_SIZE", (Object)newApproval.getQuorumSize()), new DBParam("POST_COMMENTS_ENABLED", (Object)newApproval.getPostCommentsEnabled()), new DBParam("CREATION_DATE", (Object)now), new DBParam("UPDATE_DATE", (Object)now), new DBParam("CREATOR", (Object)user), new DBParam("UPDATOR", (Object)user), new DBParam("VERSION", (Object)newApproval.getVersion()), new DBParam("STATUS_NOTIFICATION_ENABLED", (Object)newApproval.getStatusNotificationsEnabled()), new DBParam("REQUEST_NOTIFICATION_ENABLED", (Object)newApproval.getRequestNotificationsEnabled()), new DBParam("UUID", null), new DBParam("SUPERSEDED", (Object)false), new DBParam("SPACE_ID", (Object)page.getSpace().getId())});
            return this.createMembers(newApproval, approvers, approvalRet);
        });
        this.processRequestEmails(approvers, approval);
        return approval;
    }

    public ApprovalJson updateExistingApproval(ConfluenceUser user, long pageId, ApprovalCreationJson approvalJson, Approval existingApproval) throws NoPageException, NoSpacePermissionException, NoPagePermissionException, NoPageVersionException {
        AbstractPage page = this.confluencePageUtils.getConfluencePage(user, pageId, approvalJson.getVersion());
        this.markSupersededPageApprovals(page.getId(), page.getLatestVersion().getVersion() - 1);
        Approval approval = (Approval)this.activeObjects.executeInTransaction(() -> {
            HashMap<String, ApprovalMember> existingMembers = new HashMap<String, ApprovalMember>();
            HashMap<String, ApproverType> approverEmails = new HashMap<String, ApproverType>();
            for (ApprovalMember member : existingApproval.getMembers()) {
                existingMembers.put(member.getUserKey(), member);
            }
            ArrayList<String> newApproverStatus = new ArrayList<String>();
            for (String approvalMember : approvalJson.getMembers()) {
                if (!existingMembers.containsKey(approvalMember)) {
                    this.activeObjects.create(ApprovalMember.class, new DBParam[]{new DBParam("APPROVAL_ID", (Object)existingApproval.getID()), new DBParam("USER_KEY", (Object)approvalMember), new DBParam("STATUS", (Object)"pending"), new DBParam("DATE", (Object)new Date())});
                    newApproverStatus.add("pending");
                    approverEmails.put(approvalMember, ApproverType.APPROVAL);
                    continue;
                }
                newApproverStatus.add(((ApprovalMember)existingMembers.get(approvalMember)).getStatus());
                existingMembers.remove(approvalMember);
            }
            existingMembers.forEach((userKey, memberObject) -> this.activeObjects.delete(new RawEntity[]{memberObject}));
            String newState = "pending";
            int quorumSize = approvalJson.getQuorumSize() == 0 ? newApproverStatus.size() : approvalJson.getQuorumSize().intValue();
            int approves = 0;
            for (String status : newApproverStatus) {
                if (status.equals("rejected")) {
                    newState = "rejected";
                    break;
                }
                if (!status.equals("approved") || ++approves < quorumSize) continue;
                newState = "approved";
                break;
            }
            existingApproval.setExpireOnEdit(approvalJson.expireOnEdit);
            existingApproval.setExpiryDate(approvalJson.expiryDate);
            existingApproval.setQuorumSize(approvalJson.quorumSize);
            existingApproval.setRequestNotificationEnabled(approvalJson.requestNotificationsEnabled);
            existingApproval.setStatusNotificationEnabled(approvalJson.getStatusNotificationsEnabled());
            existingApproval.setTitle(approvalJson.title);
            existingApproval.setUpdateDate(new Date());
            existingApproval.setUpdator(user.getKey().getStringValue());
            existingApproval.setVersion(approvalJson.version);
            existingApproval.setStatus(newState);
            this.removeNotifications(existingApproval.getMembers());
            existingApproval.save();
            this.processRequestEmails(approverEmails, existingApproval);
            return existingApproval;
        });
        return ApprovalJson.map(this.userAccessor, approval);
    }

    private Approval updatePageApprovalEntity(ConfluenceUser user, ApprovalJson existingApproval, ApprovalCreationJson newApproval, AbstractPage page) {
        this.markSupersededPageApprovals(page.getId(), page.getLatestVersion().getVersion());
        HashMap<String, ApproverType> approvers = new HashMap<String, ApproverType>();
        boolean expired = false;
        boolean expireOnEdit = existingApproval.getExpireOnEdit();
        for (ApprovalMemberJson approvalMemberJson : existingApproval.getMembers()) {
            if (!newApproval.getMembers().contains(approvalMemberJson.getUserKey()) || approvalMemberJson.getStatus().equals("pending")) continue;
            approvers.put(approvalMemberJson.getUserKey(), ApproverType.REAPPROVAL);
            expired = true;
        }
        for (String string : newApproval.getMembers()) {
            if (approvers.keySet().contains(string)) continue;
            approvers.put(string, ApproverType.APPROVAL);
        }
        boolean finalExpired = expired;
        Approval approval = (Approval)this.activeObjects.executeInTransaction(() -> {
            DBParam[] dBParamArray = new DBParam[19];
            dBParamArray[0] = new DBParam("TYPE", (Object)PAGE_TYPE);
            dBParamArray[1] = new DBParam("TITLE", (Object)newApproval.getTitle());
            dBParamArray[2] = new DBParam("STATUS", (Object)(expireOnEdit ? (finalExpired ? "expired" : "pending") : existingApproval.getStatus()));
            dBParamArray[3] = new DBParam("MACRO_ID", null);
            dBParamArray[4] = new DBParam("PAGE_ID", (Object)newApproval.getPageId());
            dBParamArray[5] = new DBParam("EXPIRE_ON_EDIT", (Object)newApproval.getExpireOnEdit());
            dBParamArray[6] = new DBParam("EXPIRY_DATE", (Object)newApproval.getExpiryDate());
            dBParamArray[7] = new DBParam("QUORUM_SIZE", (Object)newApproval.getQuorumSize());
            dBParamArray[8] = new DBParam("POST_COMMENTS_ENABLED", (Object)newApproval.getPostCommentsEnabled());
            dBParamArray[9] = new DBParam("CREATION_DATE", (Object)existingApproval.getCreated());
            dBParamArray[10] = new DBParam("UPDATE_DATE", (Object)new Date());
            dBParamArray[11] = new DBParam("CREATOR", (Object)existingApproval.getCreatorUsername());
            dBParamArray[12] = new DBParam("UPDATOR", (Object)user.getKey().getStringValue());
            dBParamArray[13] = new DBParam("VERSION", (Object)page.getLatestVersion().getVersion());
            dBParamArray[14] = new DBParam("STATUS_NOTIFICATION_ENABLED", (Object)newApproval.getStatusNotificationsEnabled());
            dBParamArray[15] = new DBParam("REQUEST_NOTIFICATION_ENABLED", (Object)newApproval.getRequestNotificationsEnabled());
            dBParamArray[16] = new DBParam("UUID", null);
            dBParamArray[17] = new DBParam("SUPERSEDED", (Object)false);
            dBParamArray[18] = new DBParam("SPACE_ID", (Object)page.getSpace().getId());
            Approval approvalInner = (Approval)this.activeObjects.create(Approval.class, dBParamArray);
            if (!expireOnEdit) {
                for (ApprovalMemberJson member : existingApproval.getMembers()) {
                    this.activeObjects.create(ApprovalMember.class, new DBParam[]{new DBParam("APPROVAL_ID", (Object)approvalInner.getID()), new DBParam("USER_KEY", (Object)member.getUserKey()), new DBParam("STATUS", (Object)member.getStatus()), new DBParam("COMMENT", (Object)member.getComment())});
                }
            } else {
                for (String userKey : approvers.keySet()) {
                    this.activeObjects.create(ApprovalMember.class, new DBParam[]{new DBParam("APPROVAL_ID", (Object)approvalInner.getID()), new DBParam("USER_KEY", (Object)userKey), new DBParam("STATUS", (Object)(((ApproverType)((Object)((Object)((Object)approvers.get(userKey))))).equals((Object)ApproverType.APPROVAL) ? "pending" : "expired"))});
                }
            }
            return approvalInner;
        });
        if (expireOnEdit) {
            this.processRequestEmails(approvers, approval);
        }
        return approval;
    }

    public ApprovalJson getMacroApproval(ConfluenceUser user, long pageId, String uuid, String macroId, int version) throws NoPageException, NoSpacePermissionException, NoPagePermissionException, NoPageVersionException, NoApprovalException {
        return ApprovalJson.map(this.userAccessor, this.getMacroApprovalEntity(this.confluencePageUtils.getConfluencePage(user, pageId, version), uuid, macroId, pageId));
    }

    public ApprovalJson postMacroApproval(ConfluenceUser user, long pageId, ApprovalCreationJson approvalJson) throws NoPageException, NoSpacePermissionException, NoPagePermissionException, NoPageVersionException, InvalidJsonException, NoApprovalException {
        AbstractPage latestPageVersion = this.confluencePageUtils.getConfluencePage(user, pageId, null);
        try {
            Approval lastApproval = this.getMacroApprovalEntityUuid(latestPageVersion, approvalJson.getUuid());
            return ApprovalJson.map(this.userAccessor, this.updateMacroApprovalEntity(user, lastApproval, approvalJson, latestPageVersion));
        }
        catch (NoApprovalException e) {
            ApprovalCreationJson newApproval = this.setMacroApprovalDefaults(user, approvalJson, latestPageVersion);
            return ApprovalJson.map(this.userAccessor, this.createMacroApprovalEntity(newApproval, latestPageVersion));
        }
    }

    public ApprovalJson actionMacroApproval(ConfluenceUser user, ActionRequest actionRequest) throws NoPageException, NoSpacePermissionException, NoPagePermissionException, NoPageVersionException, OutdatedApprovalException, NoApprovalException {
        AbstractPage page = this.confluencePageUtils.getConfluencePage(user, actionRequest.getPageId(), actionRequest.getVersion());
        Approval approval = this.getMacroApprovalEntityUuid(page, actionRequest.getUuid());
        return this.actionApproval(user, page, approval, actionRequest.getAction(), actionRequest.getVersion(), null);
    }

    public ApprovalJson actionPageApproval(ConfluenceUser user, ActionRequest actionRequest) throws NoPageException, NoSpacePermissionException, NoPagePermissionException, NoPageVersionException, NoApprovalException, OutdatedApprovalException {
        AbstractPage page = this.confluencePageUtils.getConfluencePage(user, actionRequest.getPageId(), actionRequest.getVersion());
        Approval approval = this.getPageApprovalEntity(page.getId(), page.getVersion());
        return this.actionApproval(user, page, approval, actionRequest.getAction(), actionRequest.getVersion(), actionRequest.getComment());
    }

    private ApprovalJson actionApproval(ConfluenceUser user, AbstractPage page, Approval approval, String action, int version, String comment) throws OutdatedApprovalException {
        if (page.getLatestVersion().getVersion() == version) {
            AtomicBoolean success = new AtomicBoolean(false);
            Approval finalApproval1 = approval;
            approval = (Approval)this.activeObjects.executeInTransaction(() -> {
                for (ApprovalMember approvalMember : finalApproval1.getMembers()) {
                    if (!approvalMember.getUserKey().equals(user.getKey().getStringValue())) continue;
                    if (action.equals("approved") && !approvalMember.getStatus().equals("approved")) {
                        approvalMember.setStatus("approved");
                        approvalMember.setDate(new Date());
                        approvalMember.setComment(comment);
                        approvalMember.save();
                        success.set(true);
                        continue;
                    }
                    if (!action.equals("rejected") || approvalMember.getStatus().equals("rejected")) continue;
                    approvalMember.setStatus("rejected");
                    approvalMember.setDate(new Date());
                    approvalMember.setComment(comment);
                    approvalMember.save();
                    success.set(true);
                }
                this.removeNotifications(finalApproval1.getMembers());
                return finalApproval1;
            });
            if (success.get()) {
                Approval finalApproval = approval;
                return (ApprovalJson)this.activeObjects.executeInTransaction(() -> {
                    String currentStatus = finalApproval.getStatus();
                    switch (action) {
                        case "approved": {
                            Integer quorumSize = finalApproval.getQuorumSize();
                            if (quorumSize == 0) {
                                quorumSize = finalApproval.getMembers().length;
                            }
                            long newApprovedCount = Arrays.stream(finalApproval.getMembers()).filter(member -> member.getStatus().equals("approved") && !member.getUserKey().equals(user.getKey().getStringValue())).count() + 1L;
                            long newRejectedCount = Arrays.stream(finalApproval.getMembers()).filter(member -> member.getStatus().equals("rejected") && !member.getUserKey().equals(user.getKey().getStringValue())).count();
                            if (newApprovedCount >= (long)quorumSize.intValue() && newRejectedCount == 0L) {
                                finalApproval.setStatus("approved");
                                finalApproval.save();
                                this.processStatusEmails(finalApproval, "allApproved");
                                break;
                            }
                            if (newRejectedCount < 1L) {
                                finalApproval.setStatus("pending");
                            }
                            finalApproval.save();
                            this.processStatusEmails(finalApproval, "oneApproved");
                            break;
                        }
                        case "rejected": {
                            finalApproval.setStatus("rejected");
                            finalApproval.save();
                            this.processStatusEmails(finalApproval, "oneRejected");
                            break;
                        }
                    }
                    return ApprovalJson.map(this.userAccessor, finalApproval);
                });
            }
            return null;
        }
        throw new OutdatedApprovalException();
    }

    private Approval createMacroApprovalEntity(ApprovalCreationJson newApproval, AbstractPage page) {
        Date now = new Date();
        String user = newApproval.getCreatorUsername();
        HashMap<String, ApproverType> approvers = new HashMap<String, ApproverType>();
        Approval approval = (Approval)this.activeObjects.executeInTransaction(() -> {
            Approval approvalEntity = (Approval)this.activeObjects.create(Approval.class, new DBParam[]{new DBParam("TYPE", (Object)MACRO_TYPE), new DBParam("TITLE", (Object)newApproval.getTitle()), new DBParam("STATUS", (Object)"pending"), new DBParam("MACRO_ID", (Object)newApproval.getMacroId()), new DBParam("PAGE_ID", (Object)newApproval.getPageId()), new DBParam("EXPIRE_ON_EDIT", (Object)newApproval.getExpireOnEdit()), new DBParam("EXPIRY_DATE", (Object)newApproval.getExpiryDate()), new DBParam("QUORUM_SIZE", (Object)newApproval.getQuorumSize()), new DBParam("POST_COMMENTS_ENABLED", (Object)newApproval.getPostCommentsEnabled()), new DBParam("CREATION_DATE", (Object)now), new DBParam("UPDATE_DATE", (Object)now), new DBParam("CREATOR", (Object)user), new DBParam("UPDATOR", (Object)user), new DBParam("VERSION", (Object)newApproval.getVersion()), new DBParam("STATUS_NOTIFICATION_ENABLED", (Object)newApproval.getStatusNotificationsEnabled()), new DBParam("REQUEST_NOTIFICATION_ENABLED", (Object)newApproval.getRequestNotificationsEnabled()), new DBParam("UUID", (Object)newApproval.getUuid()), new DBParam("SUPERSEDED", (Object)false), new DBParam("SPACE_ID", (Object)page.getSpace().getId())});
            return this.createMembers(newApproval, approvers, approvalEntity);
        });
        this.processRequestEmails(approvers, approval);
        return approval;
    }

    private Approval updateMacroApprovalEntity(ConfluenceUser user, Approval existingApproval, ApprovalCreationJson newApproval, AbstractPage page) throws NoApprovalException {
        this.markSupersededMacros(page.getId(), page.getVersion(), existingApproval.getUuid());
        HashMap<String, ApproverType> approvers = new HashMap<String, ApproverType>();
        boolean expireOnEdit = existingApproval.isExpireOnEdit();
        boolean expired = false;
        for (ApprovalMember member : existingApproval.getMembers()) {
            if (!newApproval.getMembers().contains(member.getUserKey()) || member.getStatus().equals("pending")) continue;
            approvers.put(member.getUserKey(), ApproverType.REAPPROVAL);
            expired = true;
        }
        for (String member : newApproval.getMembers()) {
            if (approvers.containsKey(member)) continue;
            approvers.put(member, ApproverType.APPROVAL);
        }
        boolean finalExpired = expired;
        Approval approvalEntity = (Approval)this.activeObjects.executeInTransaction(() -> {
            DBParam[] dBParamArray = new DBParam[19];
            dBParamArray[0] = new DBParam("TYPE", (Object)MACRO_TYPE);
            dBParamArray[1] = new DBParam("STATUS", (Object)(expireOnEdit ? (finalExpired ? "expired" : "pending") : existingApproval.getStatus()));
            dBParamArray[2] = new DBParam("TITLE", (Object)newApproval.getTitle());
            dBParamArray[3] = new DBParam("MACRO_ID", (Object)newApproval.getMacroId());
            dBParamArray[4] = new DBParam("PAGE_ID", (Object)newApproval.getPageId());
            dBParamArray[5] = new DBParam("EXPIRE_ON_EDIT", (Object)newApproval.getExpireOnEdit());
            dBParamArray[6] = new DBParam("EXPIRY_DATE", (Object)newApproval.getExpiryDate());
            dBParamArray[7] = new DBParam("QUORUM_SIZE", (Object)newApproval.getQuorumSize());
            dBParamArray[8] = new DBParam("POST_COMMENTS_ENABLED", (Object)newApproval.getPostCommentsEnabled());
            dBParamArray[9] = new DBParam("CREATION_DATE", (Object)existingApproval.getCreationDate());
            dBParamArray[10] = new DBParam("UPDATE_DATE", (Object)new Date());
            dBParamArray[11] = new DBParam("CREATOR", (Object)existingApproval.getCreator());
            dBParamArray[12] = new DBParam("UPDATOR", (Object)user.getKey().getStringValue());
            dBParamArray[13] = new DBParam("VERSION", (Object)newApproval.getVersion());
            dBParamArray[14] = new DBParam("STATUS_NOTIFICATION_ENABLED", (Object)newApproval.getStatusNotificationsEnabled());
            dBParamArray[15] = new DBParam("REQUEST_NOTIFICATION_ENABLED", (Object)newApproval.getRequestNotificationsEnabled());
            dBParamArray[16] = new DBParam("UUID", (Object)newApproval.getUuid());
            dBParamArray[17] = new DBParam("SUPERSEDED", (Object)false);
            dBParamArray[18] = new DBParam("SPACE_ID", (Object)page.getSpace().getId());
            Approval approval = (Approval)this.activeObjects.create(Approval.class, dBParamArray);
            if (expireOnEdit) {
                for (String userKey : approvers.keySet()) {
                    this.activeObjects.create(ApprovalMember.class, new DBParam[]{new DBParam("APPROVAL_ID", (Object)approval.getID()), new DBParam("USER_KEY", (Object)userKey), new DBParam("DATE", (Object)new Date()), new DBParam("STATUS", (Object)(((ApproverType)((Object)((Object)approvers.get(userKey)))).equals((Object)ApproverType.APPROVAL) ? "pending" : "expired"))});
                }
            } else {
                HashSet<String> processed = new HashSet<String>();
                for (ApprovalMember member : existingApproval.getMembers()) {
                    if (!approvers.containsKey(member.getUserKey())) continue;
                    processed.add(member.getUserKey());
                    this.activeObjects.create(ApprovalMember.class, new DBParam[]{new DBParam("APPROVAL_ID", (Object)approval.getID()), new DBParam("USER_KEY", (Object)member.getUserKey()), new DBParam("DATE", (Object)member.getDate()), new DBParam("STATUS", (Object)member.getStatus())});
                }
                HashSet newApprovers = new HashSet(approvers.keySet());
                newApprovers.removeAll(processed);
                for (String userKey : newApprovers) {
                    this.activeObjects.create(ApprovalMember.class, new DBParam[]{new DBParam("APPROVAL_ID", (Object)approval.getID()), new DBParam("USER_KEY", (Object)userKey), new DBParam("DATE", (Object)new Date()), new DBParam("STATUS", (Object)"pending")});
                }
            }
            return approval;
        });
        if (expireOnEdit) {
            this.processRequestEmails(approvers, approvalEntity);
        } else if (Boolean.TRUE.equals(existingApproval.isRequestNotificationEnabled())) {
            Set existingApprovers = Arrays.stream(existingApproval.getMembers()).map(ApprovalMember::getUserKey).collect(Collectors.toSet());
            this.processRequestEmails(approvers.entrySet().stream().filter(entry -> !existingApprovers.contains(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)), approvalEntity);
        }
        return approvalEntity;
    }

    private Approval createMembers(ApprovalCreationJson newApproval, Map<String, ApproverType> approvers, Approval approval) {
        List<String> members = newApproval.getMembers();
        for (String member : members) {
            approvers.put(member, ApproverType.APPROVAL);
            this.activeObjects.create(ApprovalMember.class, new DBParam[]{new DBParam("APPROVAL_ID", (Object)approval.getID()), new DBParam("USER_KEY", (Object)member), new DBParam("DATE", (Object)new Date()), new DBParam("STATUS", (Object)"pending")});
        }
        return approval;
    }

    private void processRequestEmails(Map<String, ApproverType> map, Approval approval) {
        this.eventPublisher.publish((Object)new ApprovalRequestEvent(this, map, approval, approval.getTitle()));
    }

    private void processStatusEmails(Approval approval, String type) {
        this.eventPublisher.publish((Object)new ApprovalStatusEvent(this, type, approval));
    }

    private ApprovalCreationJson setPageApprovalDefaults(ConfluenceUser user, ApprovalCreationJson approval, AbstractPage page) throws InvalidJsonException {
        if (approval.getTitle() == null) {
            throw new InvalidJsonException();
        }
        if (approval.getMembers() == null || approval.getMembers().size() < 1) {
            throw new InvalidJsonException();
        }
        ApprovalCreationJson newApproval = new ApprovalCreationJson();
        newApproval.setPageId(page.getId());
        newApproval.setCreatorUsername(user.getKey().getStringValue());
        newApproval.setExpireOnEdit(approval.getExpireOnEdit());
        newApproval.setExpiryDate(approval.getExpiryDate());
        newApproval.setPostCommentsEnabled(approval.getPostCommentsEnabled());
        newApproval.setQuorumSize(approval.getQuorumSize());
        newApproval.setRequestNotificationsEnabled(approval.getRequestNotificationsEnabled());
        newApproval.setStatusNotificationsEnabled(approval.getStatusNotificationsEnabled());
        newApproval.setTitle(approval.getTitle());
        newApproval.setType(PAGE_TYPE);
        newApproval.setMembers(approval.getMembers());
        newApproval.setUuid(null);
        newApproval.setMacroId(null);
        newApproval.setVersion(page.getVersion());
        return newApproval;
    }

    private ApprovalCreationJson setMacroApprovalDefaults(ConfluenceUser user, ApprovalCreationJson approval, AbstractPage page) throws InvalidJsonException {
        if (approval.getTitle() == null) {
            throw new InvalidJsonException();
        }
        if (approval.getMembers() == null || approval.getMembers().size() < 1) {
            throw new InvalidJsonException();
        }
        if (approval.getMacroId() == null || approval.getMacroId().length() < 1) {
            throw new InvalidJsonException();
        }
        if (approval.getUuid() == null || approval.getUuid().length() < 1) {
            throw new InvalidJsonException();
        }
        ApprovalCreationJson newApproval = new ApprovalCreationJson();
        newApproval.setPageId(page.getId());
        newApproval.setCreatorUsername(user.getKey().getStringValue());
        newApproval.setExpireOnEdit(approval.getExpireOnEdit() == null ? false : approval.getExpireOnEdit());
        newApproval.setExpiryDate(approval.getExpiryDate());
        newApproval.setPostCommentsEnabled(approval.getPostCommentsEnabled() == null ? false : approval.getPostCommentsEnabled());
        newApproval.setQuorumSize(approval.getQuorumSize());
        newApproval.setRequestNotificationsEnabled(approval.getRequestNotificationsEnabled() == null ? false : approval.getRequestNotificationsEnabled());
        newApproval.setStatusNotificationsEnabled(approval.getStatusNotificationsEnabled() == null ? false : approval.getStatusNotificationsEnabled());
        newApproval.setTitle(approval.getTitle());
        newApproval.setType(MACRO_TYPE);
        newApproval.setUuid(approval.getUuid());
        newApproval.setMacroId(approval.getMacroId());
        newApproval.setMembers(approval.getMembers());
        newApproval.setVersion(page.getVersion());
        return newApproval;
    }

    public ApprovalCreationJson setMacroApprovalDefaultsNoCheck(ConfluenceUser user, ApprovalCreationJson approval, AbstractPage page) {
        ApprovalCreationJson newApproval = new ApprovalCreationJson();
        newApproval.setPageId(page.getId());
        newApproval.setCreatorUsername(user.getKey().getStringValue());
        newApproval.setExpireOnEdit(approval.getExpireOnEdit() == null ? false : approval.getExpireOnEdit());
        newApproval.setExpiryDate(approval.getExpiryDate());
        newApproval.setPostCommentsEnabled(approval.getPostCommentsEnabled() == null ? false : approval.getPostCommentsEnabled());
        newApproval.setQuorumSize(approval.getQuorumSize());
        newApproval.setRequestNotificationsEnabled(approval.getRequestNotificationsEnabled() == null ? false : approval.getRequestNotificationsEnabled());
        newApproval.setStatusNotificationsEnabled(approval.getStatusNotificationsEnabled() == null ? false : approval.getStatusNotificationsEnabled());
        newApproval.setTitle(approval.getTitle());
        newApproval.setType(MACRO_TYPE);
        newApproval.setUuid(approval.getUuid());
        newApproval.setMacroId(approval.getMacroId());
        newApproval.setVersion(page.getVersion());
        return newApproval;
    }

    public ApprovalCreationJson setPageApprovalDefaultsNoCheck(ConfluenceUser user, ApprovalCreationPageJson approval, AbstractPage page) throws ParseException {
        ApprovalCreationJson newApproval = new ApprovalCreationJson();
        newApproval.setPageId(page.getId());
        newApproval.setCreatorUsername(user.getKey().getStringValue());
        newApproval.setExpireOnEdit(approval.getExpireOnEdit());
        if (approval.getExpiryDate() != null && approval.getExpiryDate().length() != 0) {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
            newApproval.setExpiryDate(format.parse(approval.getExpiryDate()));
        }
        newApproval.setMembers(approval.getMembers());
        newApproval.setPostCommentsEnabled(approval.getPostCommentsEnabled() == null ? false : approval.getPostCommentsEnabled());
        newApproval.setQuorumSize(approval.getQuorumSize());
        newApproval.setRequestNotificationsEnabled(approval.getRequestNotificationsEnabled() == null ? false : approval.getRequestNotificationsEnabled());
        newApproval.setStatusNotificationsEnabled(approval.getStatusNotificationsEnabled() == null ? false : approval.getStatusNotificationsEnabled());
        newApproval.setTitle(approval.getTitle());
        newApproval.setType(PAGE_TYPE);
        newApproval.setUuid(null);
        newApproval.setMacroId(null);
        newApproval.setVersion(page.getVersion());
        return newApproval;
    }

    private Integer getLastApprovedVersion(Long pageId) {
        Approval[] approvals = (Approval[])this.activeObjects.find(Approval.class, Query.select().where("TYPE = ? AND PAGE_ID = ? AND UUID IS NULL AND STATUS = ?", new Object[]{PAGE_TYPE, pageId, "approved"}).order("VERSION DESC").limit(1));
        if (approvals.length == 0) {
            return null;
        }
        return approvals[0].getVersion();
    }

    private Approval getPageApprovalEntity(Long pageId, int version) throws NoApprovalException {
        Approval[] approvals = (Approval[])this.activeObjects.find(Approval.class, Query.select().where("TYPE = ? AND PAGE_ID = ? AND VERSION = ? AND UUID IS NULL AND SUPERSEDED = ?", new Object[]{PAGE_TYPE, pageId, version, false}).order("ID DESC").limit(1));
        if (approvals.length > 0) {
            return approvals[0];
        }
        throw new NoApprovalException();
    }

    private Approval getMacroApprovalEntity(AbstractPage page, String uuid, String macroId, long pageId) throws NoApprovalException {
        Approval[] approvals = (Approval[])this.activeObjects.find(Approval.class, Query.select().where("TYPE = ? AND PAGE_ID = ? AND VERSION = ? AND MACRO_ID = ? AND UUID = ?", new Object[]{MACRO_TYPE, pageId, page.getVersion(), macroId, uuid}).order("VERSION DESC").limit(1));
        if (approvals.length > 0) {
            return approvals[0];
        }
        throw new NoApprovalException();
    }

    private Approval getMacroApprovalEntityUuid(AbstractPage page, String uuid) throws NoApprovalException {
        Approval[] approvals = (Approval[])this.activeObjects.find(Approval.class, Query.select().where("TYPE = ? AND PAGE_ID = ? AND UUID = ?", new Object[]{MACRO_TYPE, page.getId(), uuid}).order("VERSION DESC").limit(1));
        if (approvals.length > 0) {
            return approvals[0];
        }
        throw new NoApprovalException();
    }

    private void markSupersededMacros(long pageId, int pageVersion, String uuid) {
        this.activeObjects.executeInTransaction(() -> {
            for (Approval approval : (Approval[])this.activeObjects.find(Approval.class, Query.select().where("PAGE_ID = ? AND VERSION < ? AND UUID = ?", new Object[]{pageId, pageVersion, uuid}))) {
                approval.setSuperseded(true);
                approval.save();
                this.removeNotifications(approval.getMembers());
            }
            return true;
        });
    }

    private void removeNotifications(ApprovalMember[] members) {
        this.activeObjects.executeInTransaction(() -> {
            for (ApprovalMember member : members) {
                ConfluenceUser user1 = this.userAccessor.getUserByKey(new UserKey(member.getUserKey()));
                if (user1 != null && member.getNotificationId() != null) {
                    this.notificationService.delete(user1.getName(), member.getNotificationId().longValue());
                }
                member.setNotificationId(null);
                member.save();
            }
            return true;
        });
    }

    public void markSupersededPageApprovals(long pageId, int pageVersion) {
        this.activeObjects.executeInTransaction(() -> {
            Approval[] approvals;
            for (Approval approval : approvals = (Approval[])this.activeObjects.find(Approval.class, Query.select().where("PAGE_ID = ? AND VERSION <= ? AND UUID IS NULL AND SUPERSEDED = ?", new Object[]{pageId, pageVersion, false}))) {
                approval.setSuperseded(true);
                approval.save();
                this.removeNotifications(approval.getMembers());
            }
            return true;
        });
    }

    public void reopenRestoredApprovals(long pageId) {
        Page page = this.pageManager.getPage(pageId);
        this.activeObjects.executeInTransaction(() -> {
            if (page != null) {
                for (Approval approval : (Approval[])this.activeObjects.find(Approval.class, Query.select().where("PAGE_ID = ? AND VERSION = ?", new Object[]{pageId, page.getVersion()}).order("ID DESC").limit(1))) {
                    approval.setSuperseded(false);
                }
            }
            return true;
        });
    }

    public void markSupersededMacros(long pageId) {
        this.activeObjects.executeInTransaction(() -> {
            for (Approval approval : (Approval[])this.activeObjects.find(Approval.class, Query.select().where("PAGE_ID = ?", new Object[]{pageId}))) {
                approval.setSuperseded(true);
                approval.save();
                this.removeNotifications(approval.getMembers());
            }
            return true;
        });
    }

    public void markRemovedMacros(long pageId, List<String> currentUuid) {
        this.activeObjects.executeInTransaction(() -> {
            for (Approval approval : (Approval[])this.activeObjects.find(Approval.class, Query.select().where("TYPE = 'macro' AND PAGE_ID = ? AND SUPERSEDED = ?", new Object[]{pageId, false}))) {
                if (currentUuid.contains(approval.getUuid())) continue;
                approval.setSuperseded(true);
                approval.save();
                this.approvalMaintenanceService.removeNotifications(approval);
            }
            return true;
        });
    }

    public void processMovePage(long pageId, long newSpaceId) {
        this.activeObjects.executeInTransaction(() -> {
            for (Approval approval : (Approval[])this.activeObjects.find(Approval.class, Query.select().where("PAGE_ID = ?", new Object[]{pageId}))) {
                approval.setSpaceId(newSpaceId);
                approval.save();
            }
            return true;
        });
    }

    public boolean expireOutdatedApprovals() {
        Date currentDate = new Date();
        this.activeObjects.executeInTransaction(() -> {
            for (Approval approval : (Approval[])this.activeObjects.find(Approval.class, Query.select().where("SUPERSEDED = ? AND EXPIRY_DATE IS NOT NULL AND EXPIRY_DATE <= ?", new Object[]{false, currentDate}))) {
                HashMap<String, ApproverType> recipients = new HashMap<String, ApproverType>();
                for (ApprovalMember member : approval.getMembers()) {
                    if (member.getStatus().equals("pending")) continue;
                    member.setStatus("expired");
                    recipients.put(member.getUserKey(), ApproverType.REAPPROVAL);
                    member.save();
                }
                approval.setExpiryDate(null);
                approval.setStatus("expired");
                approval.save();
                this.approvalMaintenanceService.removeNotifications(approval);
                this.processStatusEmails(approval, "expired");
                this.processRequestEmails(recipients, approval);
            }
            return true;
        });
        return true;
    }

    public List<SystemStatsJson> getStatistics(int limit) {
        if (limit == 0) {
            limit = 20;
        }
        SystemStats[] statistics = (SystemStats[])this.activeObjects.find(SystemStats.class, Query.select().order("ID DESC").limit(limit));
        List<SystemStats> systemStats = Arrays.asList(statistics);
        Collections.reverse(systemStats);
        Stream<SystemStatsJson> outputJson = systemStats.stream().map(value -> new SystemStatsJson(value.getDate(), value.getPendingCount(), value.getApprovedCount(), value.getRejectedCount(), value.getExpiredCount(), value.getTotal()));
        return outputJson.collect(Collectors.toList());
    }
}

