/*
 * Decompiled with CFR 0.152.
 */
package co.uk.automationconsultants.approvals.service;

import co.uk.automationconsultants.approvals.ao.Approval;
import co.uk.automationconsultants.approvals.ao.ApprovalMember;
import co.uk.automationconsultants.approvals.json.search.ApprovalSearchResultJson;
import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.ContentPermissionManager;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.Arrays;
import java.util.stream.Stream;
import net.java.ao.Query;

@Named(value="approvalSearchService")
public class ApprovalSearchService {
    @ComponentImport
    private final ActiveObjects activeObjects;
    @ComponentImport
    private final ContentPermissionManager contentPermissionManager;
    @ComponentImport
    private final PageManager pageManager;
    @ComponentImport
    private final UserAccessor userAccessor;
    @ComponentImport
    private final SpaceManager spaceManager;

    @Inject
    public ApprovalSearchService(ActiveObjects activeObjects, ContentPermissionManager contentPermissionManager, PageManager pageManager, UserAccessor userAccessor, SpaceManager spaceManager) {
        this.activeObjects = activeObjects;
        this.pageManager = pageManager;
        this.contentPermissionManager = contentPermissionManager;
        this.userAccessor = userAccessor;
        this.spaceManager = spaceManager;
    }

    private boolean filterApprovals(ConfluenceUser user, Approval approval) {
        Page page = this.pageManager.getPage(approval.getPageId());
        if (page == null || page.isDraft() || !page.isLatestVersion()) {
            return false;
        }
        boolean b = this.contentPermissionManager.hasContentLevelPermission(user, "View", (ContentEntityObject)page);
        return b;
    }

    public Stream<ApprovalSearchResultJson> searchApprovalCreatorUpdator(ConfluenceUser user, String userKey, String status, String spaceKey) {
        Space space;
        String userSearch = userKey;
        if (userKey == null) {
            userSearch = user.getKey().getStringValue();
        }
        Long searchSpace = null;
        if (spaceKey != null && (space = this.spaceManager.getSpace(spaceKey.toUpperCase())) != null) {
            searchSpace = space.getId();
        }
        if (status == null) {
            if (searchSpace == null) {
                return Arrays.stream((Approval[])this.activeObjects.find(Approval.class, Query.select().alias(ApprovalMember.class, "am").alias(Approval.class, "a").join(ApprovalMember.class, "am.APPROVAL_ID = a.ID").where("a.SUPERSEDED = ? AND (a.CREATOR = ? OR a.UPDATOR = ?)", new Object[]{false, userSearch, userSearch}).distinct())).filter(approval -> this.filterApprovals(user, (Approval)approval)).map(approval -> ApprovalSearchResultJson.map(approval, this.userAccessor, this.pageManager));
            }
            Stream<Approval> stream = Arrays.stream((Approval[])this.activeObjects.find(Approval.class, Query.select().alias(ApprovalMember.class, "am").alias(Approval.class, "a").join(ApprovalMember.class, "am.APPROVAL_ID = a.ID").where("a.SUPERSEDED = ? AND (a.CREATOR = ? OR a.UPDATOR = ?) AND a.SPACE_ID = ?", new Object[]{false, userSearch, userSearch, searchSpace}).distinct()));
            return stream.filter(approval -> this.filterApprovals(user, (Approval)approval)).map(approval -> ApprovalSearchResultJson.map(approval, this.userAccessor, this.pageManager));
        }
        if (searchSpace != null) {
            return Arrays.stream((Approval[])this.activeObjects.find(Approval.class, Query.select().alias(ApprovalMember.class, "am").alias(Approval.class, "a").join(ApprovalMember.class, "am.APPROVAL_ID = a.ID").where("a.SUPERSEDED = ? AND a.STATUS = ? AND (a.CREATOR = ? OR a.UPDATOR = ?) AND a.SPACE_ID = ?", new Object[]{false, status, userSearch, userSearch, searchSpace}))).filter(approval -> this.filterApprovals(user, (Approval)approval)).map(approval -> ApprovalSearchResultJson.map(approval, this.userAccessor, this.pageManager));
        }
        return Arrays.stream((Approval[])this.activeObjects.find(Approval.class, Query.select().alias(ApprovalMember.class, "am").alias(Approval.class, "a").join(ApprovalMember.class, "am.APPROVAL_ID = a.ID").where("a.SUPERSEDED = ? AND a.STATUS = ? AND (a.CREATOR = ? OR a.UPDATOR = ?)", new Object[]{false, status, userSearch, userSearch}))).filter(approval -> this.filterApprovals(user, (Approval)approval)).map(approval -> ApprovalSearchResultJson.map(approval, this.userAccessor, this.pageManager));
    }

    public Stream<ApprovalSearchResultJson> searchApprovalMembers(ConfluenceUser user, String userKey, String status, String spaceKey) {
        Space space;
        String userSearch = userKey;
        if (userKey == null) {
            userSearch = user.getKey().getStringValue();
        }
        Long searchSpace = null;
        if (spaceKey != null && (space = this.spaceManager.getSpace(spaceKey.toUpperCase())) != null) {
            searchSpace = space.getId();
        }
        if (status == null) {
            if (searchSpace == null) {
                return Arrays.stream((Approval[])this.activeObjects.find(Approval.class, Query.select().alias(ApprovalMember.class, "am").alias(Approval.class, "a").join(ApprovalMember.class, "am.APPROVAL_ID = a.ID").where("a.SUPERSEDED = ? AND am.STATUS != ? AND am.STATUS != ? AND am.USER_KEY = ?", new Object[]{false, "approved", "rejected", userSearch}))).filter(approval -> this.filterApprovals(user, (Approval)approval)).map(approval -> ApprovalSearchResultJson.map(approval, this.userAccessor, this.pageManager));
            }
            Stream<Approval> stream = Arrays.stream((Approval[])this.activeObjects.find(Approval.class, Query.select().alias(ApprovalMember.class, "am").alias(Approval.class, "a").join(ApprovalMember.class, "am.APPROVAL_ID = a.ID").where("a.SUPERSEDED = ? AND am.STATUS != ? AND am.STATUS != ? AND am.USER_KEY = ? AND a.SPACE_ID = ?", new Object[]{false, "approved", "rejected", userSearch, (long)searchSpace})));
            return stream.filter(approval -> this.filterApprovals(user, (Approval)approval)).map(approval -> ApprovalSearchResultJson.map(approval, this.userAccessor, this.pageManager));
        }
        if (searchSpace != null) {
            return Arrays.stream((Approval[])this.activeObjects.find(Approval.class, Query.select().alias(ApprovalMember.class, "am").alias(Approval.class, "a").join(ApprovalMember.class, "am.APPROVAL_ID = a.ID").where("a.SUPERSEDED = ? AND am.STATUS = ? AND am.USER_KEY = ? AND a.SPACE_ID = ?", new Object[]{false, status, userSearch, searchSpace}))).filter(approval -> this.filterApprovals(user, (Approval)approval)).map(approval -> ApprovalSearchResultJson.map(approval, this.userAccessor, this.pageManager));
        }
        return Arrays.stream((Approval[])this.activeObjects.find(Approval.class, Query.select().alias(ApprovalMember.class, "am").alias(Approval.class, "a").join(ApprovalMember.class, "am.APPROVAL_ID = a.ID").where("a.SUPERSEDED = ? AND am.STATUS = ? AND am.USER_KEY = ?", new Object[]{false, status, userSearch}))).filter(approval -> this.filterApprovals(user, (Approval)approval)).map(approval -> ApprovalSearchResultJson.map(approval, this.userAccessor, this.pageManager));
    }
}

