/*
 * Decompiled with CFR 0.152.
 */
package co.uk.automationconsultants.approvals.service;

import co.uk.automationconsultants.approvals.service.enumerator.LicenseType;
import com.atlassian.confluence.license.LicenseService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.LicenseError;
import com.atlassian.upm.api.license.entity.PluginLicense;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.IOException;
import java.io.InputStream;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named(value="approvalLicenseService")
public class ApprovalLicenseService {
    private static final Logger logger = LoggerFactory.getLogger(ApprovalLicenseService.class);
    @ComponentImport
    private final PluginLicenseManager pluginLicenseManager;
    @ComponentImport
    private final LicenseService licenseService;

    @Inject
    public ApprovalLicenseService(PluginLicenseManager pluginLicenseManager, LicenseService licenseService) {
        this.pluginLicenseManager = pluginLicenseManager;
        this.licenseService = licenseService;
    }

    private ZonedDateTime getReleaseDate() throws IOException {
        InputStream is = this.getClass().getClassLoader().getResourceAsStream("properties-from-pom.properties");
        Properties properties = new Properties();
        properties.load(is);
        String releaseDate = properties.getProperty("timestamp");
        String timestampFormat = properties.getProperty("maven.build.timestamp.format");
        return ZonedDateTime.parse(releaseDate, DateTimeFormatter.ofPattern(timestampFormat).withZone(ZoneId.of("UTC")));
    }

    boolean validateExpiredLicense(PluginLicense license) {
        if (!license.isEvaluation() && !license.isDataCenter()) {
            try {
                ZonedDateTime licenseExpiryDate = (ZonedDateTime)license.getMaintenanceExpiryZonedDate().get();
                ZonedDateTime pluginReleaseDate = this.getReleaseDate();
                return pluginReleaseDate.isBefore(licenseExpiryDate);
            }
            catch (IOException e) {
                logger.error("Failed to get release date: ", (Throwable)e);
            }
        }
        return false;
    }

    public LicenseType getLicense() {
        if (!this.pluginLicenseManager.getLicense().isDefined()) {
            logger.warn("Failed to get license as it is undefined");
            return LicenseType.NO_LICENSE;
        }
        PluginLicense pluginLicense = (PluginLicense)this.pluginLicenseManager.getLicense().get();
        boolean isConfluenceDCLicensed = this.licenseService.isLicensedForDataCenter();
        boolean isPluginDCLicensed = pluginLicense.isDataCenter();
        if (pluginLicense.getError().isDefined()) {
            if (((LicenseError)pluginLicense.getError().get()).equals((Object)LicenseError.EXPIRED) && !isConfluenceDCLicensed && !isPluginDCLicensed && pluginLicense.isMaintenanceExpired() && this.validateExpiredLicense(pluginLicense)) {
                return LicenseType.FULL_LICENSE;
            }
            logger.warn("Failed to get license as there was an error, identified by the Universal Plugin Manager (UPM), when getting the license: ", (Object)pluginLicense.getError());
            return LicenseType.NO_LICENSE;
        }
        if (isConfluenceDCLicensed == isPluginDCLicensed && pluginLicense.isValid()) {
            return pluginLicense.isEvaluation() ? LicenseType.EVAL_LICENSE : LicenseType.FULL_LICENSE;
        }
        logger.warn("Failed to get license as the license provided is not a valid license");
        return LicenseType.NO_LICENSE;
    }
}

