/*
 * Decompiled with CFR 0.152.
 */
package co.uk.automationconsultants.approvals.rest;

import co.uk.automationconsultants.approvals.ao.Approval;
import co.uk.automationconsultants.approvals.json.ApprovalJson;
import co.uk.automationconsultants.approvals.json.ErrorJson;
import co.uk.automationconsultants.approvals.json.request.AccessRequest;
import co.uk.automationconsultants.approvals.json.request.ActionRequest;
import co.uk.automationconsultants.approvals.json.request.ApprovalCreationJson;
import co.uk.automationconsultants.approvals.json.request.ApprovalCreationPageJson;
import co.uk.automationconsultants.approvals.service.ApprovalLicenseService;
import co.uk.automationconsultants.approvals.service.ApprovalService;
import co.uk.automationconsultants.approvals.service.enumerator.ErrorType;
import co.uk.automationconsultants.approvals.service.enumerator.LicenseType;
import co.uk.automationconsultants.approvals.service.exception.InvalidJsonException;
import co.uk.automationconsultants.approvals.service.exception.NoApprovalException;
import co.uk.automationconsultants.approvals.service.exception.NoPageException;
import co.uk.automationconsultants.approvals.service.exception.NoPagePermissionException;
import co.uk.automationconsultants.approvals.service.exception.NoPageVersionException;
import co.uk.automationconsultants.approvals.service.exception.NoSpacePermissionException;
import co.uk.automationconsultants.approvals.service.exception.OutdatedApprovalException;
import com.atlassian.annotations.PublicApi;
import com.atlassian.confluence.api.service.accessmode.ReadOnlyAccessAllowed;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import java.text.ParseException;
import java.util.Objects;

@Path(value="/approval")
@PublicApi
public class ApprovalRest {
    @ComponentImport
    private final PageManager pageManager;
    private final ApprovalService approvalService;
    private final ApprovalLicenseService approvalLicenseService;

    @Inject
    public ApprovalRest(ApprovalService approvalService, PageManager pageManager, ApprovalLicenseService approvalLicenseService) {
        this.approvalService = approvalService;
        this.pageManager = pageManager;
        this.approvalLicenseService = approvalLicenseService;
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ReadOnlyAccessAllowed
    @PublicApi
    public Response getApproval(@Context HttpServletRequest request, AccessRequest accessRequest) {
        if (accessRequest == null) {
            return Response.status((int)400).entity((Object)this.getErrorJson(ErrorType.INVALIDJSON)).build();
        }
        if (this.approvalLicenseService.getLicense() == LicenseType.NO_LICENSE) {
            return Response.status((int)403).entity((Object)this.getErrorJson(ErrorType.UNLICENSED)).build();
        }
        if (accessRequest.getPageId() == null) {
            return Response.status((int)400).entity((Object)this.getErrorJson(ErrorType.INVALIDPAGEID)).build();
        }
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        if (user == null) {
            return Response.ok((Object)this.getErrorJson(ErrorType.ANONYMOUS)).build();
        }
        try {
            ApprovalJson approval;
            switch (accessRequest.getType()) {
                case "page": {
                    long pageId = Objects.requireNonNull(this.pageManager.getPage(accessRequest.getPageId().longValue())).getLatestVersion().getId();
                    approval = this.approvalService.getPageApproval(user, pageId, accessRequest.getVersion());
                    break;
                }
                case "macro": {
                    approval = this.approvalService.getMacroApproval(user, accessRequest.getPageId(), accessRequest.getUuid(), accessRequest.getMacroId(), accessRequest.getVersion());
                    break;
                }
                default: {
                    return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
                }
            }
            if (approval == null) {
                return Response.status((int)404).entity((Object)this.getErrorJson(ErrorType.NOTFOUND)).build();
            }
            return Response.ok((Object)approval).build();
        }
        catch (NoApprovalException | NoPageException e) {
            return Response.status((int)404).entity((Object)this.getErrorJson(ErrorType.NOTFOUND)).build();
        }
        catch (NoPagePermissionException e) {
            return Response.status((int)401).entity((Object)this.getErrorJson(ErrorType.UNAUTHORIZEDPAGE)).build();
        }
        catch (NoSpacePermissionException e) {
            return Response.status((int)401).entity((Object)this.getErrorJson(ErrorType.UNAUTHORIZEDSPACE)).build();
        }
        catch (NoPageVersionException e) {
            e.printStackTrace();
            return Response.status((int)404).entity((Object)this.getErrorJson(ErrorType.NOTFOUND)).build();
        }
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @PublicApi
    public Response updateApproval(@Context HttpServletRequest request, ApprovalCreationJson approvalJson) {
        if (approvalJson == null) {
            return Response.status((int)400).entity((Object)this.getErrorJson(ErrorType.INVALIDJSON)).build();
        }
        if (approvalJson.getPageId() == null) {
            return Response.status((int)400).entity((Object)this.getErrorJson(ErrorType.INVALIDPAGEID)).build();
        }
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        if (user == null) {
            return Response.status((int)401).entity((Object)this.getErrorJson(ErrorType.ANONYMOUS)).build();
        }
        try {
            if (!"page".equals(approvalJson.getType())) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
            ApprovalJson existingApproval = this.approvalService.getPageApproval(user, approvalJson.getPageId(), approvalJson.getVersion() - 1);
            ApprovalJson newApproval = this.approvalService.postPageApproval(user, approvalJson.getPageId(), approvalJson, existingApproval);
            return Response.ok((Object)newApproval).build();
        }
        catch (NoSpacePermissionException e) {
            e.printStackTrace();
            return Response.status((int)401).entity((Object)this.getErrorJson(ErrorType.UNAUTHORIZEDSPACE)).build();
        }
        catch (NoPagePermissionException e) {
            e.printStackTrace();
            return Response.status((int)401).entity((Object)this.getErrorJson(ErrorType.UNAUTHORIZEDPAGE)).build();
        }
        catch (NoPageException | NoPageVersionException e) {
            e.printStackTrace();
            return Response.status((int)404).entity((Object)this.getErrorJson(ErrorType.NOTFOUND)).build();
        }
        catch (InvalidJsonException e) {
            e.printStackTrace();
            return Response.status((int)400).entity((Object)this.getErrorJson(ErrorType.INVALIDJSON)).build();
        }
        catch (NoApprovalException e) {
            e.printStackTrace();
            return Response.status((int)500).build();
        }
    }

    @DELETE
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @PublicApi
    public Response deleteApproval(@Context HttpServletRequest request, AccessRequest accessRequest) {
        this.approvalService.markSupersededPageApprovals(accessRequest.getPageId(), Integer.MAX_VALUE);
        return Response.ok().build();
    }

    private ErrorJson getErrorJson(ErrorType type) {
        switch (type) {
            case ANONYMOUS: {
                return new ErrorJson("Anonymous Access Not Allowed");
            }
            case INVALIDJSON: {
                return new ErrorJson("Invalid JSON Input");
            }
            case INVALIDPAGEID: {
                return new ErrorJson("Invalid Page ID");
            }
            case NOTFOUND: {
                return new ErrorJson("No Record Found");
            }
            case UNAUTHORIZEDSPACE: {
                return new ErrorJson("Unauthorized Access (Space Permission)");
            }
            case UNAUTHORIZEDPAGE: {
                return new ErrorJson("Unauthorized Access (Page Permission)");
            }
            case DISABLED: {
                return new ErrorJson("Operation Disabled (Space or System level))");
            }
            case INVALIDMEMBERS: {
                return new ErrorJson("One or more Users are invalid");
            }
            case UNLICENSED: {
                return new ErrorJson("License is expired/invalid");
            }
        }
        return new ErrorJson("Unknown Error");
    }

    @POST
    @Path(value="/action")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response actionApproval(@Context HttpServletRequest request, ActionRequest actionRequest) {
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        try {
            if (actionRequest.getType().equals("page")) {
                return Response.ok().entity((Object)this.approvalService.actionPageApproval(user, actionRequest)).build();
            }
            if (actionRequest.getType().equals("macro")) {
                return Response.ok().entity((Object)this.approvalService.actionMacroApproval(user, actionRequest)).build();
            }
            return Response.status((int)400).entity((Object)this.getErrorJson(ErrorType.INVALIDJSON)).build();
        }
        catch (NoApprovalException | NoPageException e) {
            e.printStackTrace();
            return Response.status((int)404).entity((Object)this.getErrorJson(ErrorType.NOTFOUND)).build();
        }
        catch (NoSpacePermissionException e) {
            e.printStackTrace();
            return Response.status((int)401).entity((Object)this.getErrorJson(ErrorType.UNAUTHORIZEDSPACE)).build();
        }
        catch (NoPagePermissionException e) {
            e.printStackTrace();
            return Response.status((int)401).entity((Object)this.getErrorJson(ErrorType.UNAUTHORIZEDPAGE)).build();
        }
        catch (NoPageVersionException e) {
            e.printStackTrace();
            return Response.status((int)401).entity((Object)this.getErrorJson(ErrorType.NOTFOUND)).build();
        }
        catch (OutdatedApprovalException e) {
            e.printStackTrace();
            return Response.status((int)401).entity((Object)this.getErrorJson(ErrorType.INVALIDJSON)).build();
        }
    }

    @PUT
    @Path(value="/page")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response createUpdatePageApproval(@Context HttpServletRequest request, ApprovalCreationPageJson approvalCreationJson) {
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        Long pageId = approvalCreationJson.getPageId();
        Page page = this.pageManager.getPage(pageId.longValue());
        if (page == null) {
            return Response.status((int)404).entity((Object)this.getErrorJson(ErrorType.NOTFOUND)).build();
        }
        try {
            ApprovalCreationJson approvalJson = this.approvalService.setPageApprovalDefaultsNoCheck(user, approvalCreationJson, (AbstractPage)page);
            ApprovalJson existingApproval = this.approvalService.getPageApproval(user, approvalJson.getPageId(), approvalJson.getVersion());
            Approval rawExistingApproval = this.approvalService.getRawPageApproval(user, pageId, page.getVersion());
            ApprovalJson newApproval = existingApproval != null ? this.approvalService.updateExistingApproval(user, approvalJson.getPageId(), approvalJson, rawExistingApproval) : this.approvalService.postPageApproval(user, approvalJson.getPageId(), approvalJson, null);
            return Response.ok((Object)newApproval).build();
        }
        catch (NoPageException e) {
            e.printStackTrace();
            return Response.status((int)404).entity((Object)this.getErrorJson(ErrorType.NOTFOUND)).build();
        }
        catch (NoSpacePermissionException e) {
            e.printStackTrace();
            return Response.status((int)401).entity((Object)this.getErrorJson(ErrorType.UNAUTHORIZEDSPACE)).build();
        }
        catch (NoPagePermissionException e) {
            e.printStackTrace();
            return Response.status((int)401).entity((Object)this.getErrorJson(ErrorType.UNAUTHORIZEDPAGE)).build();
        }
        catch (NoApprovalException | NoPageVersionException e) {
            e.printStackTrace();
            return Response.status((int)401).entity((Object)this.getErrorJson(ErrorType.NOTFOUND)).build();
        }
        catch (InvalidJsonException | ParseException e) {
            e.printStackTrace();
            return Response.status((int)400).entity((Object)this.getErrorJson(ErrorType.INVALIDJSON)).build();
        }
    }

    @GET
    @Path(value="/stats")
    @Produces(value={"application/json"})
    @PublicApi
    public Response getStatistics(@Context HttpServletRequest request, @QueryParam(value="limit") int limit) {
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        if (user != null) {
            return Response.ok(this.approvalService.getStatistics(limit)).build();
        }
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
    }
}

