/*
 * Decompiled with CFR 0.152.
 */
package co.uk.automationconsultants.approvals.json;

import co.uk.automationconsultants.approvals.ao.ApprovalMember;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.user.User;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ApprovalMemberJson {
    @XmlElement(name="approvalId")
    public Integer approvalId;
    @XmlElement(name="userKey")
    public String userKey;
    @XmlElement(name="status")
    public String status;
    @XmlElement(name="date")
    public Date date;
    @XmlElement(name="avatarUrl")
    public String avatarUrl;
    @XmlElement(name="displayName")
    public String displayName;
    @XmlElement(name="username")
    public String username;
    @XmlElement(name="comment")
    private String comment;

    public static ApprovalMemberJson map(UserAccessor userAccessor, ApprovalMember approvalMember) {
        ConfluenceUser currentUser = userAccessor.getUserByKey(new UserKey(approvalMember.getUserKey()));
        if (currentUser == null) {
            return null;
        }
        String avatarUrl = userAccessor.getUserProfilePicture((User)currentUser).getUriReference();
        return new ApprovalMemberJson(approvalMember.getApproval().getID(), approvalMember.getUserKey(), approvalMember.getStatus(), approvalMember.getDate(), avatarUrl, currentUser.getFullName(), currentUser.getName(), approvalMember.getComment());
    }

    public static List<ApprovalMemberJson> mapAll(UserAccessor userAccessor, ApprovalMember[] approvalMembers) {
        ArrayList<ApprovalMemberJson> output = new ArrayList<ApprovalMemberJson>();
        for (ApprovalMember approvalMember : approvalMembers) {
            ApprovalMemberJson memberJson = ApprovalMemberJson.map(userAccessor, approvalMember);
            if (memberJson == null) continue;
            output.add(memberJson);
        }
        return output;
    }

    public ApprovalMemberJson(Integer approvalId, String userKey, String status, Date date, String avatarUrl, String displayName, String username) {
        this.approvalId = approvalId;
        this.userKey = userKey;
        this.status = status;
        this.date = date;
        this.avatarUrl = avatarUrl;
        this.displayName = displayName;
        this.username = username;
    }

    public ApprovalMemberJson(Integer approvalId, String userKey, String status, Date date, String avatarUrl, String displayName, String username, String comment) {
        this.approvalId = approvalId;
        this.userKey = userKey;
        this.status = status;
        this.date = date;
        this.avatarUrl = avatarUrl;
        this.displayName = displayName;
        this.username = username;
        this.comment = comment;
    }

    public String getAvatarUrl() {
        return this.avatarUrl;
    }

    public void setAvatarUrl(String avatarUrl) {
        this.avatarUrl = avatarUrl;
    }

    public Integer getApprovalId() {
        return this.approvalId;
    }

    public void setApprovalId(Integer approvalId) {
        this.approvalId = approvalId;
    }

    public String getUserKey() {
        return this.userKey;
    }

    public void setUserKey(String userKey) {
        this.userKey = userKey;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApprovalMemberJson that = (ApprovalMemberJson)o;
        return Objects.equals(this.approvalId, that.approvalId) && this.userKey.equals(that.userKey) && this.status.equals(that.status) && Objects.equals(this.date, that.date) && Objects.equals(this.avatarUrl, that.avatarUrl) && Objects.equals(this.displayName, that.displayName) && Objects.equals(this.username, that.username) && Objects.equals(this.comment, that.comment);
    }

    public int hashCode() {
        return Objects.hash(this.approvalId, this.userKey);
    }
}

