/*
 * Decompiled with CFR 0.152.
 */
package co.uk.automationconsultants.approvals.helper;

import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.user.EntityException;
import com.atlassian.user.Group;
import com.atlassian.user.GroupManager;
import com.atlassian.user.search.page.Pager;
import jakarta.inject.Named;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class GroupHelper {
    @ComponentImport
    private final GroupManager groupManager;
    @ComponentImport
    private final UserAccessor userAccessor;
    private static final Logger logger = LoggerFactory.getLogger(GroupHelper.class);

    public GroupHelper(GroupManager groupManager, UserAccessor userAccessor) {
        this.groupManager = groupManager;
        this.userAccessor = userAccessor;
    }

    public List<ConfluenceUser> getGroupMembers(String groupName) {
        return this.getGroupMembers(groupName, null);
    }

    public List<ConfluenceUser> getGroupMembers(String groupName, Integer limit) {
        ArrayList<ConfluenceUser> allUsers = new ArrayList<ConfluenceUser>();
        try {
            Group group = this.groupManager.getGroup(groupName);
            Pager pager = this.groupManager.getMemberNames(group);
            do {
                for (String username : pager.getCurrentPage()) {
                    if (limit != null && allUsers.size() == limit.intValue()) {
                        return allUsers;
                    }
                    ConfluenceUser user = this.userAccessor.getUserByName(username);
                    if (user == null) continue;
                    allUsers.add(user);
                }
                pager.nextPage();
            } while (!pager.onLastPage());
        }
        catch (EntityException e) {
            logger.error("Failed to get group {}", (Object)groupName, (Object)e);
        }
        return allUsers;
    }
}

