/*
 * Decompiled with CFR 0.152.
 */
package co.uk.automationconsultants.approvals.conditions;

import co.uk.automationconsultants.approvals.cache.ConditionCache;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.web.Condition;
import jakarta.inject.Inject;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpaceEnabledCondition
implements Condition {
    private final ConditionCache conditionCache;
    private static final Logger logger = LoggerFactory.getLogger(SpaceEnabledCondition.class);

    @Inject
    public SpaceEnabledCondition(ConditionCache conditionCache) {
        this.conditionCache = conditionCache;
    }

    public void init(Map<String, String> params) throws PluginParseException {
    }

    public boolean shouldDisplay(Map<String, Object> context) {
        try {
            Object obj = context.get("space");
            if (obj == null) {
                return false;
            }
            Space space = (Space)obj;
            return this.conditionCache.isEnabled(space.getKey());
        }
        catch (NullPointerException e) {
            logger.error("The Context object that was provided is null");
            return false;
        }
    }
}

