/*
 * Decompiled with CFR 0.152.
 */
package co.uk.automationconsultants.approvals.service;

import co.uk.automationconsultants.approvals.ao.settings.Group;
import co.uk.automationconsultants.approvals.ao.settings.SpaceSettings;
import co.uk.automationconsultants.approvals.ao.settings.Team;
import co.uk.automationconsultants.approvals.ao.settings.TeamMember;
import co.uk.automationconsultants.approvals.cache.SpaceSettingsCache;
import co.uk.automationconsultants.approvals.json.request.SpaceSettingsCreationJson;
import co.uk.automationconsultants.approvals.json.request.TeamCreationJson;
import co.uk.automationconsultants.approvals.json.settings.SystemSettingsJson;
import co.uk.automationconsultants.approvals.service.exception.InternalServerErrorException;
import co.uk.automationconsultants.approvals.service.exception.InvalidJsonException;
import co.uk.automationconsultants.approvals.service.exception.NoSpacePermissionException;
import co.uk.automationconsultants.approvals.service.exception.TeamNotFoundException;
import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.confluence.security.SpacePermissionManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.user.UserKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import net.java.ao.DBParam;
import net.java.ao.Query;
import net.java.ao.RawEntity;

@Named(value="approvalSpaceService")
public class ApprovalSpaceService {
    @ComponentImport
    private final ActiveObjects activeObjects;
    @ComponentImport
    private final UserAccessor userAccessor;
    @ComponentImport
    private final SpaceManager spaceManager;
    @ComponentImport
    private final SpacePermissionManager spacePermissionManager;
    private final SpaceSettingsCache spaceSettingsCache;
    private static final String ORDER_STRING = "ID ASC";

    @Inject
    public ApprovalSpaceService(ActiveObjects activeObjects, UserAccessor userAccessor, SpaceManager spaceManager, SpacePermissionManager spacePermissionManager, SpaceSettingsCache spaceSettingsCache) {
        this.activeObjects = activeObjects;
        this.userAccessor = userAccessor;
        this.spaceManager = spaceManager;
        this.spacePermissionManager = spacePermissionManager;
        this.spaceSettingsCache = spaceSettingsCache;
    }

    public SpaceSettingsCreationJson getSettings(String spaceKey, ConfluenceUser user) throws NoSpacePermissionException, InvalidJsonException {
        if (spaceKey != null && spaceKey.length() > 0) {
            Space space = this.spaceManager.getSpace(spaceKey.toUpperCase());
            if (space != null) {
                if (!this.spacePermissionManager.hasPermission("VIEWSPACE", space, user)) {
                    throw new NoSpacePermissionException();
                }
                return this.spaceSettingsCache.getSpaceSettings(space.getId());
            }
            throw new NoSpacePermissionException();
        }
        throw new InvalidJsonException();
    }

    public SpaceSettingsCreationJson updateOrCreateTeam(ConfluenceUser user, String spaceKey, TeamCreationJson teamCreationJson) throws NoSpacePermissionException, InvalidJsonException, InternalServerErrorException, TeamNotFoundException {
        if (spaceKey == null || spaceKey.length() == 0) {
            throw new NoSpacePermissionException();
        }
        Space space = this.spaceManager.getSpace(spaceKey.toUpperCase());
        if (space == null) {
            throw new NoSpacePermissionException();
        }
        if (!this.spacePermissionManager.hasPermission("SETSPACEPERMISSIONS", space, user)) {
            throw new NoSpacePermissionException();
        }
        if (teamCreationJson == null) {
            throw new InvalidJsonException();
        }
        SpaceSettingsCreationJson settings = this.getSettings(spaceKey.toUpperCase(), user);
        SpaceSettings[] spaceSettings = (SpaceSettings[])this.activeObjects.find(SpaceSettings.class, Query.select().where("SPACE_ID = ?", new Object[]{settings.getSpaceId()}));
        if (spaceSettings.length == 0) {
            throw new InternalServerErrorException();
        }
        if (teamCreationJson.getId() == null) {
            this.createTeam(teamCreationJson, spaceSettings);
        } else {
            this.updateTeam(teamCreationJson);
        }
        this.spaceSettingsCache.invalidateCaches();
        return this.getSettings(spaceKey, user);
    }

    private void updateTeam(TeamCreationJson teamCreationJson) throws TeamNotFoundException {
        Team team = (Team)this.activeObjects.get(Team.class, (Object)teamCreationJson.getId());
        if (team == null) {
            throw new TeamNotFoundException();
        }
        for (TeamMember teamMember : team.getTeamMembers()) {
            if (teamCreationJson.getMembers().contains(teamMember.getUserKey())) continue;
            this.activeObjects.delete(new RawEntity[]{teamMember});
        }
        List existingTeamMembers = Arrays.stream(team.getTeamMembers()).map(TeamMember::getUserKey).collect(Collectors.toList());
        for (String member : teamCreationJson.getMembers()) {
            if (existingTeamMembers.contains(member)) continue;
            this.activeObjects.create(TeamMember.class, new DBParam[]{new DBParam("USER_KEY", (Object)member), new DBParam("TEAM_ID", (Object)team.getID())});
        }
        team.setDescription(teamCreationJson.getDescription());
        team.setName(teamCreationJson.getName());
        team.save();
    }

    private void createTeam(TeamCreationJson teamCreationJson, SpaceSettings[] spaceSettings) {
        Team team = (Team)this.activeObjects.create(Team.class, new DBParam[]{new DBParam("SPACE_SETTINGS_ID", (Object)spaceSettings[0].getID()), new DBParam("NAME", (Object)teamCreationJson.getName()), new DBParam("DESCRIPTION", (Object)teamCreationJson.getDescription())});
        for (String member : teamCreationJson.getMembers()) {
            if (this.userAccessor.getUserByKey(new UserKey(member)) == null) continue;
            this.activeObjects.create(TeamMember.class, new DBParam[]{new DBParam("USER_KEY", (Object)member), new DBParam("TEAM_ID", (Object)team.getID())});
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void deleteTeam(ConfluenceUser user, int teamId) throws InternalServerErrorException, NoSpacePermissionException {
        Team team = (Team)this.activeObjects.get(Team.class, (Object)teamId);
        if (team == null) throw new InternalServerErrorException();
        Long spaceId = team.getSpaceSettings().getSpaceId();
        Space space = this.spaceManager.getSpace(spaceId.longValue());
        if (space == null) throw new NoSpacePermissionException();
        if (!this.spacePermissionManager.hasPermission("SETSPACEPERMISSIONS", space, user)) {
            throw new NoSpacePermissionException();
        }
        this.activeObjects.delete((RawEntity[])team.getTeamMembers());
        this.activeObjects.delete(new RawEntity[]{team});
        this.spaceSettingsCache.invalidateCaches();
    }

    public SpaceSettingsCreationJson updateSettings(SpaceSettingsCreationJson spaceSettingsJson, String spaceKey, ConfluenceUser user) throws InvalidJsonException, NoSpacePermissionException {
        if (spaceKey != null && spaceKey.length() > 0) {
            Space space = this.spaceManager.getSpace(spaceKey.toUpperCase());
            if (space != null) {
                if (!this.spacePermissionManager.hasPermission("SETSPACEPERMISSIONS", space, user)) {
                    throw new NoSpacePermissionException();
                }
                if (spaceSettingsJson == null) {
                    throw new InvalidJsonException();
                }
                SpaceSettingsCreationJson change = this.getSettings(spaceKey.toUpperCase(), user);
                if (spaceSettingsJson.isEnabled() != null) {
                    change.setEnabled(spaceSettingsJson.isEnabled());
                }
                if (spaceSettingsJson.isOverrideWording() != null) {
                    change.setOverrideWording(spaceSettingsJson.isOverrideWording());
                }
                if (spaceSettingsJson.getApprovedText() != null && spaceSettingsJson.getApprovedText().length() > 1) {
                    change.setApprovedText(spaceSettingsJson.getApprovedText());
                }
                if (spaceSettingsJson.getRejectedText() != null && spaceSettingsJson.getRejectedText().length() > 1) {
                    change.setRejectedText(spaceSettingsJson.getRejectedText());
                }
                if (spaceSettingsJson.getPendingText() != null && spaceSettingsJson.getPendingText().length() > 1) {
                    change.setPendingText(spaceSettingsJson.getPendingText());
                }
                if (spaceSettingsJson.getExpiredText() != null && spaceSettingsJson.getExpiredText().length() > 1) {
                    change.setExpiredText(spaceSettingsJson.getExpiredText());
                }
                if (spaceSettingsJson.getCreateApprovalGroups() != null) {
                    change.setCreateApprovalGroups(spaceSettingsJson.getCreateApprovalGroups());
                }
                return ApprovalSpaceService.mapSettingsToJson((SpaceSettings)this.activeObjects.executeInTransaction(() -> {
                    SpaceSettings spaceSettings;
                    SpaceSettings[] settings = (SpaceSettings[])this.activeObjects.find(SpaceSettings.class, Query.select().where("SPACE_ID = ?", new Object[]{change.spaceId}).order(ORDER_STRING).limit(1));
                    if (settings.length < 1) {
                        spaceSettings = (SpaceSettings)this.activeObjects.create(SpaceSettings.class, new DBParam[]{new DBParam("ENABLED", (Object)change.isEnabled()), new DBParam("OVERRIDE_SYSTEM_WORDING", (Object)change.isOverrideWording()), new DBParam("PENDING_TEXT", (Object)change.getPendingText()), new DBParam("APPROVED_TEXT", (Object)change.getApprovedText()), new DBParam("REJECTED_TEXT", (Object)change.getRejectedText()), new DBParam("EXPIRED_TEXT", (Object)change.getExpiredText()), new DBParam("CREATE_APPROVAL_RESTRICTED", (Object)(!change.getCreateApprovalGroups().isEmpty() ? 1 : 0))});
                    } else {
                        for (Group group2 : (Group[])this.activeObjects.find(Group.class, Query.select().where("SPACE_SETTINGS_ID = ?", new Object[]{settings[0].getID()}))) {
                            if (change.getCreateApprovalGroups().contains(group2.getName())) continue;
                            this.activeObjects.delete(new RawEntity[]{group2});
                        }
                        SpaceSettings[] refreshedSettings = (SpaceSettings[])this.activeObjects.find(SpaceSettings.class, Query.select().where("SPACE_ID = ?", new Object[]{change.spaceId}).order(ORDER_STRING).limit(1));
                        spaceSettings = refreshedSettings[0];
                        spaceSettings.setEnabled(change.isEnabled());
                        spaceSettings.setOverrideSystemWording(change.isOverrideWording());
                        spaceSettings.setApprovedText(change.getApprovedText());
                        spaceSettings.setRejectedText(change.getRejectedText());
                        spaceSettings.setPendingText(change.getPendingText());
                        spaceSettings.setExpiredText(change.getExpiredText());
                        spaceSettings.setCreateApprovalRestricted(!change.getCreateApprovalGroups().isEmpty());
                        spaceSettings.save();
                    }
                    for (String createApprovalGroup : change.getCreateApprovalGroups()) {
                        if (this.userAccessor.getGroup(createApprovalGroup) == null || !Arrays.stream(spaceSettings.getCreateApprovalGroups()).noneMatch(group -> group.getName().equals(createApprovalGroup))) continue;
                        this.activeObjects.create(Group.class, new DBParam[]{new DBParam("SPACE_SETTINGS_ID", (Object)spaceSettings.getID()), new DBParam("NAME", (Object)createApprovalGroup)});
                    }
                    spaceSettings.save();
                    this.spaceSettingsCache.invalidateCaches();
                    return spaceSettings;
                }));
            }
            throw new NoSpacePermissionException();
        }
        throw new InvalidJsonException();
    }

    public static SpaceSettingsCreationJson mapSettingsToJson(SpaceSettings spaceSettings) {
        return new SpaceSettingsCreationJson(spaceSettings.getSpaceId(), spaceSettings.isEnabled(), spaceSettings.isOverrideSystemWording(), spaceSettings.getPendingText(), spaceSettings.getApprovedText(), spaceSettings.getRejectedText(), spaceSettings.getExpiredText(), spaceSettings.isCreateApprovalRestricted() != false ? Arrays.stream(spaceSettings.getCreateApprovalGroups()).map(Group::getName).collect(Collectors.toList()) : new ArrayList(), Arrays.stream(spaceSettings.getTeams()).map(team -> new TeamCreationJson(team.getID(), team.getName(), team.getDescription(), Arrays.stream(team.getTeamMembers()).map(TeamMember::getUserKey).collect(Collectors.toList()))).collect(Collectors.toList()));
    }

    public static SpaceSettingsCreationJson getDefaultJson(SystemSettingsJson systemSettingsJson) {
        return new SpaceSettingsCreationJson(null, systemSettingsJson.getDefaultEnabled(), false, systemSettingsJson.getPendingText(), systemSettingsJson.getApprovedText(), systemSettingsJson.getRejectedText(), systemSettingsJson.getExpiredText(), new ArrayList<String>(), new ArrayList<TeamCreationJson>());
    }
}

