/*
 * Decompiled with CFR 0.152.
 */
package co.uk.automationconsultants.approvals.rest;

import co.uk.automationconsultants.approvals.cache.ConditionCache;
import co.uk.automationconsultants.approvals.json.request.ConsolidatedJson;
import co.uk.automationconsultants.approvals.json.request.SpaceSettingsCreationJson;
import co.uk.automationconsultants.approvals.json.request.TeamCreationJson;
import co.uk.automationconsultants.approvals.json.settings.SystemSettingsJson;
import co.uk.automationconsultants.approvals.service.ApprovalMaintenanceService;
import co.uk.automationconsultants.approvals.service.ApprovalSpaceService;
import co.uk.automationconsultants.approvals.service.ApprovalSystemService;
import co.uk.automationconsultants.approvals.service.exception.InternalServerErrorException;
import co.uk.automationconsultants.approvals.service.exception.InvalidJsonException;
import co.uk.automationconsultants.approvals.service.exception.NoSpacePermissionException;
import co.uk.automationconsultants.approvals.service.exception.TeamNotFoundException;
import co.uk.automationconsultants.approvals.service.migration.ApprovalMigrationService;
import com.atlassian.annotations.PublicApi;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.atlassian.user.User;
import java.util.List;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Path(value="/settings")
@PublicApi
public class SettingsRest {
    @ComponentImport
    private final UserAccessor userAccessor;
    @ComponentImport
    private final PermissionManager permissionManager;
    private final ConditionCache conditionCache;
    private final ApprovalSystemService approvalSystemService;
    private final ApprovalSpaceService approvalSpaceService;
    private final ApprovalMaintenanceService approvalMaintenanceService;
    private final ApprovalMigrationService approvalMigrationService;

    @Inject
    public SettingsRest(ApprovalSystemService approvalSystemService, ApprovalSpaceService approvalSpaceService, PermissionManager permissionManager, ConditionCache conditionCache, UserAccessor userAccessor, ApprovalMaintenanceService approvalMaintenanceService, ApprovalMigrationService approvalMigrationService) {
        this.approvalSystemService = approvalSystemService;
        this.approvalSpaceService = approvalSpaceService;
        this.permissionManager = permissionManager;
        this.conditionCache = conditionCache;
        this.userAccessor = userAccessor;
        this.approvalMaintenanceService = approvalMaintenanceService;
        this.approvalMigrationService = approvalMigrationService;
    }

    @GET
    @Path(value="/system")
    @Produces(value={"application/json"})
    @PublicApi
    public Response getSettings(@Context HttpServletRequest request) {
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        if (user != null) {
            return Response.ok((Object)this.approvalSystemService.getSettings()).build();
        }
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
    }

    @POST
    @Path(value="/system")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @WebSudoRequired
    @PublicApi
    public Response updateSettings(@Context HttpServletRequest request, SystemSettingsJson systemSettingsJson) {
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        if (user != null && this.permissionManager.isConfluenceAdministrator(user)) {
            SystemSettingsJson settings = this.approvalSystemService.updateSettings(systemSettingsJson);
            this.conditionCache.invalidateCaches();
            return Response.ok((Object)settings).build();
        }
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
    }

    @GET
    @Path(value="/space")
    @Produces(value={"application/json"})
    @PublicApi
    public Response getSpaceSettings(@Context HttpServletRequest request, @QueryParam(value="key") String key) {
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        if (user != null) {
            try {
                return Response.ok((Object)this.approvalSpaceService.getSettings(key, user)).build();
            }
            catch (NoSpacePermissionException e) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            catch (InvalidJsonException e) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
        }
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
    }

    @GET
    @Path(value="/consolidated")
    @Produces(value={"application/json"})
    @PublicApi
    public Response getSettings(@Context HttpServletRequest request, @QueryParam(value="key") String key) {
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        if (user != null) {
            try {
                SystemSettingsJson systemSettings = this.approvalSystemService.getSettings();
                SpaceSettingsCreationJson rawSpaceSettings = this.approvalSpaceService.getSettings(key, user);
                ConsolidatedJson consolidatedJson = ConsolidatedJson.map(rawSpaceSettings, true);
                if (systemSettings.getGloballyControlled().booleanValue()) {
                    consolidatedJson.setEnabled(systemSettings.getEnabled());
                }
                if (consolidatedJson.isEnabled().booleanValue()) {
                    List<String> spaceGroups = consolidatedJson.getCreateApprovalGroups();
                    if (spaceGroups.size() == 0) {
                        consolidatedJson.setCreateApprovalGroups(systemSettings.getCreateApprovalGroups());
                    }
                    consolidatedJson.setApprovedText(systemSettings.getApprovedText());
                    consolidatedJson.setPendingText(systemSettings.getPendingText());
                    consolidatedJson.setRejectedText(systemSettings.getRejectedText());
                    consolidatedJson.setExpiredText(systemSettings.getExpiredText());
                }
                if (consolidatedJson.getCreateApprovalGroups().size() != 0) {
                    consolidatedJson.setPermission(this.hasPermission(user, consolidatedJson.getCreateApprovalGroups()));
                }
                return Response.ok((Object)consolidatedJson).build();
            }
            catch (NoSpacePermissionException e) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            catch (InvalidJsonException e) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
        }
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
    }

    private boolean hasPermission(ConfluenceUser user, List<String> groups) {
        for (String groupName : this.userAccessor.getGroupNames((User)user)) {
            if (!groups.contains(groupName)) continue;
            return true;
        }
        return false;
    }

    @POST
    @Path(value="/space")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @PublicApi
    public Response updateSpaceSettings(@Context HttpServletRequest request, @QueryParam(value="key") String key, SpaceSettingsCreationJson spaceSettingsCreationJson) {
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        if (user != null) {
            try {
                SpaceSettingsCreationJson settings = this.approvalSpaceService.updateSettings(spaceSettingsCreationJson, key, user);
                this.conditionCache.invalidateCaches();
                return Response.ok((Object)settings).build();
            }
            catch (InvalidJsonException e) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
            catch (NoSpacePermissionException e) {
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
            }
        }
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
    }

    @POST
    @Path(value="/team")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @PublicApi
    public Response updateTeam(@Context HttpServletRequest request, @QueryParam(value="key") String key, TeamCreationJson teamCreationJson) {
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        if (user != null) {
            try {
                return Response.ok((Object)this.approvalSpaceService.updateOrCreateTeam(user, key, teamCreationJson)).build();
            }
            catch (InvalidJsonException e) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
            catch (NoSpacePermissionException e) {
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
            }
            catch (InternalServerErrorException e) {
                return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
            }
            catch (TeamNotFoundException e) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
        }
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
    }

    @DELETE
    @Path(value="/team")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @PublicApi
    public Response deleteTeam(@Context HttpServletRequest request, @QueryParam(value="id") int id) {
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        if (user != null) {
            try {
                this.approvalSpaceService.deleteTeam(user, id);
                return Response.ok().build();
            }
            catch (InternalServerErrorException e) {
                return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
            }
            catch (NoSpacePermissionException e) {
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
            }
        }
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
    }

    @POST
    @Path(value="/reset-my-notifications")
    @Produces(value={"application/json"})
    @PublicApi
    public Response resetMyNotifications(@Context HttpServletRequest request) {
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        if (user != null) {
            this.approvalSystemService.removeMyNotifications(user);
            return Response.ok().build();
        }
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
    }

    @POST
    @Path(value="/reset-all-notifications")
    @Produces(value={"application/json"})
    @WebSudoRequired
    @PublicApi
    public Response resetAllNotifications(@Context HttpServletRequest request) {
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        if (user != null && this.permissionManager.isConfluenceAdministrator(user)) {
            this.approvalSystemService.removeAllNotifications();
            return Response.ok().build();
        }
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
    }

    @POST
    @Path(value="/maintenance")
    @Produces(value={"application/json"})
    @WebSudoRequired
    @PublicApi
    public Response performMaintenance(@Context HttpServletRequest request) {
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        if (user != null && this.permissionManager.isConfluenceAdministrator(user)) {
            this.approvalMaintenanceService.performCleanup();
            return Response.ok().build();
        }
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
    }

    @GET
    @Path(value="/statistics")
    @Produces(value={"application/json"})
    @WebSudoRequired
    @PublicApi
    public Response getStatistics(@Context HttpServletRequest request) {
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        if (user != null && this.permissionManager.isConfluenceAdministrator(user)) {
            return Response.ok((Object)this.approvalMaintenanceService.getStatistics()).build();
        }
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
    }

    @POST
    @Path(value="/migration")
    @Produces(value={"application/json"})
    @WebSudoRequired
    @PublicApi
    public Response migrateFromServiceRocket(@Context HttpServletRequest request, @QueryParam(value="deleteOldApprovals") boolean deleteOldApprovals) {
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        if (user != null && this.permissionManager.isConfluenceAdministrator(user)) {
            return Response.ok((Object)this.approvalMigrationService.migrateFromServiceRocket(user, deleteOldApprovals)).build();
        }
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
    }
}

