/*
 * Decompiled with CFR 0.152.
 */
package co.uk.automationconsultants.approvals.cache;

import co.uk.automationconsultants.approvals.ao.settings.SystemSettings;
import co.uk.automationconsultants.approvals.json.settings.SystemSettingsJson;
import co.uk.automationconsultants.approvals.service.ApprovalSystemService;
import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheLoader;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Named;
import javax.xml.bind.JAXB;
import net.java.ao.Query;

@Named(value="systemSettingsCacheService")
public class SystemSettingsCache {
    @ComponentImport
    private final CacheManager cacheManager;
    private final Cache<String, String> systemSettingsCache;
    private final ActiveObjects activeObjects;

    @Inject
    public SystemSettingsCache(CacheManager cacheManager, ActiveObjects activeObjects) {
        this.cacheManager = cacheManager;
        this.systemSettingsCache = cacheManager.getCache(SystemSettingsCache.class.getName() + ".systemCache", (CacheLoader)new SystemSettingsCached(), new CacheSettingsBuilder().expireAfterAccess(30L, TimeUnit.MINUTES).maxEntries(100).build());
        this.activeObjects = activeObjects;
    }

    public SystemSettingsJson getSystemSettings() {
        return (SystemSettingsJson)JAXB.unmarshal((Reader)new StringReader((String)this.systemSettingsCache.get((Object)"SYSTEM")), SystemSettingsJson.class);
    }

    public void invalidateCaches() {
        this.systemSettingsCache.removeAll();
    }

    private class SystemSettingsCached
    implements CacheLoader<String, String> {
        private SystemSettingsCached() {
        }

        public String load(@Nonnull String systemKey) {
            SystemSettings[] settings = (SystemSettings[])SystemSettingsCache.this.activeObjects.find(SystemSettings.class, Query.select().order("ID ASC").limit(1));
            SystemSettingsJson settingsJson = settings.length < 1 ? ApprovalSystemService.getDefaultJson() : ApprovalSystemService.mapSettingsToJson(settings[0]);
            StringWriter sw = new StringWriter();
            JAXB.marshal((Object)settingsJson, (Writer)sw);
            return sw.toString();
        }
    }
}

