/*
 * Decompiled with CFR 0.152.
 */
package co.uk.automationconsultants.approvals.cache;

import co.uk.automationconsultants.approvals.ao.settings.SpaceSettings;
import co.uk.automationconsultants.approvals.cache.SystemSettingsCache;
import co.uk.automationconsultants.approvals.json.request.SpaceSettingsCreationJson;
import co.uk.automationconsultants.approvals.json.settings.SystemSettingsJson;
import co.uk.automationconsultants.approvals.service.ApprovalSpaceService;
import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheLoader;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Named;
import javax.xml.bind.JAXB;
import net.java.ao.DBParam;
import net.java.ao.Query;

@Named(value="spaceSettingsCacheService")
public class SpaceSettingsCache {
    @ComponentImport
    private final CacheManager cacheManager;
    private final Cache<Long, String> spaceSettingsCache;
    private final ActiveObjects activeObjects;
    private final SystemSettingsCache systemSettingsCache;

    @Inject
    public SpaceSettingsCache(CacheManager cacheManager, ActiveObjects activeObjects, SystemSettingsCache systemSettingsCache) {
        this.cacheManager = cacheManager;
        this.spaceSettingsCache = cacheManager.getCache(SpaceSettingsCache.class.getName() + ".spaceCache", (CacheLoader)new SpaceSettingsCached(), new CacheSettingsBuilder().local().expireAfterAccess(30L, TimeUnit.MINUTES).maxEntries(100).build());
        this.activeObjects = activeObjects;
        this.systemSettingsCache = systemSettingsCache;
    }

    public SpaceSettingsCreationJson getSpaceSettings(Long spaceId) {
        return (SpaceSettingsCreationJson)JAXB.unmarshal((Reader)new StringReader((String)this.spaceSettingsCache.get((Object)spaceId)), SpaceSettingsCreationJson.class);
    }

    public void invalidateCaches() {
        this.spaceSettingsCache.removeAll();
    }

    private class SpaceSettingsCached
    implements CacheLoader<Long, String> {
        private SpaceSettingsCached() {
        }

        public String load(@Nonnull Long spaceId) {
            SpaceSettings[] spaceSettings = (SpaceSettings[])SpaceSettingsCache.this.activeObjects.find(SpaceSettings.class, Query.select().where("SPACE_ID = ?", new Object[]{spaceId}).order("ID ASC").limit(1));
            SystemSettingsJson systemSettings = SpaceSettingsCache.this.systemSettingsCache.getSystemSettings();
            SpaceSettingsCreationJson spaceSettingsJson = spaceSettings.length > 0 ? ApprovalSpaceService.mapSettingsToJson(spaceSettings[0]) : ApprovalSpaceService.mapSettingsToJson((SpaceSettings)SpaceSettingsCache.this.activeObjects.executeInTransaction(() -> {
                SpaceSettingsCreationJson defaultJson = ApprovalSpaceService.getDefaultJson(systemSettings);
                return (SpaceSettings)SpaceSettingsCache.this.activeObjects.create(SpaceSettings.class, new DBParam[]{new DBParam("SPACE_ID", (Object)spaceId), new DBParam("ENABLED", (Object)defaultJson.isEnabled()), new DBParam("OVERRIDE_SYSTEM_WORDING", (Object)defaultJson.isOverrideWording()), new DBParam("PENDING_TEXT", (Object)defaultJson.getPendingText()), new DBParam("APPROVED_TEXT", (Object)defaultJson.getApprovedText()), new DBParam("REJECTED_TEXT", (Object)defaultJson.getRejectedText()), new DBParam("EXPIRED_TEXT", (Object)defaultJson.getExpiredText()), new DBParam("CREATE_APPROVAL_RESTRICTED", (Object)(!defaultJson.getCreateApprovalGroups().isEmpty() ? 1 : 0))});
            }));
            StringWriter sw = new StringWriter();
            JAXB.marshal((Object)spaceSettingsJson, (Writer)sw);
            return sw.toString();
        }
    }
}

