/*
 * Decompiled with CFR 0.152.
 */
package co.uk.automationconsultants.approvals.cache;

import co.uk.automationconsultants.approvals.service.ApprovalLicenseService;
import co.uk.automationconsultants.approvals.service.ApprovalSpaceService;
import co.uk.automationconsultants.approvals.service.ApprovalSystemService;
import co.uk.automationconsultants.approvals.service.enumerator.LicenseType;
import co.uk.automationconsultants.approvals.service.exception.InvalidJsonException;
import co.uk.automationconsultants.approvals.service.exception.NoSpacePermissionException;
import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheLoader;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Named;

@Named(value="approvalCacheService")
public class ConditionCache {
    @ComponentImport
    private final CacheManager cacheManager;
    private final ApprovalSystemService approvalSystemService;
    private final ApprovalSpaceService approvalSpaceService;
    private ApprovalLicenseService approvalLicenseService;
    private final Cache<String, Boolean> spaceCache;
    private final Cache<String, Boolean> systemCache;
    private final Cache<String, Boolean> licenseCache;
    private final Cache<String, Boolean> globallyControlledCache;

    @Inject
    public ConditionCache(CacheManager cacheManager, ApprovalSpaceService approvalSpaceService, ApprovalSystemService approvalSystemService, ApprovalLicenseService approvalLicenseService) {
        this.systemCache = cacheManager.getCache(ConditionCache.class.getName() + ".systemCache", (CacheLoader)new SystemCache(), new CacheSettingsBuilder().local().expireAfterAccess(30L, TimeUnit.MINUTES).maxEntries(5).build());
        this.approvalLicenseService = approvalLicenseService;
        this.licenseCache = cacheManager.getCache(ConditionCache.class.getName() + "licenseCache", (CacheLoader)new LicenseCache(), new CacheSettingsBuilder().local().expireAfterAccess(30L, TimeUnit.MINUTES).maxEntries(5).build());
        this.spaceCache = cacheManager.getCache(ConditionCache.class.getName() + ".spaceCache", (CacheLoader)new SpaceCache(), new CacheSettingsBuilder().local().expireAfterAccess(30L, TimeUnit.MINUTES).maxEntries(100).build());
        this.globallyControlledCache = cacheManager.getCache(ConditionCache.class.getName() + ".globallyControlledCache", (CacheLoader)new GloballyControlledCache(), new CacheSettingsBuilder().local().expireAfterAccess(30L, TimeUnit.MINUTES).maxEntries(5).build());
        this.cacheManager = cacheManager;
        this.approvalSpaceService = approvalSpaceService;
        this.approvalSystemService = approvalSystemService;
    }

    public void invalidateCaches() {
        this.spaceCache.removeAll();
        this.systemCache.removeAll();
    }

    public boolean isGloballyControlled() {
        try {
            return (Boolean)this.globallyControlledCache.get((Object)"SYSTEM");
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean isEnabled() {
        try {
            return (Boolean)this.systemCache.get((Object)"SYSTEM");
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean isEnabled(String spaceKey) {
        try {
            return (Boolean)this.spaceCache.get((Object)spaceKey.toUpperCase());
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean isLicensed() {
        try {
            return (Boolean)this.licenseCache.get((Object)"LICENSE");
        }
        catch (Exception e) {
            return false;
        }
    }

    private class SystemCache
    implements CacheLoader<String, Boolean> {
        private SystemCache() {
        }

        public Boolean load(@Nonnull String systemKey) {
            return ConditionCache.this.approvalSystemService.getSettings().getEnabled();
        }
    }

    private class LicenseCache
    implements CacheLoader<String, Boolean> {
        private LicenseCache() {
        }

        public Boolean load(@Nonnull String licenseKey) {
            return ConditionCache.this.approvalLicenseService.getLicense() != LicenseType.NO_LICENSE;
        }
    }

    private class SpaceCache
    implements CacheLoader<String, Boolean> {
        private SpaceCache() {
        }

        public Boolean load(@Nonnull String spaceKey) {
            if (ConditionCache.this.approvalSystemService.getSettings().getGloballyControlled().booleanValue()) {
                return ConditionCache.this.approvalSystemService.getSettings().getEnabled();
            }
            ConfluenceUser user = AuthenticatedUserThreadLocal.get();
            try {
                return ConditionCache.this.approvalSpaceService.getSettings(spaceKey, user).isEnabled();
            }
            catch (InvalidJsonException | NoSpacePermissionException e) {
                return false;
            }
        }
    }

    private class GloballyControlledCache
    implements CacheLoader<String, Boolean> {
        private GloballyControlledCache() {
        }

        public Boolean load(@Nonnull String systemKey) {
            return ConditionCache.this.approvalSystemService.getSettings().getGloballyControlled();
        }
    }
}

