/*
 * Decompiled with CFR 0.152.
 */
package co.uk.automationconsultants.approvals.listener;

import co.uk.automationconsultants.approvals.ao.Approval;
import co.uk.automationconsultants.approvals.ao.ApprovalMember;
import co.uk.automationconsultants.approvals.json.ApprovalJson;
import co.uk.automationconsultants.approvals.json.request.ApprovalCreationJson;
import co.uk.automationconsultants.approvals.service.ApprovalEmailService;
import co.uk.automationconsultants.approvals.service.ApprovalMaintenanceService;
import co.uk.automationconsultants.approvals.service.ApprovalService;
import co.uk.automationconsultants.approvals.service.ApprovalSystemService;
import co.uk.automationconsultants.approvals.service.enumerator.ApproverType;
import co.uk.automationconsultants.approvals.service.events.ApprovalRequestEvent;
import co.uk.automationconsultants.approvals.service.events.ApprovalStatusEvent;
import co.uk.automationconsultants.approvals.service.exception.InvalidJsonException;
import co.uk.automationconsultants.approvals.service.exception.NoApprovalException;
import co.uk.automationconsultants.approvals.service.exception.NoPageException;
import co.uk.automationconsultants.approvals.service.exception.NoPagePermissionException;
import co.uk.automationconsultants.approvals.service.exception.NoPageVersionException;
import co.uk.automationconsultants.approvals.service.exception.NoSpacePermissionException;
import co.uk.automationconsultants.approvals.utils.StringUtils;
import com.atlassian.applinks.host.spi.HostApplication;
import com.atlassian.confluence.event.events.content.page.PageCreateEvent;
import com.atlassian.confluence.event.events.content.page.PageMoveEvent;
import com.atlassian.confluence.event.events.content.page.PageRemoveEvent;
import com.atlassian.confluence.event.events.content.page.PageRestoreEvent;
import com.atlassian.confluence.event.events.content.page.PageTrashedEvent;
import com.atlassian.confluence.event.events.content.page.PageUpdateEvent;
import com.atlassian.confluence.event.events.space.SpaceRemoveEvent;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.mywork.model.Notification;
import com.atlassian.mywork.model.NotificationBuilder;
import com.atlassian.mywork.service.LocalNotificationService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.user.UserKey;
import java.io.IOException;
import java.io.StringReader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang3.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

@Named(value="approvalListener")
public class ApprovalListener
implements DisposableBean,
InitializingBean {
    private static final Logger logger = LoggerFactory.getLogger(ApprovalListener.class);
    private static final String APPROVAL_KEY = "approval";
    private static final String AC_MACRO_ID = "ac:macro-id";
    @ComponentImport
    private EventPublisher eventPublisher;
    @ComponentImport
    private final UserAccessor userAccessor;
    @ComponentImport
    private final LocalNotificationService notificationService;
    @ComponentImport
    private final HostApplication hostApplication;
    private final ApprovalService approvalService;
    private final ApprovalMaintenanceService approvalMaintenanceService;
    private final ApprovalEmailService approvalEmailService;
    private final ApprovalSystemService approvalSystemService;

    @Inject
    public ApprovalListener(EventPublisher eventPublisher, ApprovalMaintenanceService approvalMaintenanceService, UserAccessor userAccessor, ApprovalService approvalService, LocalNotificationService notificationService, HostApplication hostApplication, ApprovalEmailService approvalEmailService, ApprovalSystemService approvalSystemService) {
        this.eventPublisher = eventPublisher;
        this.approvalMaintenanceService = approvalMaintenanceService;
        this.userAccessor = userAccessor;
        this.approvalService = approvalService;
        this.notificationService = notificationService;
        this.hostApplication = hostApplication;
        this.approvalEmailService = approvalEmailService;
        this.approvalSystemService = approvalSystemService;
        eventPublisher.register((Object)this);
    }

    @EventListener
    public void pageCreated(PageCreateEvent event) {
        String approvalMacroCount = event.getPage().getProperties().getStringProperty("macro-count.approval");
        if (approvalMacroCount != null) {
            String bodyAsStringWithoutMarkup = StringEscapeUtils.unescapeHtml4((String)event.getContent().getBodyAsString().replace("&lt;", "{").replace("&gt;", "}"));
            try {
                this.processMacros(bodyAsStringWithoutMarkup, event.getPage().getCreator(), event.getPage().getId(), event.getPage().getVersion(), (AbstractPage)event.getPage());
            }
            catch (InvalidJsonException e) {
                logger.error("An error occurred while processing macros", (Throwable)e);
            }
        }
    }

    public static String removePageLinks(String body) {
        String exprOpen = "<ac:link>";
        String exprClose = "</ac:link>";
        String regex = exprOpen + "(?<=" + exprOpen + ")(.*?)(?=" + exprClose + ")" + exprClose;
        body = body.replaceAll(regex, "");
        return body;
    }

    @EventListener
    public void pageUpdated(PageUpdateEvent event) {
        String approvalMacroCount = ((Page)event.getNew()).getProperties().getStringProperty("macro-count.approval");
        String[] macroNames = ((Page)event.getNew()).getProperties().getStringProperty("macroNames").split(",");
        boolean exists = false;
        for (String macroName : macroNames) {
            if (!macroName.equals(APPROVAL_KEY)) continue;
            exists = true;
            break;
        }
        if (approvalMacroCount != null || exists) {
            String bodyAsStringWithoutMarkup = StringEscapeUtils.unescapeHtml4((String)event.getContent().getBodyAsString().replace("&lt;", "{").replace("&gt;", "}"));
            try {
                this.processMacros(bodyAsStringWithoutMarkup, event.getNew().getLastModifier(), event.getPage().getId(), event.getPage().getVersion(), (AbstractPage)event.getPage());
            }
            catch (InvalidJsonException e) {
                logger.error("An error occurred while processing macros", (Throwable)e);
            }
        }
        try {
            ApprovalJson existingApproval = this.approvalService.getPageApproval(event.getNew().getLastModifier(), event.getPage().getId(), event.getPage().getPreviousVersion());
            if (existingApproval != null) {
                existingApproval.setVersion(existingApproval.getVersion() + 1);
                ApprovalCreationJson approvalJson = new ApprovalCreationJson(existingApproval);
                this.approvalService.postPageApproval(event.getNew().getLastModifier(), event.getPage().getId(), approvalJson, existingApproval);
            }
        }
        catch (InvalidJsonException | NoApprovalException | NoPageException | NoPagePermissionException | NoPageVersionException | NoSpacePermissionException e) {
            logger.error("An error occurred while updating page approvals", (Throwable)e);
        }
    }

    @EventListener
    public void pageMoved(PageMoveEvent event) {
        long pageId = event.getPage().getId();
        long newSpaceId = event.getPage().getSpace().getId();
        this.approvalService.processMovePage(pageId, newSpaceId);
    }

    @EventListener
    public void notifyRequest(ApprovalRequestEvent event) {
        Approval approval = event.getApproval();
        Map<String, ApproverType> recipientMap = event.getRecipientMap();
        ConfluenceUser updator = this.userAccessor.getUserByKey(new UserKey(approval.getUpdator()));
        if (Boolean.TRUE.equals(this.approvalSystemService.getSettings().getNotificationsInApp())) {
            for (Map.Entry<String, ApproverType> entry : recipientMap.entrySet()) {
                List entity;
                String s = entry.getKey();
                ApproverType approverType = entry.getValue();
                ConfluenceUser recipient = this.userAccessor.getUserByKey(new UserKey(s));
                if (recipient == null || (entity = Arrays.stream(approval.getMembers()).filter(approvalMember -> approvalMember.getUserKey().equals(recipient.getKey().getStringValue())).collect(Collectors.toList())).isEmpty()) continue;
                ApprovalMember approvalMember2 = (ApprovalMember)entity.get(0);
                try {
                    Notification task = (Notification)this.notificationService.createOrUpdate(recipient.getName(), new NotificationBuilder().application("co.uk.automationconsultants.approvals").iconUrl(this.hostApplication.getBaseUrl() + "/download/resources/com.automation-consultants.accloud.approvalmacro:icon-resources/pluginLogo.png").itemIconUrl(this.hostApplication.getBaseUrl() + "/download/resources/com.automation-consultants.accloud.approvalmacro:icon-resources/pluginIcon.png").title((approverType.equals((Object)ApproverType.REAPPROVAL) ? "Reapproval" : "Approval") + " Pending on '" + event.getMacroTitle() + "'").description("Your " + (approverType.equals((Object)ApproverType.REAPPROVAL) ? "approval has expired and requires re-approval. Requested by " : "approval  has been requested by ") + (updator == null ? "?" : updator.getFullName())).itemTitle("Approval Requested").globalId("appId=" + this.hostApplication.getId().get() + "&entity=approval-request").entity(APPROVAL_KEY).url(this.hostApplication.getBaseUrl().toASCIIString() + "/pages/viewpage.action?pageId=" + approval.getPageId()).applicationLinkId(this.hostApplication.getId().get()).createNotification()).get();
                    approvalMember2.setNotificationId(task.getId());
                    approvalMember2.save();
                }
                catch (InterruptedException | ExecutionException e) {
                    logger.error("An error occurred while sending notifications", (Throwable)e);
                    if (!(e instanceof InterruptedException)) continue;
                    Thread.currentThread().interrupt();
                }
            }
        }
        if (approval.isRequestNotificationEnabled().booleanValue() && this.approvalSystemService.getSettings().getNotificationsEmail().booleanValue()) {
            this.approvalEmailService.sendApprovalRequestEmails(recipientMap, approval);
        }
    }

    @EventListener
    public void notifyStatus(ApprovalStatusEvent event) {
        Approval approval;
        if (Boolean.TRUE.equals(this.approvalSystemService.getSettings().getNotificationsEmail()) && (approval = event.getApproval()) != null && approval.isStatusNotificationEnabled().booleanValue()) {
            this.approvalEmailService.sendApprovalStatusEmails(approval);
        }
    }

    private void processMacros(String bodyAsStringWithoutMarkup, ConfluenceUser user, Long pageId, int pageVersion, AbstractPage page) throws InvalidJsonException {
        String body = ApprovalListener.removePageLinks(bodyAsStringWithoutMarkup);
        Document document = this.getDomElement("<p>" + body.replace("&", "&#038;") + "</p>");
        if (document != null) {
            NodeList macros = document.getElementsByTagName("ac:structured-macro");
            ArrayList<String> presentUuid = new ArrayList<String>();
            for (int i = 0; i < macros.getLength(); ++i) {
                NamedNodeMap attributes;
                Node item = macros.item(i);
                if (!APPROVAL_KEY.equals(item.getAttributes().getNamedItem("ac:name").getNodeValue()) || (attributes = item.getAttributes()).getNamedItem(AC_MACRO_ID).getNodeValue() == null || attributes.getNamedItem(AC_MACRO_ID).getNodeValue().length() <= 0) continue;
                ApprovalCreationJson approvalJson = this.approvalService.setMacroApprovalDefaultsNoCheck(user, new ApprovalCreationJson("macro", user.getKey().getStringValue(), pageId, attributes.getNamedItem(AC_MACRO_ID).getNodeValue(), pageVersion), page);
                NodeList children = item.getChildNodes();
                block31: for (int j = 0; j < children.getLength(); ++j) {
                    String parameter = children.item(j).getAttributes().getNamedItem("ac:name").getNodeValue();
                    String content = children.item(j).getTextContent();
                    switch (parameter) {
                        case "uuid": {
                            approvalJson.setUuid(content);
                            presentUuid.add(content);
                            continue block31;
                        }
                        case "title": {
                            approvalJson.setTitle(content);
                            continue block31;
                        }
                        case "requestNotifications": {
                            approvalJson.setRequestNotificationsEnabled(content.equals("true"));
                            continue block31;
                        }
                        case "statusNotifications": {
                            approvalJson.setStatusNotificationsEnabled(content.equals("true"));
                            continue block31;
                        }
                        case "expireOnEdit": {
                            approvalJson.setExpireOnEdit(content.equals("true"));
                            continue block31;
                        }
                        case "expiryDate": {
                            if (content.length() <= 0) continue block31;
                            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
                            try {
                                approvalJson.setExpiryDate(format.parse(content));
                            }
                            catch (ParseException e) {
                                approvalJson.setExpiryDate(null);
                            }
                            continue block31;
                        }
                        case "approvers": {
                            List<String> list = StringUtils.parseStringToStringList(content);
                            ArrayList<String> output = new ArrayList<String>();
                            Iterator<String> iterator = list.iterator();
                            while (iterator.hasNext()) {
                                String approver;
                                String userKey = approver = iterator.next();
                                output.add(userKey);
                            }
                            approvalJson.setMembers(output);
                            continue block31;
                        }
                        case "quorumSize": {
                            try {
                                approvalJson.setQuorumSize(Integer.parseInt(content));
                            }
                            catch (NumberFormatException e) {
                                approvalJson.setQuorumSize(0);
                            }
                            continue block31;
                        }
                        case "enableQuorum": {
                            continue block31;
                        }
                        case "expireOnDate": {
                            continue block31;
                        }
                    }
                }
                try {
                    this.approvalService.postMacroApproval(user, page.getId(), approvalJson);
                    continue;
                }
                catch (NoApprovalException | NoPageException | NoPagePermissionException | NoPageVersionException | NoSpacePermissionException e) {
                    logger.error("An error occurred while creating page approvals", (Throwable)e);
                }
            }
            this.approvalService.markRemovedMacros(pageId, presentUuid);
        }
    }

    private Document getDomElement(String xml) {
        Document doc = null;
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            dbf.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            DocumentBuilder db = dbf.newDocumentBuilder();
            InputSource is = new InputSource();
            is.setCharacterStream(new StringReader(xml));
            doc = db.parse(is);
        }
        catch (IOException | ParserConfigurationException e) {
            return null;
        }
        catch (SAXException e) {
            logger.error("SAXException occurred while getting the DOM element ", (Throwable)e);
        }
        return doc;
    }

    @EventListener
    public void pageTrashed(PageTrashedEvent event) {
        Page page = event.getPage();
        long id = page.getId();
        long contentId = page.getContentId().asLong();
        logger.debug("A4C: Page Trashed (pageId: {}, contentId: {})", (Object)id, (Object)contentId);
        this.approvalService.markSupersededPageApprovals(id, Integer.MAX_VALUE);
        this.approvalService.markSupersededMacros(id);
    }

    @EventListener
    public void pageRestored(PageRestoreEvent event) {
        logger.debug("A4C: Page Restored (pageId: {})", (Object)event.getPage().getId());
        this.approvalService.reopenRestoredApprovals(event.getPage().getId());
    }

    @EventListener
    public void pageRemoved(PageRemoveEvent event) {
        Page page = event.getPage();
        long id = page.getId();
        long contentId = page.getContentId().asLong();
        logger.debug("A4C: Page Deleted (pageId: {}, contentId: {})", (Object)id, (Object)contentId);
        this.approvalMaintenanceService.removePageEntities(id);
    }

    @EventListener
    public void spaceRemoved(SpaceRemoveEvent event) {
        long id = event.getSpace().getId();
        logger.debug("A4C: Space Deleted (spaceId: {})", (Object)id);
        this.approvalMaintenanceService.removeSpaceEntities(id);
    }

    public void destroy() throws Exception {
        this.eventPublisher.unregister((Object)this);
    }

    public void afterPropertiesSet() throws Exception {
    }
}

