var firstTimeApprovalByline = true;

$(function(){
    AJS.toInit(function() {
        // Classes
        var cssContainerClass = 'approval-byline-container';
        var cssIndicatorClass = 'approval-byline-indicator';
        var cssMessageClass = 'approval-byline-text';
        var idInlineDialog = 'approval-byline-inline-dialog';
        var idAppRoot = 'approvalsForConfluenceRoot';
        var oldVersion = AJS.version.split(".")[0] === "6";

        // Get Approval Byline HTML
        function getByline(count, total, status, prettyStatus) {
            let statusText;
            let statusIcon;
            if (count == null && total == null && status == null) {
                statusIcon = `<span style="color: #0049B0; margin-right: 2px" class="aui-icon aui-icon-small ${(oldVersion ? 'aui-iconfont-add' : 'aui-iconfont-add-circle')}">Approval</span>`;
                statusText = `<a class=${cssMessageClass}><b>Add Approval</b></a>`;
            } else {
                let iconClass = "aui-iconfont-approve";
                let iconColour = "#00875A";
                if(status === "pending") {
                    iconClass = oldVersion ? "aui-iconfont-group" : "aui-iconfont-people";
                    iconColour = "#5243AA";
                } else if(status === "expired") {
                    iconClass = oldVersion ? "aui-iconfont-warning" : "aui-iconfont-error";
                    iconColour = "#FFAB00";
                } else if(status === "rejected") {
                    iconClass = oldVersion ? "aui-iconfont-remove" : "aui-iconfont-cross-circle";
                    iconColour = "#DE350B";
                }
                statusIcon = `<span style="color: ${iconColour}; margin-right: 2px" class="aui-icon aui-icon-small ${iconClass}">Approval</span>`;
                statusText = `<a style="color: ${iconColour}" class=${cssMessageClass}><b>${prettyStatus + " "}(${count}/${total})</b></a>`;
            }

            return `<li data-aui-trigger aria-controls=${idInlineDialog} title="Page Approval" class=${cssContainerClass}>
                        ${statusIcon}${statusText}
                    </li>
                    <aui-inline-dialog style="z-index: 1" alignment="bottom center" id=${idInlineDialog}>
                        <div id=${idAppRoot}></div>
                    </aui-inline-dialog>`;
        }

        // Kick the React into gear if the Byline is clicked on!
        function onContainerClick(pageApproval, spaceSettings) {
            if (firstTime) {
                // Byline Clicked
                approvalsForConfluence.renderByline(idAppRoot, pageApproval, spaceSettings);
                firstTime = false;
            } else {
                // Already Rendered
            }
        }

        // Inject the Container Listener and Tooltip
        function injectBylineClick(pageApproval, spaceSettings) {
            var container = $('.' + cssContainerClass);
            container.tooltip();
            container.on('click', function() {
                onContainerClick(pageApproval, spaceSettings);
            });
        }

        function onExistingStatus(count, total, status, spaceSettings) {
            metadata.append(getByline(count,total, status, getLabel(status, spaceSettings)));
        }

        function onNoData() {
            metadata.append(getByline(null, null, null));
        }

        function getLabel(status, spaceSettings) {
            switch(status) {
                case "pending":
                    return spaceSettings.pendingText;
                case "approved":
                    return spaceSettings.approvedText;
                case "rejected":
                    return spaceSettings.rejectedText;
                case "expired":
                    return spaceSettings.expiredText;
            }
        }

        // Only render react once
        var firstTime = true;

        // Get Byline
        var metadata = $('.page-metadata > ul:first-child');

        if (AJS.params.accessMode === "READ_WRITE" && metadata[0] && firstTimeApprovalByline) {
            firstTimeApprovalByline = false;
            // Determine if Page Approvals is enabled, stop if it's not.
            AJS.$.ajax({
                url: AJS.contextPath() + "/rest/approvalmacro/1.0/settings/consolidated?key=" + AJS.params.spaceKey.toUpperCase(),
                type: 'get',
                dataType: 'json',
                success: function (spaceSettings) {
                    if(spaceSettings && spaceSettings.enabled) {
                        // Get Page Approval
                        AJS.$.ajax({
                            url: AJS.contextPath() + "/rest/approvalmacro/1.0/approval",
                            type: 'post',
                            data: JSON.stringify({type: "page", pageId: parseInt(AJS.params.pageId), version: parseInt(AJS.$('meta[name=page-version]').attr("content"))}),
                            contentType: 'application/json',
                            success: function (pageApproval) {
                                // Existing Approval
                                var count = pageApproval.members.filter(function (value) { return value.status === "approved" }).length;
                                var total = pageApproval.members.length;
                                onExistingStatus(count, total, pageApproval.status, spaceSettings);
                                injectBylineClick(pageApproval, spaceSettings);
                            },
                            error: function(error) {
                                // No Existing Approval
                                onNoData();
                                injectBylineClick(null, spaceSettings);
                            }
                        });
                    } else {
                        // No Page Metadata, don't render
                    }
                },
                error: function() {
                    // Error occurred, don't continue.
                }
            });
        } else {
            // No Space Settings, or it's disabled, don't continue.
        }
    });
});
