/*
 * Decompiled with CFR 0.152.
 */
package co.uk.automationconsultants.approvals.cache;

import co.uk.automationconsultants.approvals.ao.settings.SystemSettings;
import co.uk.automationconsultants.approvals.json.settings.SystemSettingsJson;
import co.uk.automationconsultants.approvals.service.ApprovalSystemService;
import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheLoader;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Named;
import net.java.ao.Query;

@Named(value="systemSettingsCacheService")
public class SystemSettingsCache {
    @ComponentImport
    private final CacheManager cacheManager;
    private final Cache<String, SystemSettingsJson> systemSettingsCache;
    private final ActiveObjects activeObjects;

    @Inject
    public SystemSettingsCache(CacheManager cacheManager, ActiveObjects activeObjects) {
        this.cacheManager = cacheManager;
        this.systemSettingsCache = cacheManager.getCache(SystemSettingsCache.class.getName() + ".systemCache", (CacheLoader)new SystemSettingsCached(), new CacheSettingsBuilder().expireAfterAccess(30L, TimeUnit.MINUTES).maxEntries(100).build());
        this.activeObjects = activeObjects;
    }

    public SystemSettingsJson getSystemSettings() {
        return (SystemSettingsJson)this.systemSettingsCache.get((Object)"SYSTEM");
    }

    public void invalidateCaches() {
        this.systemSettingsCache.removeAll();
    }

    private class SystemSettingsCached
    implements CacheLoader<String, SystemSettingsJson> {
        private SystemSettingsCached() {
        }

        public SystemSettingsJson load(@Nonnull String systemKey) {
            SystemSettings[] settings = (SystemSettings[])SystemSettingsCache.this.activeObjects.find(SystemSettings.class, Query.select().order("ID ASC").limit(1));
            if (settings.length < 1) {
                return ApprovalSystemService.getDefaultJson();
            }
            return ApprovalSystemService.mapSettingsToJson(settings[0]);
        }
    }
}

