AJS.bind("init.rte", function() {
    // Adds a new event listener to the TinyMCE editor which listens for the PastePostProcess event
    // This event is triggered when a paste event occurs and modifies the pasted content before
    // it is inserted into the editor.
    tinymce.activeEditor.on('PastePostProcess', function(event) {
        function processNode(node) {
            // We must ensure that we are only editing our macros.
            if (node.tagName === 'IMG' && node.hasAttribute('data-macro-parameters') && node.getAttribute('aria-label') === 'approval macro') {
                // macroParameters is a string that contains the macro parameters. A new UUID is generated
                // and replaces the existing UUID using a regular expression. When the new UUID is inserted,
                // the change is instantly reflected in the macro editor.
                let newUuid = getUuidForApproval();
                let macroParameters = node.getAttribute('data-macro-parameters');
                let newMacroParameters = macroParameters.replace(/(uuid=)[^\|]*/, `$1${newUuid}`);
                node.setAttribute('data-macro-parameters', newMacroParameters);
            }
    
            for (let i = 0; i < node.childNodes.length; i++) {
                processNode(node.childNodes[i]);
            }
        }
    
        // event.node is the root node of the pasted content, it does not include content that
        // is does not exist in the users clipboard. A recursive function is used to traverse
        // the entire tree of nodes. A user could paste the macro (<img></img>) or they could
        // paste multiple macros across multiple lines (e.g. <p><img></img></p><p><img></img></p>).
        processNode(event.node);
    });

    var macroName = 'approval';
    // Create Dialog HTML
    AJS.$("body").append("<section id=\"approval-macro-editor\" class=\"aui-dialog2 aui-dialog2-medium aui-layer\" role=\"dialog\" aria-hidden=\"true\">\n" +
        "    <header class=\"aui-dialog2-header\">\n" +
        "        <h2 class=\"aui-dialog2-header-main\">Approval</h2>\n" +
        "        <a class=\"aui-dialog2-header-close\">\n" +
        "            <span id=\"dialog-close\" class=\"aui-icon aui-icon-small aui-iconfont-close-dialog\">Close</span>\n" +
        "        </a>\n" +
        "    </header>\n" +
        "    <div class=\"aui-dialog2-content\">\n" +
        "        <div id=\"approvalsForConfluenceMacroEditRoot\"></div>\n" +
        "    </div>\n" +
        "</section>");

    AJS.MacroBrowser.setMacroJsOverride(macroName, {
        opener: function (macro) {
            // Generate UUID
            approvalsForConfluence.renderMacroEdit("approvalsForConfluenceMacroEditRoot", macro, function (data) {
                var selection = AJS.Rte.getEditor().selection.getNode();
                var macro = {
                    name: macroName,
                    params: {
                        title: data.title,
                        expireOnEdit: data.expireOnEdit,
                        expireOnDate: data.expireOnDate,
                        expiryDate: data.expiryDate,
                        enableQuorum: data.quorumSize > 0,
                        quorumSize: data.quorumSize,
                        statusNotifications: data.statusNotifications,
                        requestNotifications: data.requestNotifications,
                        approvers: JSON.stringify(data.approvers),
                        count: data.approvers.length + (data.approvers.length === 1 ? " Approver" : " Approvers"),
                        uuid: data.uuid
                    }
                };
                tinymce.confluence.macrobrowser.macroBrowserComplete(macro);
                AJS.dialog2("#approval-macro-editor").hide();
            }, typeof macro.params === "undefined" ? null : macro.params.uuid);
            AJS.dialog2("#approval-macro-editor").show();
        }
    });

    AJS.$("#dialog-close").click(function(e) {
        e.preventDefault();
        AJS.dialog2("#approval-macro-editor").hide();
    });
});

function getUuidForApproval() {
    return "xxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx".replace(/[xy]/g, function(c) {
        const r = Math.random() * 16 | 0, v = c == "x" ? r : (r & 0x3 | 0x8);
        return v.toString(16);
    });
}