/*
 * Decompiled with CFR 0.152.
 */
package co.uk.automationconsultants.approvals.servlet;

import com.atlassian.confluence.plugin.services.VelocityHelperService;
import com.atlassian.confluence.renderer.template.TemplateRenderer;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.websudo.WebSudoManager;
import com.atlassian.sal.api.websudo.WebSudoSessionException;
import java.io.IOException;
import java.util.HashMap;
import javax.inject.Inject;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class AdminServlet
extends HttpServlet {
    @ComponentImport
    private final TemplateRenderer renderer;
    @ComponentImport
    private final WebSudoManager webSudoManager;
    @ComponentImport
    private final VelocityHelperService velocityHelperService;

    @Inject
    public AdminServlet(TemplateRenderer renderer, WebSudoManager webSudoManager, VelocityHelperService velocityHelperService) {
        this.renderer = renderer;
        this.webSudoManager = webSudoManager;
        this.velocityHelperService = velocityHelperService;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        try {
            this.webSudoManager.willExecuteWebSudoRequest(request);
            response.setContentType("text/html;charset=utf-8");
            HashMap<String, Boolean> params = new HashMap<String, Boolean>();
            String[] segments = request.getRequestURI().split("/");
            String subPath = segments[segments.length - 1];
            params.put("injectBootstrap", subPath.equals("introduction"));
            try {
                response.getWriter().write(this.velocityHelperService.getRenderedTemplate("/templates/display/admin/approvals-page.vm", params));
            }
            catch (IOException e) {
                response.sendError(500);
            }
        }
        catch (WebSudoSessionException wes) {
            this.webSudoManager.enforceWebSudoProtection(request, response);
        }
    }
}

