/*
 * Decompiled with CFR 0.152.
 */
package co.uk.automationconsultants.approvals.utils;

import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public class ApprovalMigrationUtils {
    public static final int APPROVAL_MEMBER_MAX_SIZE = 20;

    private ApprovalMigrationUtils() {
    }

    private static boolean doesMonthHave31Days(Integer month) {
        return !Arrays.asList(1, 3, 5, 8, 10).contains(month);
    }

    private static boolean isMonthInRange(int month) {
        return 1 <= month && month <= 12;
    }

    private static boolean isDayInRange(int day) {
        return 1 <= day && day <= 31;
    }

    private static boolean isExpiryDayAndMonthValid(Integer month, Integer day) {
        if (month == null && day == null) {
            return false;
        }
        if (month == null) {
            return ApprovalMigrationUtils.isDayInRange(day);
        }
        if (day == null) {
            return ApprovalMigrationUtils.isMonthInRange(month);
        }
        if (!ApprovalMigrationUtils.isDayInRange(day) || !ApprovalMigrationUtils.isMonthInRange(month)) {
            return false;
        }
        if (day == 31) {
            return ApprovalMigrationUtils.doesMonthHave31Days(month - 1);
        }
        if (day == 30) {
            return month != 2;
        }
        return true;
    }

    private static int getNextMonth(int currMonth, int currDay, int day) {
        if (day > currDay) {
            if (day == 30 && currMonth == 1) {
                return 2;
            }
            if (day == 31) {
                return ApprovalMigrationUtils.doesMonthHave31Days(currMonth) ? currMonth : ApprovalMigrationUtils.getNextMonthWith31Days(currMonth);
            }
            return currMonth;
        }
        if (day == 30 && currMonth == 0) {
            return 2;
        }
        if (day == 31) {
            return ApprovalMigrationUtils.getNextMonthWith31Days(currMonth);
        }
        return currMonth + 1;
    }

    private static int getNextMonthWith31Days(int currMonth) {
        int m = currMonth + 1;
        while (m != currMonth) {
            if (ApprovalMigrationUtils.doesMonthHave31Days(m)) {
                return m;
            }
            m = (m + 1) % 12;
        }
        return currMonth;
    }

    private static int getMonth(int currMonth, int currDay, Integer month, int day) {
        if (month == null) {
            return ApprovalMigrationUtils.getNextMonth(currMonth, currDay, day);
        }
        return month - 1;
    }

    @Nullable
    public static Date parseExpiryDate(Date currDate, Integer month, Integer day) {
        if (!ApprovalMigrationUtils.isExpiryDayAndMonthValid(month, day)) {
            return null;
        }
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        calendar.setTime(currDate);
        int currYear = calendar.get(1);
        int currMonth = calendar.get(2);
        int currDay = calendar.get(5);
        int actualDay = day == null ? 1 : day;
        int actualMonth = ApprovalMigrationUtils.getMonth(currMonth, currDay, month, actualDay);
        calendar.set(currYear, actualMonth, actualDay, 12, 0, 0);
        if (calendar.getTime().compareTo(currDate) < 0) {
            calendar.set(currYear + 1, actualMonth, actualDay, 12, 0, 0);
        }
        return calendar.getTime();
    }

    public static Date parseExpireAfterTerm(Date currDate, String timePeriod) {
        if (currDate == null) {
            return null;
        }
        String preprocess = timePeriod.toLowerCase().replace(" ", "").replace("s", "");
        Pattern pattern = Pattern.compile("^(\\d+)(\\w+)");
        Matcher matcher = pattern.matcher(preprocess);
        int timeValue = 0;
        String timeType = "";
        if (matcher.find()) {
            timeValue = Integer.parseInt(matcher.group(1));
            timeType = matcher.group(2);
        }
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        cal.setTime(currDate);
        cal.set(14, 0);
        cal.set(13, 0);
        cal.set(12, 0);
        cal.set(10, 0);
        cal.set(11, 0);
        switch (timeType) {
            case "hour": {
                cal.setTime(currDate);
                cal.add(11, timeValue);
                break;
            }
            case "day": {
                cal.add(5, timeValue);
                break;
            }
            case "month": {
                cal.add(2, timeValue);
                break;
            }
            case "year": {
                cal.add(1, timeValue);
                break;
            }
            default: {
                return null;
            }
        }
        return cal.getTime();
    }

    public static Date parseExpiryDate(Integer month, Integer day) {
        return ApprovalMigrationUtils.parseExpiryDate(new Date(), month, day);
    }
}

