/*
 * Decompiled with CFR 0.152.
 */
package co.uk.automationconsultants.approvals.service.migration;

import co.uk.automationconsultants.approvals.ao.Approval;
import co.uk.automationconsultants.approvals.ao.ApprovalMember;
import co.uk.automationconsultants.approvals.helper.GroupHelper;
import co.uk.automationconsultants.approvals.json.ApprovalJson;
import co.uk.automationconsultants.approvals.json.ApprovalMemberJson;
import co.uk.automationconsultants.approvals.service.ApprovalService;
import co.uk.automationconsultants.approvals.service.migration.ApprovalAndApprovalMemberService;
import co.uk.automationconsultants.approvals.service.migration.ContentSearchFactory;
import co.uk.automationconsultants.approvals.service.migration.SpaceMacroMigrationService;
import co.uk.automationconsultants.approvals.utils.ApprovalMigrationUtils;
import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.ContentPropertyManager;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.search.v2.ContentSearch;
import com.atlassian.confluence.search.v2.ISearch;
import com.atlassian.confluence.search.v2.InvalidSearchException;
import com.atlassian.confluence.search.v2.SearchManager;
import com.atlassian.confluence.search.v2.SearchQuery;
import com.atlassian.confluence.search.v2.SearchResult;
import com.atlassian.confluence.search.v2.SearchResults;
import com.atlassian.confluence.search.v2.query.MacroUsageQuery;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.user.UserKey;
import java.io.IOException;
import java.io.StringReader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.java.ao.DBParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

@Named(value="approvalMigrationService")
public class ApprovalMigrationService {
    @ComponentImport
    private final ActiveObjects activeObjects;
    @ComponentImport
    private final PageManager pageManager;
    @ComponentImport
    private final ContentPropertyManager contentPropertyManager;
    @ComponentImport
    private final SearchManager searchManager;
    private final ApprovalService approvalService;
    @ComponentImport
    private final UserAccessor userAccessor;
    private final SpaceMacroMigrationService spaceMacroMigrationService;
    private final GroupHelper groupHelper;
    private final ApprovalAndApprovalMemberService approvalAndApprovalMemberService;
    private static final Logger logger = LoggerFactory.getLogger(ApprovalMigrationService.class);
    private static final String macroName = "pageapproval";

    @Inject
    public ApprovalMigrationService(ActiveObjects activeObjects, ApprovalAndApprovalMemberService approvalAndApprovalMemberService, ApprovalService approvalService, ContentPropertyManager contentPropertyManager, GroupHelper groupHelper, PageManager pageManager, SearchManager searchManager, SpaceMacroMigrationService spaceMacroMigrationService, UserAccessor userAccessor) {
        this.activeObjects = activeObjects;
        this.approvalAndApprovalMemberService = approvalAndApprovalMemberService;
        this.approvalService = approvalService;
        this.contentPropertyManager = contentPropertyManager;
        this.groupHelper = groupHelper;
        this.pageManager = pageManager;
        this.searchManager = searchManager;
        this.spaceMacroMigrationService = spaceMacroMigrationService;
        this.userAccessor = userAccessor;
    }

    public int migrateFromServiceRocket(ConfluenceUser currentUser, boolean deleteOldApprovals) {
        logger.info("Starting Service Rocket Migration");
        int total = 0;
        try {
            MacroUsageQuery query = new MacroUsageQuery(macroName);
            ContentSearch search = new ContentSearchFactory().getContentSearch((SearchQuery)query);
            logger.info("Detected {} pages for migration", (Object)this.searchManager.search((ISearch)search).getUnfilteredResultsCount());
            while (search != null) {
                SearchResults searchResults = this.searchManager.search((ISearch)search);
                total += this.migratePages(searchResults, currentUser, deleteOldApprovals);
                search = searchResults.getNextPageSearch();
            }
        }
        catch (InvalidSearchException e) {
            logger.error("An error occurred while migrating pages from Service Rocket. Invalid Search", (Throwable)e);
        }
        logger.info("Completed Service Rocket Migration. {} approvals were migrated", (Object)total);
        return total;
    }

    private int migratePages(SearchResults searchResults, ConfluenceUser currentUser, boolean deleteOldApprovals) {
        int total = 0;
        for (SearchResult searchResult : searchResults.getAll()) {
            try {
                long pageId = Long.parseLong(searchResult.getField("handle").split("Page-")[1]);
                Page page = this.pageManager.getPage(pageId);
                if (deleteOldApprovals) {
                    this.approvalAndApprovalMemberService.deletePageApprovalsAndApprovalMembers(pageId);
                }
                if (page == null) continue;
                logger.info("Migrating Page '{}' to Approvals for Confluence", (Object)page.getTitle());
                ApprovalJson approvalJson = this.processPage((AbstractPage)page, currentUser);
                logger.info("Begin migrating old versions of Page '{}' to Approvals for Confluence", (Object)page.getTitle());
                for (int version = 1; version < page.getVersion(); ++version) {
                    AbstractPage historicPage = this.pageManager.getPageByVersion((AbstractPage)page, version);
                    if (historicPage == null) continue;
                    logger.info("Migrate page '{}' version {} to approvals for Confluence", (Object)page.getTitle(), (Object)page.getVersion());
                    ApprovalJson historicJson = this.processPage(historicPage, currentUser);
                    if (historicJson == null) continue;
                    ++total;
                    this.createPageApprovalEntity(historicJson, (AbstractPage)page);
                }
                if (approvalJson != null) {
                    ++total;
                    this.createPageApprovalEntity(approvalJson, (AbstractPage)page);
                }
                logger.info("End migration for Page '{}'", (Object)page.getTitle());
            }
            catch (Exception e) {
                logger.error("An error occurred while migrating pages from Service Rocket", (Throwable)e);
            }
        }
        return total;
    }

    private void createPageApprovalEntity(ApprovalJson approvalJson, AbstractPage page) {
        try {
            this.approvalService.markSupersededPageApprovals(page.getId(), page.getVersion());
            String user = approvalJson.getCreatorUsername();
            this.activeObjects.executeInTransaction(() -> {
                Approval approvalRet = (Approval)this.activeObjects.create(Approval.class, new DBParam[]{new DBParam("TYPE", (Object)"page"), new DBParam("STATUS", (Object)approvalJson.getStatus()), new DBParam("TITLE", (Object)approvalJson.getTitle()), new DBParam("MACRO_ID", null), new DBParam("PAGE_ID", (Object)approvalJson.getPageId()), new DBParam("EXPIRE_ON_EDIT", (Object)approvalJson.getExpireOnEdit()), new DBParam("EXPIRY_DATE", (Object)approvalJson.getExpiryDate()), new DBParam("QUORUM_SIZE", (Object)approvalJson.getQuorumSize()), new DBParam("POST_COMMENTS_ENABLED", (Object)false), new DBParam("CREATION_DATE", (Object)approvalJson.getCreated()), new DBParam("UPDATE_DATE", (Object)approvalJson.getUpdated()), new DBParam("CREATOR", (Object)user), new DBParam("UPDATOR", (Object)user), new DBParam("VERSION", (Object)approvalJson.getVersion()), new DBParam("STATUS_NOTIFICATION_ENABLED", (Object)true), new DBParam("REQUEST_NOTIFICATION_ENABLED", (Object)true), new DBParam("UUID", null), new DBParam("SUPERSEDED", (Object)approvalJson.getSuperseded()), new DBParam("SPACE_ID", (Object)page.getSpace().getId())});
                return this.createMembers(approvalJson.getMembers(), approvalRet);
            });
        }
        catch (Exception e) {
            logger.error("An error occurred when adding approval during service rocket migration ", (Throwable)e);
        }
    }

    private Approval createMembers(List<ApprovalMemberJson> members, Approval approval) {
        for (ApprovalMemberJson member : members) {
            this.activeObjects.create(ApprovalMember.class, new DBParam[]{new DBParam("APPROVAL_ID", (Object)approval.getID()), new DBParam("USER_KEY", (Object)member.getUserKey()), new DBParam("DATE", (Object)member.getDate()), new DBParam("STATUS", (Object)member.getStatus()), new DBParam("COMMENT", (Object)member.getComment())});
        }
        return approval;
    }

    private Document getDomElement(String xml) {
        Document doc = null;
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            InputSource is = new InputSource();
            is.setCharacterStream(new StringReader(xml));
            doc = db.parse(is);
        }
        catch (IOException | ParserConfigurationException e) {
            return null;
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
        return doc;
    }

    private ApprovalJson getDefaultJson(AbstractPage page, ConfluenceUser currentUser) {
        return new ApprovalJson("page", page.getLastModifier() != null ? page.getLastModifier().getKey().getStringValue() : currentUser.getKey().getStringValue(), page.getLatestVersion().getId(), null, page.getDisplayTitle(), true, true, true, null, 0, false, new ArrayList<ApprovalMemberJson>(), page.getVersion(), null, !page.isCurrent(), "pending", page.getSpace() != null ? Long.valueOf(page.getSpace().getId()) : null, page.getCreationDate(), page.getLastModificationDate());
    }

    private ApprovalMemberJson getMemberJson(ConfluenceUser user, AbstractPage page) throws NullPointerException {
        if (user != null) {
            ApprovalMemberJson member = new ApprovalMemberJson(null, user.getKey().getStringValue(), "pending", null, null, null, null);
            String comment = this.contentPropertyManager.getStringProperty((ContentEntityObject)page.getLatestVersion(), "com.saikore.pageapprovalcomment&" + user.getName() + "&" + page.getVersion());
            member.setComment(comment);
            String approvedBy = this.contentPropertyManager.getStringProperty((ContentEntityObject)page.getLatestVersion(), "com.saikore.pageapprovalcom.saikore.pageapprovalapprovedby" + page.getVersion());
            if (approvedBy != null) {
                for (String s : approvedBy.split("\\?")) {
                    if (!s.equals(user.getName())) continue;
                    member.setStatus("approved");
                    String date = this.contentPropertyManager.getStringProperty((ContentEntityObject)page.getLatestVersion(), "com.saikore.pageapprovalapprovaldate&" + user.getName() + "&" + page.getVersion());
                    if (date == null) continue;
                    SimpleDateFormat dateFormat = new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy", Locale.US);
                    try {
                        member.setDate(dateFormat.parse(date));
                    }
                    catch (ParseException e) {
                        member.setDate(page.getLastModificationDate());
                    }
                }
            }
            return member;
        }
        return null;
    }

    private Date getDateForRelativeExpiry(String status, List<ApprovalMemberJson> members) {
        if (status.equals("approved")) {
            return members.stream().map(ApprovalMemberJson::getDate).map(date -> date == null ? new Date(Long.MIN_VALUE) : date).max(Comparator.comparingLong(Date::getTime)).orElse(null);
        }
        return null;
    }

    private String getQuroumSizeFromPage(Node macroNode) {
        NodeList children = macroNode.getChildNodes();
        for (int j = 0; j < children.getLength(); ++j) {
            String parameter = children.item(j).getAttributes().getNamedItem("ac:name").getNodeValue();
            if (!parameter.equals("quorum")) continue;
            return children.item(j).getFirstChild().getTextContent();
        }
        return null;
    }

    private ApprovalJson processMacro(Node macroNode, AbstractPage page, ConfluenceUser currentUser) {
        String status;
        String quorumSize;
        ApprovalJson approvalJson = this.getDefaultJson(page, currentUser);
        List<ApprovalMemberJson> members = this.getApprovalMembers(macroNode, page);
        approvalJson.setMembers(members);
        String quorumSizeFromPage = this.getQuroumSizeFromPage(macroNode);
        if (quorumSizeFromPage != null) {
            try {
                Integer.parseInt(quorumSizeFromPage);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        if ((quorumSize = this.contentPropertyManager.getStringProperty((ContentEntityObject)page, "com.saikore.pageapprovalquorum")) != null) {
            try {
                int quorum = Integer.parseInt(quorumSize);
                approvalJson.setQuorumSize(Math.min(quorum, members.size()));
            }
            catch (NumberFormatException e) {
                approvalJson.setQuorumSize(0);
            }
        }
        if (Boolean.parseBoolean(status = this.contentPropertyManager.getStringProperty((ContentEntityObject)page.getLatestVersion(), "com.saikore.pageapprovalapprovalstate?" + page.getVersion()))) {
            approvalJson.setStatus("approved");
        } else {
            approvalJson.setStatus("pending");
        }
        Date dateForRelativeExpiry = this.getDateForRelativeExpiry(approvalJson.getStatus(), approvalJson.getMembers());
        approvalJson.setExpiryDate(this.getExpiryDate(dateForRelativeExpiry, macroNode, page.getSpaceKey()));
        if (!approvalJson.getMembers().isEmpty()) {
            return approvalJson;
        }
        return null;
    }

    private Date getExpiryDate(Date dateForRelativeExpiry, Node macroNode, String spaceKey) {
        Integer month = null;
        Integer day = null;
        Date date = null;
        NodeList children = macroNode.getChildNodes();
        block10: for (int j = 0; j < children.getLength(); ++j) {
            String parameter;
            switch (parameter = children.item(j).getAttributes().getNamedItem("ac:name").getNodeValue()) {
                case "expirymonth": {
                    month = Integer.valueOf(children.item(j).getFirstChild().getTextContent());
                    continue block10;
                }
                case "expiryday": {
                    day = Integer.valueOf(children.item(j).getFirstChild().getTextContent());
                    continue block10;
                }
                case "expireafter": {
                    String timePeriod = String.valueOf(children.item(j).getFirstChild().getTextContent());
                    date = ApprovalMigrationUtils.parseExpireAfterTerm(dateForRelativeExpiry, timePeriod);
                    continue block10;
                }
            }
        }
        if (month == null && day == null && date == null && this.spaceMacroMigrationService.isSpaceSettingsEnabled(spaceKey)) {
            return this.spaceMacroMigrationService.getExpiryDate(dateForRelativeExpiry, spaceKey);
        }
        if (month != null || day != null) {
            return ApprovalMigrationUtils.parseExpiryDate(new Date(), month, day);
        }
        if (date != null) {
            return date;
        }
        return ApprovalMigrationUtils.parseExpiryDate(new Date(), month, day);
    }

    private List<ConfluenceUser> getUsers(Node macroNode, AbstractPage page) {
        HashSet<ConfluenceUser> allUsers = new HashSet<ConfluenceUser>();
        boolean isSpaceMacro = false;
        NodeList children = macroNode.getChildNodes();
        block14: for (int j = 0; j < children.getLength(); ++j) {
            String[] parameter;
            switch (parameter = children.item(j).getAttributes().getNamedItem("ac:name").getNodeValue()) {
                case "users": {
                    NodeList users = children.item(j).getChildNodes();
                    for (int k = 0; k < users.getLength(); ++k) {
                        if (allUsers.size() >= 20) {
                            return new ArrayList<ConfluenceUser>(allUsers);
                        }
                        String userValue = users.item(k).getAttributes().getNamedItem("ri:userkey").getNodeValue();
                        ConfluenceUser userObject = this.userAccessor.getUserByKey(new UserKey(userValue));
                        allUsers.add(userObject);
                    }
                    continue block14;
                }
                case "approvalGroup": {
                    String groupNames = children.item(j).getFirstChild().getTextContent();
                    for (String groupName : groupNames.split("\\s*,\\s*")) {
                        if (allUsers.size() >= 20) {
                            return new ArrayList<ConfluenceUser>(allUsers);
                        }
                        try {
                            List<ConfluenceUser> groupUsers = this.groupHelper.getGroupMembers(groupName, 20);
                            this.mergeMembers(allUsers, new HashSet<ConfluenceUser>(groupUsers));
                        }
                        catch (NullPointerException e) {
                            logger.error("The Approval Group, {}, does not exist.", (Object)groupName);
                            e.printStackTrace();
                        }
                    }
                    continue block14;
                }
                case "spacemacro": {
                    isSpaceMacro = Boolean.parseBoolean(children.item(j).getFirstChild().getTextContent());
                    continue block14;
                }
            }
        }
        if (isSpaceMacro || this.spaceMacroMigrationService.isSpaceSettingsEnabled(page.getSpaceKey())) {
            Set<ConfluenceUser> spaceUsers = this.spaceMacroMigrationService.getUsers(page.getSpaceKey());
            this.mergeMembers(allUsers, spaceUsers);
        }
        try {
            String[] allApprovalUsers;
            for (String approvalUser : allApprovalUsers = this.contentPropertyManager.getStringProperty((ContentEntityObject)page.getLatestVersion(), "com.saikore.pageapprovalcom.saikore.pageapprovalmyUsers1").split("\\?")) {
                if (allUsers.contains(this.userAccessor.getUserByName(approvalUser))) continue;
                allUsers.add(this.userAccessor.getUserByName(approvalUser));
            }
        }
        catch (NullPointerException e) {
            logger.error("An error occurred while migrating pages from Service Rocket. Invalid Search", (Throwable)e);
        }
        String deregisteredUsersProperty = this.contentPropertyManager.getStringProperty((ContentEntityObject)page.getLatestVersion(), "com.saikore.pageapprovalcom.saikore.pageapprovalisnotactive" + page.getVersion());
        if (deregisteredUsersProperty != null) {
            Set deregisteredUsernames = Arrays.stream(deregisteredUsersProperty.split("\\?")).collect(Collectors.toSet());
            return allUsers.stream().filter(user -> !deregisteredUsernames.contains(user.getName())).collect(Collectors.toList());
        }
        return new ArrayList<ConfluenceUser>(allUsers);
    }

    private List<ApprovalMemberJson> getApprovalMembersFromUsers(List<ConfluenceUser> users, AbstractPage page) {
        try {
            return users.stream().map(user -> this.getMemberJson((ConfluenceUser)user, page)).collect(Collectors.toList());
        }
        catch (NullPointerException e) {
            logger.error("Error migrating page with an Approved approval that has a Null date assigned as the date of being approved.");
            e.printStackTrace();
            return new ArrayList<ApprovalMemberJson>();
        }
    }

    private <T> void mergeMembers(Set<T> members, Set<T> partialMembers) {
        int extraMembersAllowed = 20 - members.size();
        List<T> additionalMembers = new ArrayList<T>(partialMembers).subList(0, Math.min(extraMembersAllowed, partialMembers.size()));
        members.addAll(additionalMembers);
    }

    private List<ApprovalMemberJson> getApprovalMembers(Node macroNode, AbstractPage page) {
        List<ConfluenceUser> users = this.getUsers(macroNode, page);
        return this.getApprovalMembersFromUsers(users, page);
    }

    private ApprovalJson processPage(AbstractPage page, ConfluenceUser currentUser) {
        Document document = this.getDomElement("<p>" + page.getBodyAsString().replace("&", "&#038;") + "</p>");
        if (document != null) {
            NodeList macros = document.getElementsByTagName("ac:structured-macro");
            for (int i = 0; i < macros.getLength(); ++i) {
                NamedNodeMap attributes;
                Node item = macros.item(i);
                if (!macroName.equals(item.getAttributes().getNamedItem("ac:name").getNodeValue()) || (attributes = item.getAttributes()).getNamedItem("ac:macro-id").getNodeValue() == null || attributes.getNamedItem("ac:macro-id").getNodeValue().length() <= 0) continue;
                return this.processMacro(item, page, currentUser);
            }
            NodeList possSpaceMacros = document.getElementsByTagName("ac:macro");
            for (int i = 0; i < possSpaceMacros.getLength(); ++i) {
                Node item = possSpaceMacros.item(i);
                if (!macroName.equals(item.getAttributes().getNamedItem("ac:name").getNodeValue())) continue;
                return this.processMacro(item, page, currentUser);
            }
        }
        return null;
    }
}

