/*
 * Decompiled with CFR 0.152.
 */
package co.uk.automationconsultants.approvals.service.migration;

import com.atlassian.confluence.search.v2.ContentSearch;
import com.atlassian.confluence.search.v2.SearchQuery;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContentSearchFactory {
    private static final Logger logger = LoggerFactory.getLogger(ContentSearchFactory.class);

    public ContentSearch getContentSearch(SearchQuery query) {
        try {
            Constructor<?>[] constructors;
            for (Constructor<?> constructor : constructors = ContentSearch.class.getConstructors()) {
                Type[] types = constructor.getGenericParameterTypes();
                logger.info("Found ContentSearch constructor with the following types {}", Arrays.stream(types).map(Type::getTypeName));
                if (types.length != 5) continue;
                logger.info("Instantiating ContentSearch with 5 arguments.");
                return (ContentSearch)constructor.newInstance(query, null, null, 0, 500);
            }
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            logger.warn("Found old ContentSearch constructor, but could not instantiate with it");
        }
        logger.info("Instantiating ContentSearch with 4 arguments.");
        return new ContentSearch(query, null, 0, 500);
    }
}

