/*
 * Decompiled with CFR 0.152.
 */
package co.uk.automationconsultants.approvals.service.migration;

import co.uk.automationconsultants.approvals.ao.Approval;
import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import java.util.Arrays;
import javax.inject.Inject;
import javax.inject.Named;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named(value="approvalAndApprovalMemberTablesUtils")
public class ApprovalAndApprovalMemberTablesUtils {
    @ComponentImport
    private final ActiveObjects activeObjects;
    private static final Logger logger = LoggerFactory.getLogger(ApprovalAndApprovalMemberTablesUtils.class);

    @Inject
    public ApprovalAndApprovalMemberTablesUtils(ActiveObjects activeObjects) {
        this.activeObjects = activeObjects;
    }

    public void deletePageApprovalsAndApprovalMembers(long pageId) {
        try {
            this.activeObjects.executeInTransaction(() -> {
                Approval[] approvals = (Approval[])this.activeObjects.find(Approval.class, Query.select().where("PAGE_ID = ? AND TYPE = ?", new Object[]{pageId, "page"}));
                Arrays.stream(approvals).forEach(approval -> this.activeObjects.delete((RawEntity[])approval.getMembers()));
                this.activeObjects.delete((RawEntity[])approvals);
                logger.info("Deleted old approvals for page {}", (Object)pageId);
                return null;
            });
        }
        catch (Exception e) {
            logger.error("Failed to delete old page approvals for page {}", (Object)pageId, (Object)e);
        }
    }
}

